/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2023-11-03 10:13:39 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) NOT NULL,
  `status` varchar(20) NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `args` varchar(191) DEFAULT NULL,
  `schedule` longtext DEFAULT NULL,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `attempts` int(11) NOT NULL DEFAULT 0,
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `extended_args` varchar(8000) DEFAULT NULL,
  `priority` tinyint(3) unsigned NOT NULL DEFAULT 10,
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id` (`claim_id`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=474 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=9456 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=1404 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_e_events` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_e_submissions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(60) DEFAULT NULL,
  `hash_id` varchar(60) NOT NULL,
  `main_meta_id` bigint(20) unsigned NOT NULL COMMENT 'Id of main field. to represent the main meta field',
  `post_id` bigint(20) unsigned NOT NULL,
  `referer` varchar(500) NOT NULL,
  `referer_title` varchar(300) DEFAULT NULL,
  `element_id` varchar(20) NOT NULL,
  `form_name` varchar(60) NOT NULL,
  `campaign_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip` varchar(46) NOT NULL,
  `user_agent` text NOT NULL,
  `actions_count` int(11) DEFAULT 0,
  `actions_succeeded_count` int(11) DEFAULT 0,
  `status` varchar(20) NOT NULL,
  `is_read` tinyint(1) NOT NULL DEFAULT 0,
  `meta` text DEFAULT NULL,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `hash_id_unique_index` (`hash_id`),
  KEY `main_meta_id_index` (`main_meta_id`),
  KEY `hash_id_index` (`hash_id`),
  KEY `type_index` (`type`),
  KEY `post_id_index` (`post_id`),
  KEY `element_id_index` (`element_id`),
  KEY `campaign_id_index` (`campaign_id`),
  KEY `user_id_index` (`user_id`),
  KEY `user_ip_index` (`user_ip`),
  KEY `status_index` (`status`),
  KEY `is_read_index` (`is_read`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`),
  KEY `referer_index` (`referer`(191)),
  KEY `referer_title_index` (`referer_title`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_e_submissions_actions_log` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) unsigned NOT NULL,
  `action_name` varchar(60) NOT NULL,
  `action_label` varchar(60) DEFAULT NULL,
  `status` varchar(20) NOT NULL,
  `log` text DEFAULT NULL,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `action_name_index` (`action_name`),
  KEY `status_index` (`status`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_e_submissions_values` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `key` varchar(60) DEFAULT NULL,
  `value` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `key_index` (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=39529 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3740 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=1884 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_revslider_css` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `settings` longtext DEFAULT NULL,
  `hover` longtext DEFAULT NULL,
  `advanced` longtext DEFAULT NULL,
  `params` longtext NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `handle_index` (`handle`(64))
) ENGINE=InnoDB AUTO_INCREMENT=110 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_css_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `settings` longtext DEFAULT NULL,
  `hover` longtext DEFAULT NULL,
  `advanced` longtext DEFAULT NULL,
  `params` longtext NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `handle_index` (`handle`(64))
) ENGINE=InnoDB AUTO_INCREMENT=48 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_layer_animations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `params` text NOT NULL,
  `settings` text DEFAULT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_layer_animations_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `params` text NOT NULL,
  `settings` text DEFAULT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_navigations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `handle` varchar(191) NOT NULL,
  `type` varchar(191) NOT NULL,
  `css` longtext NOT NULL,
  `markup` longtext NOT NULL,
  `settings` longtext DEFAULT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_navigations_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `handle` varchar(191) NOT NULL,
  `type` varchar(191) NOT NULL,
  `css` longtext NOT NULL,
  `markup` longtext NOT NULL,
  `settings` longtext DEFAULT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_sliders` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext DEFAULT NULL,
  `params` longtext NOT NULL,
  `settings` text DEFAULT NULL,
  `type` varchar(191) NOT NULL DEFAULT '',
  UNIQUE KEY `id` (`id`),
  KEY `type_index` (`type`(8))
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_sliders_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext DEFAULT NULL,
  `params` longtext NOT NULL,
  `settings` text DEFAULT NULL,
  `type` varchar(191) NOT NULL DEFAULT '',
  UNIQUE KEY `id` (`id`),
  KEY `type_index` (`type`(8))
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `slide_order` int(11) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL DEFAULT '',
  UNIQUE KEY `id` (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_slides_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `slide_order` int(11) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL DEFAULT '',
  UNIQUE KEY `id` (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_static_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_static_slides_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=51 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=205 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=51 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=113 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_admin_note_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `note_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `label` varchar(255) NOT NULL,
  `query` longtext NOT NULL,
  `status` varchar(255) NOT NULL,
  `actioned_text` varchar(255) NOT NULL,
  `nonce_action` varchar(255) DEFAULT NULL,
  `nonce_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `note_id` (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=40916 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_admin_notes` (
  `note_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `type` varchar(20) NOT NULL,
  `locale` varchar(20) NOT NULL,
  `title` longtext NOT NULL,
  `content` longtext NOT NULL,
  `content_data` longtext DEFAULT NULL,
  `status` varchar(200) NOT NULL,
  `source` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_reminder` datetime DEFAULT NULL,
  `is_snoozable` tinyint(1) NOT NULL DEFAULT 0,
  `layout` varchar(20) NOT NULL DEFAULT '',
  `image` varchar(200) DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT 0,
  `icon` varchar(200) NOT NULL DEFAULT 'info',
  `is_read` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=199 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_category_lookup` (
  `category_tree_id` bigint(20) unsigned NOT NULL,
  `category_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`category_tree_id`,`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_customer_lookup` (
  `customer_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `username` varchar(60) NOT NULL DEFAULT '',
  `first_name` varchar(255) NOT NULL,
  `last_name` varchar(255) NOT NULL,
  `email` varchar(100) DEFAULT NULL,
  `date_last_active` timestamp NULL DEFAULT NULL,
  `date_registered` timestamp NULL DEFAULT NULL,
  `country` char(2) NOT NULL DEFAULT '',
  `postcode` varchar(20) NOT NULL DEFAULT '',
  `city` varchar(100) NOT NULL DEFAULT '',
  `state` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `email` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_download_log` (
  `download_log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_order_addresses` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned NOT NULL,
  `address_type` varchar(20) DEFAULT NULL,
  `first_name` text DEFAULT NULL,
  `last_name` text DEFAULT NULL,
  `company` text DEFAULT NULL,
  `address_1` text DEFAULT NULL,
  `address_2` text DEFAULT NULL,
  `city` text DEFAULT NULL,
  `state` text DEFAULT NULL,
  `postcode` text DEFAULT NULL,
  `country` text DEFAULT NULL,
  `email` varchar(320) DEFAULT NULL,
  `phone` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `address_type_order_id` (`address_type`,`order_id`),
  KEY `order_id` (`order_id`),
  KEY `email` (`email`(191)),
  KEY `phone` (`phone`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_coupon_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `coupon_id` bigint(20) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `discount_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`coupon_id`),
  KEY `coupon_id` (`coupon_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_order_operational_data` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned DEFAULT NULL,
  `created_via` varchar(100) DEFAULT NULL,
  `woocommerce_version` varchar(20) DEFAULT NULL,
  `prices_include_tax` tinyint(1) DEFAULT NULL,
  `coupon_usages_are_counted` tinyint(1) DEFAULT NULL,
  `download_permission_granted` tinyint(1) DEFAULT NULL,
  `cart_hash` varchar(100) DEFAULT NULL,
  `new_order_email_sent` tinyint(1) DEFAULT NULL,
  `order_key` varchar(100) DEFAULT NULL,
  `order_stock_reduced` tinyint(1) DEFAULT NULL,
  `date_paid_gmt` datetime DEFAULT NULL,
  `date_completed_gmt` datetime DEFAULT NULL,
  `shipping_tax_amount` decimal(26,8) DEFAULT NULL,
  `shipping_total_amount` decimal(26,8) DEFAULT NULL,
  `discount_tax_amount` decimal(26,8) DEFAULT NULL,
  `discount_total_amount` decimal(26,8) DEFAULT NULL,
  `recorded_sales` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `order_id` (`order_id`),
  KEY `order_key` (`order_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_product_lookup` (
  `order_item_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `variation_id` bigint(20) unsigned NOT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `product_qty` int(11) NOT NULL,
  `product_net_revenue` double NOT NULL DEFAULT 0,
  `product_gross_revenue` double NOT NULL DEFAULT 0,
  `coupon_amount` double NOT NULL DEFAULT 0,
  `tax_amount` double NOT NULL DEFAULT 0,
  `shipping_amount` double NOT NULL DEFAULT 0,
  `shipping_tax_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  KEY `customer_id` (`customer_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_order_stats` (
  `order_id` bigint(20) unsigned NOT NULL,
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `num_items_sold` int(11) NOT NULL DEFAULT 0,
  `total_sales` double NOT NULL DEFAULT 0,
  `tax_total` double NOT NULL DEFAULT 0,
  `shipping_total` double NOT NULL DEFAULT 0,
  `net_total` double NOT NULL DEFAULT 0,
  `returning_customer` tinyint(1) DEFAULT NULL,
  `status` varchar(200) NOT NULL,
  `customer_id` bigint(20) unsigned NOT NULL,
  `date_paid` datetime DEFAULT '0000-00-00 00:00:00',
  `date_completed` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_id` (`customer_id`),
  KEY `status` (`status`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_order_tax_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `shipping_tax` double NOT NULL DEFAULT 0,
  `order_tax` double NOT NULL DEFAULT 0,
  `total_tax` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`tax_rate_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_orders` (
  `id` bigint(20) unsigned NOT NULL,
  `status` varchar(20) DEFAULT NULL,
  `currency` varchar(10) DEFAULT NULL,
  `type` varchar(20) DEFAULT NULL,
  `tax_amount` decimal(26,8) DEFAULT NULL,
  `total_amount` decimal(26,8) DEFAULT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `billing_email` varchar(320) DEFAULT NULL,
  `date_created_gmt` datetime DEFAULT NULL,
  `date_updated_gmt` datetime DEFAULT NULL,
  `parent_order_id` bigint(20) unsigned DEFAULT NULL,
  `payment_method` varchar(100) DEFAULT NULL,
  `payment_method_title` text DEFAULT NULL,
  `transaction_id` varchar(100) DEFAULT NULL,
  `ip_address` varchar(100) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `customer_note` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `status` (`status`),
  KEY `date_created` (`date_created_gmt`),
  KEY `customer_id_billing_email` (`customer_id`,`billing_email`(171)),
  KEY `billing_email` (`billing_email`(191)),
  KEY `type_status_date` (`type`,`status`,`date_created_gmt`),
  KEY `parent_order_id` (`parent_order_id`),
  KEY `date_updated` (`date_updated_gmt`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_orders_meta` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned DEFAULT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_key_value` (`meta_key`(100),`meta_value`(82)),
  KEY `order_id_meta_key_meta_value` (`order_id`,`meta_key`(100),`meta_value`(82))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_attributes_lookup` (
  `product_id` bigint(20) NOT NULL,
  `product_or_parent_id` bigint(20) NOT NULL,
  `taxonomy` varchar(32) NOT NULL,
  `term_id` bigint(20) NOT NULL,
  `is_variation_attribute` tinyint(1) NOT NULL,
  `in_stock` tinyint(1) NOT NULL,
  PRIMARY KEY (`product_or_parent_id`,`term_id`,`product_id`,`taxonomy`),
  KEY `is_variation_attribute_term_id` (`is_variation_attribute`,`term_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_product_download_directories` (
  `url_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(256) NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`url_id`),
  KEY `url` (`url`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_product_meta_lookup` (
  `product_id` bigint(20) NOT NULL,
  `sku` varchar(100) DEFAULT '',
  `virtual` tinyint(1) DEFAULT 0,
  `downloadable` tinyint(1) DEFAULT 0,
  `min_price` decimal(19,4) DEFAULT NULL,
  `max_price` decimal(19,4) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT 0,
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) DEFAULT 'instock',
  `rating_count` bigint(20) DEFAULT 0,
  `average_rating` decimal(3,2) DEFAULT 0.00,
  `total_sales` bigint(20) DEFAULT 0,
  `tax_status` varchar(100) DEFAULT 'taxable',
  `tax_class` varchar(100) DEFAULT '',
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_rate_limits` (
  `rate_limit_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `rate_limit_key` varchar(200) NOT NULL,
  `rate_limit_expiry` bigint(20) unsigned NOT NULL,
  `rate_limit_remaining` smallint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`rate_limit_id`),
  UNIQUE KEY `rate_limit_key` (`rate_limit_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_reserved_stock` (
  `order_id` bigint(20) NOT NULL,
  `product_id` bigint(20) NOT NULL,
  `stock_quantity` double NOT NULL DEFAULT 0,
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`,`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_tax_rate_classes` (
  `tax_rate_class_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_webhooks` (
  `webhook_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) NOT NULL,
  `name` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `delivery_url` text NOT NULL,
  `secret` text NOT NULL,
  `topic` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint(4) NOT NULL,
  `failure_count` smallint(10) NOT NULL DEFAULT 0,
  `pending_delivery` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_api_keys` (
  `key_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `description` varchar(200) DEFAULT NULL,
  `permissions` varchar(10) NOT NULL,
  `consumer_key` char(64) NOT NULL,
  `consumer_secret` char(43) NOT NULL,
  `nonces` longtext DEFAULT NULL,
  `truncated_key` char(7) NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) NOT NULL,
  `attribute_label` varchar(200) DEFAULT NULL,
  `attribute_type` varchar(20) NOT NULL,
  `attribute_orderby` varchar(20) NOT NULL,
  `attribute_public` int(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `order_key` varchar(200) NOT NULL,
  `user_email` varchar(200) NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_log` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint(4) NOT NULL,
  `source` varchar(200) NOT NULL,
  `message` longtext NOT NULL,
  `context` longtext DEFAULT NULL,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_order_itemmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_order_items` (
  `order_item_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text NOT NULL,
  `order_item_type` varchar(200) NOT NULL DEFAULT '',
  `order_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_payment_tokenmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_payment_tokens` (
  `token_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) NOT NULL,
  `token` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `type` varchar(200) NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_sessions` (
  `session_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) NOT NULL,
  `session_value` longtext NOT NULL,
  `session_expiry` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`)
) ENGINE=InnoDB AUTO_INCREMENT=1399 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint(20) unsigned NOT NULL,
  `location_code` varchar(200) NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `location_id` (`location_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_methods` (
  `zone_id` bigint(20) unsigned NOT NULL,
  `instance_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) NOT NULL,
  `method_order` bigint(20) unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`instance_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_shipping_zones` (
  `zone_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) NOT NULL,
  `zone_order` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_tax_rate_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_tax_rates` (
  `tax_rate_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) NOT NULL DEFAULT '',
  `tax_rate` varchar(8) NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) NOT NULL DEFAULT '',
  `tax_rate_priority` bigint(20) unsigned NOT NULL,
  `tax_rate_compound` int(1) NOT NULL DEFAULT 0,
  `tax_rate_shipping` int(1) NOT NULL DEFAULT 1,
  `tax_rate_order` bigint(20) unsigned NOT NULL,
  `tax_rate_class` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woodmart_wishlist_products` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `product_id` varchar(255) NOT NULL,
  `wishlist_id` int(11) DEFAULT NULL,
  `date_added` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`ID`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE `wp_woodmart_wishlists` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `date_created` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: wp_actionscheduler_actions */
INSERT INTO `wp_actionscheduler_actions` VALUES("30", "woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications", "failed", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "[]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "0", "1", "2021-07-27 10:29:36", "2021-07-27 13:59:36", "111", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("301", "woocommerce_run_on_woocommerce_admin_updated", "failed", "2023-04-20 10:10:18", "2023-04-20 10:10:18", "[\"Automattic\\\\WooCommerce\\\\Admin\\\\RemoteInboxNotifications\\\\RemoteInboxNotificationsEngine\",\"run_on_woocommerce_admin_updated\"]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1681985418;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1681985418;}", "5", "1", "2023-04-20 10:10:22", "2023-04-20 13:40:22", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("443", "woocommerce_cleanup_draft_orders", "complete", "2023-10-04 03:45:48", "2023-10-04 03:45:48", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1696391148;s:18:\"\0*\0first_timestamp\";i:1661002506;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1696391148;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2023-10-04 03:53:48", "2023-10-04 07:23:48", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("444", "woocommerce_cleanup_draft_orders", "complete", "2023-10-05 03:53:48", "2023-10-05 03:53:48", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1696478028;s:18:\"\0*\0first_timestamp\";i:1661002506;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1696478028;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2023-10-05 04:24:49", "2023-10-05 07:54:49", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("445", "woocommerce_cleanup_draft_orders", "complete", "2023-10-06 04:24:49", "2023-10-06 04:24:49", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1696566289;s:18:\"\0*\0first_timestamp\";i:1661002506;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1696566289;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2023-10-06 05:24:51", "2023-10-06 08:54:51", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("446", "woocommerce_cleanup_draft_orders", "complete", "2023-10-07 05:24:51", "2023-10-07 05:24:51", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1696656291;s:18:\"\0*\0first_timestamp\";i:1661002506;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1696656291;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2023-10-07 05:28:51", "2023-10-07 08:58:51", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("447", "woocommerce_cleanup_draft_orders", "complete", "2023-10-08 05:28:51", "2023-10-08 05:28:51", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1696742931;s:18:\"\0*\0first_timestamp\";i:1661002506;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1696742931;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2023-10-08 05:28:57", "2023-10-08 08:58:57", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("448", "woocommerce_cleanup_draft_orders", "complete", "2023-10-09 05:28:57", "2023-10-09 05:28:57", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1696829337;s:18:\"\0*\0first_timestamp\";i:1661002506;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1696829337;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2023-10-09 07:12:45", "2023-10-09 10:42:45", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("449", "woocommerce_cleanup_draft_orders", "complete", "2023-10-10 07:12:45", "2023-10-10 07:12:45", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1696921965;s:18:\"\0*\0first_timestamp\";i:1661002506;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1696921965;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2023-10-10 07:13:05", "2023-10-10 10:43:05", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("450", "woocommerce_cleanup_draft_orders", "complete", "2023-10-11 07:13:05", "2023-10-11 07:13:05", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1697008385;s:18:\"\0*\0first_timestamp\";i:1661002506;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1697008385;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2023-10-11 08:01:31", "2023-10-11 11:31:31", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("451", "woocommerce_cleanup_draft_orders", "complete", "2023-10-12 08:01:31", "2023-10-12 08:01:31", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1697097691;s:18:\"\0*\0first_timestamp\";i:1661002506;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1697097691;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2023-10-12 09:11:56", "2023-10-12 12:41:56", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("452", "woocommerce_cleanup_draft_orders", "complete", "2023-10-13 09:11:56", "2023-10-13 09:11:56", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1697188316;s:18:\"\0*\0first_timestamp\";i:1661002506;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1697188316;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2023-10-13 09:15:12", "2023-10-13 12:45:12", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("453", "woocommerce_cleanup_draft_orders", "complete", "2023-10-14 09:15:12", "2023-10-14 09:15:12", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1697274912;s:18:\"\0*\0first_timestamp\";i:1661002506;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1697274912;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2023-10-14 10:53:33", "2023-10-14 14:23:33", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("454", "woocommerce_cleanup_draft_orders", "complete", "2023-10-15 10:53:33", "2023-10-15 10:53:33", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1697367213;s:18:\"\0*\0first_timestamp\";i:1661002506;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1697367213;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2023-10-15 12:48:38", "2023-10-15 16:18:38", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("455", "woocommerce_cleanup_draft_orders", "complete", "2023-10-16 12:48:38", "2023-10-16 12:48:38", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1697460518;s:18:\"\0*\0first_timestamp\";i:1661002506;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1697460518;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2023-10-16 12:51:25", "2023-10-16 16:21:25", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("456", "woocommerce_cleanup_draft_orders", "complete", "2023-10-17 12:51:25", "2023-10-17 12:51:25", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1697547085;s:18:\"\0*\0first_timestamp\";i:1661002506;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1697547085;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2023-10-17 13:10:40", "2023-10-17 16:40:40", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("457", "woocommerce_cleanup_draft_orders", "complete", "2023-10-18 13:10:40", "2023-10-18 13:10:40", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1697634640;s:18:\"\0*\0first_timestamp\";i:1661002506;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1697634640;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2023-10-18 13:55:24", "2023-10-18 17:25:24", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("458", "woocommerce_cleanup_draft_orders", "complete", "2023-10-19 13:55:24", "2023-10-19 13:55:24", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1697723724;s:18:\"\0*\0first_timestamp\";i:1661002506;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1697723724;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2023-10-19 14:05:57", "2023-10-19 17:35:57", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("459", "woocommerce_cleanup_draft_orders", "complete", "2023-10-20 14:05:57", "2023-10-20 14:05:57", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1697810757;s:18:\"\0*\0first_timestamp\";i:1661002506;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1697810757;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2023-10-20 16:58:04", "2023-10-20 20:28:04", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("460", "woocommerce_cleanup_draft_orders", "complete", "2023-10-21 16:58:04", "2023-10-21 16:58:04", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1697907484;s:18:\"\0*\0first_timestamp\";i:1661002506;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1697907484;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2023-10-21 17:51:27", "2023-10-21 21:21:27", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("461", "woocommerce_cleanup_draft_orders", "complete", "2023-10-22 17:51:27", "2023-10-22 17:51:27", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1697997087;s:18:\"\0*\0first_timestamp\";i:1661002506;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1697997087;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2023-10-22 19:12:31", "2023-10-22 22:42:31", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("462", "woocommerce_cleanup_draft_orders", "complete", "2023-10-23 19:12:31", "2023-10-23 19:12:31", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1698088351;s:18:\"\0*\0first_timestamp\";i:1661002506;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1698088351;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2023-10-23 21:03:57", "2023-10-24 00:33:57", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("463", "woocommerce_cleanup_draft_orders", "complete", "2023-10-24 21:03:57", "2023-10-24 21:03:57", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1698181437;s:18:\"\0*\0first_timestamp\";i:1661002506;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1698181437;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2023-10-24 22:00:46", "2023-10-25 01:30:46", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("464", "woocommerce_cleanup_draft_orders", "complete", "2023-10-25 22:00:46", "2023-10-25 22:00:46", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1698271246;s:18:\"\0*\0first_timestamp\";i:1661002506;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1698271246;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2023-10-25 22:37:20", "2023-10-26 02:07:20", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("465", "woocommerce_cleanup_draft_orders", "complete", "2023-10-26 22:37:20", "2023-10-26 22:37:20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1698359840;s:18:\"\0*\0first_timestamp\";i:1661002506;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1698359840;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2023-10-27 03:35:30", "2023-10-27 07:05:30", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("466", "woocommerce_cleanup_draft_orders", "complete", "2023-10-28 03:35:30", "2023-10-28 03:35:30", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1698464130;s:18:\"\0*\0first_timestamp\";i:1661002506;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1698464130;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2023-10-28 06:48:20", "2023-10-28 10:18:20", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("467", "woocommerce_cleanup_draft_orders", "complete", "2023-10-29 06:48:20", "2023-10-29 06:48:20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1698562100;s:18:\"\0*\0first_timestamp\";i:1661002506;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1698562100;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2023-10-29 07:44:11", "2023-10-29 11:14:11", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("468", "woocommerce_cleanup_draft_orders", "complete", "2023-10-30 07:44:11", "2023-10-30 07:44:11", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1698651851;s:18:\"\0*\0first_timestamp\";i:1661002506;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1698651851;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2023-10-30 07:48:16", "2023-10-30 11:18:16", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("469", "woocommerce_cleanup_draft_orders", "complete", "2023-10-31 07:48:16", "2023-10-31 07:48:16", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1698738496;s:18:\"\0*\0first_timestamp\";i:1661002506;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1698738496;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2023-10-31 16:03:23", "2023-10-31 19:33:23", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("470", "woocommerce_cleanup_draft_orders", "complete", "2023-11-01 16:03:23", "2023-11-01 16:03:23", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1698854603;s:18:\"\0*\0first_timestamp\";i:1661002506;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1698854603;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2023-11-01 20:20:51", "2023-11-01 23:50:51", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("471", "woocommerce_cleanup_draft_orders", "complete", "2023-11-02 20:20:51", "2023-11-02 20:20:51", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1698956451;s:18:\"\0*\0first_timestamp\";i:1661002506;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1698956451;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2023-11-03 00:32:17", "2023-11-03 04:02:17", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("472", "woocommerce_cleanup_draft_orders", "pending", "2023-11-04 00:32:17", "2023-11-04 00:32:17", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1699057937;s:18:\"\0*\0first_timestamp\";i:1661002506;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1699057937;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("473", "woocommerce_run_on_woocommerce_admin_updated", "complete", "2023-11-03 10:10:59", "2023-11-03 10:10:59", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1699006259;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1699006259;}", "5", "1", "2023-11-03 10:11:33", "2023-11-03 13:41:33", "0", NULL, "10");

/* INSERT TABLE DATA: wp_actionscheduler_claims */
INSERT INTO `wp_actionscheduler_claims` VALUES("111", "2021-07-27 10:29:36");

/* INSERT TABLE DATA: wp_actionscheduler_groups */
INSERT INTO `wp_actionscheduler_groups` VALUES("1", "action-scheduler-migration");
INSERT INTO `wp_actionscheduler_groups` VALUES("2", "wc_update_product_lookup_tables");
INSERT INTO `wp_actionscheduler_groups` VALUES("3", "wc-admin-data");
INSERT INTO `wp_actionscheduler_groups` VALUES("4", "woocommerce-db-updates");
INSERT INTO `wp_actionscheduler_groups` VALUES("5", "woocommerce-remote-inbox-engine");

/* INSERT TABLE DATA: wp_actionscheduler_logs */
INSERT INTO `wp_actionscheduler_logs` VALUES("73", "30", "ایجاد فعالیت", "2021-07-27 10:29:00", "2021-07-27 10:29:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("75", "30", "action started via Async Request", "2021-07-27 10:29:36", "2021-07-27 10:29:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("82", "30", "فعالیت بعد از 300 ثانیه انجام شد.", "2021-07-27 10:34:43", "2021-07-27 10:34:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("885", "301", "ایجاد فعالیت", "2023-04-20 10:10:18", "2023-04-20 10:10:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("886", "301", "عملیات توسط WP Cron شروع شد", "2023-04-20 10:10:22", "2023-04-20 10:10:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("887", "301", "اقدام از طریق WP Cron انجام نشد: Scheduled action for woocommerce_run_on_woocommerce_admin_updated will not be executed as no callbacks are registered.", "2023-04-20 10:10:22", "2023-04-20 10:10:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("1313", "443", "ایجاد فعالیت", "2023-10-03 03:45:48", "2023-10-03 03:45:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("1314", "443", "عملیات توسط WP Cron شروع شد", "2023-10-04 03:53:47", "2023-10-04 03:53:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("1315", "443", "عملیات توسط WP Cron کامل شد", "2023-10-04 03:53:48", "2023-10-04 03:53:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("1316", "444", "ایجاد فعالیت", "2023-10-04 03:53:48", "2023-10-04 03:53:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("1317", "444", "عملیات توسط WP Cron شروع شد", "2023-10-05 04:24:49", "2023-10-05 04:24:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("1318", "444", "عملیات توسط WP Cron کامل شد", "2023-10-05 04:24:49", "2023-10-05 04:24:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("1319", "445", "ایجاد فعالیت", "2023-10-05 04:24:49", "2023-10-05 04:24:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("1320", "445", "عملیات توسط WP Cron شروع شد", "2023-10-06 05:24:51", "2023-10-06 05:24:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("1321", "445", "عملیات توسط WP Cron کامل شد", "2023-10-06 05:24:51", "2023-10-06 05:24:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("1322", "446", "ایجاد فعالیت", "2023-10-06 05:24:51", "2023-10-06 05:24:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("1323", "446", "عملیات توسط WP Cron شروع شد", "2023-10-07 05:28:51", "2023-10-07 05:28:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("1324", "446", "عملیات توسط WP Cron کامل شد", "2023-10-07 05:28:51", "2023-10-07 05:28:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("1325", "447", "ایجاد فعالیت", "2023-10-07 05:28:51", "2023-10-07 05:28:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("1326", "447", "عملیات توسط WP Cron شروع شد", "2023-10-08 05:28:57", "2023-10-08 05:28:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("1327", "447", "عملیات توسط WP Cron کامل شد", "2023-10-08 05:28:57", "2023-10-08 05:28:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("1328", "448", "ایجاد فعالیت", "2023-10-08 05:28:57", "2023-10-08 05:28:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("1329", "448", "عملیات توسط WP Cron شروع شد", "2023-10-09 07:12:45", "2023-10-09 07:12:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("1330", "448", "عملیات توسط WP Cron کامل شد", "2023-10-09 07:12:45", "2023-10-09 07:12:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("1331", "449", "ایجاد فعالیت", "2023-10-09 07:12:45", "2023-10-09 07:12:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("1332", "449", "عملیات توسط WP Cron شروع شد", "2023-10-10 07:13:05", "2023-10-10 07:13:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("1333", "449", "عملیات توسط WP Cron کامل شد", "2023-10-10 07:13:05", "2023-10-10 07:13:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("1334", "450", "ایجاد فعالیت", "2023-10-10 07:13:05", "2023-10-10 07:13:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("1335", "450", "عملیات توسط WP Cron شروع شد", "2023-10-11 08:01:31", "2023-10-11 08:01:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("1336", "450", "عملیات توسط WP Cron کامل شد", "2023-10-11 08:01:31", "2023-10-11 08:01:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("1337", "451", "ایجاد فعالیت", "2023-10-11 08:01:31", "2023-10-11 08:01:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("1338", "451", "عملیات توسط WP Cron شروع شد", "2023-10-12 09:11:56", "2023-10-12 09:11:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("1339", "451", "عملیات توسط WP Cron کامل شد", "2023-10-12 09:11:56", "2023-10-12 09:11:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("1340", "452", "ایجاد فعالیت", "2023-10-12 09:11:56", "2023-10-12 09:11:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("1341", "452", "عملیات توسط WP Cron شروع شد", "2023-10-13 09:15:12", "2023-10-13 09:15:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1342", "452", "عملیات توسط WP Cron کامل شد", "2023-10-13 09:15:12", "2023-10-13 09:15:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1343", "453", "ایجاد فعالیت", "2023-10-13 09:15:12", "2023-10-13 09:15:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1344", "453", "عملیات توسط WP Cron شروع شد", "2023-10-14 10:53:33", "2023-10-14 10:53:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("1345", "453", "عملیات توسط WP Cron کامل شد", "2023-10-14 10:53:33", "2023-10-14 10:53:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("1346", "454", "ایجاد فعالیت", "2023-10-14 10:53:33", "2023-10-14 10:53:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("1347", "454", "عملیات توسط WP Cron شروع شد", "2023-10-15 12:48:38", "2023-10-15 12:48:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("1348", "454", "عملیات توسط WP Cron کامل شد", "2023-10-15 12:48:38", "2023-10-15 12:48:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("1349", "455", "ایجاد فعالیت", "2023-10-15 12:48:38", "2023-10-15 12:48:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("1350", "455", "عملیات توسط WP Cron شروع شد", "2023-10-16 12:51:25", "2023-10-16 12:51:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("1351", "455", "عملیات توسط WP Cron کامل شد", "2023-10-16 12:51:25", "2023-10-16 12:51:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("1352", "456", "ایجاد فعالیت", "2023-10-16 12:51:25", "2023-10-16 12:51:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("1353", "456", "عملیات توسط WP Cron شروع شد", "2023-10-17 13:10:39", "2023-10-17 13:10:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("1354", "456", "عملیات توسط WP Cron کامل شد", "2023-10-17 13:10:40", "2023-10-17 13:10:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("1355", "457", "ایجاد فعالیت", "2023-10-17 13:10:40", "2023-10-17 13:10:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("1356", "457", "عملیات توسط WP Cron شروع شد", "2023-10-18 13:55:24", "2023-10-18 13:55:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("1357", "457", "عملیات توسط WP Cron کامل شد", "2023-10-18 13:55:24", "2023-10-18 13:55:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("1358", "458", "ایجاد فعالیت", "2023-10-18 13:55:24", "2023-10-18 13:55:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("1359", "458", "عملیات توسط WP Cron شروع شد", "2023-10-19 14:05:57", "2023-10-19 14:05:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("1360", "458", "عملیات توسط WP Cron کامل شد", "2023-10-19 14:05:57", "2023-10-19 14:05:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("1361", "459", "ایجاد فعالیت", "2023-10-19 14:05:57", "2023-10-19 14:05:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("1362", "459", "عملیات توسط WP Cron شروع شد", "2023-10-20 16:58:04", "2023-10-20 16:58:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("1363", "459", "عملیات توسط WP Cron کامل شد", "2023-10-20 16:58:04", "2023-10-20 16:58:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("1364", "460", "ایجاد فعالیت", "2023-10-20 16:58:04", "2023-10-20 16:58:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("1365", "460", "عملیات توسط WP Cron شروع شد", "2023-10-21 17:51:27", "2023-10-21 17:51:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("1366", "460", "عملیات توسط WP Cron کامل شد", "2023-10-21 17:51:27", "2023-10-21 17:51:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("1367", "461", "ایجاد فعالیت", "2023-10-21 17:51:27", "2023-10-21 17:51:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("1368", "461", "عملیات توسط WP Cron شروع شد", "2023-10-22 19:12:31", "2023-10-22 19:12:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("1369", "461", "عملیات توسط WP Cron کامل شد", "2023-10-22 19:12:31", "2023-10-22 19:12:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("1370", "462", "ایجاد فعالیت", "2023-10-22 19:12:31", "2023-10-22 19:12:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("1371", "462", "عملیات توسط WP Cron شروع شد", "2023-10-23 21:03:57", "2023-10-23 21:03:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("1372", "462", "عملیات توسط WP Cron کامل شد", "2023-10-23 21:03:57", "2023-10-23 21:03:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("1373", "463", "ایجاد فعالیت", "2023-10-23 21:03:57", "2023-10-23 21:03:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("1374", "463", "عملیات توسط WP Cron شروع شد", "2023-10-24 22:00:46", "2023-10-24 22:00:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("1375", "463", "عملیات توسط WP Cron کامل شد", "2023-10-24 22:00:46", "2023-10-24 22:00:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("1376", "464", "ایجاد فعالیت", "2023-10-24 22:00:46", "2023-10-24 22:00:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("1377", "464", "عملیات توسط WP Cron شروع شد", "2023-10-25 22:37:20", "2023-10-25 22:37:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("1378", "464", "عملیات توسط WP Cron کامل شد", "2023-10-25 22:37:20", "2023-10-25 22:37:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("1379", "465", "ایجاد فعالیت", "2023-10-25 22:37:20", "2023-10-25 22:37:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("1380", "465", "عملیات توسط WP Cron شروع شد", "2023-10-27 03:35:30", "2023-10-27 03:35:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("1381", "465", "عملیات توسط WP Cron کامل شد", "2023-10-27 03:35:30", "2023-10-27 03:35:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("1382", "466", "ایجاد فعالیت", "2023-10-27 03:35:30", "2023-10-27 03:35:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("1383", "466", "عملیات توسط WP Cron شروع شد", "2023-10-28 06:48:20", "2023-10-28 06:48:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("1384", "466", "عملیات توسط WP Cron کامل شد", "2023-10-28 06:48:20", "2023-10-28 06:48:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("1385", "467", "ایجاد فعالیت", "2023-10-28 06:48:20", "2023-10-28 06:48:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("1386", "467", "عملیات توسط WP Cron شروع شد", "2023-10-29 07:44:11", "2023-10-29 07:44:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("1387", "467", "عملیات توسط WP Cron کامل شد", "2023-10-29 07:44:11", "2023-10-29 07:44:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("1388", "468", "ایجاد فعالیت", "2023-10-29 07:44:11", "2023-10-29 07:44:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("1389", "468", "عملیات توسط WP Cron شروع شد", "2023-10-30 07:48:16", "2023-10-30 07:48:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("1390", "468", "عملیات توسط WP Cron کامل شد", "2023-10-30 07:48:16", "2023-10-30 07:48:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("1391", "469", "ایجاد فعالیت", "2023-10-30 07:48:16", "2023-10-30 07:48:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("1392", "469", "عملیات توسط WP Cron شروع شد", "2023-10-31 16:03:23", "2023-10-31 16:03:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("1393", "469", "عملیات توسط WP Cron کامل شد", "2023-10-31 16:03:23", "2023-10-31 16:03:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("1394", "470", "ایجاد فعالیت", "2023-10-31 16:03:23", "2023-10-31 16:03:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("1395", "470", "عملیات توسط WP Cron شروع شد", "2023-11-01 20:20:51", "2023-11-01 20:20:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("1396", "470", "عملیات توسط WP Cron کامل شد", "2023-11-01 20:20:51", "2023-11-01 20:20:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("1397", "471", "ایجاد فعالیت", "2023-11-01 20:20:51", "2023-11-01 20:20:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("1398", "471", "عملیات توسط WP Cron شروع شد", "2023-11-03 00:32:17", "2023-11-03 00:32:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("1399", "471", "عملیات توسط WP Cron کامل شد", "2023-11-03 00:32:17", "2023-11-03 00:32:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("1400", "472", "ایجاد فعالیت", "2023-11-03 00:32:17", "2023-11-03 00:32:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("1401", "473", "ایجاد فعالیت", "2023-11-03 10:11:00", "2023-11-03 10:11:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("1402", "473", "عملیات توسط WP Cron شروع شد", "2023-11-03 10:11:32", "2023-11-03 10:11:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("1403", "473", "عملیات توسط WP Cron کامل شد", "2023-11-03 10:11:33", "2023-11-03 10:11:33");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("1", "maindemo_el", "d270047118b7d4383638_20231103101310", "21", "2023-11-03 10:13:39", "admin", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2023-11-03 10:13:10\";s:7:\"Version\";s:7:\"1.5.6.1\";s:9:\"VersionWP\";s:5:\"6.3.2\";s:9:\"VersionDB\";s:7:\"10.6.15\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:1;s:4:\"Name\";s:11:\"maindemo_el\";s:4:\"Hash\";s:35:\"d270047118b7d4383638_20231103101310\";s:8:\"NameHash\";s:47:\"maindemo_el_d270047118b7d4383638_20231103101310\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:57:\"maindemo_el_d270047118b7d4383638_20231103101310_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"20.9\";s:6:\"WPUser\";s:5:\"admin\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:59:\"maindemo_el_d270047118b7d4383638_20231103101310_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:68:\"/home/iranwood/domains/iran-woodmart.ir/public_html/demo/maindemo-el\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:2600;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:16557;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2023-11-03 10:13:10\";s:7:\"Version\";s:7:\"1.5.6.1\";s:9:\"VersionWP\";s:5:\"6.3.2\";s:9:\"VersionDB\";s:7:\"10.6.15\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:11:\"maindemo_el\";s:4:\"Hash\";s:35:\"d270047118b7d4383638_20231103101310\";s:8:\"NameHash\";s:47:\"maindemo_el_d270047118b7d4383638_20231103101310\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:65:\"maindemo_el_d270047118b7d4383638_20231103101310_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:82:\"/home/iranwood/domains/iran-woodmart.ir/public_html/demo/maindemo-el/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:60:\"maindemo_el_d270047118b7d4383638_20231103101310_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:14:\"MariaDB Server\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:161:\"/home/iranwood/domains/iran-woodmart.ir/public_html/demo/maindemo-el/wp-content/backups-dup-lite/tmp/maindemo_el_d270047118b7d4383638_20231103101310_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:77:\"/home/iranwood/domains/iran-woodmart.ir/public_html/demo/maindemo-el/wp-admin\";i:1;s:80:\"/home/iranwood/domains/iran-woodmart.ir/public_html/demo/maindemo-el/wp-includes\";i:2;s:89:\"/home/iranwood/domains/iran-woodmart.ir/public_html/demo/maindemo-el/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:68:\"/home/iranwood/domains/iran-woodmart.ir/public_html/demo/maindemo-el\";i:1;s:68:\"/home/iranwood/domains/iran-woodmart.ir/public_html/demo/maindemo-el\";i:2;s:79:\"/home/iranwood/domains/iran-woodmart.ir/public_html/demo/maindemo-el/wp-content\";i:3;s:87:\"/home/iranwood/domains/iran-woodmart.ir/public_html/demo/maindemo-el/wp-content/uploads\";i:4;s:87:\"/home/iranwood/domains/iran-woodmart.ir/public_html/demo/maindemo-el/wp-content/plugins\";i:5;s:90:\"/home/iranwood/domains/iran-woodmart.ir/public_html/demo/maindemo-el/wp-content/mu-plugins\";i:6;s:86:\"/home/iranwood/domains/iran-woodmart.ir/public_html/demo/maindemo-el/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:100:\"/home/iranwood/domains/iran-woodmart.ir/public_html/demo/maindemo-el/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "siteurl", "http://iran-woodmart.ir/demo/maindemo-el", "yes");
INSERT INTO `wp_options` VALUES("2", "home", "http://iran-woodmart.ir/demo/maindemo-el", "yes");
INSERT INTO `wp_options` VALUES("3", "blogname", "دمو اصلی قالب ایران وودمارت - المنتور", "yes");
INSERT INTO `wp_options` VALUES("4", "blogdescription", "یک سایت دیگر با وردپرس فارسی", "yes");
INSERT INTO `wp_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `wp_options` VALUES("6", "admin_email", "info@iran-woodmart.ir", "yes");
INSERT INTO `wp_options` VALUES("7", "start_of_week", "6", "yes");
INSERT INTO `wp_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `wp_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `wp_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `wp_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `wp_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `wp_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `wp_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `wp_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `wp_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `wp_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `wp_options` VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO `wp_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `wp_options` VALUES("21", "default_pingback_flag", "0", "yes");
INSERT INTO `wp_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `wp_options` VALUES("23", "date_format", "F j, Y", "yes");
INSERT INTO `wp_options` VALUES("24", "time_format", "g:i a", "yes");
INSERT INTO `wp_options` VALUES("25", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO `wp_options` VALUES("26", "comment_moderation", "0", "yes");
INSERT INTO `wp_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("28", "permalink_structure", "/%postname%/", "yes");
INSERT INTO `wp_options` VALUES("29", "rewrite_rules", "a:323:{s:24:\"^wc-auth/v([1]{1})/(.*)?\";s:63:\"index.php?wc-auth-version=$matches[1]&wc-auth-route=$matches[2]\";s:22:\"^wc-api/v([1-3]{1})/?$\";s:51:\"index.php?wc-api-version=$matches[1]&wc-api-route=/\";s:24:\"^wc-api/v([1-3]{1})(.*)?\";s:61:\"index.php?wc-api-version=$matches[1]&wc-api-route=$matches[2]\";s:12:\"portfolio/?$\";s:29:\"index.php?post_type=portfolio\";s:42:\"portfolio/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?post_type=portfolio&feed=$matches[1]\";s:37:\"portfolio/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?post_type=portfolio&feed=$matches[1]\";s:29:\"portfolio/page/([0-9]{1,})/?$\";s:47:\"index.php?post_type=portfolio&paged=$matches[1]\";s:7:\"shop/?$\";s:27:\"index.php?post_type=product\";s:37:\"shop/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:32:\"shop/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:24:\"shop/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=product&paged=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:23:\"^/([^/]*)/page/([^/]*)?\";s:61:\"index.php?page_id=0&wishlist_id=$matches[1]&paged=$matches[2]\";s:15:\"^/page/([^/]*)?\";s:37:\"index.php?page_id=0&paged=$matches[1]\";s:11:\"^/([^/]*)/?\";s:43:\"index.php?page_id=0&wishlist_id=$matches[1]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:32:\"category/(.+?)/wc-api(/(.*))?/?$\";s:54:\"index.php?category_name=$matches[1]&wc-api=$matches[3]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:29:\"tag/([^/]+)/wc-api(/(.*))?/?$\";s:44:\"index.php?tag=$matches[1]&wc-api=$matches[3]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:42:\"e-landing-page/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:52:\"e-landing-page/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:72:\"e-landing-page/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"e-landing-page/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"e-landing-page/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:48:\"e-landing-page/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:31:\"e-landing-page/([^/]+)/embed/?$\";s:47:\"index.php?e-landing-page=$matches[1]&embed=true\";s:35:\"e-landing-page/([^/]+)/trackback/?$\";s:41:\"index.php?e-landing-page=$matches[1]&tb=1\";s:43:\"e-landing-page/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?e-landing-page=$matches[1]&paged=$matches[2]\";s:50:\"e-landing-page/([^/]+)/comment-page-([0-9]{1,})/?$\";s:54:\"index.php?e-landing-page=$matches[1]&cpage=$matches[2]\";s:40:\"e-landing-page/([^/]+)/wc-api(/(.*))?/?$\";s:55:\"index.php?e-landing-page=$matches[1]&wc-api=$matches[3]\";s:46:\"e-landing-page/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:57:\"e-landing-page/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:39:\"e-landing-page/([^/]+)(?:/([0-9]+))?/?$\";s:53:\"index.php?e-landing-page=$matches[1]&page=$matches[2]\";s:31:\"e-landing-page/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"e-landing-page/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"e-landing-page/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"e-landing-page/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"e-landing-page/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\"e-landing-page/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:43:\"woodmart_layout/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:53:\"woodmart_layout/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:73:\"woodmart_layout/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"woodmart_layout/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"woodmart_layout/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:49:\"woodmart_layout/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:32:\"woodmart_layout/([^/]+)/embed/?$\";s:48:\"index.php?woodmart_layout=$matches[1]&embed=true\";s:36:\"woodmart_layout/([^/]+)/trackback/?$\";s:42:\"index.php?woodmart_layout=$matches[1]&tb=1\";s:44:\"woodmart_layout/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?woodmart_layout=$matches[1]&paged=$matches[2]\";s:51:\"woodmart_layout/([^/]+)/comment-page-([0-9]{1,})/?$\";s:55:\"index.php?woodmart_layout=$matches[1]&cpage=$matches[2]\";s:41:\"woodmart_layout/([^/]+)/wc-api(/(.*))?/?$\";s:56:\"index.php?woodmart_layout=$matches[1]&wc-api=$matches[3]\";s:47:\"woodmart_layout/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:58:\"woodmart_layout/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:40:\"woodmart_layout/([^/]+)(?:/([0-9]+))?/?$\";s:54:\"index.php?woodmart_layout=$matches[1]&page=$matches[2]\";s:32:\"woodmart_layout/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"woodmart_layout/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"woodmart_layout/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"woodmart_layout/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"woodmart_layout/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"woodmart_layout/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:43:\"woodmart_woo_lv/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:53:\"woodmart_woo_lv/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:73:\"woodmart_woo_lv/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"woodmart_woo_lv/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"woodmart_woo_lv/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:49:\"woodmart_woo_lv/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:32:\"woodmart_woo_lv/([^/]+)/embed/?$\";s:48:\"index.php?woodmart_woo_lv=$matches[1]&embed=true\";s:36:\"woodmart_woo_lv/([^/]+)/trackback/?$\";s:42:\"index.php?woodmart_woo_lv=$matches[1]&tb=1\";s:44:\"woodmart_woo_lv/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?woodmart_woo_lv=$matches[1]&paged=$matches[2]\";s:51:\"woodmart_woo_lv/([^/]+)/comment-page-([0-9]{1,})/?$\";s:55:\"index.php?woodmart_woo_lv=$matches[1]&cpage=$matches[2]\";s:41:\"woodmart_woo_lv/([^/]+)/wc-api(/(.*))?/?$\";s:56:\"index.php?woodmart_woo_lv=$matches[1]&wc-api=$matches[3]\";s:47:\"woodmart_woo_lv/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:58:\"woodmart_woo_lv/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:40:\"woodmart_woo_lv/([^/]+)(?:/([0-9]+))?/?$\";s:54:\"index.php?woodmart_woo_lv=$matches[1]&page=$matches[2]\";s:32:\"woodmart_woo_lv/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"woodmart_woo_lv/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"woodmart_woo_lv/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"woodmart_woo_lv/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"woodmart_woo_lv/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"woodmart_woo_lv/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:44:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:54:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:74:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:50:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"woodmart_woo_fbt/([^/]+)/embed/?$\";s:49:\"index.php?woodmart_woo_fbt=$matches[1]&embed=true\";s:37:\"woodmart_woo_fbt/([^/]+)/trackback/?$\";s:43:\"index.php?woodmart_woo_fbt=$matches[1]&tb=1\";s:45:\"woodmart_woo_fbt/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?woodmart_woo_fbt=$matches[1]&paged=$matches[2]\";s:52:\"woodmart_woo_fbt/([^/]+)/comment-page-([0-9]{1,})/?$\";s:56:\"index.php?woodmart_woo_fbt=$matches[1]&cpage=$matches[2]\";s:42:\"woodmart_woo_fbt/([^/]+)/wc-api(/(.*))?/?$\";s:57:\"index.php?woodmart_woo_fbt=$matches[1]&wc-api=$matches[3]\";s:48:\"woodmart_woo_fbt/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:59:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:41:\"woodmart_woo_fbt/([^/]+)(?:/([0-9]+))?/?$\";s:55:\"index.php?woodmart_woo_fbt=$matches[1]&page=$matches[2]\";s:33:\"woodmart_woo_fbt/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"woodmart_woo_fbt/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"woodmart_woo_fbt/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"woodmart_woo_fbt/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"woodmart_woo_fbt/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"woodmart_woo_fbt/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:54:\"cms_block_cat/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?cms_block_cat=$matches[1]&feed=$matches[2]\";s:49:\"cms_block_cat/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?cms_block_cat=$matches[1]&feed=$matches[2]\";s:30:\"cms_block_cat/([^/]+)/embed/?$\";s:46:\"index.php?cms_block_cat=$matches[1]&embed=true\";s:42:\"cms_block_cat/([^/]+)/page/?([0-9]{1,})/?$\";s:53:\"index.php?cms_block_cat=$matches[1]&paged=$matches[2]\";s:24:\"cms_block_cat/([^/]+)/?$\";s:35:\"index.php?cms_block_cat=$matches[1]\";s:42:\"woodmart_slide/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:52:\"woodmart_slide/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:72:\"woodmart_slide/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"woodmart_slide/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"woodmart_slide/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:48:\"woodmart_slide/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:31:\"woodmart_slide/([^/]+)/embed/?$\";s:47:\"index.php?woodmart_slide=$matches[1]&embed=true\";s:35:\"woodmart_slide/([^/]+)/trackback/?$\";s:41:\"index.php?woodmart_slide=$matches[1]&tb=1\";s:43:\"woodmart_slide/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?woodmart_slide=$matches[1]&paged=$matches[2]\";s:50:\"woodmart_slide/([^/]+)/comment-page-([0-9]{1,})/?$\";s:54:\"index.php?woodmart_slide=$matches[1]&cpage=$matches[2]\";s:40:\"woodmart_slide/([^/]+)/wc-api(/(.*))?/?$\";s:55:\"index.php?woodmart_slide=$matches[1]&wc-api=$matches[3]\";s:46:\"woodmart_slide/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:57:\"woodmart_slide/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:39:\"woodmart_slide/([^/]+)(?:/([0-9]+))?/?$\";s:53:\"index.php?woodmart_slide=$matches[1]&page=$matches[2]\";s:31:\"woodmart_slide/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"woodmart_slide/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"woodmart_slide/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"woodmart_slide/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"woodmart_slide/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\"woodmart_slide/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:56:\"woodmart_slider/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:68:\"index.php?taxonomy=woodmart_slider&term=$matches[1]&feed=$matches[2]\";s:51:\"woodmart_slider/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:68:\"index.php?taxonomy=woodmart_slider&term=$matches[1]&feed=$matches[2]\";s:32:\"woodmart_slider/([^/]+)/embed/?$\";s:62:\"index.php?taxonomy=woodmart_slider&term=$matches[1]&embed=true\";s:44:\"woodmart_slider/([^/]+)/page/?([0-9]{1,})/?$\";s:69:\"index.php?taxonomy=woodmart_slider&term=$matches[1]&paged=$matches[2]\";s:26:\"woodmart_slider/([^/]+)/?$\";s:51:\"index.php?taxonomy=woodmart_slider&term=$matches[1]\";s:37:\"portfolio/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"portfolio/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"portfolio/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"portfolio/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"portfolio/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"portfolio/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:26:\"portfolio/([^/]+)/embed/?$\";s:42:\"index.php?portfolio=$matches[1]&embed=true\";s:30:\"portfolio/([^/]+)/trackback/?$\";s:36:\"index.php?portfolio=$matches[1]&tb=1\";s:50:\"portfolio/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?portfolio=$matches[1]&feed=$matches[2]\";s:45:\"portfolio/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?portfolio=$matches[1]&feed=$matches[2]\";s:38:\"portfolio/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&paged=$matches[2]\";s:45:\"portfolio/([^/]+)/comment-page-([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&cpage=$matches[2]\";s:35:\"portfolio/([^/]+)/wc-api(/(.*))?/?$\";s:50:\"index.php?portfolio=$matches[1]&wc-api=$matches[3]\";s:41:\"portfolio/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:52:\"portfolio/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:34:\"portfolio/([^/]+)(?:/([0-9]+))?/?$\";s:48:\"index.php?portfolio=$matches[1]&page=$matches[2]\";s:26:\"portfolio/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:36:\"portfolio/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:56:\"portfolio/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"portfolio/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"portfolio/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:32:\"portfolio/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:50:\"project-cat/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?project-cat=$matches[1]&feed=$matches[2]\";s:45:\"project-cat/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?project-cat=$matches[1]&feed=$matches[2]\";s:26:\"project-cat/(.+?)/embed/?$\";s:44:\"index.php?project-cat=$matches[1]&embed=true\";s:38:\"project-cat/(.+?)/page/?([0-9]{1,})/?$\";s:51:\"index.php?project-cat=$matches[1]&paged=$matches[2]\";s:20:\"project-cat/(.+?)/?$\";s:33:\"index.php?project-cat=$matches[1]\";s:55:\"product-category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:50:\"product-category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:31:\"product-category/(.+?)/embed/?$\";s:44:\"index.php?product_cat=$matches[1]&embed=true\";s:43:\"product-category/(.+?)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_cat=$matches[1]&paged=$matches[2]\";s:25:\"product-category/(.+?)/?$\";s:33:\"index.php?product_cat=$matches[1]\";s:52:\"product-tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:47:\"product-tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:28:\"product-tag/([^/]+)/embed/?$\";s:44:\"index.php?product_tag=$matches[1]&embed=true\";s:40:\"product-tag/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_tag=$matches[1]&paged=$matches[2]\";s:22:\"product-tag/([^/]+)/?$\";s:33:\"index.php?product_tag=$matches[1]\";s:35:\"product/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"product/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"product/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"product/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"product/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"product/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"product/([^/]+)/embed/?$\";s:40:\"index.php?product=$matches[1]&embed=true\";s:28:\"product/([^/]+)/trackback/?$\";s:34:\"index.php?product=$matches[1]&tb=1\";s:48:\"product/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:43:\"product/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:36:\"product/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&paged=$matches[2]\";s:43:\"product/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&cpage=$matches[2]\";s:33:\"product/([^/]+)/wc-api(/(.*))?/?$\";s:48:\"index.php?product=$matches[1]&wc-api=$matches[3]\";s:39:\"product/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:50:\"product/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:32:\"product/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?product=$matches[1]&page=$matches[2]\";s:24:\"product/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"product/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"product/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"product/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"product/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"product/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:38:\"mc4wp-form/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:48:\"mc4wp-form/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:68:\"mc4wp-form/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"mc4wp-form/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"mc4wp-form/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:44:\"mc4wp-form/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:27:\"mc4wp-form/([^/]+)/embed/?$\";s:43:\"index.php?mc4wp-form=$matches[1]&embed=true\";s:31:\"mc4wp-form/([^/]+)/trackback/?$\";s:37:\"index.php?mc4wp-form=$matches[1]&tb=1\";s:39:\"mc4wp-form/([^/]+)/page/?([0-9]{1,})/?$\";s:50:\"index.php?mc4wp-form=$matches[1]&paged=$matches[2]\";s:46:\"mc4wp-form/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?mc4wp-form=$matches[1]&cpage=$matches[2]\";s:36:\"mc4wp-form/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?mc4wp-form=$matches[1]&wc-api=$matches[3]\";s:42:\"mc4wp-form/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:53:\"mc4wp-form/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:35:\"mc4wp-form/([^/]+)(?:/([0-9]+))?/?$\";s:49:\"index.php?mc4wp-form=$matches[1]&page=$matches[2]\";s:27:\"mc4wp-form/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"mc4wp-form/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"mc4wp-form/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"mc4wp-form/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"mc4wp-form/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"mc4wp-form/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:40:\"index.php?&page_id=891&cpage=$matches[1]\";s:17:\"wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:26:\"comments/wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:29:\"search/(.+)/wc-api(/(.*))?/?$\";s:42:\"index.php?s=$matches[1]&wc-api=$matches[3]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:32:\"author/([^/]+)/wc-api(/(.*))?/?$\";s:52:\"index.php?author_name=$matches[1]&wc-api=$matches[3]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:54:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:82:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc-api=$matches[5]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:41:\"([0-9]{4})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:66:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc-api=$matches[4]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:28:\"([0-9]{4})/wc-api(/(.*))?/?$\";s:45:\"index.php?year=$matches[1]&wc-api=$matches[3]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:25:\"(.?.+?)/wc-api(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&wc-api=$matches[3]\";s:28:\"(.?.+?)/order-pay(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&order-pay=$matches[3]\";s:33:\"(.?.+?)/order-received(/(.*))?/?$\";s:57:\"index.php?pagename=$matches[1]&order-received=$matches[3]\";s:25:\"(.?.+?)/orders(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&orders=$matches[3]\";s:29:\"(.?.+?)/view-order(/(.*))?/?$\";s:53:\"index.php?pagename=$matches[1]&view-order=$matches[3]\";s:28:\"(.?.+?)/downloads(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&downloads=$matches[3]\";s:31:\"(.?.+?)/edit-account(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-account=$matches[3]\";s:31:\"(.?.+?)/edit-address(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-address=$matches[3]\";s:34:\"(.?.+?)/payment-methods(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&payment-methods=$matches[3]\";s:32:\"(.?.+?)/lost-password(/(.*))?/?$\";s:56:\"index.php?pagename=$matches[1]&lost-password=$matches[3]\";s:34:\"(.?.+?)/customer-logout(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&customer-logout=$matches[3]\";s:37:\"(.?.+?)/add-payment-method(/(.*))?/?$\";s:61:\"index.php?pagename=$matches[1]&add-payment-method=$matches[3]\";s:40:\"(.?.+?)/delete-payment-method(/(.*))?/?$\";s:64:\"index.php?pagename=$matches[1]&delete-payment-method=$matches[3]\";s:45:\"(.?.+?)/set-default-payment-method(/(.*))?/?$\";s:69:\"index.php?pagename=$matches[1]&set-default-payment-method=$matches[3]\";s:31:\".?.+?/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\".?.+?/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:25:\"([^/]+)/wc-api(/(.*))?/?$\";s:45:\"index.php?name=$matches[1]&wc-api=$matches[3]\";s:31:\"[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\"[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}", "yes");
INSERT INTO `wp_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `wp_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `wp_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `wp_options` VALUES("33", "active_plugins", "a:7:{i:0;s:36:\"contact-form-7/wp-contact-form-7.php\";i:1;s:25:\"duplicator/duplicator.php\";i:2;s:23:\"elementor/elementor.php\";i:3;s:37:\"mailchimp-for-wp/mailchimp-for-wp.php\";i:4;s:23:\"revslider/revslider.php\";i:5;s:27:\"woocommerce/woocommerce.php\";i:6;s:31:\"woodmart-core/woodmart-core.php\";}", "yes");
INSERT INTO `wp_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `wp_options` VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `wp_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `wp_options` VALUES("37", "gmt_offset", "+3.5", "yes");
INSERT INTO `wp_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `wp_options` VALUES("39", "recently_edited", "", "no");
INSERT INTO `wp_options` VALUES("40", "template", "woodmart", "yes");
INSERT INTO `wp_options` VALUES("41", "stylesheet", "woodmart-child", "yes");
INSERT INTO `wp_options` VALUES("42", "comment_registration", "0", "yes");
INSERT INTO `wp_options` VALUES("43", "html_type", "text/html", "yes");
INSERT INTO `wp_options` VALUES("44", "use_trackback", "0", "yes");
INSERT INTO `wp_options` VALUES("45", "default_role", "subscriber", "yes");
INSERT INTO `wp_options` VALUES("46", "db_version", "55853", "yes");
INSERT INTO `wp_options` VALUES("47", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `wp_options` VALUES("48", "upload_path", "", "yes");
INSERT INTO `wp_options` VALUES("49", "blog_public", "0", "yes");
INSERT INTO `wp_options` VALUES("50", "default_link_category", "2", "yes");
INSERT INTO `wp_options` VALUES("51", "show_on_front", "page", "yes");
INSERT INTO `wp_options` VALUES("52", "tag_base", "", "yes");
INSERT INTO `wp_options` VALUES("53", "show_avatars", "1", "yes");
INSERT INTO `wp_options` VALUES("54", "avatar_rating", "G", "yes");
INSERT INTO `wp_options` VALUES("55", "upload_url_path", "", "yes");
INSERT INTO `wp_options` VALUES("56", "thumbnail_size_w", "150", "yes");
INSERT INTO `wp_options` VALUES("57", "thumbnail_size_h", "150", "yes");
INSERT INTO `wp_options` VALUES("58", "thumbnail_crop", "1", "yes");
INSERT INTO `wp_options` VALUES("59", "medium_size_w", "300", "yes");
INSERT INTO `wp_options` VALUES("60", "medium_size_h", "300", "yes");
INSERT INTO `wp_options` VALUES("61", "avatar_default", "mystery", "yes");
INSERT INTO `wp_options` VALUES("62", "large_size_w", "1024", "yes");
INSERT INTO `wp_options` VALUES("63", "large_size_h", "1024", "yes");
INSERT INTO `wp_options` VALUES("64", "image_default_link_type", "none", "yes");
INSERT INTO `wp_options` VALUES("65", "image_default_size", "", "yes");
INSERT INTO `wp_options` VALUES("66", "image_default_align", "", "yes");
INSERT INTO `wp_options` VALUES("67", "close_comments_for_old_posts", "0", "yes");
INSERT INTO `wp_options` VALUES("68", "close_comments_days_old", "14", "yes");
INSERT INTO `wp_options` VALUES("69", "thread_comments", "1", "yes");
INSERT INTO `wp_options` VALUES("70", "thread_comments_depth", "5", "yes");
INSERT INTO `wp_options` VALUES("71", "page_comments", "0", "yes");
INSERT INTO `wp_options` VALUES("72", "comments_per_page", "50", "yes");
INSERT INTO `wp_options` VALUES("73", "default_comments_page", "newest", "yes");
INSERT INTO `wp_options` VALUES("74", "comment_order", "asc", "yes");
INSERT INTO `wp_options` VALUES("75", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("76", "widget_categories", "a:4:{i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}i:8;a:1:{s:5:\"title\";s:10:\"Categories\";}i:6;a:4:{s:5:\"title\";s:22:\"دسته بندی ها\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("77", "widget_text", "a:5:{i:11;a:1:{s:4:\"text\";s:719:\"\n<div class=\"footer-logo\" style=\"max-width: 80%; margin-bottom: 10px;\"><img src=\"http://iran-woodmart.ir/demo/maindemo-el/wp-content/themes/woodmart/images/wood-logo-dark.svg\"  style=\"margin-bottom: 10px;\" /></div>\n<p>Condimentum adipiscing vel neque dis nam parturient orci at scelerisque neque dis nam parturient.</p>\n<div style=\"line-height: 2;\"><i class=\"fa fa-location-arrow\" style=\"width: 15px; text-align: center; margin-right: 4px;\"></i> 451 Wall Street, UK, London<br>\n<i class=\"fa fa-mobile\" style=\"width: 15px; text-align: center; margin-right: 4px;\"></i> Phone: (064) 332-1233<br>\n<i class=\"fa fa-envelope-o\" style=\"width: 15px; text-align: center; margin-right: 4px;\"></i> Fax: (099) 453-1357</div>\n		    	\";}i:13;a:4:{s:5:\"title\";s:26:\"نماینده های ما\";s:4:\"text\";s:428:\"<ul class=\"menu\">\r\n     <li><a href=\"#\">نماینده ما در تهران</a></li>\r\n     <li><a href=\"#\">نماینده ما در مشهد</a></li>\r\n     <li><a href=\"#\">نماینده ما در اصفهان</a></li>\r\n     <li><a href=\"#\">نماینده ما در شیراز</a></li>\r\n     <li><a href=\"#\">نماینده ما در تبریز</a></li>\r\n     <li><a href=\"#\">نماینده ما در گرگان</a></li>\r\n</ul>\r\n\";s:6:\"filter\";b:0;s:6:\"visual\";b:0;}i:14;a:4:{s:5:\"title\";s:24:\"لینک های مفید\";s:4:\"text\";s:384:\"<ul class=\"menu\">\r\n<li><a href=\"#\">قوانین و مقررات سایت</a></li>\r\n<li><a href=\"#\">ایران وودمارت</a></li>\r\n<li><a href=\"#\">قوانین بازگشت وجه</a></li>\r\n<li><a href=\"#\">تماس با ما</a></li>\r\n<li><a href=\"#\">آخرین مطالب سایت</a></li>\r\n<li><a href=\"https://iran-woodmart.ir/\">خرید قالب وودمارت</a></li>\r\n</ul>\";s:6:\"filter\";b:0;s:6:\"visual\";b:0;}i:15;a:4:{s:5:\"title\";s:19:\"فهرست فوتر\";s:4:\"text\";s:445:\"<ul>\r\n<li><a href=\"#\">مجموعه های جدید</a></li>\r\n<li><a href=\"#\">نمایندگان جدید</a></li>\r\n<li><a href=\"#\">محصولات جدید</a></li>\r\n<li><a href=\"#\">برخی از مقالات</a></li>\r\n<li><a href=\"#\">فروشندگان برتر</a></li>\r\n<li><a href=\"https://iran-woodmart.ir/product/%d9%82%d8%a7%d9%84%d8%a8-%d9%88%d9%88%d8%af%d9%85%d8%a7%d8%b1%d8%aa/\">خرید قالب وودمارت</a></li>\r\n</ul>\r\n		    	\";s:6:\"filter\";b:0;s:6:\"visual\";b:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("78", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("79", "uninstall_plugins", "a:2:{s:23:\"elementor/elementor.php\";a:2:{i:0;s:21:\"Elementor\\Maintenance\";i:1;s:9:\"uninstall\";}s:28:\"export-import-menus/main.php\";a:2:{i:0;s:20:\"DspExportImportMenus\";i:1;s:12:\"on_uninstall\";}}", "no");
INSERT INTO `wp_options` VALUES("80", "timezone_string", "", "yes");
INSERT INTO `wp_options` VALUES("81", "page_for_posts", "107", "yes");
INSERT INTO `wp_options` VALUES("82", "page_on_front", "891", "yes");
INSERT INTO `wp_options` VALUES("83", "default_post_format", "0", "yes");
INSERT INTO `wp_options` VALUES("84", "link_manager_enabled", "0", "yes");
INSERT INTO `wp_options` VALUES("85", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `wp_options` VALUES("86", "site_icon", "0", "yes");
INSERT INTO `wp_options` VALUES("87", "medium_large_size_w", "768", "yes");
INSERT INTO `wp_options` VALUES("88", "medium_large_size_h", "0", "yes");
INSERT INTO `wp_options` VALUES("89", "wp_page_for_privacy_policy", "3", "yes");
INSERT INTO `wp_options` VALUES("90", "show_comments_cookies_opt_in", "1", "yes");
INSERT INTO `wp_options` VALUES("91", "admin_email_lifespan", "1699949906", "yes");
INSERT INTO `wp_options` VALUES("92", "disallowed_keys", "", "no");
INSERT INTO `wp_options` VALUES("93", "comment_previously_approved", "1", "yes");
INSERT INTO `wp_options` VALUES("94", "auto_plugin_theme_update_emails", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("95", "initial_db_version", "48748", "yes");
INSERT INTO `wp_options` VALUES("96", "wp_user_roles", "a:7:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:114:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:8:\"customer\";a:2:{s:4:\"name\";s:8:\"Customer\";s:12:\"capabilities\";a:1:{s:4:\"read\";b:1;}}s:12:\"shop_manager\";a:2:{s:4:\"name\";s:12:\"Shop manager\";s:12:\"capabilities\";a:92:{s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:4:\"read\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:10:\"edit_posts\";b:1;s:10:\"edit_pages\";b:1;s:20:\"edit_published_posts\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"edit_private_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_posts\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_posts\";b:1;s:12:\"delete_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:20:\"delete_private_posts\";b:1;s:22:\"delete_published_pages\";b:1;s:22:\"delete_published_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:19:\"delete_others_pages\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:17:\"moderate_comments\";b:1;s:12:\"upload_files\";b:1;s:6:\"export\";b:1;s:6:\"import\";b:1;s:10:\"list_users\";b:1;s:18:\"edit_theme_options\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;}}}", "yes");
INSERT INTO `wp_options` VALUES("97", "fresh_site", "0", "yes");
INSERT INTO `wp_options` VALUES("98", "WPLANG", "fa_IR", "yes");
INSERT INTO `wp_options` VALUES("99", "widget_search", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("100", "widget_recent-posts", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("101", "widget_recent-comments", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("102", "widget_archives", "a:2:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("103", "widget_meta", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("104", "sidebars_widgets", "a:16:{s:19:\"wp_inactive_widgets\";a:11:{i:0;s:10:\"archives-2\";i:1;s:6:\"meta-2\";i:2;s:8:\"search-2\";i:3;s:7:\"text-11\";i:4;s:12:\"categories-2\";i:5;s:12:\"categories-8\";i:6;s:14:\"recent-posts-2\";i:7;s:17:\"recent-comments-2\";i:8;s:21:\"woodmart-instagram-10\";i:9;s:23:\"woodmart-recent-posts-9\";i:10;s:24:\"woodmart-recent-posts-12\";}s:9:\"sidebar-1\";a:3:{i:0;s:12:\"categories-6\";i:1;s:23:\"woodmart-recent-posts-7\";i:2;s:20:\"woodmart-instagram-8\";}s:22:\"portfolio-widgets-area\";a:0:{}s:12:\"sidebar-shop\";a:4:{i:0;s:32:\"woocommerce_product_categories-1\";i:1;s:26:\"woocommerce_price_filter-2\";i:2;s:34:\"woodmart-woocommerce-layered-nav-3\";i:3;s:22:\"woocommerce_products-4\";}s:12:\"filters-area\";a:0:{}s:22:\"sidebar-product-single\";a:2:{i:0;s:22:\"woocommerce_products-5\";i:1;s:23:\"woodmart-recent-posts-6\";}s:18:\"sidebar-my-account\";a:0:{}s:24:\"sidebar-full-screen-menu\";a:0:{}s:19:\"mobile-menu-widgets\";a:0:{}s:8:\"footer-1\";a:2:{i:0;s:7:\"block-2\";i:1;s:7:\"block-6\";}s:8:\"footer-2\";a:1:{i:0;s:24:\"woodmart-recent-posts-10\";}s:8:\"footer-3\";a:1:{i:0;s:7:\"text-13\";}s:8:\"footer-4\";a:1:{i:0;s:7:\"text-14\";}s:8:\"footer-5\";a:1:{i:0;s:7:\"text-15\";}s:11:\"sidebar-204\";a:1:{i:0;s:23:\"woodmart-recent-posts-5\";}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `wp_options` VALUES("105", "cron", "a:31:{i:1699006456;a:1:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}}i:1699007353;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1699007814;a:1:{s:40:\"woodmart_wishlist_send_promotional_email\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1699009600;a:1:{s:33:\"wc_admin_process_orders_milestone\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1699009607;a:1:{s:29:\"wc_admin_unsnooze_admin_notes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1699009856;a:1:{s:20:\"jetpack_clean_nonces\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1699009859;a:1:{s:32:\"woocommerce_cancel_unpaid_orders\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1699016130;a:1:{s:37:\"puc_cron_check_updates_theme-woodmart\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1699017059;a:2:{s:24:\"woocommerce_cleanup_logs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:31:\"woocommerce_cleanup_rate_limits\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1699022398;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1699027859;a:1:{s:28:\"woocommerce_cleanup_sessions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1699035479;a:1:{s:28:\"elementor/tracker/send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1699043353;a:3:{s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1699043596;a:1:{s:36:\"puc_cron_check_updates-Elementor-Pro\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1699044363;a:1:{s:18:\"wp_https_detection\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1699045200;a:1:{s:27:\"woocommerce_scheduled_sales\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1699062060;a:1:{s:29:\"mc4wp_refresh_mailchimp_lists\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1699084200;a:1:{s:29:\"mc4wp_refresh_mailchimp_lists\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1699086047;a:1:{s:17:\"nikan_offer_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1699086552;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1699086982;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1699086983;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1699088800;a:1:{s:14:\"wc_admin_daily\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1699092657;a:1:{s:20:\"jetpack_v2_heartbeat\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1699092669;a:2:{s:33:\"woocommerce_cleanup_personal_data\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:30:\"woocommerce_tracker_send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1699259352;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1699266600;a:1:{s:29:\"duplicator_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1699384515;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1699610985;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1700302319;a:1:{s:25:\"woocommerce_geoip_updater\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:11:\"fifteendays\";s:4:\"args\";a:0:{}s:8:\"interval\";i:1296000;}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO `wp_options` VALUES("106", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("107", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("108", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("109", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("110", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("111", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("112", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("113", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("114", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("116", "recovery_keys", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("120", "theme_mods_twentytwenty", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1627203375;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";}s:9:\"sidebar-2\";a:3:{i:0;s:10:\"archives-2\";i:1;s:12:\"categories-2\";i:2;s:6:\"meta-2\";}}}}", "yes");
INSERT INTO `wp_options` VALUES("131", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:15:\"admin@gmail.com\";s:7:\"version\";s:5:\"6.2.3\";s:9:\"timestamp\";i:1697144332;}", "no");
INSERT INTO `wp_options` VALUES("152", "finished_updating_comment_type", "1", "yes");
INSERT INTO `wp_options` VALUES("154", "widget_block", "a:3:{i:2;a:1:{s:7:\"content\";s:190:\"<!-- wp:image -->\n<figure class=\"wp-block-image\"><img src=\"http://iran-woodmart.ir/demo/maindemo-el/wp-content/themes/woodmart/images/wood-logo-dark.svg\" alt=\"\"/></figure>\n<!-- /wp:image -->\";}i:6;a:1:{s:7:\"content\";s:675:\"<p>با استفاده از قالب وردپرس فروشگاهی وودمارت ، فراتر از دیجی کالا را طراحی نمایید و محصولات خود را برای فروش آماده کنید</p>\n<div style=\"line-height: 2;\"><i class=\"fa fa-location-arrow\" style=\"width: 15px; text-align: center; margin-right: 4px; color: #676767;\"></i> تهران - شهر ری<br>\n<i class=\"fa fa-location-arrow\" style=\"width: 15px; text-align: center; margin-right: 4px; color: #676767;\"></i> تلفن : 021-8955622<br>\n<i class=\"fa fa-envelope-o\" style=\"width: 15px; text-align: center; margin-right: 4px; color: #676767;\"></i> فکس : 021-59594444</div>\n		    	\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("155", "auto_update_core_dev", "enabled", "yes");
INSERT INTO `wp_options` VALUES("156", "auto_update_core_minor", "enabled", "yes");
INSERT INTO `wp_options` VALUES("157", "auto_update_core_major", "unset", "yes");
INSERT INTO `wp_options` VALUES("158", "wp_force_deactivated_plugins", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("159", "db_upgraded", "", "yes");
INSERT INTO `wp_options` VALUES("163", "https_detection_errors", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("165", "current_theme", "Woodmart Child", "yes");
INSERT INTO `wp_options` VALUES("166", "theme_mods_twentytwentyone", "a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:0:{}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1627203380;s:4:\"data\";a:2:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}}}}", "yes");
INSERT INTO `wp_options` VALUES("167", "theme_switched", "", "yes");
INSERT INTO `wp_options` VALUES("169", "theme_mods_woodmart-child", "a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:2:{s:9:\"main-menu\";s:2:\"46\";s:11:\"mobile-menu\";s:2:\"47\";}s:18:\"custom_css_post_id\";i:-1;}", "yes");
INSERT INTO `wp_options` VALUES("170", "woodmart_token", "1", "yes");
INSERT INTO `wp_options` VALUES("171", "woodmart_is_activated", "1", "yes");
INSERT INTO `wp_options` VALUES("173", "puc_external_updates_theme-woodmart", "O:8:\"stdClass\":5:{s:9:\"lastCheck\";i:1699006182;s:14:\"checkedVersion\";s:5:\"7.3.2\";s:6:\"update\";O:8:\"stdClass\":5:{s:4:\"slug\";s:8:\"woodmart\";s:7:\"version\";s:5:\"7.3.2\";s:12:\"download_url\";s:61:\"http://dl.flatsomee.ir/sources/wdmrt/woodmart-new-version.zip\";s:12:\"translations\";a:0:{}s:11:\"details_url\";s:49:\"http://dl.flatsomee.ir/sources/wdmrt/changes.html\";}s:11:\"updateClass\";s:21:\"Puc_v4p9_Theme_Update\";s:15:\"updateBaseClass\";s:12:\"Theme_Update\";}", "no");
INSERT INTO `wp_options` VALUES("178", "action_scheduler_hybrid_store_demarkation", "5", "yes");
INSERT INTO `wp_options` VALUES("179", "schema-ActionScheduler_StoreSchema", "7.0.1699006258", "yes");
INSERT INTO `wp_options` VALUES("180", "schema-ActionScheduler_LoggerSchema", "3.0.1642499670", "yes");
INSERT INTO `wp_options` VALUES("183", "woocommerce_schema_version", "430", "yes");
INSERT INTO `wp_options` VALUES("184", "woocommerce_store_address", "ایران", "yes");
INSERT INTO `wp_options` VALUES("185", "woocommerce_store_address_2", "ایران", "yes");
INSERT INTO `wp_options` VALUES("186", "woocommerce_store_city", "ایران", "yes");
INSERT INTO `wp_options` VALUES("187", "woocommerce_default_country", "IR:GLS", "yes");
INSERT INTO `wp_options` VALUES("188", "woocommerce_store_postcode", "7954321158", "yes");
INSERT INTO `wp_options` VALUES("189", "woocommerce_allowed_countries", "all", "yes");
INSERT INTO `wp_options` VALUES("190", "woocommerce_all_except_countries", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("191", "woocommerce_specific_allowed_countries", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("192", "woocommerce_ship_to_countries", "", "yes");
INSERT INTO `wp_options` VALUES("193", "woocommerce_specific_ship_to_countries", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("194", "woocommerce_default_customer_address", "base", "yes");
INSERT INTO `wp_options` VALUES("195", "woocommerce_calc_taxes", "no", "yes");
INSERT INTO `wp_options` VALUES("196", "woocommerce_enable_coupons", "yes", "yes");
INSERT INTO `wp_options` VALUES("197", "woocommerce_calc_discounts_sequentially", "no", "no");
INSERT INTO `wp_options` VALUES("198", "woocommerce_currency", "IRT", "yes");
INSERT INTO `wp_options` VALUES("199", "woocommerce_currency_pos", "right_space", "yes");
INSERT INTO `wp_options` VALUES("200", "woocommerce_price_thousand_sep", "", "yes");
INSERT INTO `wp_options` VALUES("201", "woocommerce_price_decimal_sep", "", "yes");
INSERT INTO `wp_options` VALUES("202", "woocommerce_price_num_decimals", "0", "yes");
INSERT INTO `wp_options` VALUES("203", "woocommerce_shop_page_id", "6", "yes");
INSERT INTO `wp_options` VALUES("204", "woocommerce_cart_redirect_after_add", "no", "yes");
INSERT INTO `wp_options` VALUES("205", "woocommerce_enable_ajax_add_to_cart", "yes", "yes");
INSERT INTO `wp_options` VALUES("206", "woocommerce_placeholder_image", "5", "yes");
INSERT INTO `wp_options` VALUES("207", "woocommerce_weight_unit", "kg", "yes");
INSERT INTO `wp_options` VALUES("208", "woocommerce_dimension_unit", "cm", "yes");
INSERT INTO `wp_options` VALUES("209", "woocommerce_enable_reviews", "yes", "yes");
INSERT INTO `wp_options` VALUES("210", "woocommerce_review_rating_verification_label", "yes", "no");
INSERT INTO `wp_options` VALUES("211", "woocommerce_review_rating_verification_required", "no", "no");
INSERT INTO `wp_options` VALUES("212", "woocommerce_enable_review_rating", "yes", "yes");
INSERT INTO `wp_options` VALUES("213", "woocommerce_review_rating_required", "yes", "no");
INSERT INTO `wp_options` VALUES("214", "woocommerce_manage_stock", "yes", "yes");
INSERT INTO `wp_options` VALUES("215", "woocommerce_hold_stock_minutes", "60", "no");
INSERT INTO `wp_options` VALUES("216", "woocommerce_notify_low_stock", "yes", "no");
INSERT INTO `wp_options` VALUES("217", "woocommerce_notify_no_stock", "yes", "no");
INSERT INTO `wp_options` VALUES("218", "woocommerce_stock_email_recipient", "admin@gmail.com", "no");
INSERT INTO `wp_options` VALUES("219", "woocommerce_notify_low_stock_amount", "2", "no");
INSERT INTO `wp_options` VALUES("220", "woocommerce_notify_no_stock_amount", "0", "yes");
INSERT INTO `wp_options` VALUES("221", "woocommerce_hide_out_of_stock_items", "no", "yes");
INSERT INTO `wp_options` VALUES("222", "woocommerce_stock_format", "", "yes");
INSERT INTO `wp_options` VALUES("223", "woocommerce_file_download_method", "force", "no");
INSERT INTO `wp_options` VALUES("224", "woocommerce_downloads_redirect_fallback_allowed", "no", "no");
INSERT INTO `wp_options` VALUES("225", "woocommerce_downloads_require_login", "no", "no");
INSERT INTO `wp_options` VALUES("226", "woocommerce_downloads_grant_access_after_payment", "yes", "no");
INSERT INTO `wp_options` VALUES("227", "woocommerce_downloads_add_hash_to_filename", "yes", "yes");
INSERT INTO `wp_options` VALUES("228", "woocommerce_prices_include_tax", "no", "yes");
INSERT INTO `wp_options` VALUES("229", "woocommerce_tax_based_on", "shipping", "yes");
INSERT INTO `wp_options` VALUES("230", "woocommerce_shipping_tax_class", "inherit", "yes");
INSERT INTO `wp_options` VALUES("231", "woocommerce_tax_round_at_subtotal", "no", "yes");
INSERT INTO `wp_options` VALUES("232", "woocommerce_tax_classes", "", "yes");
INSERT INTO `wp_options` VALUES("233", "woocommerce_tax_display_shop", "excl", "yes");
INSERT INTO `wp_options` VALUES("234", "woocommerce_tax_display_cart", "excl", "yes");
INSERT INTO `wp_options` VALUES("235", "woocommerce_price_display_suffix", "", "yes");
INSERT INTO `wp_options` VALUES("236", "woocommerce_tax_total_display", "itemized", "no");
INSERT INTO `wp_options` VALUES("237", "woocommerce_enable_shipping_calc", "yes", "no");
INSERT INTO `wp_options` VALUES("238", "woocommerce_shipping_cost_requires_address", "no", "yes");
INSERT INTO `wp_options` VALUES("239", "woocommerce_ship_to_destination", "billing", "no");
INSERT INTO `wp_options` VALUES("240", "woocommerce_shipping_debug_mode", "no", "yes");
INSERT INTO `wp_options` VALUES("241", "woocommerce_enable_guest_checkout", "yes", "no");
INSERT INTO `wp_options` VALUES("242", "woocommerce_enable_checkout_login_reminder", "no", "no");
INSERT INTO `wp_options` VALUES("243", "woocommerce_enable_signup_and_login_from_checkout", "no", "no");
INSERT INTO `wp_options` VALUES("244", "woocommerce_enable_myaccount_registration", "yes", "no");
INSERT INTO `wp_options` VALUES("245", "woocommerce_registration_generate_username", "yes", "no");
INSERT INTO `wp_options` VALUES("246", "woocommerce_registration_generate_password", "yes", "no");
INSERT INTO `wp_options` VALUES("247", "woocommerce_erasure_request_removes_order_data", "no", "no");
INSERT INTO `wp_options` VALUES("248", "woocommerce_erasure_request_removes_download_data", "no", "no");
INSERT INTO `wp_options` VALUES("249", "woocommerce_allow_bulk_remove_personal_data", "no", "no");
INSERT INTO `wp_options` VALUES("250", "woocommerce_registration_privacy_policy_text", "اطلاعات شخصی شما برای پردازش سفارش شما استفاده می‌شود، و پشتیبانی از تجربه شما در این وبسایت، و برای اهداف دیگری که در [privacy_policy] توضیح داده شده است.", "yes");
INSERT INTO `wp_options` VALUES("251", "woocommerce_checkout_privacy_policy_text", "اطلاعات شخصی شما برای پردازش سفارش شما و پشتیبانی از تجربه شما در این وبسایت و برای اهداف دیگری که در [privacy_policy] توضیح داده شده است استفاده می‌شود.", "yes");
INSERT INTO `wp_options` VALUES("252", "woocommerce_delete_inactive_accounts", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "no");
INSERT INTO `wp_options` VALUES("253", "woocommerce_trash_pending_orders", "", "no");
INSERT INTO `wp_options` VALUES("254", "woocommerce_trash_failed_orders", "", "no");
INSERT INTO `wp_options` VALUES("255", "woocommerce_trash_cancelled_orders", "", "no");
INSERT INTO `wp_options` VALUES("256", "woocommerce_anonymize_completed_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "no");
INSERT INTO `wp_options` VALUES("257", "woocommerce_email_from_name", "دمو اصلی قالب ایران وودمارت &#8211; المنتور", "no");
INSERT INTO `wp_options` VALUES("258", "woocommerce_email_from_address", "admin@gmail.com", "no");
INSERT INTO `wp_options` VALUES("259", "woocommerce_email_header_image", "", "no");
INSERT INTO `wp_options` VALUES("260", "woocommerce_email_footer_text", "{site_title} &mdash; Built with {WooCommerce}", "no");
INSERT INTO `wp_options` VALUES("261", "woocommerce_email_base_color", "#96588a", "no");
INSERT INTO `wp_options` VALUES("262", "woocommerce_email_background_color", "#f7f7f7", "no");
INSERT INTO `wp_options` VALUES("263", "woocommerce_email_body_background_color", "#ffffff", "no");
INSERT INTO `wp_options` VALUES("264", "woocommerce_email_text_color", "#3c3c3c", "no");
INSERT INTO `wp_options` VALUES("265", "woocommerce_merchant_email_notifications", "no", "no");
INSERT INTO `wp_options` VALUES("266", "woocommerce_cart_page_id", "7", "no");
INSERT INTO `wp_options` VALUES("267", "woocommerce_checkout_page_id", "8", "no");
INSERT INTO `wp_options` VALUES("268", "woocommerce_myaccount_page_id", "9", "no");
INSERT INTO `wp_options` VALUES("269", "woocommerce_terms_page_id", "", "no");
INSERT INTO `wp_options` VALUES("270", "woocommerce_force_ssl_checkout", "no", "yes");
INSERT INTO `wp_options` VALUES("271", "woocommerce_unforce_ssl_checkout", "no", "yes");
INSERT INTO `wp_options` VALUES("272", "woocommerce_checkout_pay_endpoint", "order-pay", "yes");
INSERT INTO `wp_options` VALUES("273", "woocommerce_checkout_order_received_endpoint", "order-received", "yes");
INSERT INTO `wp_options` VALUES("274", "woocommerce_myaccount_add_payment_method_endpoint", "add-payment-method", "yes");
INSERT INTO `wp_options` VALUES("275", "woocommerce_myaccount_delete_payment_method_endpoint", "delete-payment-method", "yes");
INSERT INTO `wp_options` VALUES("276", "woocommerce_myaccount_set_default_payment_method_endpoint", "set-default-payment-method", "yes");
INSERT INTO `wp_options` VALUES("277", "woocommerce_myaccount_orders_endpoint", "orders", "yes");
INSERT INTO `wp_options` VALUES("278", "woocommerce_myaccount_view_order_endpoint", "view-order", "yes");
INSERT INTO `wp_options` VALUES("279", "woocommerce_myaccount_downloads_endpoint", "downloads", "yes");
INSERT INTO `wp_options` VALUES("280", "woocommerce_myaccount_edit_account_endpoint", "edit-account", "yes");
INSERT INTO `wp_options` VALUES("281", "woocommerce_myaccount_edit_address_endpoint", "edit-address", "yes");
INSERT INTO `wp_options` VALUES("282", "woocommerce_myaccount_payment_methods_endpoint", "payment-methods", "yes");
INSERT INTO `wp_options` VALUES("283", "woocommerce_myaccount_lost_password_endpoint", "lost-password", "yes");
INSERT INTO `wp_options` VALUES("284", "woocommerce_logout_endpoint", "customer-logout", "yes");
INSERT INTO `wp_options` VALUES("285", "woocommerce_api_enabled", "no", "yes");
INSERT INTO `wp_options` VALUES("286", "woocommerce_allow_tracking", "no", "no");
INSERT INTO `wp_options` VALUES("287", "woocommerce_show_marketplace_suggestions", "yes", "no");
INSERT INTO `wp_options` VALUES("288", "woocommerce_single_image_width", "1200", "yes");
INSERT INTO `wp_options` VALUES("289", "woocommerce_thumbnail_image_width", "600", "yes");
INSERT INTO `wp_options` VALUES("290", "woocommerce_checkout_highlight_required_fields", "yes", "yes");
INSERT INTO `wp_options` VALUES("291", "woocommerce_demo_store", "no", "no");
INSERT INTO `wp_options` VALUES("292", "woocommerce_permalinks", "a:5:{s:12:\"product_base\";s:7:\"product\";s:13:\"category_base\";s:16:\"product-category\";s:8:\"tag_base\";s:11:\"product-tag\";s:14:\"attribute_base\";s:0:\"\";s:22:\"use_verbose_page_rules\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("293", "current_theme_supports_woocommerce", "yes", "yes");
INSERT INTO `wp_options` VALUES("294", "woocommerce_queue_flush_rewrite_rules", "no", "yes");
INSERT INTO `wp_options` VALUES("297", "default_product_cat", "15", "yes");
INSERT INTO `wp_options` VALUES("300", "woocommerce_paypal_settings", "a:23:{s:7:\"enabled\";s:2:\"no\";s:5:\"title\";s:13:\"پی‌پال\";s:11:\"description\";s:168:\"پرداخت از راه پی‌پال، اگر حساب کاربری پی‌پال ندارید، می توانید با کارت اعتباری پرداخت کنید.\";s:5:\"email\";s:15:\"admin@gmail.com\";s:8:\"advanced\";s:0:\"\";s:8:\"testmode\";s:2:\"no\";s:5:\"debug\";s:2:\"no\";s:16:\"ipn_notification\";s:3:\"yes\";s:14:\"receiver_email\";s:15:\"admin@gmail.com\";s:14:\"identity_token\";s:0:\"\";s:14:\"invoice_prefix\";s:3:\"WC-\";s:13:\"send_shipping\";s:3:\"yes\";s:16:\"address_override\";s:2:\"no\";s:13:\"paymentaction\";s:4:\"sale\";s:9:\"image_url\";s:0:\"\";s:11:\"api_details\";s:0:\"\";s:12:\"api_username\";s:0:\"\";s:12:\"api_password\";s:0:\"\";s:13:\"api_signature\";s:0:\"\";s:20:\"sandbox_api_username\";s:0:\"\";s:20:\"sandbox_api_password\";s:0:\"\";s:21:\"sandbox_api_signature\";s:0:\"\";s:12:\"_should_load\";s:2:\"no\";}", "yes");
INSERT INTO `wp_options` VALUES("301", "woocommerce_version", "8.2.1", "yes");
INSERT INTO `wp_options` VALUES("302", "woocommerce_db_version", "7.6.0", "yes");
INSERT INTO `wp_options` VALUES("303", "woocommerce_inbox_variant_assignment", "10", "yes");
INSERT INTO `wp_options` VALUES("307", "_transient_jetpack_autoloader_plugin_paths", "a:1:{i:0;s:29:\"{{WP_PLUGIN_DIR}}/woocommerce\";}", "yes");
INSERT INTO `wp_options` VALUES("308", "action_scheduler_lock_async-request-runner", "6544c7b6b443b2.27184221|1699006450", "yes");
INSERT INTO `wp_options` VALUES("309", "woocommerce_admin_notices", "a:2:{i:0;s:6:\"update\";i:1;s:14:\"template_files\";}", "yes");
INSERT INTO `wp_options` VALUES("310", "woocommerce_maxmind_geolocation_settings", "a:1:{s:15:\"database_prefix\";s:32:\"O1C87EOTQn3f2Qn0sSx0rgU4LFIU5gT8\";}", "yes");
INSERT INTO `wp_options` VALUES("311", "_transient_woocommerce_webhook_ids_status_active", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("312", "widget_woocommerce_widget_cart", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("313", "widget_woocommerce_layered_nav_filters", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("314", "widget_woocommerce_layered_nav", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("315", "widget_woocommerce_price_filter", "a:2:{i:2;a:1:{s:5:\"title\";s:15:\"Filter by price\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("316", "widget_woocommerce_product_categories", "a:2:{i:1;a:8:{s:5:\"title\";s:22:\"دسته بندی ها\";s:7:\"orderby\";s:4:\"name\";s:8:\"dropdown\";i:0;s:5:\"count\";i:0;s:12:\"hierarchical\";i:1;s:18:\"show_children_only\";i:0;s:10:\"hide_empty\";i:0;s:9:\"max_depth\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("317", "widget_woocommerce_product_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("318", "widget_woocommerce_product_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("319", "widget_woocommerce_products", "a:3:{i:4;a:7:{s:5:\"title\";s:19:\"محصولات ما\";s:6:\"number\";i:5;s:4:\"show\";s:0:\"\";s:7:\"orderby\";s:4:\"date\";s:5:\"order\";s:4:\"desc\";s:9:\"hide_free\";i:0;s:11:\"show_hidden\";i:0;}i:5;a:7:{s:5:\"title\";s:14:\"محصولات\";s:6:\"number\";i:5;s:4:\"show\";s:0:\"\";s:7:\"orderby\";s:4:\"date\";s:5:\"order\";s:4:\"desc\";s:9:\"hide_free\";i:0;s:11:\"show_hidden\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("320", "widget_woocommerce_recently_viewed_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("321", "widget_woocommerce_top_rated_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("322", "widget_woocommerce_recent_reviews", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("323", "widget_woocommerce_rating_filter", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("327", "woocommerce_admin_install_timestamp", "1627204000", "yes");
INSERT INTO `wp_options` VALUES("328", "wc_remote_inbox_notifications_wca_updated", "", "no");
INSERT INTO `wp_options` VALUES("330", "wc_remote_inbox_notifications_stored_state", "O:8:\"stdClass\":2:{s:22:\"there_were_no_products\";b:1;s:22:\"there_are_now_products\";b:1;}", "no");
INSERT INTO `wp_options` VALUES("334", "wc_blocks_db_schema_version", "260", "yes");
INSERT INTO `wp_options` VALUES("335", "woocommerce_meta_box_errors", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("345", "recently_activated", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("347", "elementor_pro_license_key", "activated", "yes");
INSERT INTO `wp_options` VALUES("348", "_elementor_pro_license_data", "a:2:{s:7:\"timeout\";i:1671949279;s:5:\"value\";s:73:\"{\"license\":\"valid\",\"expires\":\"01.01.2030\",\"features\":{\"pro_trial\":false}}\";}", "yes");
INSERT INTO `wp_options` VALUES("349", "revslider_servers", "a:3:{i:0;s:22:\"themepunch-ext-c.tools\";i:1;s:22:\"themepunch-ext-a.tools\";i:2;s:22:\"themepunch-ext-b.tools\";}", "yes");
INSERT INTO `wp_options` VALUES("350", "revslider_server_refresh", "1698643560", "yes");
INSERT INTO `wp_options` VALUES("351", "revslider-update-check-short", "1698946466", "yes");
INSERT INTO `wp_options` VALUES("352", "revslider-connection", "1", "yes");
INSERT INTO `wp_options` VALUES("353", "revslider-update-hash", "bfec01824c8dd245436aaf0c314f2cba", "yes");
INSERT INTO `wp_options` VALUES("354", "revslider-latest-version", "6.6.18", "yes");
INSERT INTO `wp_options` VALUES("355", "revslider-stable-version", "4.2.0", "yes");
INSERT INTO `wp_options` VALUES("356", "revslider-notices", "a:6:{i:0;O:8:\"stdClass\":9:{s:7:\"version\";s:5:\"1.0.0\";s:4:\"text\";s:546:\"<div style=\"display: block; background: #fff;text-align: center; height: 250px;\"><a href=\"https://account.sliderrevolution.com/portal/pricing/?utm_source=admin&utm_medium=banner&utm_campaign=srusers&utm_content=getpremium\" target=\"_blank\" rel=\"noopener\"><video style=\"object-fit: cover; background-size: cover; opacity: 1; width: 960px; height: 250px; display: inline-block;\" muted=\"\" loop=\"\" autoplay=\"\" preload=\"auto\"><source src=\"https://sliderrevolution.com/wp-content/uploads/2021/07/adminpremiumvid4.mp4\" type=\"video/mp4\"></video></a></div>\";s:4:\"code\";s:12:\"TPRSV6511-01\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:10:\"additional\";a:0:{}}i:1;O:8:\"stdClass\":9:{s:7:\"version\";s:5:\"1.9.9\";s:4:\"text\";s:562:\"<div style=\"display: block; background: #fff;text-align: center; \nheight: 300px;\"><a \nhref=\"https://www.sliderrevolution.com/slider-revolution-visual-editor-version-6-6/?utm_source=admin&utm_medium=banner&utm_campaign=srusers&utm_content=update66\"\n target=\"_blank\" rel=\"noopener\"><video style=\"object-fit: \ncover; background-size: cover; opacity: 1; width: 920px; height: 300px; \ndisplay: inline-block;\" muted loop autoplay \npreload=\"auto\"><source src=\"//updates.themepunch-ext-c.tools//banners/rs60/update66videobanner2.mp4\" type=\"video/mp4\"></video></a></div>\n\";s:4:\"code\";s:8:\"TPRSV663\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:10:\"additional\";a:0:{}}i:2;O:8:\"stdClass\":9:{s:7:\"version\";s:5:\"1.0.0\";s:4:\"text\";s:537:\"<div style=\"display: block; background: #fff;text-align: center; height: 300px;\"><a href=\"https://account.sliderrevolution.com/portal/pricing/?utm_source=admin&utm_medium=banner&utm_campaign=srusers&utm_content=getpremium2\" target=\"_blank\" rel=\"noopener\"><video style=\"object-fit: cover; background-size: cover; opacity: 1; width: 920px; height: 300px; display: inline-block;\" muted=\"\" loop=\"\" autoplay=\"\" preload=\"auto\"><source src=\"//updates.themepunch-ext-c.tools//banners/videobanner_premium2.mp4\" type=\"video/mp4\"></video></a></div>\";s:4:\"code\";s:12:\"TPRSV6518-01\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:10:\"additional\";a:0:{}}i:3;O:8:\"stdClass\":10:{s:7:\"version\";s:5:\"0.9.9\";s:4:\"text\";s:402:\"<div style=\"display: block; background:#fff;text-align: center; height: 250px;\"><a href=\"https://www.sliderrevolution.com/wordpress-hosting/?utm_source=admin&utm_medium=banner&utm_campaign=srusers&utm_content=getwphosting\" target=\"_blank\" rel=\"noopener\"><img style=\"width: 960px; height: 250px; display: inline-block;\"  src=\"//updates.themepunch-ext-c.tools//banners/rs60/wphostingadmin.jpg\"></a></div>\";s:4:\"code\";s:12:\"TPRSV6518-02\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:10:\"registered\";b:1;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:10:\"additional\";a:0:{}}i:4;O:8:\"stdClass\":10:{s:7:\"version\";s:5:\"0.9.9\";s:4:\"text\";s:527:\"<div style=\"display: block; background: #0d0d0e;text-align: center; height: 504px;\"><a href=\"https://account.sliderrevolution.com/portal/pricing/?utm_source=admin&utm_medium=banner&utm_campaign=srusers&utm_content=getpremium3\" target=\"_blank\" rel=\"noopener\"><video style=\"object-fit: cover; background-size: cover; opacity: 1; width: 900px; height: 504px; display: inline-block;\" muted loop autoplay preload=\"auto\"><source src=\"//updates.themepunch-ext-c.tools//banners/rs60/buypremium3.mp4\" type=\"video/mp4\"></video></a></div>\";s:4:\"code\";s:8:\"TPRSV668\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:10:\"registered\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:10:\"additional\";a:0:{}}i:5;O:8:\"stdClass\":9:{s:7:\"version\";s:5:\"9.9.9\";s:4:\"text\";s:487:\"<div style=\"display: block; background:transparent;text-align: left; height: 250px;\"><a href=\"https://forms.gle/tQhQvrp5rZ1rQU7r7\" target=\"_blank\" rel=\"noopener\"><noscript><img decoding=\"async\" style=\"width: 960px; height: 250px; display: inline-block;\" src=\"//updates.themepunch-ext-c.tools//banners/surveybanner.jpg\"></noscript><img decoding=\"async\" style=\"width: 960px; height: 250px; display: inline-block;\" src=\"//updates.themepunch-ext-c.tools//banners/surveybanner.jpg\"></a></div>\";s:4:\"code\";s:10:\"TPRSV669-1\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:10:\"additional\";a:0:{}}}", "yes");
INSERT INTO `wp_options` VALUES("357", "revslider-additions", "O:8:\"stdClass\":2:{s:9:\"templates\";O:8:\"stdClass\":3:{s:9:\"tutorials\";a:3:{i:0;O:8:\"stdClass\":2:{s:5:\"title\";s:19:\"Rapid Fire Overview\";s:3:\"url\";s:49:\"https://www.youtube.com/watch?v=LRNTFu-MFgw&t=25s\";}i:1;O:8:\"stdClass\":2:{s:5:\"title\";s:34:\"Responsiveness in Edited Templates\";s:3:\"url\";s:43:\"https://www.youtube.com/watch?v=hP4oV8SWgKY\";}i:2;O:8:\"stdClass\":2:{s:5:\"title\";s:16:\"Animation Basics\";s:3:\"url\";s:43:\"https://www.youtube.com/watch?v=nn3azizwpbs\";}}s:5:\"guide\";O:8:\"stdClass\":3:{s:5:\"title\";s:78:\"Require Expert Technical Advice?<br />Submit a Ticket for Dedicated 1on1 Help.\";s:3:\"url\";s:36:\"https://support.sliderrevolution.com\";s:3:\"img\";s:67:\"//updates.themepunch-ext-c.tools/banners/default_template_guide.jpg\";}s:6:\"bottom\";O:8:\"stdClass\":2:{s:5:\"title\";s:32:\"Load A Template From The Library\";s:3:\"img\";s:61:\"//updates.themepunch-ext-c.tools/banners/guide_mod_banner.png\";}}s:7:\"selling\";b:1;}", "yes");
INSERT INTO `wp_options` VALUES("358", "rs-addons-counter", "1", "yes");
INSERT INTO `wp_options` VALUES("359", "revslider-addons", "O:8:\"stdClass\":34:{s:28:\"revslider-particlewave-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"380\";s:9:\"releaseid\";s:2:\"29\";s:4:\"slug\";s:28:\"revslider-particlewave-addon\";s:12:\"version_from\";s:6:\"6.5.15\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:13:\"Particle Wave\";s:6:\"line_1\";s:36:\"Create 3D particle and polygon grids\";s:6:\"line_2\";s:40:\"with lots of style and animation options\";s:9:\"available\";s:5:\"1.1.5\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:1:\"9\";s:11:\"last_update\";s:10:\"2023-08-24\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:79:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_particlewave.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PW\";}}s:25:\"revslider-particles-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"424\";s:9:\"releaseid\";s:1:\"7\";s:4:\"slug\";s:25:\"revslider-particles-addon\";s:12:\"version_from\";s:5:\"6.5.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:16:\"Particle Effects\";s:6:\"line_1\";s:17:\"Let\'s Parti(cle)!\";s:6:\"line_2\";s:51:\"Add interactive particle animations to your sliders\";s:9:\"available\";s:5:\"3.3.3\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:2:\"10\";s:11:\"last_update\";s:10:\"2023-07-28\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:76:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_particles.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PT\";}}s:27:\"revslider-bubblemorph-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"405\";s:9:\"releaseid\";s:2:\"20\";s:4:\"slug\";s:27:\"revslider-bubblemorph-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:11:\"BubbleMorph\";s:6:\"line_1\";s:26:\"Include BubbleMorph Layers\";s:6:\"line_2\";s:33:\"for a decorative lava lamp effect\";s:9:\"available\";s:5:\"3.0.8\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"20\";s:11:\"last_update\";s:10:\"2023-06-26\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:78:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_bubblemorph.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BM\";}}s:26:\"revslider-thecluster-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"481\";s:9:\"releaseid\";s:2:\"28\";s:4:\"slug\";s:26:\"revslider-thecluster-addon\";s:12:\"version_from\";s:5:\"6.6.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:11:\"The Cluster\";s:6:\"line_1\";s:24:\"Cluster Particle Effects\";s:6:\"line_2\";s:27:\"with millions of Variations\";s:9:\"available\";s:6:\"1.0.10\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:2:\"22\";s:11:\"last_update\";s:10:\"2023-06-26\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:74:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_cluster.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"TC\";}}s:30:\"revslider-transitionpack-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"369\";s:9:\"releaseid\";s:2:\"28\";s:4:\"slug\";s:30:\"revslider-transitionpack-addon\";s:12:\"version_from\";s:5:\"6.5.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:20:\"Advanced Transitions\";s:6:\"line_1\";s:43:\"Add never-before-seen slide transitions to \";s:6:\"line_2\";s:42:\"Slider Revolution with the power of WEBGL.\";s:9:\"available\";s:5:\"1.0.6\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:2:\"30\";s:11:\"last_update\";s:10:\"2023-02-23\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:77:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_transition.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"AT\";}}s:27:\"revslider-beforeafter-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"404\";s:9:\"releaseid\";s:2:\"15\";s:4:\"slug\";s:27:\"revslider-beforeafter-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Before & After\";s:6:\"line_1\";s:35:\"Compare two slides before and after\";s:6:\"line_2\";s:33:\"use it vertically or horizontally\";s:9:\"available\";s:5:\"3.1.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:2:\"40\";s:11:\"last_update\";s:10:\"2023-05-20\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:78:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_beforeafter.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BA\";}}s:26:\"revslider-typewriter-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"418\";s:9:\"releaseid\";s:1:\"3\";s:4:\"slug\";s:26:\"revslider-typewriter-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:17:\"Typewriter Effect\";s:6:\"line_1\";s:27:\"Enhance your slider\'s text \";s:6:\"line_2\";s:24:\"with typewriter effects \";s:9:\"available\";s:5:\"3.0.6\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:2:\"50\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:77:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_typewriter.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"TW\";}}s:25:\"revslider-mousetrap-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"499\";s:9:\"releaseid\";s:2:\"24\";s:4:\"slug\";s:25:\"revslider-mousetrap-addon\";s:12:\"version_from\";s:5:\"6.6.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:9:\"Mousetrap\";s:6:\"line_1\";s:31:\"Create all kinds of interesting\";s:6:\"line_2\";s:19:\" mouse interactions\";s:9:\"available\";s:5:\"3.1.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"60\";s:11:\"last_update\";s:10:\"2023-10-06\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:76:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_mousetrap.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"MT\";}}s:28:\"revslider-liquideffect-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"500\";s:9:\"releaseid\";s:2:\"21\";s:4:\"slug\";s:28:\"revslider-liquideffect-addon\";s:12:\"version_from\";s:5:\"6.6.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Distortion\";s:6:\"line_1\";s:22:\"Add Distortion Effects\";s:6:\"line_2\";s:30:\"to your slides and transitions\";s:9:\"available\";s:5:\"3.0.5\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"70\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:77:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_distortion.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LE\";}}s:22:\"revslider-lottie-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"420\";s:9:\"releaseid\";s:2:\"25\";s:4:\"slug\";s:22:\"revslider-lottie-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Lottie\";s:6:\"line_1\";s:53:\"Adds support for the popular Lottie Animation format,\";s:6:\"line_2\";s:70:\" including animation control, style customization and a local library.\";s:9:\"available\";s:5:\"3.1.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"80\";s:11:\"last_update\";s:10:\"2023-06-26\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:73:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_lottie.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LT\";}}s:26:\"revslider-paintbrush-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"411\";s:9:\"releaseid\";s:2:\"23\";s:4:\"slug\";s:26:\"revslider-paintbrush-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Paintbrush\";s:6:\"line_1\";s:14:\"Paint or Erase\";s:6:\"line_2\";s:22:\"your background images\";s:9:\"available\";s:5:\"3.0.4\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"90\";s:11:\"last_update\";s:10:\"2023-08-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:77:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_paintbrush.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PB\";}}s:22:\"revslider-charts-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"483\";s:9:\"releaseid\";s:2:\"27\";s:4:\"slug\";s:22:\"revslider-charts-addon\";s:12:\"version_from\";s:6:\"6.5.17\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Charts\";s:6:\"line_1\";s:93:\"The Charts addon allows you to create visually impressive line or bar graphs from .csv data, \";s:6:\"line_2\";s:56:\"with tons of options to take full control of the design.\";s:9:\"available\";s:5:\"3.0.5\";s:10:\"background\";s:73:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_charts.png\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:3:\"100\";s:11:\"last_update\";s:10:\"2022-08-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:73:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_charts.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"CH\";}}s:22:\"revslider-slicey-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"417\";s:9:\"releaseid\";s:2:\"13\";s:4:\"slug\";s:22:\"revslider-slicey-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Slicey\";s:6:\"line_1\";s:20:\"Slice \'em up nicely!\";s:6:\"line_2\";s:38:\"Create image slices of your background\";s:9:\"available\";s:5:\"3.0.4\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"110\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:73:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_slicey.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SL\";}}s:25:\"revslider-filmstrip-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"422\";s:9:\"releaseid\";s:2:\"10\";s:4:\"slug\";s:25:\"revslider-filmstrip-addon\";s:12:\"version_from\";s:5:\"6.5.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:9:\"Filmstrip\";s:6:\"line_1\";s:44:\"Display a continously rotating set of images\";s:6:\"line_2\";s:26:\"for your slide backgrounds\";s:9:\"available\";s:5:\"3.0.6\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"125\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:76:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_filmstrip.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"FS\";}}s:27:\"revslider-maintenance-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"421\";s:9:\"releaseid\";s:1:\"4\";s:4:\"slug\";s:27:\"revslider-maintenance-addon\";s:12:\"version_from\";s:5:\"6.5.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:15:\"Coming & Maint.\";s:6:\"line_1\";s:37:\"Simple Coming Soon & Maintenance Page\";s:6:\"line_2\";s:42:\"Let your visitors know what\'s up and when!\";s:9:\"available\";s:5:\"3.0.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"127\";s:11:\"last_update\";s:10:\"2023-07-17\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:84:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_underconstruction.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"MT\";}}s:24:\"revslider-revealer-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"416\";s:9:\"releaseid\";s:2:\"19\";s:4:\"slug\";s:24:\"revslider-revealer-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Reveal\";s:6:\"line_1\";s:9:\"Reveal...\";s:6:\"line_2\";s:37:\"...your inner beast... and RevSliders\";s:9:\"available\";s:5:\"3.0.3\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"130\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:73:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_reveal.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RV\";}}s:24:\"revslider-panorama-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"423\";s:9:\"releaseid\";s:2:\"17\";s:4:\"slug\";s:24:\"revslider-panorama-addon\";s:12:\"version_from\";s:5:\"6.5.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:8:\"Panorama\";s:6:\"line_1\";s:14:\"Panorama AddOn\";s:6:\"line_2\";s:28:\"Display images in 360 degree\";s:9:\"available\";s:5:\"3.0.9\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"135\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:75:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_panorama.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PN\";}}s:27:\"revslider-scrollvideo-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"498\";s:9:\"releaseid\";s:2:\"26\";s:4:\"slug\";s:27:\"revslider-scrollvideo-addon\";s:12:\"version_from\";s:5:\"6.6.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:12:\"Scroll Video\";s:6:\"line_1\";s:114:\"This addon allows you to generate a sequence of images from any html5 video and play them with scroll interaction.\";s:6:\"line_2\";s:49:\"Quality options are included for optimal results!\";s:9:\"available\";s:5:\"3.0.4\";s:10:\"background\";s:78:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_scrollvideo.jpg\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"140\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:78:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_scrollvideo.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SV\";}}s:31:\"revslider-explodinglayers-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"407\";s:9:\"releaseid\";s:2:\"22\";s:4:\"slug\";s:31:\"revslider-explodinglayers-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:16:\"Exploding Layers\";s:6:\"line_1\";s:23:\"Add explosive particles\";s:6:\"line_2\";s:24:\"to your layers animation\";s:9:\"available\";s:5:\"3.0.5\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"150\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:76:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_exploding.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"EL\";}}s:23:\"revslider-sharing-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"397\";s:9:\"releaseid\";s:1:\"5\";s:4:\"slug\";s:23:\"revslider-sharing-addon\";s:12:\"version_from\";s:5:\"6.5.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Social Sharing\";s:6:\"line_1\";s:17:\"Share your slides\";s:6:\"line_2\";s:50:\"with RevSlider \"actions\" because sharing is caring\";s:9:\"available\";s:5:\"3.0.1\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"165\";s:11:\"last_update\";s:10:\"2023-07-08\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:80:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_socialsharing.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SH\";}}s:26:\"revslider-whiteboard-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"419\";s:9:\"releaseid\";s:1:\"1\";s:4:\"slug\";s:26:\"revslider-whiteboard-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Whiteboard\";s:6:\"line_1\";s:31:\"Create Hand-Drawn Presentations\";s:6:\"line_2\";s:45:\"that are understandable, memorable & engaging\";s:9:\"available\";s:5:\"3.0.5\";s:10:\"background\";s:81:\"//updates.themepunch-ext-c.tools/revslider/addons/images/whiteboard_widget_bg.jpg\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"170\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:77:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_whiteboard.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"WB\";}}s:24:\"revslider-polyfold-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"414\";s:9:\"releaseid\";s:2:\"14\";s:4:\"slug\";s:24:\"revslider-polyfold-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:22:\"Polyfold Scroll Effect\";s:6:\"line_1\";s:32:\"Add sharp edges to your sliders \";s:6:\"line_2\";s:35:\"as they scroll into and out of view\";s:9:\"available\";s:5:\"3.0.6\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"180\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:75:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_polyfold.jpg\";s:5:\"color\";s:7:\"#3e186f\";s:4:\"text\";s:2:\"PF\";}}s:29:\"revslider-domain-switch-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:2:\"78\";s:9:\"releaseid\";s:2:\"11\";s:4:\"slug\";s:29:\"revslider-domain-switch-addon\";s:12:\"version_from\";s:5:\"6.0.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:13:\"Domain Switch\";s:6:\"line_1\";s:17:\"Switch Image URLs\";s:6:\"line_2\";s:37:\"in sliders from one domain to another\";s:9:\"available\";s:5:\"1.0.1\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"300\";s:11:\"last_update\";s:10:\"2022-02-19\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:79:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_domainswitch.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"DS\";}}s:23:\"revslider-refresh-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"415\";s:9:\"releaseid\";s:2:\"10\";s:4:\"slug\";s:23:\"revslider-refresh-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:8:\"(Re)Load\";s:6:\"line_1\";s:39:\"Reload the current page or a custom URL\";s:6:\"line_2\";s:34:\"after a certain time, loops, slide\";s:9:\"available\";s:5:\"3.0.4\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"330\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:73:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_reload.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RF\";}}s:25:\"revslider-rel-posts-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:2:\"55\";s:9:\"releaseid\";s:1:\"9\";s:4:\"slug\";s:25:\"revslider-rel-posts-addon\";s:12:\"version_from\";s:7:\"5.2.4.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:13:\"Related Posts\";s:6:\"line_1\";s:25:\"Add related Posts Sliders\";s:6:\"line_2\";s:31:\"at the end of your post content\";s:9:\"available\";s:5:\"2.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"340\";s:11:\"last_update\";s:10:\"2023-06-12\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:76:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_wprelated.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RP\";}}s:20:\"revslider-snow-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"399\";s:9:\"releaseid\";s:1:\"6\";s:4:\"slug\";s:20:\"revslider-snow-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:12:\"Holiday Snow\";s:6:\"line_1\";s:12:\"Let it snow!\";s:6:\"line_2\";s:32:\"Add animated snow to any Slider \";s:9:\"available\";s:5:\"3.0.5\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"380\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:71:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_snow.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SN\";}}s:23:\"revslider-gallery-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"378\";s:9:\"releaseid\";s:1:\"2\";s:4:\"slug\";s:23:\"revslider-gallery-addon\";s:12:\"version_from\";s:6:\"6.4.11\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:17:\"WordPress Gallery\";s:6:\"line_1\";s:31:\"Replace the standard WP Gallery\";s:6:\"line_2\";s:31:\"with the Sliders of your choice\";s:9:\"available\";s:5:\"2.0.4\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"430\";s:11:\"last_update\";s:10:\"2022-01-31\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:76:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_wpgallery.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"GA\";}}s:22:\"revslider-backup-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:2:\"53\";s:9:\"releaseid\";s:1:\"3\";s:4:\"slug\";s:22:\"revslider-backup-addon\";s:12:\"version_from\";s:5:\"5.2.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Backup\";s:6:\"line_1\";s:12:\"Make Backups\";s:6:\"line_2\";s:25:\"Revisions for your safety\";s:9:\"available\";s:5:\"2.0.3\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"500\";s:11:\"last_update\";s:10:\"2023-05-31\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:73:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_backup.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BU\";}}s:19:\"revslider-404-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:2:\"62\";s:9:\"releaseid\";s:1:\"8\";s:4:\"slug\";s:19:\"revslider-404-addon\";s:12:\"version_from\";s:3:\"5.3\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:3:\"404\";s:6:\"line_1\";s:39:\"Build custom 404 \"Page not Found\" Pages\";s:6:\"line_2\";s:28:\"with Slider Revolution swag!\";s:9:\"available\";s:5:\"2.0.1\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"620\";s:11:\"last_update\";s:10:\"2022-12-04\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:70:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_404.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:3:\"404\";}}s:30:\"revslider-prevnext-posts-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:2:\"63\";s:9:\"releaseid\";s:1:\"9\";s:4:\"slug\";s:30:\"revslider-prevnext-posts-addon\";s:12:\"version_from\";s:3:\"5.4\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Adjacent Posts\";s:6:\"line_1\";s:30:\"Display previous and next post\";s:6:\"line_2\";s:28:\"to the currently showing one\";s:9:\"available\";s:5:\"2.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"630\";s:11:\"last_update\";s:10:\"2023-08-04\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:77:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_wpadjacent.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PN\";}}s:21:\"revslider-login-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"388\";s:9:\"releaseid\";s:2:\"11\";s:4:\"slug\";s:21:\"revslider-login-addon\";s:12:\"version_from\";s:5:\"6.5.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Login Page\";s:6:\"line_1\";s:25:\"Very simple WP Login Page\";s:6:\"line_2\";s:34:\"enhanced with your favorite slider\";s:9:\"available\";s:5:\"3.0.1\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"650\";s:11:\"last_update\";s:10:\"2023-06-12\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:72:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_login.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LI\";}}s:24:\"revslider-featured-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"379\";s:9:\"releaseid\";s:2:\"12\";s:4:\"slug\";s:24:\"revslider-featured-addon\";s:12:\"version_from\";s:6:\"6.4.11\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:20:\"Post Featured Slider\";s:6:\"line_1\";s:25:\"Display a featured Slider\";s:6:\"line_2\";s:41:\"instead of a featured Image in your Posts\";s:9:\"available\";s:5:\"2.0.4\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"660\";s:11:\"last_update\";s:10:\"2023-05-31\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:77:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_wpfeatured.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"FT\";}}s:23:\"revslider-weather-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"402\";s:9:\"releaseid\";s:2:\"16\";s:4:\"slug\";s:23:\"revslider-weather-addon\";s:12:\"version_from\";s:5:\"6.5.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:7:\"Weather\";s:6:\"line_1\";s:21:\"Every where you go...\";s:6:\"line_2\";s:36:\"...always take the weather with you!\";s:9:\"available\";s:5:\"3.0.1\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"690\";s:11:\"last_update\";s:10:\"2023-05-31\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:74:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_weather.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"WT\";}}s:30:\"revslider-duotonefilters-addon\";O:8:\"stdClass\":16:{s:2:\"id\";s:3:\"406\";s:9:\"releaseid\";s:2:\"18\";s:4:\"slug\";s:30:\"revslider-duotonefilters-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:7:\"Duotone\";s:6:\"line_1\";s:7:\"Duotone\";s:6:\"line_2\";s:25:\"Because one is not enough\";s:9:\"available\";s:5:\"3.0.5\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"710\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:74:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_duotone.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:3:\"DTF\";}}}", "yes");
INSERT INTO `wp_options` VALUES("360", "revslider-library-check", "1697910689", "yes");
INSERT INTO `wp_options` VALUES("361", "revslider-library-hash", "dae3de1eb57eeeee008b70e9a23844b5", "yes");
INSERT INTO `wp_options` VALUES("362", "rs-library", "a:3:{s:4:\"hash\";s:32:\"dae3de1eb57eeeee008b70e9a23844b5\";s:7:\"objects\";a:417:{i:0;a:12:{s:2:\"id\";s:3:\"198\";s:6:\"handle\";s:16:\"object_dvd_1.png\";s:4:\"name\";s:3:\"DVD\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:43:17\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:1;a:12:{s:2:\"id\";s:3:\"188\";s:6:\"handle\";s:18:\"object_plant_1.png\";s:4:\"name\";s:7:\"Plant 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-12 16:25:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:2;a:12:{s:2:\"id\";s:3:\"187\";s:6:\"handle\";s:16:\"object_pen_1.png\";s:4:\"name\";s:5:\"Pen 1\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-12 16:25:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:3;a:12:{s:2:\"id\";s:3:\"172\";s:6:\"handle\";s:16:\"object_egg_1.png\";s:4:\"name\";s:3:\"Egg\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"600\";s:6:\"height\";s:3:\"600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:4;a:12:{s:2:\"id\";s:3:\"171\";s:6:\"handle\";s:19:\"object_guitar_1.png\";s:4:\"name\";s:6:\"Guitar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:5;a:12:{s:2:\"id\";s:3:\"170\";s:6:\"handle\";s:21:\"object_envelope_1.png\";s:4:\"name\";s:15:\"Closed Envelope\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:6;a:12:{s:2:\"id\";s:3:\"169\";s:6:\"handle\";s:19:\"object_postit_2.png\";s:4:\"name\";s:18:\"Postit Label White\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:7;a:12:{s:2:\"id\";s:3:\"168\";s:6:\"handle\";s:21:\"object_envelope_2.png\";s:4:\"name\";s:13:\"Open Envelope\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:8;a:12:{s:2:\"id\";s:3:\"167\";s:6:\"handle\";s:17:\"object_eggs_1.png\";s:4:\"name\";s:10:\"Egg Carton\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:9;a:12:{s:2:\"id\";s:3:\"166\";s:6:\"handle\";s:25:\"object_bottleopener_1.png\";s:4:\"name\";s:13:\"Bottle Opener\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:10;a:12:{s:2:\"id\";s:3:\"165\";s:6:\"handle\";s:23:\"object_blueprints_1.png\";s:4:\"name\";s:10:\"Blueprints\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:11;a:12:{s:2:\"id\";s:3:\"164\";s:6:\"handle\";s:22:\"object_holepunch_1.png\";s:4:\"name\";s:10:\"Hole punch\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:12;a:12:{s:2:\"id\";s:3:\"163\";s:6:\"handle\";s:20:\"object_speaker_1.png\";s:4:\"name\";s:13:\"Black Speaker\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:13;a:12:{s:2:\"id\";s:3:\"162\";s:6:\"handle\";s:19:\"object_eraser_1.png\";s:4:\"name\";s:6:\"Eraser\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:14;a:12:{s:2:\"id\";s:3:\"161\";s:6:\"handle\";s:23:\"object_vinylcover_1.png\";s:4:\"name\";s:11:\"Vinyl Cover\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:15;a:12:{s:2:\"id\";s:3:\"160\";s:6:\"handle\";s:20:\"object_booklet_1.png\";s:4:\"name\";s:9:\"Booklet 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:16;a:12:{s:2:\"id\";s:3:\"159\";s:6:\"handle\";s:22:\"object_earphones_2.png\";s:4:\"name\";s:11:\"Earphones 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:17;a:12:{s:2:\"id\";s:3:\"158\";s:6:\"handle\";s:18:\"object_vinyl_1.png\";s:4:\"name\";s:5:\"Vinyl\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:18;a:12:{s:2:\"id\";s:3:\"157\";s:6:\"handle\";s:19:\"object_postit_1.png\";s:4:\"name\";s:17:\"Postit Label Pink\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:19;a:12:{s:2:\"id\";s:3:\"156\";s:6:\"handle\";s:23:\"object_mechpencil_1.png\";s:4:\"name\";s:17:\"Mechanical Pencil\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:20;a:12:{s:2:\"id\";s:3:\"155\";s:6:\"handle\";s:22:\"object_turntable_1.png\";s:4:\"name\";s:9:\"Turntable\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:21;a:12:{s:2:\"id\";s:3:\"154\";s:6:\"handle\";s:19:\"object_folder_2.png\";s:4:\"name\";s:19:\"Closed Folder Black\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:22;a:12:{s:2:\"id\";s:3:\"153\";s:6:\"handle\";s:19:\"object_postit_4.png\";s:4:\"name\";s:18:\"Postit Label Green\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:23;a:12:{s:2:\"id\";s:3:\"152\";s:6:\"handle\";s:19:\"object_folder_1.png\";s:4:\"name\";s:12:\"Blank Folder\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:24;a:12:{s:2:\"id\";s:3:\"151\";s:6:\"handle\";s:19:\"object_pencup_1.png\";s:4:\"name\";s:7:\"Pen Cup\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:25;a:12:{s:2:\"id\";s:3:\"150\";s:6:\"handle\";s:23:\"object_winebottle_1.png\";s:4:\"name\";s:15:\"Red Wine Bottle\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:26;a:12:{s:2:\"id\";s:3:\"149\";s:6:\"handle\";s:23:\"object_headphones_1.png\";s:4:\"name\";s:10:\"Headphones\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:27;a:12:{s:2:\"id\";s:3:\"148\";s:6:\"handle\";s:22:\"object_earphones_1.png\";s:4:\"name\";s:9:\"Earphones\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:28;a:12:{s:2:\"id\";s:3:\"147\";s:6:\"handle\";s:19:\"object_postit_3.png\";s:4:\"name\";s:19:\"Postit Label Yellow\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:29;a:12:{s:2:\"id\";s:3:\"146\";s:6:\"handle\";s:22:\"object_corkscrew_1.png\";s:4:\"name\";s:23:\"Corkscrew Bottle Opener\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1300\";s:6:\"height\";s:4:\"1300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:30;a:12:{s:2:\"id\";s:3:\"145\";s:6:\"handle\";s:19:\"object_muffin_1.png\";s:4:\"name\";s:16:\"Chocolate Muffin\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:31;a:12:{s:2:\"id\";s:3:\"144\";s:6:\"handle\";s:18:\"object_chair_2.png\";s:4:\"name\";s:12:\"Yellow Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:32;a:12:{s:2:\"id\";s:3:\"143\";s:6:\"handle\";s:18:\"object_knife_2.png\";s:4:\"name\";s:7:\"Knife 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:33;a:12:{s:2:\"id\";s:3:\"142\";s:6:\"handle\";s:26:\"object_choppingboard_2.png\";s:4:\"name\";s:16:\"Chopping Board 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:34;a:12:{s:2:\"id\";s:3:\"141\";s:6:\"handle\";s:26:\"object_choppingboard_3.png\";s:4:\"name\";s:16:\"Chopping Board 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:35;a:12:{s:2:\"id\";s:3:\"140\";s:6:\"handle\";s:19:\"object_coffee_2.png\";s:4:\"name\";s:12:\"Coffee Cup 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:4:\"1200\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:36;a:12:{s:2:\"id\";s:3:\"139\";s:6:\"handle\";s:18:\"object_bread_1.png\";s:4:\"name\";s:15:\"Croissant Bread\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:37;a:12:{s:2:\"id\";s:3:\"138\";s:6:\"handle\";s:18:\"object_spoon_2.png\";s:4:\"name\";s:12:\"Wodden Spoon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:38;a:12:{s:2:\"id\";s:3:\"137\";s:6:\"handle\";s:26:\"object_choppingboard_1.png\";s:4:\"name\";s:16:\"Chopping Board 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:39;a:12:{s:2:\"id\";s:3:\"136\";s:6:\"handle\";s:16:\"object_cup_2.png\";s:4:\"name\";s:11:\"Empty Cup 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:40;a:12:{s:2:\"id\";s:3:\"135\";s:6:\"handle\";s:18:\"object_knife_1.png\";s:4:\"name\";s:5:\"Knife\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:41;a:12:{s:2:\"id\";s:3:\"134\";s:6:\"handle\";s:18:\"object_spoon_1.png\";s:4:\"name\";s:5:\"Spoon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:42;a:12:{s:2:\"id\";s:3:\"133\";s:6:\"handle\";s:16:\"object_cup_1.png\";s:4:\"name\";s:9:\"Empty Cup\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:43;a:12:{s:2:\"id\";s:3:\"132\";s:6:\"handle\";s:18:\"object_chair_3.png\";s:4:\"name\";s:11:\"White Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:44;a:12:{s:2:\"id\";s:3:\"131\";s:6:\"handle\";s:19:\"object_coffee_1.png\";s:4:\"name\";s:10:\"Coffee Cup\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:45;a:12:{s:2:\"id\";s:3:\"130\";s:6:\"handle\";s:19:\"object_frypan_2.png\";s:4:\"name\";s:9:\"Fry Pan 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:46;a:12:{s:2:\"id\";s:3:\"129\";s:6:\"handle\";s:19:\"object_frypan_1.png\";s:4:\"name\";s:9:\"Fry Pan 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:47;a:12:{s:2:\"id\";s:3:\"128\";s:6:\"handle\";s:17:\"object_fork_1.png\";s:4:\"name\";s:4:\"Fork\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:48;a:12:{s:2:\"id\";s:3:\"127\";s:6:\"handle\";s:20:\"object_dishrag_1.png\";s:4:\"name\";s:13:\"Dishrag Cloth\";s:4:\"tags\";a:0:{}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:49;a:12:{s:2:\"id\";s:3:\"126\";s:6:\"handle\";s:20:\"object_wacom_pen.png\";s:4:\"name\";s:17:\"Wacom Drawing Pen\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1060\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:50;a:12:{s:2:\"id\";s:3:\"125\";s:6:\"handle\";s:21:\"object_occulus_vr.png\";s:4:\"name\";s:23:\"Occulus Virtual Reality\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:51;a:12:{s:2:\"id\";s:3:\"124\";s:6:\"handle\";s:18:\"object_antenna.png\";s:4:\"name\";s:13:\"Antenna Radar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:52;a:12:{s:2:\"id\";s:3:\"123\";s:6:\"handle\";s:21:\"object_solarpanel.png\";s:4:\"name\";s:11:\"Solar Panel\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:53;a:12:{s:2:\"id\";s:3:\"122\";s:6:\"handle\";s:16:\"object_wacom.png\";s:4:\"name\";s:20:\"Wacom Drawing Tablet\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:54;a:12:{s:2:\"id\";s:3:\"121\";s:6:\"handle\";s:18:\"object_earth_2.png\";s:4:\"name\";s:20:\"Earth Globe Planet 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:55;a:12:{s:2:\"id\";s:3:\"120\";s:6:\"handle\";s:18:\"object_chair_1.png\";s:4:\"name\";s:12:\"Office Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:56;a:12:{s:2:\"id\";s:3:\"119\";s:6:\"handle\";s:24:\"object_windturbine_2.png\";s:4:\"name\";s:14:\"Wind Turbine 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:57;a:12:{s:2:\"id\";s:3:\"118\";s:6:\"handle\";s:22:\"object_windturbine.png\";s:4:\"name\";s:12:\"Wind Turbine\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:58;a:12:{s:2:\"id\";s:3:\"117\";s:6:\"handle\";s:16:\"object_earth.png\";s:4:\"name\";s:18:\"Earth Globe Planet\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:59;a:12:{s:2:\"id\";s:2:\"88\";s:6:\"handle\";s:24:\"object_eiffeltower_2.png\";s:4:\"name\";s:13:\"Eiffeltower 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"700\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:60;a:12:{s:2:\"id\";s:2:\"87\";s:6:\"handle\";s:21:\"object_notebook_1.png\";s:4:\"name\";s:11:\"Notebook PC\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:61;a:12:{s:2:\"id\";s:2:\"86\";s:6:\"handle\";s:20:\"object_macbook_1.png\";s:4:\"name\";s:20:\"Apple Macbook Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:62;a:12:{s:2:\"id\";s:2:\"85\";s:6:\"handle\";s:18:\"object_canon_2.png\";s:4:\"name\";s:21:\"Canon Camera DSLR Top\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:63;a:12:{s:2:\"id\";s:2:\"84\";s:6:\"handle\";s:19:\"object_iphone_3.png\";s:4:\"name\";s:25:\"Apple iPhone Silver White\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:64;a:12:{s:2:\"id\";s:2:\"83\";s:6:\"handle\";s:18:\"object_candy_2.png\";s:4:\"name\";s:15:\"Candy Colored 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:65;a:12:{s:2:\"id\";s:2:\"82\";s:6:\"handle\";s:21:\"object_macmouse_1.png\";s:4:\"name\";s:15:\"Apple Mac Mouse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:66;a:12:{s:2:\"id\";s:2:\"81\";s:6:\"handle\";s:19:\"object_iphone_1.png\";s:4:\"name\";s:18:\"Apple iPhone Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:67;a:12:{s:2:\"id\";s:2:\"80\";s:6:\"handle\";s:17:\"object_deco_1.png\";s:4:\"name\";s:17:\"White Deco Object\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:68;a:12:{s:2:\"id\";s:2:\"79\";s:6:\"handle\";s:23:\"object_applewatch_1.png\";s:4:\"name\";s:24:\"Apple Watch White Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:69;a:12:{s:2:\"id\";s:2:\"78\";s:6:\"handle\";s:23:\"object_swissknife_1.png\";s:4:\"name\";s:11:\"Swiss Knife\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:70;a:12:{s:2:\"id\";s:2:\"77\";s:6:\"handle\";s:23:\"object_applewatch_2.png\";s:4:\"name\";s:17:\"Apple Watch Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:71;a:12:{s:2:\"id\";s:2:\"76\";s:6:\"handle\";s:18:\"object_candy_1.png\";s:4:\"name\";s:13:\"Candy Colored\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:72;a:12:{s:2:\"id\";s:2:\"75\";s:6:\"handle\";s:17:\"object_ipad_1.png\";s:4:\"name\";s:16:\"Apple iPad Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:73;a:12:{s:2:\"id\";s:2:\"74\";s:6:\"handle\";s:17:\"object_lamp_2.png\";s:4:\"name\";s:15:\"Black Desk Lamp\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:74;a:12:{s:2:\"id\";s:2:\"73\";s:6:\"handle\";s:18:\"object_canon_1.png\";s:4:\"name\";s:17:\"Canon Camera DLSR\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:75;a:12:{s:2:\"id\";s:2:\"72\";s:6:\"handle\";s:23:\"object_blackberry_2.png\";s:4:\"name\";s:12:\"Blackberry 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:76;a:12:{s:2:\"id\";s:2:\"71\";s:6:\"handle\";s:19:\"object_iphone_2.png\";s:4:\"name\";s:19:\"Apple iPhone Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:77;a:12:{s:2:\"id\";s:2:\"70\";s:6:\"handle\";s:17:\"object_ipad_2.png\";s:4:\"name\";s:15:\"Apple iPad Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:78;a:12:{s:2:\"id\";s:2:\"69\";s:6:\"handle\";s:20:\"object_printer_1.png\";s:4:\"name\";s:7:\"Printer\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:79;a:12:{s:2:\"id\";s:2:\"68\";s:6:\"handle\";s:20:\"object_pcmouse_1.png\";s:4:\"name\";s:14:\"Black PC Mouse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:80;a:12:{s:2:\"id\";s:2:\"67\";s:6:\"handle\";s:17:\"object_ipad_3.png\";s:4:\"name\";s:17:\"Apple iPad Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:81;a:12:{s:2:\"id\";s:2:\"66\";s:6:\"handle\";s:17:\"object_lamp_1.png\";s:4:\"name\";s:13:\"Desk Lamp Top\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:82;a:12:{s:2:\"id\";s:2:\"65\";s:6:\"handle\";s:22:\"object_macscreen_1.png\";s:4:\"name\";s:16:\"Apple Mac Screen\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:83;a:12:{s:2:\"id\";s:2:\"64\";s:6:\"handle\";s:23:\"object_blackberry_3.png\";s:4:\"name\";s:12:\"Blackberry 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:84;a:12:{s:2:\"id\";s:2:\"63\";s:6:\"handle\";s:23:\"object_applewatch_3.png\";s:4:\"name\";s:16:\"Apple Watch Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:85;a:12:{s:2:\"id\";s:2:\"62\";s:6:\"handle\";s:23:\"object_blackberry_1.png\";s:4:\"name\";s:10:\"Blackberry\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:86;a:12:{s:2:\"id\";s:2:\"49\";s:6:\"handle\";s:19:\"object_bottle_1.png\";s:4:\"name\";s:18:\"Brown Glass Bottle\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:87;a:12:{s:2:\"id\";s:2:\"48\";s:6:\"handle\";s:20:\"object_glasses_1.png\";s:4:\"name\";s:19:\"Hipster Glasses Top\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:88;a:12:{s:2:\"id\";s:2:\"47\";s:6:\"handle\";s:21:\"object_magazine_1.png\";s:4:\"name\";s:14:\"Blank Magazine\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:89;a:12:{s:2:\"id\";s:2:\"46\";s:6:\"handle\";s:28:\"object_leatherdocument_2.png\";s:4:\"name\";s:24:\"Black Leather Document 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:90;a:12:{s:2:\"id\";s:2:\"45\";s:6:\"handle\";s:18:\"object_purse_2.png\";s:4:\"name\";s:13:\"Black Purse 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:91;a:12:{s:2:\"id\";s:2:\"44\";s:6:\"handle\";s:23:\"object_typewriter_1.png\";s:4:\"name\";s:18:\"Retro Typewriter 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:92;a:12:{s:2:\"id\";s:2:\"43\";s:6:\"handle\";s:17:\"object_book_5.png\";s:4:\"name\";s:9:\"Old Books\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:93;a:12:{s:2:\"id\";s:2:\"42\";s:6:\"handle\";s:28:\"object_leatherdocument_1.png\";s:4:\"name\";s:29:\"Black Leather Document Closed\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:94;a:12:{s:2:\"id\";s:2:\"41\";s:6:\"handle\";s:17:\"object_book_4.png\";s:4:\"name\";s:8:\"Old Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:95;a:12:{s:2:\"id\";s:2:\"40\";s:6:\"handle\";s:19:\"object_wallet_2.png\";s:4:\"name\";s:22:\"Black Leather Document\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:96;a:12:{s:2:\"id\";s:2:\"39\";s:6:\"handle\";s:18:\"object_quill_2.png\";s:4:\"name\";s:15:\"Quill Feather 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:97;a:12:{s:2:\"id\";s:2:\"38\";s:6:\"handle\";s:24:\"object_eiffeltower_1.png\";s:4:\"name\";s:11:\"Eiffeltower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:98;a:12:{s:2:\"id\";s:2:\"37\";s:6:\"handle\";s:21:\"object_magazine_2.png\";s:4:\"name\";s:11:\"Open Book 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1333\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:99;a:12:{s:2:\"id\";s:2:\"36\";s:6:\"handle\";s:17:\"object_book_1.png\";s:4:\"name\";s:10:\"Blank Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:100;a:12:{s:2:\"id\";s:2:\"35\";s:6:\"handle\";s:20:\"object_glasses_2.png\";s:4:\"name\";s:15:\"Hipster Glasses\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:101;a:12:{s:2:\"id\";s:2:\"34\";s:6:\"handle\";s:17:\"object_book_2.png\";s:4:\"name\";s:11:\"Open Book 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:102;a:12:{s:2:\"id\";s:2:\"33\";s:6:\"handle\";s:19:\"object_gloves_1.png\";s:4:\"name\";s:12:\"Black Gloves\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:103;a:12:{s:2:\"id\";s:2:\"32\";s:6:\"handle\";s:23:\"object_typewriter_2.png\";s:4:\"name\";s:16:\"Retro Typewriter\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:104;a:12:{s:2:\"id\";s:2:\"31\";s:6:\"handle\";s:17:\"object_book_3.png\";s:4:\"name\";s:9:\"Open Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:105;a:12:{s:2:\"id\";s:2:\"30\";s:6:\"handle\";s:19:\"object_wallet_1.png\";s:4:\"name\";s:12:\"Black Wallet\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:106;a:12:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:18:\"object_purse_1.png\";s:4:\"name\";s:11:\"Black Purse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:107;a:12:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:18:\"object_quill_1.png\";s:4:\"name\";s:13:\"Quill Feather\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:108;a:12:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:19:\"object_artbox_2.png\";s:4:\"name\";s:16:\"Art Box Colors 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:109;a:12:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:18:\"object_cloth_1.png\";s:4:\"name\";s:17:\"Cloth Paint Color\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:110;a:12:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:21:\"object_brushpot_1.png\";s:4:\"name\";s:9:\"Brush Pot\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"984\";s:6:\"height\";s:3:\"984\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:111;a:12:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:24:\"object_paintbucket_1.png\";s:4:\"name\";s:12:\"Paint Bucket\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:112;a:12:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:23:\"object_paintbrush_2.png\";s:4:\"name\";s:12:\"Paintbrush 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"700\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:113;a:12:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:19:\"object_artbox_1.png\";s:4:\"name\";s:14:\"Art Box Colors\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:114;a:12:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:23:\"object_paintbrush_3.png\";s:4:\"name\";s:12:\"Paintbrush 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1100\";s:6:\"height\";s:4:\"1100\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:115;a:12:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:23:\"object_paintbrush_1.png\";s:4:\"name\";s:12:\"Paintbrush 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:116;a:12:{s:2:\"id\";s:2:\"11\";s:6:\"handle\";s:21:\"table_radio_right.png\";s:4:\"name\";s:18:\"Radio Speaker Wood\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:117;a:12:{s:2:\"id\";s:2:\"10\";s:6:\"handle\";s:18:\"keyboard_apple.png\";s:4:\"name\";s:14:\"Apple Keyboard\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:118;a:12:{s:2:\"id\";s:1:\"9\";s:6:\"handle\";s:20:\"macbook_top_gold.png\";s:4:\"name\";s:18:\"Apple Macbook Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:119;a:12:{s:2:\"id\";s:1:\"8\";s:6:\"handle\";s:21:\"nexus6_front_blue.png\";s:4:\"name\";s:19:\"Google Nexus 6 Blue\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1100\";s:6:\"height\";s:4:\"1100\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:120;a:12:{s:2:\"id\";s:3:\"479\";s:6:\"handle\";s:31:\"Tram-beside-waiting-station.jpg\";s:4:\"name\";s:27:\"Tram beside waiting station\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1450\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:52:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:121;a:12:{s:2:\"id\";s:3:\"478\";s:6:\"handle\";s:14:\"Pulling-up.jpg\";s:4:\"name\";s:10:\"Pulling up\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1297\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:41:20\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:122;a:12:{s:2:\"id\";s:3:\"477\";s:6:\"handle\";s:16:\"Snowboarding.jpg\";s:4:\"name\";s:12:\"Snowboarding\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1290\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:41:20\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:123;a:12:{s:2:\"id\";s:3:\"476\";s:6:\"handle\";s:16:\"Morning-yoga.jpg\";s:4:\"name\";s:12:\"Morning yoga\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1346\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:124;a:12:{s:2:\"id\";s:3:\"475\";s:6:\"handle\";s:8:\"Yoga.jpg\";s:4:\"name\";s:4:\"Yoga\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1079\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:125;a:12:{s:2:\"id\";s:3:\"474\";s:6:\"handle\";s:14:\"Golf-balls.jpg\";s:4:\"name\";s:10:\"Golf balls\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:126;a:12:{s:2:\"id\";s:3:\"473\";s:6:\"handle\";s:19:\"Confident-Boxer.jpg\";s:4:\"name\";s:15:\"Confident Boxer\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:127;a:12:{s:2:\"id\";s:3:\"472\";s:6:\"handle\";s:11:\"Aerobic.jpg\";s:4:\"name\";s:7:\"Aerobic\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:128;a:12:{s:2:\"id\";s:3:\"471\";s:6:\"handle\";s:18:\"Riding-bicycle.jpg\";s:4:\"name\";s:14:\"Riding bicycle\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1358\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:129;a:12:{s:2:\"id\";s:3:\"470\";s:6:\"handle\";s:27:\"woman-with-barbell-back.jpg\";s:4:\"name\";s:23:\"woman with barbell back\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:130;a:12:{s:2:\"id\";s:3:\"469\";s:6:\"handle\";s:24:\"Woman-lying-on-floor.jpg\";s:4:\"name\";s:20:\"Woman lying on floor\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1318\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:131;a:12:{s:2:\"id\";s:3:\"468\";s:6:\"handle\";s:27:\"Holding-black-dumbbells.jpg\";s:4:\"name\";s:23:\"Holding black dumbbells\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:132;a:12:{s:2:\"id\";s:3:\"467\";s:6:\"handle\";s:25:\"Woman-using-dumbbells.jpg\";s:4:\"name\";s:21:\"Woman using dumbbells\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1425\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:133;a:12:{s:2:\"id\";s:3:\"466\";s:6:\"handle\";s:16:\"Soccer-cleat.jpg\";s:4:\"name\";s:12:\"Soccer cleat\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:134;a:12:{s:2:\"id\";s:3:\"465\";s:6:\"handle\";s:16:\"Soccer-field.jpg\";s:4:\"name\";s:12:\"Soccer field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:135;a:12:{s:2:\"id\";s:3:\"464\";s:6:\"handle\";s:23:\"Man-tying-his-shoes.jpg\";s:4:\"name\";s:19:\"Man tying his shoes\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1200\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:136;a:12:{s:2:\"id\";s:3:\"463\";s:6:\"handle\";s:10:\"Boxing.jpg\";s:4:\"name\";s:6:\"Boxing\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:137;a:12:{s:2:\"id\";s:3:\"462\";s:6:\"handle\";s:22:\"woman-with-barbell.jpg\";s:4:\"name\";s:18:\"woman with barbell\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:138;a:12:{s:2:\"id\";s:3:\"461\";s:6:\"handle\";s:12:\"Crossfit.jpg\";s:4:\"name\";s:8:\"Crossfit\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:139;a:12:{s:2:\"id\";s:3:\"460\";s:6:\"handle\";s:25:\"Man-and-woman-jogging.jpg\";s:4:\"name\";s:21:\"Man and woman jogging\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:140;a:12:{s:2:\"id\";s:3:\"459\";s:6:\"handle\";s:16:\"Playing-golf.jpg\";s:4:\"name\";s:12:\"Playing golf\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:141;a:12:{s:2:\"id\";s:3:\"458\";s:6:\"handle\";s:18:\"Surfer-in-wave.jpg\";s:4:\"name\";s:14:\"Surfer in wave\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:142;a:12:{s:2:\"id\";s:3:\"457\";s:6:\"handle\";s:25:\"Woman-lifting-barbell.jpg\";s:4:\"name\";s:21:\"Woman lifting barbell\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:143;a:12:{s:2:\"id\";s:3:\"456\";s:6:\"handle\";s:14:\"Stretching.jpg\";s:4:\"name\";s:10:\"Stretching\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:144;a:12:{s:2:\"id\";s:3:\"455\";s:6:\"handle\";s:18:\"Snowboarding-2.jpg\";s:4:\"name\";s:14:\"Snowboarding 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:145;a:12:{s:2:\"id\";s:3:\"454\";s:6:\"handle\";s:11:\"Balance.jpg\";s:4:\"name\";s:7:\"Balance\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1920\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:146;a:12:{s:2:\"id\";s:3:\"453\";s:6:\"handle\";s:19:\"Pool-meditation.jpg\";s:4:\"name\";s:15:\"Pool meditation\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:147;a:12:{s:2:\"id\";s:3:\"452\";s:6:\"handle\";s:18:\"Soccer-stadium.jpg\";s:4:\"name\";s:14:\"Soccer stadium\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:148;a:12:{s:2:\"id\";s:3:\"451\";s:6:\"handle\";s:25:\"Soccer-field-top-view.jpg\";s:4:\"name\";s:21:\"Soccer field top view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:149;a:12:{s:2:\"id\";s:3:\"450\";s:6:\"handle\";s:14:\"Basketball.jpg\";s:4:\"name\";s:10:\"Basketball\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:150;a:12:{s:2:\"id\";s:3:\"449\";s:6:\"handle\";s:14:\"in-the-fog.jpg\";s:4:\"name\";s:10:\"in the fog\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:151;a:12:{s:2:\"id\";s:3:\"448\";s:6:\"handle\";s:13:\"Handstand.jpg\";s:4:\"name\";s:9:\"Handstand\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1079\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:152;a:12:{s:2:\"id\";s:3:\"447\";s:6:\"handle\";s:11:\"Friends.jpg\";s:4:\"name\";s:7:\"Friends\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:153;a:12:{s:2:\"id\";s:3:\"446\";s:6:\"handle\";s:28:\"Sneakers-on-the-railroad.jpg\";s:4:\"name\";s:24:\"Sneakers on the railroad\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:154;a:12:{s:2:\"id\";s:3:\"445\";s:6:\"handle\";s:23:\"Family-on-the-ocean.jpg\";s:4:\"name\";s:19:\"Family on the ocean\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:155;a:12:{s:2:\"id\";s:3:\"444\";s:6:\"handle\";s:10:\"Sunset.jpg\";s:4:\"name\";s:6:\"Sunset\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:156;a:12:{s:2:\"id\";s:3:\"443\";s:6:\"handle\";s:9:\"Books.jpg\";s:4:\"name\";s:5:\"Books\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:157;a:12:{s:2:\"id\";s:3:\"442\";s:6:\"handle\";s:25:\"Looking-at-the-window.jpg\";s:4:\"name\";s:21:\"Looking at the window\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:158;a:12:{s:2:\"id\";s:3:\"441\";s:6:\"handle\";s:48:\"woman-standing-near-buildings-during-daytime.jpg\";s:4:\"name\";s:44:\"woman standing near buildings during daytime\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:159;a:12:{s:2:\"id\";s:3:\"440\";s:6:\"handle\";s:12:\"Lollipop.jpg\";s:4:\"name\";s:8:\"Lollipop\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1395\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:160;a:12:{s:2:\"id\";s:3:\"439\";s:6:\"handle\";s:26:\"People-crossing-street.jpg\";s:4:\"name\";s:22:\"People crossing street\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:161;a:12:{s:2:\"id\";s:3:\"438\";s:6:\"handle\";s:24:\"Friends-on-the-shore.jpg\";s:4:\"name\";s:20:\"Friends on the shore\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:162;a:12:{s:2:\"id\";s:3:\"437\";s:6:\"handle\";s:13:\"Coworkers.jpg\";s:4:\"name\";s:9:\"Coworkers\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:163;a:12:{s:2:\"id\";s:3:\"436\";s:6:\"handle\";s:27:\"Hiking-in-the-Dolomites.jpg\";s:4:\"name\";s:23:\"Hiking in the Dolomites\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:164;a:12:{s:2:\"id\";s:3:\"435\";s:6:\"handle\";s:18:\"Successful-man.jpg\";s:4:\"name\";s:14:\"Successful man\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:165;a:12:{s:2:\"id\";s:3:\"434\";s:6:\"handle\";s:23:\"Beautiful-sunny-day.jpg\";s:4:\"name\";s:19:\"Beautiful sunny day\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:166;a:12:{s:2:\"id\";s:3:\"433\";s:6:\"handle\";s:8:\"Guys.jpg\";s:4:\"name\";s:4:\"Guys\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:167;a:12:{s:2:\"id\";s:3:\"432\";s:6:\"handle\";s:19:\"Confetti-Shower.jpg\";s:4:\"name\";s:15:\"Confetti Shower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:168;a:12:{s:2:\"id\";s:3:\"431\";s:6:\"handle\";s:24:\"Sun-was-setting-down.jpg\";s:4:\"name\";s:20:\"Sun was setting down\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:169;a:12:{s:2:\"id\";s:3:\"430\";s:6:\"handle\";s:9:\"Jumps.jpg\";s:4:\"name\";s:5:\"Jumps\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:170;a:12:{s:2:\"id\";s:3:\"429\";s:6:\"handle\";s:23:\"Friends-by-the-fire.jpg\";s:4:\"name\";s:19:\"Friends by the fire\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:171;a:12:{s:2:\"id\";s:3:\"428\";s:6:\"handle\";s:21:\"Under-the-blanket.jpg\";s:4:\"name\";s:17:\"Under the blanket\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1413\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:172;a:12:{s:2:\"id\";s:3:\"427\";s:6:\"handle\";s:18:\"Pretty-in-Pink.jpg\";s:4:\"name\";s:14:\"Pretty in Pink\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1394\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:173;a:12:{s:2:\"id\";s:3:\"426\";s:6:\"handle\";s:31:\"Discussions-at-a-long-table.jpg\";s:4:\"name\";s:27:\"Discussions at a long table\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1268\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:174;a:12:{s:2:\"id\";s:3:\"425\";s:6:\"handle\";s:18:\"Lost-in-Lemons.jpg\";s:4:\"name\";s:14:\"Lost in Lemons\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:175;a:12:{s:2:\"id\";s:3:\"424\";s:6:\"handle\";s:13:\"Team-work.jpg\";s:4:\"name\";s:9:\"Team work\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:176;a:12:{s:2:\"id\";s:3:\"423\";s:6:\"handle\";s:20:\"Romantic-evening.jpg\";s:4:\"name\";s:16:\"Romantic evening\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1263\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:177;a:12:{s:2:\"id\";s:3:\"422\";s:6:\"handle\";s:19:\"Crew-collective.jpg\";s:4:\"name\";s:15:\"Crew collective\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:178;a:12:{s:2:\"id\";s:3:\"421\";s:6:\"handle\";s:8:\"Code.jpg\";s:4:\"name\";s:4:\"Code\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:179;a:12:{s:2:\"id\";s:3:\"420\";s:6:\"handle\";s:48:\"Yellow-ceramic-mug-beside-gray-aluminum-iMac.jpg\";s:4:\"name\";s:44:\"Yellow ceramic mug beside gray aluminum iMac\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:180;a:12:{s:2:\"id\";s:3:\"419\";s:6:\"handle\";s:11:\"My-desk.jpg\";s:4:\"name\";s:7:\"My desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1315\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:181;a:12:{s:2:\"id\";s:3:\"418\";s:6:\"handle\";s:17:\"Cooperation-2.jpg\";s:4:\"name\";s:13:\"Cooperation 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:182;a:12:{s:2:\"id\";s:3:\"417\";s:6:\"handle\";s:33:\"MacBook-on-top-of-brown-table.jpg\";s:4:\"name\";s:29:\"MacBook on top of brown table\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:183;a:12:{s:2:\"id\";s:3:\"416\";s:6:\"handle\";s:27:\"Beautiful-working-place.jpg\";s:4:\"name\";s:23:\"Beautiful working place\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:184;a:12:{s:2:\"id\";s:3:\"415\";s:6:\"handle\";s:14:\"Typewriter.jpg\";s:4:\"name\";s:10:\"Typewriter\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:185;a:12:{s:2:\"id\";s:3:\"414\";s:6:\"handle\";s:19:\"White-desk-lamp.jpg\";s:4:\"name\";s:15:\"White desk lamp\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:186;a:12:{s:2:\"id\";s:3:\"413\";s:6:\"handle\";s:18:\"Office-working.jpg\";s:4:\"name\";s:14:\"Office working\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:187;a:12:{s:2:\"id\";s:3:\"412\";s:6:\"handle\";s:36:\"Silver-iMac-on-brown-wooden-desk.jpg\";s:4:\"name\";s:32:\"Silver iMac on brown wooden desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1240\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:188;a:12:{s:2:\"id\";s:3:\"411\";s:6:\"handle\";s:23:\"Working-in-progress.jpg\";s:4:\"name\";s:19:\"Working in progress\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:189;a:12:{s:2:\"id\";s:3:\"410\";s:6:\"handle\";s:15:\"Cooperation.jpg\";s:4:\"name\";s:11:\"Cooperation\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:190;a:12:{s:2:\"id\";s:3:\"409\";s:6:\"handle\";s:17:\"Working-place.jpg\";s:4:\"name\";s:13:\"Working place\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:191;a:12:{s:2:\"id\";s:3:\"408\";s:6:\"handle\";s:16:\"Working-desk.jpg\";s:4:\"name\";s:12:\"Working desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:192;a:12:{s:2:\"id\";s:3:\"407\";s:6:\"handle\";s:23:\"low-angle-of-forest.jpg\";s:4:\"name\";s:19:\"low angle of forest\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:193;a:12:{s:2:\"id\";s:3:\"406\";s:6:\"handle\";s:23:\"Lake-under-blue-sky.jpg\";s:4:\"name\";s:19:\"Lake under blue sky\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1351\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:194;a:12:{s:2:\"id\";s:3:\"405\";s:6:\"handle\";s:21:\"Blue-starry-night.jpg\";s:4:\"name\";s:17:\"Blue starry night\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:195;a:12:{s:2:\"id\";s:3:\"404\";s:6:\"handle\";s:22:\"Aerial-photography.jpg\";s:4:\"name\";s:18:\"Aerial photography\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:196;a:12:{s:2:\"id\";s:3:\"403\";s:6:\"handle\";s:14:\"Red-clouds.jpg\";s:4:\"name\";s:10:\"Red clouds\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:197;a:12:{s:2:\"id\";s:3:\"402\";s:6:\"handle\";s:14:\"Snow-field.jpg\";s:4:\"name\";s:10:\"Snow field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1227\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:198;a:12:{s:2:\"id\";s:3:\"401\";s:6:\"handle\";s:13:\"White-sky.jpg\";s:4:\"name\";s:9:\"White sky\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:199;a:12:{s:2:\"id\";s:3:\"400\";s:6:\"handle\";s:24:\"Trees-covered-by-fog.jpg\";s:4:\"name\";s:20:\"Trees covered by fog\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:200;a:12:{s:2:\"id\";s:3:\"399\";s:6:\"handle\";s:26:\"Red-and-white-mushroom.jpg\";s:4:\"name\";s:22:\"Red and white mushroom\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:201;a:12:{s:2:\"id\";s:3:\"398\";s:6:\"handle\";s:24:\"Lake-near-pine-trees.jpg\";s:4:\"name\";s:20:\"Lake near pine trees\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:202;a:12:{s:2:\"id\";s:3:\"397\";s:6:\"handle\";s:35:\"After-a-long-day-of-backpacking.jpg\";s:4:\"name\";s:31:\"After a long day of backpacking\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:203;a:12:{s:2:\"id\";s:3:\"396\";s:6:\"handle\";s:32:\"Mountains-during-golden-hour.jpg\";s:4:\"name\";s:28:\"Mountains during golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:204;a:12:{s:2:\"id\";s:3:\"395\";s:6:\"handle\";s:27:\"Man-looking-on-mountain.jpg\";s:4:\"name\";s:23:\"Man looking on mountain\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:205;a:12:{s:2:\"id\";s:3:\"394\";s:6:\"handle\";s:19:\"Body-of-water-2.jpg\";s:4:\"name\";s:15:\"Body of water 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:206;a:12:{s:2:\"id\";s:3:\"393\";s:6:\"handle\";s:15:\"Brown-cliff.jpg\";s:4:\"name\";s:11:\"Brown cliff\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:207;a:12:{s:2:\"id\";s:3:\"392\";s:6:\"handle\";s:20:\"Green-foggy-tree.jpg\";s:4:\"name\";s:16:\"Green foggy tree\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1417\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:208;a:12:{s:2:\"id\";s:3:\"391\";s:6:\"handle\";s:32:\"Grayscale-photo-of-mountains.jpg\";s:4:\"name\";s:28:\"Grayscale photo of mountains\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:209;a:12:{s:2:\"id\";s:3:\"390\";s:6:\"handle\";s:19:\"Under-sunny-sky.jpg\";s:4:\"name\";s:15:\"Under sunny sky\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:210;a:12:{s:2:\"id\";s:3:\"389\";s:6:\"handle\";s:16:\"Rock-concert.jpg\";s:4:\"name\";s:12:\"Rock concert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1443\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:211;a:12:{s:2:\"id\";s:3:\"388\";s:6:\"handle\";s:30:\"Group-of-people-in-concert.jpg\";s:4:\"name\";s:26:\"Group of people in concert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:212;a:12:{s:2:\"id\";s:3:\"387\";s:6:\"handle\";s:6:\"DJ.jpg\";s:4:\"name\";s:2:\"DJ\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:213;a:12:{s:2:\"id\";s:3:\"386\";s:6:\"handle\";s:56:\"Woman-standing-watching-LED-light-musical-instrument.jpg\";s:4:\"name\";s:52:\"Woman standing watching LED light musical instrument\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:214;a:12:{s:2:\"id\";s:3:\"385\";s:6:\"handle\";s:16:\"Concert-hall.jpg\";s:4:\"name\";s:12:\"Concert hall\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:215;a:12:{s:2:\"id\";s:3:\"384\";s:6:\"handle\";s:18:\"Concert-hall-2.jpg\";s:4:\"name\";s:14:\"Concert hall 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:216;a:12:{s:2:\"id\";s:3:\"383\";s:6:\"handle\";s:29:\"man-playing-upright-piano.jpg\";s:4:\"name\";s:25:\"man playing upright piano\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1340\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:217;a:12:{s:2:\"id\";s:3:\"382\";s:6:\"handle\";s:30:\"person-performing-on-stage.jpg\";s:4:\"name\";s:26:\"person performing on stage\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:218;a:12:{s:2:\"id\";s:3:\"381\";s:6:\"handle\";s:27:\"Brown-string-instrument.jpg\";s:4:\"name\";s:23:\"Brown string instrument\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:219;a:12:{s:2:\"id\";s:3:\"380\";s:6:\"handle\";s:36:\"silhouette-of-person-with-guitar.jpg\";s:4:\"name\";s:32:\"silhouette of person with guitar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:220;a:12:{s:2:\"id\";s:3:\"379\";s:6:\"handle\";s:14:\"Party-fans.jpg\";s:4:\"name\";s:10:\"Party fans\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:221;a:12:{s:2:\"id\";s:3:\"378\";s:6:\"handle\";s:24:\"Condenser-microphone.jpg\";s:4:\"name\";s:20:\"Condenser microphone\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:222;a:12:{s:2:\"id\";s:3:\"377\";s:6:\"handle\";s:42:\"Low-angle-photo-of-high-rise-buildings.jpg\";s:4:\"name\";s:38:\"Low angle photo of high rise buildings\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:223;a:12:{s:2:\"id\";s:3:\"376\";s:6:\"handle\";s:23:\"High-rise-buildings.jpg\";s:4:\"name\";s:19:\"High rise buildings\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:224;a:12:{s:2:\"id\";s:3:\"375\";s:6:\"handle\";s:16:\"Cable-bridge.jpg\";s:4:\"name\";s:12:\"Cable bridge\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:225;a:12:{s:2:\"id\";s:3:\"374\";s:6:\"handle\";s:35:\"Bokeh-effect-from-street-lights.jpg\";s:4:\"name\";s:31:\"Bokeh effect from street lights\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:226;a:12:{s:2:\"id\";s:3:\"373\";s:6:\"handle\";s:18:\"Low-angle-view.jpg\";s:4:\"name\";s:14:\"Low angle view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:227;a:12:{s:2:\"id\";s:3:\"372\";s:6:\"handle\";s:21:\"Double-decker-bus.jpg\";s:4:\"name\";s:17:\"Double decker bus\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1373\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:228;a:12:{s:2:\"id\";s:3:\"371\";s:6:\"handle\";s:32:\"Buildings-near-body-of-water.jpg\";s:4:\"name\";s:28:\"Buildings near body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1370\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:229;a:12:{s:2:\"id\";s:3:\"370\";s:6:\"handle\";s:18:\"Satellite-view.jpg\";s:4:\"name\";s:14:\"Satellite view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:230;a:12:{s:2:\"id\";s:3:\"369\";s:6:\"handle\";s:14:\"Twin-Tower.jpg\";s:4:\"name\";s:10:\"Twin Tower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:231;a:12:{s:2:\"id\";s:3:\"368\";s:6:\"handle\";s:22:\"Two-person-walking.jpg\";s:4:\"name\";s:18:\"Two person walking\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1345\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:232;a:12:{s:2:\"id\";s:3:\"367\";s:6:\"handle\";s:15:\"Sears-Tower.jpg\";s:4:\"name\";s:11:\"Sears Tower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:233;a:12:{s:2:\"id\";s:3:\"366\";s:6:\"handle\";s:19:\"Night-cityscape.jpg\";s:4:\"name\";s:15:\"Night cityscape\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:234;a:12:{s:2:\"id\";s:3:\"365\";s:6:\"handle\";s:25:\"Empire-State-Building.jpg\";s:4:\"name\";s:21:\"Empire State Building\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:235;a:12:{s:2:\"id\";s:3:\"364\";s:6:\"handle\";s:9:\"Paris.jpg\";s:4:\"name\";s:5:\"Paris\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:236;a:12:{s:2:\"id\";s:3:\"363\";s:6:\"handle\";s:31:\"Building-during-golden-hour.jpg\";s:4:\"name\";s:27:\"Building during golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1288\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:237;a:12:{s:2:\"id\";s:3:\"362\";s:6:\"handle\";s:21:\"Afternoon-skyline.jpg\";s:4:\"name\";s:17:\"Afternoon skyline\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:238;a:12:{s:2:\"id\";s:3:\"361\";s:6:\"handle\";s:22:\"Concrete-buildings.jpg\";s:4:\"name\";s:18:\"Concrete buildings\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:239;a:12:{s:2:\"id\";s:3:\"360\";s:6:\"handle\";s:26:\"Architectural-building.jpg\";s:4:\"name\";s:22:\"Architectural building\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1382\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:240;a:12:{s:2:\"id\";s:3:\"359\";s:6:\"handle\";s:23:\"Skyline-photography.jpg\";s:4:\"name\";s:19:\"Skyline photography\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:241;a:12:{s:2:\"id\";s:3:\"358\";s:6:\"handle\";s:38:\"People-standing-on-pedestrian-lane.jpg\";s:4:\"name\";s:34:\"People standing on pedestrian lane\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1154\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:242;a:12:{s:2:\"id\";s:3:\"357\";s:6:\"handle\";s:16:\"Burj-Khalifa.jpg\";s:4:\"name\";s:12:\"Burj Khalifa\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:243;a:12:{s:2:\"id\";s:3:\"356\";s:6:\"handle\";s:13:\"Skycraper.jpg\";s:4:\"name\";s:9:\"Skycraper\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:244;a:12:{s:2:\"id\";s:3:\"355\";s:6:\"handle\";s:14:\"Gray-tower.jpg\";s:4:\"name\";s:10:\"Gray tower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1433\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:245;a:12:{s:2:\"id\";s:3:\"354\";s:6:\"handle\";s:28:\"One-fine-day-in-Maldives.jpg\";s:4:\"name\";s:24:\"One fine day in Maldives\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1116\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:246;a:12:{s:2:\"id\";s:3:\"353\";s:6:\"handle\";s:25:\"Boat-on-body-of-water.jpg\";s:4:\"name\";s:21:\"Boat on body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:247;a:12:{s:2:\"id\";s:3:\"352\";s:6:\"handle\";s:33:\"Aerial-photo-of-body-of-water.jpg\";s:4:\"name\";s:29:\"Aerial photo of body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1078\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:248;a:12:{s:2:\"id\";s:3:\"351\";s:6:\"handle\";s:31:\"Assorted-color-beach-houses.jpg\";s:4:\"name\";s:27:\"Assorted color beach houses\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1135\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:249;a:12:{s:2:\"id\";s:3:\"350\";s:6:\"handle\";s:36:\"Woman-leaning-on-tree-near-beach.jpg\";s:4:\"name\";s:32:\"Woman leaning on tree near beach\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1559\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:250;a:12:{s:2:\"id\";s:3:\"349\";s:6:\"handle\";s:17:\"Body-of-water.jpg\";s:4:\"name\";s:13:\"Body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1269\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:251;a:12:{s:2:\"id\";s:3:\"348\";s:6:\"handle\";s:17:\"People-on-sea.jpg\";s:4:\"name\";s:13:\"People on sea\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:252;a:12:{s:2:\"id\";s:3:\"347\";s:6:\"handle\";s:31:\"Man-sitting-beside-of-woman.jpg\";s:4:\"name\";s:27:\"Man sitting beside of woman\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:253;a:12:{s:2:\"id\";s:3:\"346\";s:6:\"handle\";s:22:\"woman-in-the-water.jpg\";s:4:\"name\";s:18:\"woman in the water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:254;a:12:{s:2:\"id\";s:3:\"345\";s:6:\"handle\";s:39:\"Brown-stone-near-sea-at-golden-hour.jpg\";s:4:\"name\";s:35:\"Brown stone near sea at golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:255;a:12:{s:2:\"id\";s:3:\"344\";s:6:\"handle\";s:18:\"Birds-eye-view.jpg\";s:4:\"name\";s:14:\"Birds eye view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1079\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:256;a:12:{s:2:\"id\";s:3:\"343\";s:6:\"handle\";s:18:\"Empty-seashore.jpg\";s:4:\"name\";s:14:\"Empty seashore\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1365\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:257;a:12:{s:2:\"id\";s:3:\"342\";s:6:\"handle\";s:31:\"Seashore-during-golden-hour.jpg\";s:4:\"name\";s:27:\"Seashore during golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1439\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:258;a:12:{s:2:\"id\";s:3:\"341\";s:6:\"handle\";s:16:\"Coconut-tree.jpg\";s:4:\"name\";s:12:\"Coconut tree\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:259;a:12:{s:2:\"id\";s:3:\"340\";s:6:\"handle\";s:37:\"Aerial-photography-of-beach-shore.jpg\";s:4:\"name\";s:33:\"Aerial photography of beach shore\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1439\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:260;a:12:{s:2:\"id\";s:3:\"197\";s:6:\"handle\";s:17:\"relax_hammock.jpg\";s:4:\"name\";s:13:\"Relax Hammock\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:261;a:12:{s:2:\"id\";s:3:\"196\";s:6:\"handle\";s:16:\"beach_houses.jpg\";s:4:\"name\";s:12:\"Beach Houses\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:262;a:12:{s:2:\"id\";s:3:\"195\";s:6:\"handle\";s:17:\"forest_road_2.jpg\";s:4:\"name\";s:13:\"Forest Road 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:263;a:12:{s:2:\"id\";s:3:\"194\";s:6:\"handle\";s:14:\"clean_desk.jpg\";s:4:\"name\";s:10:\"Clean Desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:264;a:12:{s:2:\"id\";s:3:\"193\";s:6:\"handle\";s:19:\"mountain_view_6.jpg\";s:4:\"name\";s:15:\"Mountain View 6\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1249\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:265;a:12:{s:2:\"id\";s:3:\"192\";s:6:\"handle\";s:14:\"corn_field.jpg\";s:4:\"name\";s:10:\"Corn Field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1320\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:266;a:12:{s:2:\"id\";s:3:\"191\";s:6:\"handle\";s:21:\"stylish_apartment.jpg\";s:4:\"name\";s:17:\"Stylish Apartment\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:267;a:12:{s:2:\"id\";s:3:\"190\";s:6:\"handle\";s:24:\"hipster_coffee_house.jpg\";s:4:\"name\";s:20:\"Hipster Coffee House\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:268;a:12:{s:2:\"id\";s:3:\"189\";s:6:\"handle\";s:16:\"blurry_beach.jpg\";s:4:\"name\";s:12:\"Blurry Beach\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:269;a:12:{s:2:\"id\";s:3:\"186\";s:6:\"handle\";s:17:\"greens_street.jpg\";s:4:\"name\";s:13:\"Greens Street\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:270;a:12:{s:2:\"id\";s:3:\"185\";s:6:\"handle\";s:10:\"desert.jpg\";s:4:\"name\";s:6:\"Desert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:271;a:12:{s:2:\"id\";s:3:\"184\";s:6:\"handle\";s:19:\"mountain_view_5.jpg\";s:4:\"name\";s:15:\"Mountain View 5\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:272;a:12:{s:2:\"id\";s:3:\"183\";s:6:\"handle\";s:10:\"laptop.jpg\";s:4:\"name\";s:6:\"Laptop\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1391\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:273;a:12:{s:2:\"id\";s:3:\"182\";s:6:\"handle\";s:16:\"grand_canyon.jpg\";s:4:\"name\";s:12:\"Grand Canyon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1287\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:274;a:12:{s:2:\"id\";s:3:\"181\";s:6:\"handle\";s:20:\"landscape_clouds.jpg\";s:4:\"name\";s:16:\"Landscape Clouds\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:275;a:12:{s:2:\"id\";s:3:\"180\";s:6:\"handle\";s:17:\"highway_night.jpg\";s:4:\"name\";s:13:\"Highway Night\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:276;a:12:{s:2:\"id\";s:3:\"179\";s:6:\"handle\";s:15:\"beach_water.jpg\";s:4:\"name\";s:11:\"Beach Water\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:277;a:12:{s:2:\"id\";s:3:\"177\";s:6:\"handle\";s:15:\"woman_beach.jpg\";s:4:\"name\";s:11:\"Woman Beach\";s:4:\"tags\";a:4:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:3;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:278;a:12:{s:2:\"id\";s:3:\"175\";s:6:\"handle\";s:12:\"cool_guy.jpg\";s:4:\"name\";s:8:\"Cool Guy\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:279;a:12:{s:2:\"id\";s:3:\"174\";s:6:\"handle\";s:13:\"beach_sea.jpg\";s:4:\"name\";s:9:\"Beach Sea\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:280;a:12:{s:2:\"id\";s:3:\"173\";s:6:\"handle\";s:17:\"bridge_clouds.jpg\";s:4:\"name\";s:13:\"Bridge Clouds\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:281;a:12:{s:2:\"id\";s:3:\"116\";s:6:\"handle\";s:19:\"mountain_view_2.jpg\";s:4:\"name\";s:15:\"Mountain View 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:282;a:12:{s:2:\"id\";s:3:\"115\";s:6:\"handle\";s:16:\"desert_trees.jpg\";s:4:\"name\";s:12:\"Desert Trees\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:283;a:12:{s:2:\"id\";s:3:\"114\";s:6:\"handle\";s:20:\"explore_moutains.jpg\";s:4:\"name\";s:17:\"Explore Mountains\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:284;a:12:{s:2:\"id\";s:3:\"113\";s:6:\"handle\";s:19:\"night_skyline_2.jpg\";s:4:\"name\";s:15:\"Night Skyline 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:285;a:12:{s:2:\"id\";s:3:\"112\";s:6:\"handle\";s:15:\"cliff_ocean.jpg\";s:4:\"name\";s:11:\"Cliff Ocean\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:286;a:12:{s:2:\"id\";s:3:\"111\";s:6:\"handle\";s:14:\"city_smoke.jpg\";s:4:\"name\";s:10:\"City Smoke\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:287;a:12:{s:2:\"id\";s:3:\"110\";s:6:\"handle\";s:16:\"surfer_beach.jpg\";s:4:\"name\";s:12:\"Surfer Beach\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:288;a:12:{s:2:\"id\";s:3:\"109\";s:6:\"handle\";s:13:\"sky_night.jpg\";s:4:\"name\";s:9:\"Sky Night\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:289;a:12:{s:2:\"id\";s:3:\"108\";s:6:\"handle\";s:15:\"palm_sunset.jpg\";s:4:\"name\";s:11:\"Palm Sunset\";s:4:\"tags\";a:4:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:3;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1372\";s:6:\"height\";s:4:\"1920\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:290;a:12:{s:2:\"id\";s:3:\"107\";s:6:\"handle\";s:18:\"concert_people.jpg\";s:4:\"name\";s:14:\"Concert People\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:291;a:12:{s:2:\"id\";s:3:\"106\";s:6:\"handle\";s:15:\"forest_road.jpg\";s:4:\"name\";s:11:\"Forest Road\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:292;a:12:{s:2:\"id\";s:3:\"105\";s:6:\"handle\";s:15:\"beach_ocean.jpg\";s:4:\"name\";s:11:\"Beach Ocean\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:293;a:12:{s:2:\"id\";s:3:\"104\";s:6:\"handle\";s:18:\"mountain_night.jpg\";s:4:\"name\";s:14:\"Mountain Night\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:294;a:12:{s:2:\"id\";s:3:\"103\";s:6:\"handle\";s:19:\"ocean_mountains.jpg\";s:4:\"name\";s:15:\"Ocean Mountains\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:295;a:12:{s:2:\"id\";s:3:\"102\";s:6:\"handle\";s:10:\"forest.jpg\";s:4:\"name\";s:6:\"Forest\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:296;a:12:{s:2:\"id\";s:3:\"101\";s:6:\"handle\";s:16:\"ocean_stones.jpg\";s:4:\"name\";s:12:\"Ocean Stones\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:297;a:12:{s:2:\"id\";s:3:\"100\";s:6:\"handle\";s:16:\"country_road.jpg\";s:4:\"name\";s:12:\"Country Road\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:298;a:12:{s:2:\"id\";s:2:\"99\";s:6:\"handle\";s:9:\"beach.jpg\";s:4:\"name\";s:5:\"Beach\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:299;a:12:{s:2:\"id\";s:2:\"98\";s:6:\"handle\";s:16:\"city_skyline.jpg\";s:4:\"name\";s:12:\"City Skyline\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:300;a:12:{s:2:\"id\";s:2:\"97\";s:6:\"handle\";s:17:\"night_skyline.jpg\";s:4:\"name\";s:13:\"Night Skyline\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:301;a:12:{s:2:\"id\";s:2:\"96\";s:6:\"handle\";s:14:\"city_river.jpg\";s:4:\"name\";s:10:\"City River\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:302;a:12:{s:2:\"id\";s:2:\"95\";s:6:\"handle\";s:19:\"mountain_view_3.jpg\";s:4:\"name\";s:15:\"Mountain View 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:303;a:12:{s:2:\"id\";s:2:\"94\";s:6:\"handle\";s:14:\"misty_farm.jpg\";s:4:\"name\";s:10:\"Misty Farm\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:304;a:12:{s:2:\"id\";s:2:\"93\";s:6:\"handle\";s:17:\"mountain_path.jpg\";s:4:\"name\";s:13:\"Mountain Path\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:305;a:12:{s:2:\"id\";s:2:\"92\";s:6:\"handle\";s:19:\"night_skyline_3.jpg\";s:4:\"name\";s:15:\"Night Skyline 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:306;a:12:{s:2:\"id\";s:2:\"91\";s:6:\"handle\";s:17:\"mountain_view.jpg\";s:4:\"name\";s:13:\"Mountain View\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1160\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:307;a:12:{s:2:\"id\";s:2:\"90\";s:6:\"handle\";s:19:\"rocky_landscape.jpg\";s:4:\"name\";s:15:\"Rocky Landscape\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:308;a:12:{s:2:\"id\";s:2:\"89\";s:6:\"handle\";s:19:\"mountain_view_4.jpg\";s:4:\"name\";s:15:\"Mountain View 4\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1203\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:309;a:13:{s:2:\"id\";s:3:\"529\";s:6:\"handle\";s:13:\"Fitness-4.jpg\";s:5:\"video\";s:13:\"Fitness-4.mp4\";s:4:\"name\";s:10:\"Fitness 4 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:310;a:13:{s:2:\"id\";s:3:\"528\";s:6:\"handle\";s:13:\"Fitness-3.jpg\";s:5:\"video\";s:13:\"Fitness-3.mp4\";s:4:\"name\";s:10:\"Fitness 3 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:311;a:13:{s:2:\"id\";s:3:\"527\";s:6:\"handle\";s:9:\"Chess.jpg\";s:5:\"video\";s:9:\"Chess.mp4\";s:4:\"name\";s:6:\"Chess \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:312;a:13:{s:2:\"id\";s:3:\"526\";s:6:\"handle\";s:13:\"Fitness-2.jpg\";s:5:\"video\";s:13:\"Fitness-2.mp4\";s:4:\"name\";s:10:\"Fitness 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:313;a:13:{s:2:\"id\";s:3:\"525\";s:6:\"handle\";s:11:\"Fitness.jpg\";s:5:\"video\";s:11:\"Fitness.mp4\";s:4:\"name\";s:8:\"Fitness \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:314;a:13:{s:2:\"id\";s:3:\"524\";s:6:\"handle\";s:9:\"Earth.jpg\";s:5:\"video\";s:9:\"Earth.mp4\";s:4:\"name\";s:6:\"Earth \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:315;a:13:{s:2:\"id\";s:3:\"523\";s:6:\"handle\";s:11:\"Space-2.jpg\";s:5:\"video\";s:11:\"Space-2.mp4\";s:4:\"name\";s:8:\"Space 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1440\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:316;a:13:{s:2:\"id\";s:3:\"522\";s:6:\"handle\";s:13:\"Asteroids.jpg\";s:5:\"video\";s:13:\"Asteroids.mp4\";s:4:\"name\";s:10:\"Asteroids \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:317;a:13:{s:2:\"id\";s:3:\"521\";s:6:\"handle\";s:9:\"Space.jpg\";s:5:\"video\";s:9:\"Space.mp4\";s:4:\"name\";s:6:\"Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:318;a:13:{s:2:\"id\";s:3:\"520\";s:6:\"handle\";s:10:\"People.jpg\";s:5:\"video\";s:10:\"People.mp4\";s:4:\"name\";s:7:\"People \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:319;a:13:{s:2:\"id\";s:3:\"519\";s:6:\"handle\";s:11:\"Walking.jpg\";s:5:\"video\";s:11:\"Walking.mp4\";s:4:\"name\";s:8:\"Walking \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:320;a:13:{s:2:\"id\";s:3:\"518\";s:6:\"handle\";s:19:\"Double-Exposure.jpg\";s:5:\"video\";s:19:\"Double-Exposure.mp4\";s:4:\"name\";s:16:\"Double Exposure \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:321;a:13:{s:2:\"id\";s:3:\"517\";s:6:\"handle\";s:8:\"Girl.jpg\";s:5:\"video\";s:8:\"Girl.mp4\";s:4:\"name\";s:5:\"Girl \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1088\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:322;a:13:{s:2:\"id\";s:3:\"516\";s:6:\"handle\";s:17:\"Bengal-Lights.jpg\";s:5:\"video\";s:17:\"Bengal-Lights.mp4\";s:4:\"name\";s:14:\"Bengal Lights \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:323;a:13:{s:2:\"id\";s:3:\"515\";s:6:\"handle\";s:13:\"Swiping-2.jpg\";s:5:\"video\";s:13:\"Swiping-2.mp4\";s:4:\"name\";s:10:\"Swiping 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:324;a:13:{s:2:\"id\";s:3:\"514\";s:6:\"handle\";s:11:\"Mock-Up.jpg\";s:5:\"video\";s:11:\"Mock-Up.mp4\";s:4:\"name\";s:8:\"Mock Up \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:325;a:13:{s:2:\"id\";s:3:\"513\";s:6:\"handle\";s:13:\"Countdown.jpg\";s:5:\"video\";s:13:\"Countdown.mp4\";s:4:\"name\";s:10:\"Countdown \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:326;a:13:{s:2:\"id\";s:3:\"512\";s:6:\"handle\";s:18:\"Wall-Sketching.jpg\";s:5:\"video\";s:18:\"Wall-Sketching.mp4\";s:4:\"name\";s:15:\"Wall Sketching \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:327;a:13:{s:2:\"id\";s:3:\"511\";s:6:\"handle\";s:26:\"Typing-on-the-keyboard.jpg\";s:5:\"video\";s:26:\"Typing-on-the-keyboard.mp4\";s:4:\"name\";s:23:\"Typing on the keyboard \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:328;a:13:{s:2:\"id\";s:3:\"510\";s:6:\"handle\";s:11:\"Meeting.jpg\";s:5:\"video\";s:11:\"Meeting.mp4\";s:4:\"name\";s:8:\"Meeting \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:329;a:13:{s:2:\"id\";s:3:\"509\";s:6:\"handle\";s:11:\"Swiping.jpg\";s:5:\"video\";s:11:\"Swiping.mp4\";s:4:\"name\";s:8:\"Swiping \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:330;a:13:{s:2:\"id\";s:3:\"508\";s:6:\"handle\";s:9:\"Alarm.jpg\";s:5:\"video\";s:9:\"Alarm.mp4\";s:4:\"name\";s:6:\"Alarm \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1013\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:331;a:13:{s:2:\"id\";s:3:\"507\";s:6:\"handle\";s:13:\"Hey-World.jpg\";s:5:\"video\";s:13:\"Hey-World.mp4\";s:4:\"name\";s:10:\"Hey World \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:332;a:13:{s:2:\"id\";s:3:\"506\";s:6:\"handle\";s:28:\"Typing-on-the-keyboard-2.jpg\";s:5:\"video\";s:28:\"Typing-on-the-keyboard-2.mp4\";s:4:\"name\";s:25:\"Typing on the keyboard 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:333;a:13:{s:2:\"id\";s:3:\"505\";s:6:\"handle\";s:10:\"Valley.jpg\";s:5:\"video\";s:10:\"Valley.mp4\";s:4:\"name\";s:7:\"Valley \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:334;a:13:{s:2:\"id\";s:3:\"504\";s:6:\"handle\";s:9:\"Stars.jpg\";s:5:\"video\";s:9:\"Stars.mp4\";s:4:\"name\";s:6:\"Stars \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:335;a:13:{s:2:\"id\";s:3:\"503\";s:6:\"handle\";s:21:\"Car-in-the-forest.jpg\";s:5:\"video\";s:21:\"Car-in-the-forest.mp4\";s:4:\"name\";s:18:\"Car in the forest \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1012\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:336;a:13:{s:2:\"id\";s:3:\"502\";s:6:\"handle\";s:15:\"Aerial-Shot.jpg\";s:5:\"video\";s:15:\"Aerial-Shot.mp4\";s:4:\"name\";s:12:\"Aerial Shot \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:337;a:13:{s:2:\"id\";s:3:\"501\";s:6:\"handle\";s:14:\"Disco-Ball.jpg\";s:5:\"video\";s:14:\"Disco-Ball.mp4\";s:4:\"name\";s:11:\"Disco Ball \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:338;a:13:{s:2:\"id\";s:3:\"500\";s:6:\"handle\";s:22:\"Man-Playing-Guitar.jpg\";s:5:\"video\";s:22:\"Man-Playing-Guitar.mp4\";s:4:\"name\";s:19:\"Man Playing Guitar \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:339;a:13:{s:2:\"id\";s:3:\"499\";s:6:\"handle\";s:14:\"Live-Music.jpg\";s:5:\"video\";s:14:\"Live-Music.mp4\";s:4:\"name\";s:11:\"Live Music \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:340;a:13:{s:2:\"id\";s:3:\"498\";s:6:\"handle\";s:12:\"Cheer-Up.jpg\";s:5:\"video\";s:12:\"Cheer-Up.mp4\";s:4:\"name\";s:9:\"Cheer Up \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:341;a:13:{s:2:\"id\";s:3:\"497\";s:6:\"handle\";s:14:\"Night-club.jpg\";s:5:\"video\";s:14:\"Night-club.mp4\";s:4:\"name\";s:11:\"Night club \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:342;a:13:{s:2:\"id\";s:3:\"496\";s:6:\"handle\";s:17:\"Cup-Of-Coffee.jpg\";s:5:\"video\";s:17:\"Cup-Of-Coffee.mp4\";s:4:\"name\";s:14:\"Cup Of Coffee \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:343;a:13:{s:2:\"id\";s:3:\"495\";s:6:\"handle\";s:7:\"Pot.jpg\";s:5:\"video\";s:7:\"Pot.mp4\";s:4:\"name\";s:4:\"Pot \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:344;a:13:{s:2:\"id\";s:3:\"494\";s:6:\"handle\";s:11:\"Grill-2.jpg\";s:5:\"video\";s:11:\"Grill-2.mp4\";s:4:\"name\";s:8:\"Grill 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:345;a:13:{s:2:\"id\";s:3:\"493\";s:6:\"handle\";s:13:\"Rice-Bowl.jpg\";s:5:\"video\";s:13:\"Rice-Bowl.mp4\";s:4:\"name\";s:10:\"Rice Bowl \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1010\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:346;a:13:{s:2:\"id\";s:3:\"492\";s:6:\"handle\";s:9:\"Grill.jpg\";s:5:\"video\";s:9:\"Grill.mp4\";s:4:\"name\";s:6:\"Grill \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:347;a:13:{s:2:\"id\";s:3:\"491\";s:6:\"handle\";s:9:\"Water.jpg\";s:5:\"video\";s:9:\"Water.mp4\";s:4:\"name\";s:6:\"Water \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:348;a:13:{s:2:\"id\";s:3:\"490\";s:6:\"handle\";s:17:\"Feet-and-Sand.jpg\";s:5:\"video\";s:17:\"Feet-and-Sand.mp4\";s:4:\"name\";s:14:\"Feet and Sand \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:349;a:13:{s:2:\"id\";s:3:\"489\";s:6:\"handle\";s:9:\"Ocean.jpg\";s:5:\"video\";s:9:\"Ocean.mp4\";s:4:\"name\";s:6:\"Ocean \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:350;a:13:{s:2:\"id\";s:3:\"488\";s:6:\"handle\";s:9:\"Waves.jpg\";s:5:\"video\";s:9:\"Waves.mp4\";s:4:\"name\";s:6:\"Waves \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:351;a:13:{s:2:\"id\";s:3:\"487\";s:6:\"handle\";s:10:\"Hearts.jpg\";s:5:\"video\";s:10:\"Hearts.mp4\";s:4:\"name\";s:7:\"Hearts \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:352;a:13:{s:2:\"id\";s:3:\"486\";s:6:\"handle\";s:12:\"Octagons.jpg\";s:5:\"video\";s:12:\"Octagons.mp4\";s:4:\"name\";s:9:\"Octagons \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:353;a:13:{s:2:\"id\";s:3:\"485\";s:6:\"handle\";s:11:\"Squares.jpg\";s:5:\"video\";s:11:\"Squares.mp4\";s:4:\"name\";s:8:\"Squares \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:354;a:13:{s:2:\"id\";s:3:\"484\";s:6:\"handle\";s:12:\"Pink-ink.jpg\";s:5:\"video\";s:12:\"Pink-ink.mp4\";s:4:\"name\";s:9:\"Pink ink \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:355;a:13:{s:2:\"id\";s:3:\"483\";s:6:\"handle\";s:22:\"Blurred-Background.jpg\";s:5:\"video\";s:22:\"Blurred-Background.mp4\";s:4:\"name\";s:19:\"Blurred Background \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:356;a:13:{s:2:\"id\";s:3:\"482\";s:6:\"handle\";s:20:\"Blinking-bubbles.jpg\";s:5:\"video\";s:20:\"Blinking-bubbles.mp4\";s:4:\"name\";s:17:\"Blinking bubbles \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:357;a:13:{s:2:\"id\";s:3:\"481\";s:6:\"handle\";s:13:\"Fireworks.jpg\";s:5:\"video\";s:13:\"Fireworks.mp4\";s:4:\"name\";s:10:\"Fireworks \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:358;a:13:{s:2:\"id\";s:3:\"480\";s:6:\"handle\";s:12:\"Dark-ink.jpg\";s:5:\"video\";s:12:\"Dark-ink.mp4\";s:4:\"name\";s:9:\"Dark ink \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:359;a:13:{s:2:\"id\";s:3:\"238\";s:6:\"handle\";s:12:\"Mt_Baker.jpg\";s:5:\"video\";s:12:\"Mt_Baker.mp4\";s:4:\"name\";s:9:\"Mt Baker \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:360;a:13:{s:2:\"id\";s:3:\"237\";s:6:\"handle\";s:16:\"Two-Swimmers.jpg\";s:5:\"video\";s:16:\"Two-Swimmers.mp4\";s:4:\"name\";s:13:\"Two Swimmers \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:361;a:13:{s:2:\"id\";s:3:\"236\";s:6:\"handle\";s:14:\"Boats_Maze.jpg\";s:5:\"video\";s:14:\"Boats_Maze.mp4\";s:4:\"name\";s:11:\"Boats Maze \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:362;a:13:{s:2:\"id\";s:3:\"235\";s:6:\"handle\";s:18:\"Candolim-Beach.jpg\";s:5:\"video\";s:18:\"Candolim-Beach.mp4\";s:4:\"name\";s:15:\"Candolim Beach \";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:363;a:13:{s:2:\"id\";s:3:\"234\";s:6:\"handle\";s:17:\"Working-Space.jpg\";s:5:\"video\";s:17:\"Working-Space.mp4\";s:4:\"name\";s:14:\"Working Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:364;a:13:{s:2:\"id\";s:3:\"233\";s:6:\"handle\";s:9:\"Wavez.jpg\";s:5:\"video\";s:9:\"Wavez.mp4\";s:4:\"name\";s:6:\"Wavez \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:365;a:13:{s:2:\"id\";s:3:\"232\";s:6:\"handle\";s:17:\"Coconut-Grove.jpg\";s:5:\"video\";s:17:\"Coconut-Grove.mp4\";s:4:\"name\";s:14:\"Coconut Grove \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:366;a:13:{s:2:\"id\";s:3:\"231\";s:6:\"handle\";s:19:\"Very-Open-Space.jpg\";s:5:\"video\";s:19:\"Very-Open-Space.mp4\";s:4:\"name\";s:16:\"Very Open Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:367;a:13:{s:2:\"id\";s:3:\"230\";s:6:\"handle\";s:14:\"Office-Day.jpg\";s:5:\"video\";s:14:\"Office-Day.mp4\";s:4:\"name\";s:11:\"Office Day \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:368;a:13:{s:2:\"id\";s:3:\"229\";s:6:\"handle\";s:12:\"The-Hill.jpg\";s:5:\"video\";s:12:\"The-Hill.mp4\";s:4:\"name\";s:9:\"The Hill \";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:369;a:13:{s:2:\"id\";s:3:\"339\";s:6:\"handle\";s:19:\"best_price_dark.jpg\";s:5:\"video\";s:19:\"best_price_dark.mp4\";s:4:\"name\";s:15:\"best_price_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"best_price_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:370;a:13:{s:2:\"id\";s:3:\"337\";s:6:\"handle\";s:27:\"limited_time_offer_dark.jpg\";s:5:\"video\";s:27:\"limited_time_offer_dark.mp4\";s:4:\"name\";s:23:\"limited_time_offer_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:23:\"limited_time_offer_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:371;a:13:{s:2:\"id\";s:3:\"336\";s:6:\"handle\";s:26:\"slider_revolution_dark.jpg\";s:5:\"video\";s:26:\"slider_revolution_dark.mp4\";s:4:\"name\";s:22:\"slider_revolution_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:22:\"slider_revolution_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:372;a:13:{s:2:\"id\";s:3:\"335\";s:6:\"handle\";s:19:\"mick_brown_dark.jpg\";s:5:\"video\";s:19:\"mick_brown_dark.mp4\";s:4:\"name\";s:15:\"mick_brown_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"mick_brown_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:373;a:13:{s:2:\"id\";s:3:\"334\";s:6:\"handle\";s:14:\"sales_dark.jpg\";s:5:\"video\";s:14:\"sales_dark.mp4\";s:4:\"name\";s:10:\"sales_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:10:\"sales_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:374;a:13:{s:2:\"id\";s:3:\"333\";s:6:\"handle\";s:21:\"robert_smith_dark.jpg\";s:5:\"video\";s:21:\"robert_smith_dark.mp4\";s:4:\"name\";s:17:\"robert_smith_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"robert_smith_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:375;a:13:{s:2:\"id\";s:3:\"332\";s:6:\"handle\";s:21:\"product_name_dark.jpg\";s:5:\"video\";s:21:\"product_name_dark.mp4\";s:4:\"name\";s:17:\"product_name_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"product_name_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:376;a:13:{s:2:\"id\";s:3:\"331\";s:6:\"handle\";s:21:\"high_quality_dark.jpg\";s:5:\"video\";s:21:\"high_quality_dark.mp4\";s:4:\"name\";s:17:\"high_quality_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"high_quality_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:377;a:13:{s:2:\"id\";s:3:\"330\";s:6:\"handle\";s:24:\"robert_johnson_light.jpg\";s:5:\"video\";s:24:\"robert_johnson_light.mp4\";s:4:\"name\";s:20:\"robert_johnson_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:20:\"robert_johnson_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:378;a:13:{s:2:\"id\";s:3:\"329\";s:6:\"handle\";s:21:\"jake_collins_dark.jpg\";s:5:\"video\";s:21:\"jake_collins_dark.mp4\";s:4:\"name\";s:17:\"jake_collins_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"jake_collins_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:379;a:13:{s:2:\"id\";s:3:\"328\";s:6:\"handle\";s:22:\"daniele_wood_light.jpg\";s:5:\"video\";s:22:\"daniele_wood_light.mp4\";s:4:\"name\";s:18:\"daniele_wood_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"daniele_wood_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:31:30\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:380;a:13:{s:2:\"id\";s:3:\"327\";s:6:\"handle\";s:23:\"michael_blake_light.jpg\";s:5:\"video\";s:23:\"michael_blake_light.mp4\";s:4:\"name\";s:19:\"michael_blake_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:19:\"michael_blake_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:381;a:13:{s:2:\"id\";s:3:\"326\";s:6:\"handle\";s:22:\"product_name_light.jpg\";s:5:\"video\";s:22:\"product_name_light.mp4\";s:4:\"name\";s:18:\"product_name_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"product_name_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:382;a:13:{s:2:\"id\";s:3:\"325\";s:6:\"handle\";s:24:\"rebecca_cooper_light.jpg\";s:5:\"video\";s:24:\"rebecca_cooper_light.mp4\";s:4:\"name\";s:20:\"rebecca_cooper_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:20:\"rebecca_cooper_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:383;a:13:{s:2:\"id\";s:3:\"324\";s:6:\"handle\";s:28:\"limited_time_offer_light.jpg\";s:5:\"video\";s:28:\"limited_time_offer_light.mp4\";s:4:\"name\";s:24:\"limited_time_offer_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:24:\"limited_time_offer_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:384;a:13:{s:2:\"id\";s:3:\"322\";s:6:\"handle\";s:22:\"jake_michael_light.jpg\";s:5:\"video\";s:22:\"jake_michael_light.mp4\";s:4:\"name\";s:18:\"jake_michael_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"jake_michael_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:385;a:13:{s:2:\"id\";s:3:\"321\";s:6:\"handle\";s:23:\"colin_johnson_light.jpg\";s:5:\"video\";s:23:\"colin_johnson_light.mp4\";s:4:\"name\";s:19:\"colin_johnson_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:19:\"colin_johnson_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:386;a:13:{s:2:\"id\";s:3:\"320\";s:6:\"handle\";s:21:\"colin_morris_dark.jpg\";s:5:\"video\";s:21:\"colin_morris_dark.mp4\";s:4:\"name\";s:17:\"colin_morris_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"colin_morris_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:387;a:13:{s:2:\"id\";s:3:\"319\";s:6:\"handle\";s:22:\"justin_cooper_dark.jpg\";s:5:\"video\";s:22:\"justin_cooper_dark.mp4\";s:4:\"name\";s:18:\"justin_cooper_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:18:\"justin_cooper_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:388;a:13:{s:2:\"id\";s:3:\"318\";s:6:\"handle\";s:21:\"james-dodson_dark.jpg\";s:5:\"video\";s:21:\"james-dodson_dark.mp4\";s:4:\"name\";s:17:\"james-dodson_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"james-dodson_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:389;a:13:{s:2:\"id\";s:3:\"317\";s:6:\"handle\";s:23:\"robert_sanders_dark.jpg\";s:5:\"video\";s:23:\"robert_sanders_dark.mp4\";s:4:\"name\";s:19:\"robert_sanders_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:19:\"robert_sanders_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:390;a:13:{s:2:\"id\";s:3:\"316\";s:6:\"handle\";s:21:\"emily_carney_dark.jpg\";s:5:\"video\";s:21:\"emily_carney_dark.mp4\";s:4:\"name\";s:17:\"emily_carney_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"emily_carney_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:391;a:13:{s:2:\"id\";s:3:\"315\";s:6:\"handle\";s:22:\"michael-smith_dark.jpg\";s:5:\"video\";s:22:\"michael-smith_dark.mp4\";s:4:\"name\";s:18:\"michael-smith_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:18:\"michael-smith_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:392;a:13:{s:2:\"id\";s:3:\"314\";s:6:\"handle\";s:23:\"sandra_johnson_dark.jpg\";s:5:\"video\";s:23:\"sandra_johnson_dark.mp4\";s:4:\"name\";s:19:\"sandra_johnson_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:19:\"sandra_johnson_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:393;a:13:{s:2:\"id\";s:3:\"313\";s:6:\"handle\";s:22:\"robert_bolton_dark.jpg\";s:5:\"video\";s:22:\"robert_bolton_dark.mp4\";s:4:\"name\";s:18:\"robert_bolton_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:18:\"robert_bolton_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:394;a:13:{s:2:\"id\";s:3:\"312\";s:6:\"handle\";s:25:\"elegant_captions_dark.png\";s:5:\"video\";s:25:\"elegant_captions_dark.mp4\";s:4:\"name\";s:21:\"elegant_captions_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:21:\"elegant_captions_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-18 14:41:45\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:395;a:13:{s:2:\"id\";s:3:\"311\";s:6:\"handle\";s:19:\"Caption_Dark_06.png\";s:5:\"video\";s:19:\"Caption_Dark_06.mp4\";s:4:\"name\";s:15:\"Caption_Dark_06\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_06\";s:5:\"width\";s:3:\"414\";s:6:\"height\";s:3:\"225\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:396;a:13:{s:2:\"id\";s:3:\"310\";s:6:\"handle\";s:19:\"Header_Light_02.png\";s:5:\"video\";s:19:\"Header_Light_02.mp4\";s:4:\"name\";s:15:\"Header_Light_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:15:\"Header_Light_02\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:397;a:13:{s:2:\"id\";s:3:\"309\";s:6:\"handle\";s:21:\"Columns_4_Dark_01.png\";s:5:\"video\";s:21:\"Columns_4_Dark_01.mp4\";s:4:\"name\";s:17:\"Columns_4_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"Columns_4_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:398;a:13:{s:2:\"id\";s:3:\"308\";s:6:\"handle\";s:18:\"Header_Dark_01.png\";s:5:\"video\";s:18:\"Header_Dark_01.mp4\";s:4:\"name\";s:14:\"Header_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:14:\"Header_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:399;a:13:{s:2:\"id\";s:3:\"307\";s:6:\"handle\";s:19:\"Caption_Dark_03.png\";s:5:\"video\";s:19:\"Caption_Dark_03.mp4\";s:4:\"name\";s:15:\"Caption_Dark_03\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_03\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:400;a:13:{s:2:\"id\";s:3:\"306\";s:6:\"handle\";s:21:\"Columns_3_Dark_01.png\";s:5:\"video\";s:21:\"Columns_3_Dark_01.mp4\";s:4:\"name\";s:17:\"Columns_3_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"Columns_3_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:401;a:13:{s:2:\"id\";s:3:\"305\";s:6:\"handle\";s:19:\"Caption_Dark_05.png\";s:5:\"video\";s:19:\"Caption_Dark_05.mp4\";s:4:\"name\";s:15:\"Caption_Dark_05\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_05\";s:5:\"width\";s:4:\"1104\";s:6:\"height\";s:3:\"600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:402;a:13:{s:2:\"id\";s:3:\"304\";s:6:\"handle\";s:20:\"Caption_Light_06.png\";s:5:\"video\";s:20:\"Caption_Light_06.mp4\";s:4:\"name\";s:16:\"Caption_Light_06\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_06\";s:5:\"width\";s:3:\"828\";s:6:\"height\";s:3:\"450\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:403;a:13:{s:2:\"id\";s:3:\"303\";s:6:\"handle\";s:19:\"Header_Light_01.png\";s:5:\"video\";s:19:\"Header_Light_01.mp4\";s:4:\"name\";s:15:\"Header_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:15:\"Header_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:404;a:13:{s:2:\"id\";s:3:\"302\";s:6:\"handle\";s:20:\"Caption_Light_03.png\";s:5:\"video\";s:20:\"Caption_Light_03.mp4\";s:4:\"name\";s:16:\"Caption_Light_03\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_03\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:405;a:13:{s:2:\"id\";s:3:\"301\";s:6:\"handle\";s:19:\"Caption_Dark_01.png\";s:5:\"video\";s:19:\"Caption_Dark_01.mp4\";s:4:\"name\";s:15:\"Caption_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:406;a:13:{s:2:\"id\";s:3:\"300\";s:6:\"handle\";s:21:\"PromoCode_Dark_01.png\";s:5:\"video\";s:21:\"PromoCode_Dark_01.mp4\";s:4:\"name\";s:17:\"PromoCode_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"PromoCode_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:407;a:13:{s:2:\"id\";s:3:\"299\";s:6:\"handle\";s:19:\"Caption_Dark_02.png\";s:5:\"video\";s:19:\"Caption_Dark_02.mp4\";s:4:\"name\";s:15:\"Caption_Dark_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_02\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:408;a:13:{s:2:\"id\";s:3:\"298\";s:6:\"handle\";s:18:\"Header_Dark_02.png\";s:5:\"video\";s:18:\"Header_Dark_02.mp4\";s:4:\"name\";s:14:\"Header_Dark_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:14:\"Header_Dark_02\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:409;a:13:{s:2:\"id\";s:3:\"297\";s:6:\"handle\";s:22:\"Columns_3_Light_01.png\";s:5:\"video\";s:22:\"Columns_3_Light_01.mp4\";s:4:\"name\";s:18:\"Columns_3_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"Columns_3_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:410;a:13:{s:2:\"id\";s:3:\"296\";s:6:\"handle\";s:20:\"Caption_Light_01.png\";s:5:\"video\";s:20:\"Caption_Light_01.mp4\";s:4:\"name\";s:16:\"Caption_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:411;a:13:{s:2:\"id\";s:3:\"295\";s:6:\"handle\";s:19:\"Caption_Dark_04.png\";s:5:\"video\";s:19:\"Caption_Dark_04.mp4\";s:4:\"name\";s:15:\"Caption_Dark_04\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_04\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:412;a:13:{s:2:\"id\";s:3:\"294\";s:6:\"handle\";s:20:\"Caption_Light_02.png\";s:5:\"video\";s:20:\"Caption_Light_02.mp4\";s:4:\"name\";s:16:\"Caption_Light_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_02\";s:5:\"width\";s:3:\"828\";s:6:\"height\";s:3:\"450\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:413;a:13:{s:2:\"id\";s:3:\"293\";s:6:\"handle\";s:20:\"Caption_Light_04.png\";s:5:\"video\";s:20:\"Caption_Light_04.mp4\";s:4:\"name\";s:16:\"Caption_Light_04\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_04\";s:5:\"width\";s:4:\"1104\";s:6:\"height\";s:3:\"600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:414;a:13:{s:2:\"id\";s:3:\"292\";s:6:\"handle\";s:22:\"Columns_4_Light_01.png\";s:5:\"video\";s:22:\"Columns_4_Light_01.mp4\";s:4:\"name\";s:18:\"Columns_4_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"Columns_4_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:415;a:13:{s:2:\"id\";s:3:\"291\";s:6:\"handle\";s:20:\"Caption_Light_05.png\";s:5:\"video\";s:20:\"Caption_Light_05.mp4\";s:4:\"name\";s:16:\"Caption_Light_05\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_05\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:416;a:13:{s:2:\"id\";s:3:\"290\";s:6:\"handle\";s:22:\"PromoCode_Light_01.png\";s:5:\"video\";s:22:\"PromoCode_Light_01.mp4\";s:4:\"name\";s:18:\"PromoCode_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"PromoCode_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}}s:4:\"tags\";a:18:{i:28;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}i:5;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:20;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:21;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:25;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:16;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}i:26;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}i:18;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:4;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:19;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:23;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:3;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:24;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:22;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:29;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}i:27;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}}", "no");
INSERT INTO `wp_options` VALUES("363", "revslider-templates-check", "1698768217", "yes");
INSERT INTO `wp_options` VALUES("364", "revslider-templates-hash", "b6897ad1ea846c0481d544eb1b0f97e9", "yes");
INSERT INTO `wp_options` VALUES("365", "rs-templates-new", "", "no");
INSERT INTO `wp_options` VALUES("366", "rs-templates", "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", "no");
INSERT INTO `wp_options` VALUES("367", "rs-templates-counter", "0", "no");
INSERT INTO `wp_options` VALUES("368", "revslider_table_version", "1.0.12", "yes");
INSERT INTO `wp_options` VALUES("371", "revslider_update_version", "6.6.0", "yes");
INSERT INTO `wp_options` VALUES("372", "elementor_version", "3.17.2", "yes");
INSERT INTO `wp_options` VALUES("373", "elementor_install_history", "a:13:{s:5:\"3.2.2\";i:1652603598;s:5:\"3.2.3\";i:1627204022;s:5:\"3.3.1\";i:1627204060;s:5:\"3.5.3\";i:1642499633;s:5:\"3.5.5\";i:1644828089;s:5:\"3.6.5\";i:1661002445;s:5:\"3.7.0\";i:1661002444;s:5:\"3.7.1\";i:1661002458;s:5:\"3.8.0\";i:1667382830;s:5:\"3.9.2\";i:1671893511;s:6:\"3.10.1\";i:1674497883;s:6:\"3.12.1\";i:1681985297;s:6:\"3.17.2\";i:1699006269;}", "yes");
INSERT INTO `wp_options` VALUES("374", "elementor_pro_version", "3.7.3", "yes");
INSERT INTO `wp_options` VALUES("375", "widget_rev-slider-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("376", "widget_nav_mega_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("377", "widget_woodmart-banner", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("378", "widget_woodmart-author-information", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("379", "widget_woodmart-instagram", "a:3:{i:10;a:5:{s:5:\"title\";s:13:\"Our Instagram\";s:8:\"username\";s:17:\"ozdesignfurniture\";s:6:\"number\";s:1:\"9\";s:4:\"size\";s:9:\"thumbnail\";s:6:\"target\";s:6:\"_blank\";}i:8;a:28:{s:5:\"title\";s:25:\"اینستاگرام ما\";s:8:\"username\";s:17:\"ozdesignfurniture\";s:6:\"number\";s:1:\"9\";s:4:\"size\";s:9:\"thumbnail\";s:6:\"target\";s:6:\"_blank\";s:12:\"data_divider\";s:0:\"\";s:11:\"data_source\";s:6:\"scrape\";s:14:\"images_divider\";s:0:\"\";s:6:\"images\";s:0:\"\";s:11:\"images_size\";s:0:\"\";s:11:\"images_link\";s:0:\"\";s:12:\"images_likes\";s:10:\"1000-10000\";s:15:\"images_comments\";s:6:\"0-1000\";s:15:\"content_divider\";s:0:\"\";s:7:\"content\";s:0:\"\";s:12:\"link_divider\";s:0:\"\";s:4:\"link\";s:0:\"\";s:14:\"layout_divider\";s:0:\"\";s:6:\"design\";s:0:\"\";s:7:\"per_row\";s:0:\"\";s:7:\"spacing\";s:0:\"\";s:14:\"spacing_custom\";s:0:\"\";s:7:\"rounded\";s:0:\"\";s:9:\"hide_mask\";s:0:\"\";s:23:\"hide_pagination_control\";s:0:\"\";s:22:\"hide_prev_next_buttons\";s:0:\"\";s:13:\"extra_divider\";s:0:\"\";s:8:\"el_class\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("380", "widget_woodmart-html-block", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("381", "widget_woodmart-recent-posts", "a:7:{i:6;a:11:{s:5:\"title\";s:21:\"مقالات اخیر\";s:5:\"limit\";i:3;s:12:\"thumb_height\";i:60;s:11:\"thumb_width\";i:75;s:6:\"offset\";i:0;s:5:\"order\";s:4:\"DESC\";s:7:\"orderby\";s:4:\"date\";s:8:\"category\";s:3:\"all\";s:4:\"date\";b:1;s:13:\"comment_count\";b:1;s:5:\"thumb\";b:1;}i:7;a:11:{s:5:\"title\";s:21:\"مقالات اخیر\";s:5:\"limit\";i:3;s:12:\"thumb_height\";i:60;s:11:\"thumb_width\";i:75;s:6:\"offset\";i:0;s:5:\"order\";s:4:\"DESC\";s:7:\"orderby\";s:4:\"date\";s:8:\"category\";s:3:\"all\";s:4:\"date\";b:1;s:13:\"comment_count\";b:1;s:5:\"thumb\";b:1;}i:9;a:4:{s:5:\"title\";s:12:\"Recent Posts\";s:5:\"limit\";i:3;s:12:\"thumb_height\";i:60;s:11:\"thumb_width\";i:75;}i:12;a:4:{s:5:\"title\";s:12:\"Recent Posts\";s:5:\"limit\";i:2;s:12:\"thumb_height\";i:60;s:11:\"thumb_width\";i:75;}i:5;a:4:{s:5:\"title\";s:12:\"Recent Posts\";s:5:\"limit\";i:3;s:12:\"thumb_height\";i:60;s:11:\"thumb_width\";i:75;}i:10;a:11:{s:5:\"title\";s:23:\"آخرین مقالات\";s:5:\"limit\";i:2;s:12:\"thumb_height\";i:60;s:11:\"thumb_width\";i:75;s:6:\"offset\";i:0;s:5:\"order\";s:4:\"DESC\";s:7:\"orderby\";s:4:\"date\";s:8:\"category\";s:3:\"all\";s:4:\"date\";b:1;s:13:\"comment_count\";b:1;s:5:\"thumb\";b:1;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("382", "widget_woodmart-twitter", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("383", "widget_woodmart-user-panel", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("384", "widget_woodmart-woocommerce-layered-nav", "a:2:{s:12:\"_multiwidget\";i:1;i:3;a:6:{s:5:\"title\";s:15:\"Filter by color\";s:9:\"attribute\";s:5:\"color\";s:10:\"query_type\";s:3:\"and\";s:7:\"display\";s:4:\"list\";s:4:\"size\";s:6:\"normal\";s:6:\"labels\";s:2:\"on\";}}", "yes");
INSERT INTO `wp_options` VALUES("385", "widget_woodmart-woocommerce-sort-by", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("386", "widget_woodmart-price-filter", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("387", "widget_woodmart-ajax-search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("388", "widget_wd-widget-stock-status", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("389", "widget_elementor-library", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("390", "_elementor_pro_installed_time", "1627204022", "yes");
INSERT INTO `wp_options` VALUES("391", "elementor_submissions_db_version", "5", "yes");
INSERT INTO `wp_options` VALUES("392", "_elementor_installed_time", "1627204022", "yes");
INSERT INTO `wp_options` VALUES("393", "elementor_remote_info_library", "a:3:{s:10:\"types_data\";a:4:{s:5:\"block\";a:2:{s:10:\"categories\";a:27:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:3:\"faq\";i:9;s:8:\"features\";i:10;s:6:\"footer\";i:11;s:7:\"Gallery\";i:12;s:6:\"header\";i:13;s:4:\"hero\";i:14;s:9:\"portfolio\";i:15;s:7:\"pricing\";i:16;s:15:\"product archive\";i:17;s:5:\"Quote\";i:18;s:15:\"Service Details\";i:19;s:8:\"services\";i:20;s:11:\"single page\";i:21;s:11:\"single post\";i:22;s:14:\"single product\";i:23;s:5:\"stats\";i:24;s:9:\"subscribe\";i:25;s:4:\"team\";i:26;s:12:\"testimonials\";}s:4:\"sets\";a:5:{i:0;s:11:\"Boxing Club\";i:1;s:19:\"Business Consultant\";i:2;s:16:\"Marketing Agency\";i:3;s:9:\"Wireframe\";i:4;s:15:\"Workshop Center\";}}s:5:\"popup\";a:1:{s:10:\"categories\";a:6:{i:0;s:10:\"bottom bar\";i:1;s:7:\"classic\";i:2;s:6:\"fly-in\";i:3;s:11:\"full screen\";i:4;s:9:\"hello bar\";i:5;s:8:\"slide-in\";}}s:2:\"lp\";a:1:{s:10:\"categories\";a:15:{i:0;s:8:\"Business\";i:1;s:16:\"Coming Soon Page\";i:2;s:9:\"eCommerce\";i:3;s:9:\"Education\";i:4;s:6:\"Events\";i:5;s:18:\"Health and Fitness\";i:6;s:3:\"NFT\";i:7;s:14:\"Online Service\";i:8;s:7:\"Product\";i:9;s:11:\"Real Estate\";i:10;s:18:\"Social Involvement\";i:11;s:14:\"Thank You Page\";i:12;s:6:\"Travel\";i:13;s:18:\"Under Construction\";i:14;s:9:\"Wireframe\";}}s:2:\"lb\";a:1:{s:10:\"categories\";a:2:{i:0;s:4:\"post\";i:1;s:7:\"product\";}}}s:10:\"categories\";a:27:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:3:\"faq\";i:9;s:8:\"features\";i:10;s:6:\"footer\";i:11;s:7:\"Gallery\";i:12;s:6:\"header\";i:13;s:4:\"hero\";i:14;s:9:\"portfolio\";i:15;s:7:\"pricing\";i:16;s:15:\"product archive\";i:17;s:5:\"Quote\";i:18;s:15:\"Service Details\";i:19;s:8:\"services\";i:20;s:11:\"single page\";i:21;s:11:\"single post\";i:22;s:14:\"single product\";i:23;s:5:\"stats\";i:24;s:9:\"subscribe\";i:25;s:4:\"team\";i:26;s:12:\"testimonials\";}s:9:\"templates\";a:823:{i:0;a:18:{s:4:\"tmpl\";i:1280;s:2:\"id\";i:22403;s:5:\"title\";s:40:\"Hello Bar | Subscribe | Aesthetic Clinic\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/aesthetic-clinic-19.jpg\";s:12:\"tmpl_created\";i:1647354307;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/hello-bar-subscribe-aesthetic-clinic/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:48:\"[\"Barbershop\",\"Business\",\"Discount\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:1;a:18:{s:4:\"tmpl\";i:1281;s:2:\"id\";i:22410;s:5:\"title\";s:32:\"Fly-In | Discount | Hair Stylist\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/hair-stylist-20.jpg\";s:12:\"tmpl_created\";i:1647354614;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-discount-hair-stylist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:32:\"[\"Barbershop\",\"Discount\",\"Hair\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:2;a:18:{s:4:\"tmpl\";i:1285;s:2:\"id\";i:22440;s:5:\"title\";s:32:\"Classic | Subscribe | Shoe Store\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/shoes-store-21.jpg\";s:12:\"tmpl_created\";i:1647418620;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-subscribe-shoe-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:37:\"[\"Ecommerce\",\"Marketing\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:3;a:18:{s:4:\"tmpl\";i:1286;s:2:\"id\";i:22446;s:5:\"title\";s:37:\"Full Screen | Subscribe | Denim Store\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/denim-store-22.jpg\";s:12:\"tmpl_created\";i:1647419614;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/full-screen-subscribe-denim-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:35:\"[\"Ecommerce\",\"Fashion\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:4;a:18:{s:4:\"tmpl\";i:1287;s:2:\"id\";i:22452;s:5:\"title\";s:37:\"Fly-In | Subscribe | Pizza Restaurant\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/pizza-restaurant-23.jpg\";s:12:\"tmpl_created\";i:1647420733;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/fly-in-subscribe-pizza-restaurant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:19:\"[\"Business\",\"Food\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:5;a:18:{s:4:\"tmpl\";i:1288;s:2:\"id\";i:22458;s:5:\"title\";s:38:\"Full Screen | Subscribe | Fashion Shop\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/fashion-shop-24.jpg\";s:12:\"tmpl_created\";i:1647426379;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/full-screen-subscribe-fashion-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:31:\"[\"Ecommerce\",\"Fashion\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:6;a:18:{s:4:\"tmpl\";i:1289;s:2:\"id\";i:22464;s:5:\"title\";s:32:\"Fly-In | Contact | Makeup Studio\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/makeup-studio-25.jpg\";s:12:\"tmpl_created\";i:1647427026;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-contact-makeup-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:22:\"[\"Business\",\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:7;a:18:{s:4:\"tmpl\";i:1290;s:2:\"id\";i:22470;s:5:\"title\";s:32:\"Fly-In | Contact | Design Studio\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/design-studio-26.jpg\";s:12:\"tmpl_created\";i:1647428250;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-contact-design-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:39:\"[\"Business\",\"Contact\",\"Digital Agency\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:8;a:18:{s:4:\"tmpl\";i:1291;s:2:\"id\";i:22480;s:5:\"title\";s:27:\"Classic | CTA | MasterClass\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/master-class-27.jpg\";s:12:\"tmpl_created\";i:1647428474;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/classic-cta-masterclass/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"cta\",\"Magazine\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:9;a:18:{s:4:\"tmpl\";i:1292;s:2:\"id\";i:22489;s:5:\"title\";s:29:\"Classic | CTA | Music Concert\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/music-concert-29.jpg\";s:12:\"tmpl_created\";i:1647429738;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/classic-cta-music-concert/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"cta\",\"Landing Pages\",\"Magazine\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:10;a:18:{s:4:\"tmpl\";i:1293;s:2:\"id\";i:22495;s:5:\"title\";s:27:\"Classic | CTA | Music Album\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/music-album-30.jpg\";s:12:\"tmpl_created\";i:1647430056;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/classic-cta-music-album/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Ba\",\"Landing Pages\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:11;a:18:{s:4:\"tmpl\";i:1294;s:2:\"id\";i:22501;s:5:\"title\";s:37:\"Fly-In | CTA | Photography Exhibition\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/photography-exhibition-31.jpg\";s:12:\"tmpl_created\";i:1647430512;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/fly-in-cta-photography-exhibition/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:33:\"[\"cta\",\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:12;a:18:{s:4:\"tmpl\";i:1295;s:2:\"id\";i:22507;s:5:\"title\";s:34:\"Classic | CTA | Clothing Shop Sale\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/clothing-shop-sale-32.jpg\";s:12:\"tmpl_created\";i:1647430774;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/popups/classic-cta-clothing-shop-sale/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:35:\"[\"Ecommerce\",\"Fashion\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:13;a:18:{s:4:\"tmpl\";i:1296;s:2:\"id\";i:22486;s:5:\"title\";s:30:\"Classic | CTA | Shop Promotion\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/shop-promotion-28.jpg\";s:12:\"tmpl_created\";i:1647430951;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-shop-promotion/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"cta\",\"Magazine\",\"Photography\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:14;a:18:{s:4:\"tmpl\";i:1297;s:2:\"id\";i:22516;s:5:\"title\";s:32:\"Fly-In | CTA | Glasses Shop Sale\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/glasses-shop-sale-33.jpg\";s:12:\"tmpl_created\";i:1647431136;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-cta-glasses-shop-sale/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:30:\"[\"Business\",\"cta\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:15;a:18:{s:4:\"tmpl\";i:1298;s:2:\"id\";i:22522;s:5:\"title\";s:30:\"Fly-In | Discount | Skate Shop\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/50-skate-shop-Discount.jpg\";s:12:\"tmpl_created\";i:1647434058;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/fly-in-discount-skate-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:32:\"[\"Discount\",\"Ecommerce\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:16;a:18:{s:4:\"tmpl\";i:1299;s:2:\"id\";i:22532;s:5:\"title\";s:43:\"Classic | Subscription | Basketball Academy\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2022/03/21-basketball-academy-Subscription.jpg\";s:12:\"tmpl_created\";i:1647434608;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/popups/classic-subscription-basketball-academy/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:33:\"[\"Education\",\"Marketing\",\"Sport\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:17;a:18:{s:4:\"tmpl\";i:1300;s:2:\"id\";i:22543;s:5:\"title\";s:38:\"Classic | Discount | Veterinary Clinic\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/veterinery-clinic-small.jpg\";s:12:\"tmpl_created\";i:1647435581;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/classic-discount-veterinary-clinic/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:19:\"[\"Discount\",\"Pets\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:18;a:18:{s:4:\"tmpl\";i:1301;s:2:\"id\";i:22553;s:5:\"title\";s:39:\"Classic | Contact | Business Consulting\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2022/03/27-business-consulting-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647439935;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/classic-contact-business-consulting/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:22:\"[\"Business\",\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:19;a:18:{s:4:\"tmpl\";i:1302;s:2:\"id\";i:22562;s:5:\"title\";s:28:\"Classic | Contact | Handyman\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/handyman-small.jpg\";s:12:\"tmpl_created\";i:1647440333;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/classic-contact-handyman/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:33:\"[\"Business\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:20;a:18:{s:4:\"tmpl\";i:1303;s:2:\"id\";i:22573;s:5:\"title\";s:40:\"Classic | Discount | Online Fashion Shop\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/31-online-fashion-shop-Discount.jpg\";s:12:\"tmpl_created\";i:1647462549;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/classic-discount-online-fashion-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"Discount\",\"Ecommerce\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:21;a:18:{s:4:\"tmpl\";i:1304;s:2:\"id\";i:22583;s:5:\"title\";s:36:\"Fly-In | Discount | Personal Trainer\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/personal-trainer-small.jpg\";s:12:\"tmpl_created\";i:1647503781;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/fly-in-discount-personal-trainer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:31:\"[\"Discount\",\"Sport\",\"Training\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:22;a:18:{s:4:\"tmpl\";i:1305;s:2:\"id\";i:22592;s:5:\"title\";s:41:\"Classic | Contact | Illustrator Portfolio\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/illustrator-protfolio-small.jpg\";s:12:\"tmpl_created\";i:1647504218;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/classic-contact-illustrator-portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:49:\"[\"Contact\",\"Creative Portfolio\",\"Digital Agency\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:23;a:18:{s:4:\"tmpl\";i:1306;s:2:\"id\";i:22602;s:5:\"title\";s:46:\"Bottom Bar | Discount | Handmade Ceramics Shop\";s:9:\"thumbnail\";s:91:\"https://library.elementor.com/wp-content/uploads/2022/03/handmade-ceramic-shop-36-small.jpg\";s:12:\"tmpl_created\";i:1647507007;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:148:\"https://library.elementor.com/popups/bottom-bar-discount-handmade-ceramics-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:48:\"[\"Business\",\"cta\",\"Ecommerce\",\"Interior Design\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:24;a:18:{s:4:\"tmpl\";i:1307;s:2:\"id\";i:22612;s:5:\"title\";s:51:\"Classic | Contact | Classic Car Restoration Company\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/restoration-car-shop-37-small.jpg\";s:12:\"tmpl_created\";i:1647507310;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:153:\"https://library.elementor.com/popups/classic-contact-classic-car-restoration-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"Booking\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:25;a:18:{s:4:\"tmpl\";i:1308;s:2:\"id\";i:22621;s:5:\"title\";s:30:\"Classic | Booking | Life Coach\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/38-life-coach-Booking.jpg\";s:12:\"tmpl_created\";i:1647508596;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-booking-life-coach/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:33:\"[\"Booking\",\"Business\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:26;a:18:{s:4:\"tmpl\";i:1309;s:2:\"id\";i:22632;s:5:\"title\";s:42:\"Classic |  Subscription | Merchandise Shop\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/Merchandise-Shop-39-small.jpg\";s:12:\"tmpl_created\";i:1647509196;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/classic-subscription-merchandise-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"Ecommerce\",\"Marketing\",\"Shop\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:27;a:18:{s:4:\"tmpl\";i:1310;s:2:\"id\";i:22643;s:5:\"title\";s:48:\"Fly-In | Contact | Non-Governmental Organization\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2022/03/NGO-41-small.jpg\";s:12:\"tmpl_created\";i:1647509528;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:150:\"https://library.elementor.com/popups/fly-in-contact-non-governmental-organization/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:28;a:18:{s:4:\"tmpl\";i:1311;s:2:\"id\";i:22654;s:5:\"title\";s:35:\"Hello Bar | Contact | Family Doctor\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/family-doctor-44-small.jpg\";s:12:\"tmpl_created\";i:1647509732;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/hello-bar-contact-family-doctor/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:31:\"[\"Contact\",\"Health\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:29;a:18:{s:4:\"tmpl\";i:1312;s:2:\"id\";i:22663;s:5:\"title\";s:36:\"Classic | Subscription | Sports Blog\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/03/45-sport-blog-Subscription.jpg\";s:12:\"tmpl_created\";i:1647509908;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-subscription-sports-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:16:\"[\"Blog\",\"Sport\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:30;a:18:{s:4:\"tmpl\";i:1313;s:2:\"id\";i:22673;s:5:\"title\";s:30:\"Hello Bar | Booking | Event DJ\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/DJ-service-46-small.jpg\";s:12:\"tmpl_created\";i:1647510160;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/hello-bar-booking-event-dj/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:31:\"[\"Booking\",\"Events\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:31;a:18:{s:4:\"tmpl\";i:1314;s:2:\"id\";i:22684;s:5:\"title\";s:36:\"Fly-In | Discount | Cleaning Company\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/51-cleaning-company-Discount.jpg\";s:12:\"tmpl_created\";i:1647510546;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/fly-in-discount-cleaning-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:31:\"[\"Discount\",\"Offer\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:32;a:18:{s:4:\"tmpl\";i:1315;s:2:\"id\";i:22693;s:5:\"title\";s:28:\"Fly-In | Contact | Carpenter\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/carpenter-53-small.jpg\";s:12:\"tmpl_created\";i:1647511972;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/fly-in-contact-carpenter/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:22:\"[\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:33;a:18:{s:4:\"tmpl\";i:1316;s:2:\"id\";i:22703;s:5:\"title\";s:31:\"Classic | Booking | Yoga Studio\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/55-yoga-studio-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647512209;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-booking-yoga-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:30:\"[\"Booking\",\"Contact\",\"Health\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:34;a:18:{s:4:\"tmpl\";i:1317;s:2:\"id\";i:22714;s:5:\"title\";s:37:\"Classic | Discount | Pet Care Company\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/56-Pet-Care-Discount.jpg\";s:12:\"tmpl_created\";i:1647513031;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/classic-discount-pet-care-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:17:\"[\"Offer\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:35;a:18:{s:4:\"tmpl\";i:1318;s:2:\"id\";i:22725;s:5:\"title\";s:38:\"Fly-In | Discount | Online Coffee Shop\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/online-coffee-shop-57-small.jpg\";s:12:\"tmpl_created\";i:1647513325;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/fly-in-discount-online-coffee-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:29:\"[\"Food\",\"Offer\",\"Restaurant\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:36;a:18:{s:4:\"tmpl\";i:1319;s:2:\"id\";i:22737;s:5:\"title\";s:44:\"Fly-In | CTA | Moving &#038; Storage Company\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/moving-company-59-small.jpg\";s:12:\"tmpl_created\";i:1647520956;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/fly-in-cta-moving-storage-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:37;a:18:{s:4:\"tmpl\";i:1320;s:2:\"id\";i:22749;s:5:\"title\";s:47:\"Classic | Contact | Industrial Design Portfolio\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/60-industrial-design-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647528116;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:149:\"https://library.elementor.com/popups/classic-contact-industrial-design-portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:40:\"[\"Contact\",\"Interior Design\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:38;a:18:{s:4:\"tmpl\";i:1321;s:2:\"id\";i:22759;s:5:\"title\";s:25:\"Classic | Contact | Drone\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/drone-61-small.jpg\";s:12:\"tmpl_created\";i:1647528899;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/popups/classic-contact-drone/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:22:\"[\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:39;a:18:{s:4:\"tmpl\";i:1322;s:2:\"id\";i:22768;s:5:\"title\";s:46:\"Full Screen | Menu | Fashion Stylist Portfolio\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/62-Fashion-Stylist-Menu.jpg\";s:12:\"tmpl_created\";i:1647529434;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:148:\"https://library.elementor.com/popups/full-screen-menu-fashion-stylist-portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:31:\"[\"Fashion\",\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:40;a:18:{s:4:\"tmpl\";i:1323;s:2:\"id\";i:22780;s:5:\"title\";s:31:\"Fly-In | CTA | Landscape Design\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2022/03/64-Landscape-Design-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647530337;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-cta-landscape-design/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:18:\"[\"cta\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:41;a:18:{s:4:\"tmpl\";i:1324;s:2:\"id\";i:22790;s:5:\"title\";s:48:\"Bottom Bar  | Contact | Architecture Photography\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2022/03/architecture-photography-65-small.jpg\";s:12:\"tmpl_created\";i:1647532358;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:149:\"https://library.elementor.com/popups/bottom-bar-contact-architecture-photography/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:26:\"[\"Architecture\",\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:42;a:18:{s:4:\"tmpl\";i:1325;s:2:\"id\";i:22800;s:5:\"title\";s:41:\"Fly-In  | CTA | Speech-Language Therapist\";s:9:\"thumbnail\";s:103:\"https://library.elementor.com/wp-content/uploads/2022/03/66-Speech-Language-Therapist-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647532720;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/fly-in-cta-speech-language-therapist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:25:\"[\"cta\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:43;a:18:{s:4:\"tmpl\";i:1326;s:2:\"id\";i:22812;s:5:\"title\";s:35:\"Full Screen | Verification | Winery\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/67-Winery-Verification.jpg\";s:12:\"tmpl_created\";i:1647761384;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/full-screen-verification-winery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:24:\"[\"Alert\",\"Verification\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:44;a:18:{s:4:\"tmpl\";i:1327;s:2:\"id\";i:22822;s:5:\"title\";s:36:\"Fly-In | Subscription | Nutritionist\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/nutritionist-69-small.jpg\";s:12:\"tmpl_created\";i:1647762620;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/fly-in-subscription-nutritionist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:28:\"[\"Food\",\"Health\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:45;a:18:{s:4:\"tmpl\";i:1328;s:2:\"id\";i:22833;s:5:\"title\";s:40:\"Classic | Subscription | App &#038; SaaS\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2022/03/app-70-small.jpg\";s:12:\"tmpl_created\";i:1647762955;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/classic-subscription-app-saas/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:14:\"[\"App\",\"SaaS\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:46;a:18:{s:4:\"tmpl\";i:1329;s:2:\"id\";i:22844;s:5:\"title\";s:41:\"Bottom Bar | Discount | Handmade Cupcakes\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/72-Handmade-Cupcakes-Discount.jpg\";s:12:\"tmpl_created\";i:1647763350;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/bottom-bar-discount-handmade-cupcakes/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:21:\"[\"Food\",\"Restaurant\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:47;a:18:{s:4:\"tmpl\";i:1330;s:2:\"id\";i:22855;s:5:\"title\";s:40:\"Bottom Bar | Subscription | Fashion Blog\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/fashion-blog-75-small.jpg\";s:12:\"tmpl_created\";i:1647763907;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/bottom-bar-subscription-fashion-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:30:\"[\"Blog\",\"Fashion\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:48;a:18:{s:4:\"tmpl\";i:1331;s:2:\"id\";i:22866;s:5:\"title\";s:28:\"Fly-In | CTA | Private Tutor\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/private-tutor-77-small.jpg\";s:12:\"tmpl_created\";i:1647764062;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/fly-in-cta-private-tutor/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:49;a:18:{s:4:\"tmpl\";i:1332;s:2:\"id\";i:22876;s:5:\"title\";s:30:\"Classic | CTA | Tennis Academy\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/78-Tennis-Academy-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647765192;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-tennis-academy/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:50;a:18:{s:4:\"tmpl\";i:1333;s:2:\"id\";i:22887;s:5:\"title\";s:31:\"Fly-In | CTA | Shared Workspace\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/shared-workspace-79-small.jpg\";s:12:\"tmpl_created\";i:1647765419;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-cta-shared-workspace/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:18:\"[\"Business\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:51;a:18:{s:4:\"tmpl\";i:1334;s:2:\"id\";i:22899;s:5:\"title\";s:30:\"Bottom Bar | CTA | Art Gallery\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/80-Art-Gallery-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647765652;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/bottom-bar-cta-art-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:13:\"[\"Art\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:52;a:18:{s:4:\"tmpl\";i:1335;s:2:\"id\";i:22910;s:5:\"title\";s:44:\"Fly-In | Subscription | Hiking Tours Company\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/hiking-tours-company-81-small.jpg\";s:12:\"tmpl_created\";i:1647765835;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/popups/fly-in-subscription-hiking-tours-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:29:\"[\"Subscribe\",\"Travel\",\"Trip\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:53;a:18:{s:4:\"tmpl\";i:1336;s:2:\"id\";i:22921;s:5:\"title\";s:26:\"Classic | CTA | Music Band\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/music-band-82-small.jpg\";s:12:\"tmpl_created\";i:1647769462;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/popups/classic-cta-music-band/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:21:\"[\"Marketing\",\"Music\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:54;a:18:{s:4:\"tmpl\";i:1337;s:2:\"id\";i:22935;s:5:\"title\";s:35:\"Classic | CTA | Computer Technician\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/comuter-technician-83-small.jpg\";s:12:\"tmpl_created\";i:1647769843;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/classic-cta-computer-technician/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:18:\"[\"cta\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:55;a:18:{s:4:\"tmpl\";i:1338;s:2:\"id\";i:22945;s:5:\"title\";s:37:\"Classic | Discount | Delivery Company\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/delivery-company-88-small.jpg\";s:12:\"tmpl_created\";i:1647770834;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/classic-discount-delivery-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:23:\"[\"Discount\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:56;a:18:{s:4:\"tmpl\";i:1339;s:2:\"id\";i:22959;s:5:\"title\";s:29:\"Classic | Discount | Eco Shop\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/echo-shop-89-small.jpg\";s:12:\"tmpl_created\";i:1647771211;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/classic-discount-eco-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:24:\"[\"Discount\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:57;a:18:{s:4:\"tmpl\";i:1340;s:2:\"id\";i:22972;s:5:\"title\";s:54:\"Fly-In | Subscription | Health &#038; Mindfulness Blog\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/health-blog-91-small.jpg\";s:12:\"tmpl_created\";i:1647771461;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:149:\"https://library.elementor.com/popups/fly-in-subscription-health-mindfulness-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:21:\"[\"Health\",\"Magazine\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:58;a:18:{s:4:\"tmpl\";i:1341;s:2:\"id\";i:22982;s:5:\"title\";s:31:\"Full Screen | Menu | Art Museum\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/art-museum-112-small.jpg\";s:12:\"tmpl_created\";i:1647771938;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/full-screen-menu-art-museum/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:59;a:18:{s:4:\"tmpl\";i:1342;s:2:\"id\";i:22992;s:5:\"title\";s:40:\"Classic | Discount | Urban Clothing Shop\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/health-blog-91-small-1.jpg\";s:12:\"tmpl_created\";i:1647773067;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/classic-discount-urban-clothing-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Discount\",\"Ecommerce\",\"Fashion\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:60;a:18:{s:4:\"tmpl\";i:1343;s:2:\"id\";i:23004;s:5:\"title\";s:60:\"Full Screen | Menu | Digital &#038; Technology Design School\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2022/03/digital-design-tech-school-small-1.jpg\";s:12:\"tmpl_created\";i:1647773366;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:155:\"https://library.elementor.com/popups/full-screen-menu-digital-technology-design-school/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:61;a:18:{s:4:\"tmpl\";i:1344;s:2:\"id\";i:23015;s:5:\"title\";s:62:\"Bottom Bar | Contact | Digital &#038; Technology Design School\";s:9:\"thumbnail\";s:93:\"https://library.elementor.com/wp-content/uploads/2022/03/digital-design-tech-school-small.jpg\";s:12:\"tmpl_created\";i:1647773492;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:157:\"https://library.elementor.com/popups/bottom-bar-contact-digital-technology-design-school/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:23:\"[\"Contact\",\"Portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:62;a:18:{s:4:\"tmpl\";i:1345;s:2:\"id\";i:23025;s:5:\"title\";s:32:\"Full Screen | Menu | Flower Shop\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/flower-shop-small.jpg\";s:12:\"tmpl_created\";i:1647773820;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/full-screen-menu-flower-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:63;a:18:{s:4:\"tmpl\";i:1346;s:2:\"id\";i:23037;s:5:\"title\";s:36:\"Classic | Subscription | Flower Shop\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/flower-shop-small-1.jpg\";s:12:\"tmpl_created\";i:1647773949;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-subscription-flower-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:24:\"[\"Discount\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:64;a:18:{s:4:\"tmpl\";i:1347;s:2:\"id\";i:23056;s:5:\"title\";s:48:\"Classic | Discount | Health &#038; Fitness eBook\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/fitness-ebook-small-1.jpg\";s:12:\"tmpl_created\";i:1647774468;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/classic-discount-health-fitness-ebook/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:23:\"[\"Contact\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:65;a:18:{s:4:\"tmpl\";i:1348;s:2:\"id\";i:23067;s:5:\"title\";s:37:\"Fly-In | Menu | Baby Sleep Consultant\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/baby-sleep-consultant-small-1.jpg\";s:12:\"tmpl_created\";i:1647778954;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/popups/baby-sleep-consultant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:66;a:18:{s:4:\"tmpl\";i:1349;s:2:\"id\";i:23077;s:5:\"title\";s:46:\"Classic | Subscription | Baby Sleep Consultant\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/baby-sleep-consultant-small.jpg\";s:12:\"tmpl_created\";i:1647779074;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:148:\"https://library.elementor.com/popups/classic-subscription-baby-sleep-consultant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:12:\"[\"Discount\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:67;a:18:{s:4:\"tmpl\";i:1350;s:2:\"id\";i:23090;s:5:\"title\";s:33:\"Full Screen | Menu | Luxury Hotel\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/luxury-hotel-small.jpg\";s:12:\"tmpl_created\";i:1647779390;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/full-screen-menu-luxury-hotel/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:68;a:18:{s:4:\"tmpl\";i:1351;s:2:\"id\";i:23100;s:5:\"title\";s:31:\"Fly-In | Booking | Luxury Hotel\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/luxury-hotel-small-1.jpg\";s:12:\"tmpl_created\";i:1647779500;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-booking-luxury-hotel/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:20:\"[\"Booking\",\"Travel\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:69;a:18:{s:4:\"tmpl\";i:1352;s:2:\"id\";i:23109;s:5:\"title\";s:38:\"Full Screen | Menu | Design Conference\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/03/design-conference-35-small.jpg\";s:12:\"tmpl_created\";i:1647779675;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/full-screen-menu-design-conference/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:70;a:18:{s:4:\"tmpl\";i:1353;s:2:\"id\";i:23120;s:5:\"title\";s:41:\"Full Screen | Booking | Design Conference\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/design-conference-35-small-1.jpg\";s:12:\"tmpl_created\";i:1647779793;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/full-screen-booking-design-conference/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:35:\"[\"Booking\",\"Conference\",\"Creative\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:71;a:18:{s:4:\"tmpl\";i:1354;s:2:\"id\";i:23129;s:5:\"title\";s:29:\"Slide-In | Menu | VR Headsets\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/VR-headset-small.jpg\";s:12:\"tmpl_created\";i:1647781211;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/slide-in-menu-vr-headsets/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:72;a:18:{s:4:\"tmpl\";i:1355;s:2:\"id\";i:23139;s:5:\"title\";s:31:\"Classic | Contact | VR Headsets\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/VR-headset-small-1.jpg\";s:12:\"tmpl_created\";i:1647781384;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-contact-vr-headsets/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:73;a:18:{s:4:\"tmpl\";i:1356;s:2:\"id\";i:23149;s:5:\"title\";s:38:\"Slide-In | Menu | Portrait Photography\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/48-portrair-photography-Menu.jpg\";s:12:\"tmpl_created\";i:1647782336;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/slide-in-menu-portrait-photography/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:74;a:18:{s:4:\"tmpl\";i:1357;s:2:\"id\";i:23159;s:5:\"title\";s:47:\"Hello Bar | Subscription | Portrait Photography\";s:9:\"thumbnail\";s:97:\"https://library.elementor.com/wp-content/uploads/2022/03/48-portrair-photography-Subscription.jpg\";s:12:\"tmpl_created\";i:1647782478;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:149:\"https://library.elementor.com/popups/hello-bar-subscription-portrait-photography/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:34:\"[\"Blog\",\"Photography\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:75;a:18:{s:4:\"tmpl\";i:1358;s:2:\"id\";i:23169;s:5:\"title\";s:32:\"Full Screen | Menu | English Pub\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/49-englisg-pub-Menu.jpg\";s:12:\"tmpl_created\";i:1647782664;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/full-screen-menu-english-pub/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:76;a:18:{s:4:\"tmpl\";i:1359;s:2:\"id\";i:23179;s:5:\"title\";s:32:\"Classic | Discount | English Pub\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/49-englisg-pub-Discount.jpg\";s:12:\"tmpl_created\";i:1647782796;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-discount-english-pub/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:20:\"[\"Discount\",\"Offer\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:77;a:18:{s:4:\"tmpl\";i:1360;s:2:\"id\";i:23189;s:5:\"title\";s:27:\"Full Screen | Menu | Singer\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/58-Music-Artist-Menu.jpg\";s:12:\"tmpl_created\";i:1647783070;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/full-screen-menu-singer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:29:\"[\"Fullscreen\",\"menu\",\"Music\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:78;a:18:{s:4:\"tmpl\";i:1361;s:2:\"id\";i:23200;s:5:\"title\";s:31:\"Classic | Subscription | Singer\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/58-Music-Artist-Subscription.jpg\";s:12:\"tmpl_created\";i:1647783249;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-subscription-singer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:21:\"[\"Music\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:79;a:18:{s:4:\"tmpl\";i:1362;s:2:\"id\";i:23210;s:5:\"title\";s:38:\"Full Screen | Menu | Virtual Assistant\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/virtual-assistnt-73-small.jpg\";s:12:\"tmpl_created\";i:1647784292;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/full-screen-menu-virtual-assistant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:80;a:18:{s:4:\"tmpl\";i:1363;s:2:\"id\";i:23223;s:5:\"title\";s:39:\"Hello Bar | Contact | Virtual Assistant\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/73-Virtual-Assistant-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647784616;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/hello-bar-contact-virtual-assistant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:37:\"[\"Contact\",\"Psychologist\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:81;a:18:{s:4:\"tmpl\";i:1364;s:2:\"id\";i:23234;s:5:\"title\";s:32:\"Slide-In  | Menu | Personal Chef\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/74-Personal-Chef-Menu.jpg\";s:12:\"tmpl_created\";i:1647798194;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/slide-in-menu-personal-chef/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:82;a:18:{s:4:\"tmpl\";i:1365;s:2:\"id\";i:23244;s:5:\"title\";s:29:\"Classic | CTA | Personal Chef\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/74-Personal-Chef-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647798297;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/classic-cta-personal-chef/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:24:\"[\"Booking\",\"Chef\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:83;a:18:{s:4:\"tmpl\";i:1366;s:2:\"id\";i:23254;s:5:\"title\";s:31:\"Full Screen | Menu | Food Truck\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/food-truck-76-small-1.jpg\";s:12:\"tmpl_created\";i:1647798447;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/full-screen-menu-food-truck/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:84;a:18:{s:4:\"tmpl\";i:1367;s:2:\"id\";i:23265;s:5:\"title\";s:30:\"Fly-In | Discount | Food Truck\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/food-truck-76-small.jpg\";s:12:\"tmpl_created\";i:1647798657;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/fly-in-discount-food-truck/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:20:\"[\"Discount\",\"Offer\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:85;a:18:{s:4:\"tmpl\";i:1369;s:2:\"id\";i:23323;s:5:\"title\";s:28:\"Classic | CTA | Black Friday\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-6-Small.jpg\";s:12:\"tmpl_created\";i:1647855505;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/classic-cta-black-friday/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:86;a:18:{s:4:\"tmpl\";i:1370;s:2:\"id\";i:23329;s:5:\"title\";s:29:\"Slide-In | CTA | Black Friday\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-5-Small.jpg\";s:12:\"tmpl_created\";i:1647855865;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/slide-in-cta-black-friday/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:87;a:18:{s:4:\"tmpl\";i:1371;s:2:\"id\";i:23335;s:5:\"title\";s:31:\"Slide-In | CTA | Black Friday 1\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-1-Small.jpg\";s:12:\"tmpl_created\";i:1647856357;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/slide-in-cta-black-friday-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:88;a:18:{s:4:\"tmpl\";i:1372;s:2:\"id\";i:23341;s:5:\"title\";s:30:\"Classic | CTA | Black Friday 2\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-3-Small.jpg\";s:12:\"tmpl_created\";i:1647856493;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-black-friday-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:89;a:18:{s:4:\"tmpl\";i:1373;s:2:\"id\";i:23347;s:5:\"title\";s:30:\"Classic | CTA | Black Friday 3\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-2-Small.jpg\";s:12:\"tmpl_created\";i:1647856891;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-black-friday-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:90;a:18:{s:4:\"tmpl\";i:1374;s:2:\"id\";i:23354;s:5:\"title\";s:30:\"Classic | CTA | Black Friday 4\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-4-Small.jpg\";s:12:\"tmpl_created\";i:1647856996;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-black-friday-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:91;a:18:{s:4:\"tmpl\";i:1375;s:2:\"id\";i:23394;s:5:\"title\";s:27:\"Classic | CTA | Halloween 1\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-3-Small.jpg\";s:12:\"tmpl_created\";i:1647857351;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/classic-cta-halloween-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:31:\"[\"cta\",\"Ecommerce\",\"Halloween\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:92;a:18:{s:4:\"tmpl\";i:1376;s:2:\"id\";i:23401;s:5:\"title\";s:33:\"Slide-In | Discount | Halloween 2\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-2-Small.jpg\";s:12:\"tmpl_created\";i:1647857567;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/slide-in-discount-halloween-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:36:\"[\"Discount\",\"Ecommerce\",\"Halloween\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:93;a:18:{s:4:\"tmpl\";i:1377;s:2:\"id\";i:23407;s:5:\"title\";s:33:\"Slide-In | Discount | Halloween 3\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-1-Small.jpg\";s:12:\"tmpl_created\";i:1647857814;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/slide-in-discount-halloween-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:36:\"[\"Discount\",\"Ecommerce\",\"Halloween\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:94;a:18:{s:4:\"tmpl\";i:1378;s:2:\"id\";i:23416;s:5:\"title\";s:31:\"Fly-In | Discount | Halloween 4\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-5-Small.jpg\";s:12:\"tmpl_created\";i:1647858024;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-discount-halloween-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:44:\"[\"Discount\",\"Ecommerce\",\"Halloween\",\"Offer\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:95;a:18:{s:4:\"tmpl\";i:1379;s:2:\"id\";i:23422;s:5:\"title\";s:36:\"Classic | Subscription | Halloween 5\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-4-Small.jpg\";s:12:\"tmpl_created\";i:1647858246;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-subscription-halloween-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:48:\"[\"Discount\",\"Ecommerce\",\"Halloween\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:96;a:18:{s:4:\"tmpl\";i:1380;s:2:\"id\";i:23471;s:5:\"title\";s:28:\"Slide-In | CTA | Christmas 1\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-2-Small.jpg\";s:12:\"tmpl_created\";i:1647859193;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/slide-in-cta-christmas-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:19:\"[\"Christmas\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:97;a:18:{s:4:\"tmpl\";i:1381;s:2:\"id\";i:23477;s:5:\"title\";s:28:\"Slide-In | CTA | Christmas 2\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-4-Small.jpg\";s:12:\"tmpl_created\";i:1647859838;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/slide-in-cta-christmas-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:19:\"[\"Christmas\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:98;a:18:{s:4:\"tmpl\";i:1382;s:2:\"id\";i:23483;s:5:\"title\";s:26:\"Fly-In | CTA | Christmas 3\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-1-Small.jpg\";s:12:\"tmpl_created\";i:1647860157;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/popups/fly-in-cta-christmas-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:31:\"[\"Christmas\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:99;a:18:{s:4:\"tmpl\";i:1383;s:2:\"id\";i:23489;s:5:\"title\";s:33:\"Slide-In | Discount | Christmas 4\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-5-Small.jpg\";s:12:\"tmpl_created\";i:1647860302;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/slide-in-discount-christmas-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:31:\"[\"Christmas\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:100;a:18:{s:4:\"tmpl\";i:1384;s:2:\"id\";i:23496;s:5:\"title\";s:32:\"Classic | Discount | Christmas 5\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-3-Small.jpg\";s:12:\"tmpl_created\";i:1647860454;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-discount-christmas-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Christmas\",\"Offer\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:101;a:18:{s:4:\"tmpl\";i:1385;s:2:\"id\";i:23523;s:5:\"title\";s:30:\"Classic | CTA | Valentines Day\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/Valentines-Day-2-Small.jpg\";s:12:\"tmpl_created\";i:1647860912;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-valentines-day/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:25:\"[\"cta\",\"Valentine\'s Day\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:102;a:18:{s:4:\"tmpl\";i:1386;s:2:\"id\";i:23529;s:5:\"title\";s:39:\"Hello Bar | Discount | Valentines Day 2\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/Valentines-Day-1-Small.jpg\";s:12:\"tmpl_created\";i:1647861064;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/hello-bar-discount-valentines-day-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:30:\"[\"Discount\",\"Valentine\'s Day\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:103;a:18:{s:4:\"tmpl\";i:1387;s:2:\"id\";i:23536;s:5:\"title\";s:32:\"Classic | CTA | Valentines Day 3\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/Valentines-Day-3-Small.jpg\";s:12:\"tmpl_created\";i:1647861536;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-cta-valentines-day-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:25:\"[\"cta\",\"Valentine\'s Day\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:104;a:18:{s:4:\"tmpl\";i:1388;s:2:\"id\";i:23586;s:5:\"title\";s:51:\"Fly-In | Subscribe | Health &#038; Wellness Company\";s:9:\"thumbnail\";s:103:\"https://library.elementor.com/wp-content/uploads/2022/03/35-Subscribe-Health-Wellness-Company-Small.jpg\";s:12:\"tmpl_created\";i:1647862008;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/popups/fly-in-subscribe-health-wellness-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:24:\"[\"Business\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:105;a:18:{s:4:\"tmpl\";i:1389;s:2:\"id\";i:23592;s:5:\"title\";s:34:\"Classic | Subscribe | Tech Company\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/36-Subscribe-Tech-Company-Small.jpg\";s:12:\"tmpl_created\";i:1647866706;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/popups/classic-subscribe-tech-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:25:\"[\"Marketing\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:106;a:18:{s:4:\"tmpl\";i:1390;s:2:\"id\";i:23598;s:5:\"title\";s:36:\"Classic | Contact Us | Fight Classes\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2022/03/37-Contact-Us-Fight-Classes-Small.jpg\";s:12:\"tmpl_created\";i:1647866869;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-contact-us-fight-classes/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:23:\"[\"Contact\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:107;a:18:{s:4:\"tmpl\";i:1391;s:2:\"id\";i:23611;s:5:\"title\";s:31:\"Classic | CTA | Mochi Shop Sale\";s:9:\"thumbnail\";s:99:\"https://library.elementor.com/wp-content/uploads/2022/03/39-Click-Through-Mochi-Shop-Sale-Small.jpg\";s:12:\"tmpl_created\";i:1647867750;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-cta-mochi-shop-sale/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:23:\"[\"cta\",\"Offer\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:108;a:18:{s:4:\"tmpl\";i:1392;s:2:\"id\";i:23618;s:5:\"title\";s:28:\"Classic | CTA | Fashion Shop\";s:9:\"thumbnail\";s:96:\"https://library.elementor.com/wp-content/uploads/2022/03/40-Click-Through-Fashion-Shop-Small.jpg\";s:12:\"tmpl_created\";i:1647868251;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/classic-cta-fashion-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:19:\"[\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:109;a:18:{s:4:\"tmpl\";i:1393;s:2:\"id\";i:23624;s:5:\"title\";s:29:\"Fly-In | Login | Tech Company\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/41-Login-Tech-Company-Small.jpg\";s:12:\"tmpl_created\";i:1647868704;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/fly-in-login-tech-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:9:\"[\"Login\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:110;a:18:{s:4:\"tmpl\";i:1394;s:2:\"id\";i:23630;s:5:\"title\";s:36:\"Fly-In | Verification | Liquor Store\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2022/03/42-Verification-Liquor-Store-Small.jpg\";s:12:\"tmpl_created\";i:1647870308;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/fly-in-verification-liquor-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:16:\"[\"Verification\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:111;a:18:{s:4:\"tmpl\";i:1395;s:2:\"id\";i:23636;s:5:\"title\";s:39:\"Hello Bar | Subscribe | Online Magazine\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2022/03/44-Subscribe-Online-Magazine-Small.jpg\";s:12:\"tmpl_created\";i:1647870465;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/hello-bar-subscribe-online-magazine/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:20:\"[\"Blog\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:112;a:18:{s:4:\"tmpl\";i:1396;s:2:\"id\";i:23642;s:5:\"title\";s:27:\"Fly-In | Login | Health Spa\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/43-Login-Health-Spa-Small.jpg\";s:12:\"tmpl_created\";i:1647872427;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/fly-in-login-health-spa/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:20:\"[\"Login\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:113;a:18:{s:4:\"tmpl\";i:1397;s:2:\"id\";i:23648;s:5:\"title\";s:33:\"Fly-In | Verification | Wine Shop\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/45-Verification-Wine-Shop-Small.jpg\";s:12:\"tmpl_created\";i:1647872627;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/fly-in-verification-wine-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:16:\"[\"Verification\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:114;a:18:{s:4:\"tmpl\";i:1421;s:2:\"id\";i:24235;s:5:\"title\";s:24:\"Ladydog Club &#8211; NFT\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2022/05/Ladydog_Club.jpg\";s:12:\"tmpl_created\";i:1651525072;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/lp/ladydog-club-nft/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:3:\"NFT\";s:4:\"tags\";s:100:\"[\"Art\",\"Author\",\"Business\",\"Creative\",\"Design\",\"Gallery\",\"Landing Pages\",\"NFT\",\"Products\",\"Virtual\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:115;a:18:{s:4:\"tmpl\";i:1422;s:2:\"id\";i:24166;s:5:\"title\";s:15:\"Dot &#8211; NFT\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2022/05/Dot-250_280.jpg\";s:12:\"tmpl_created\";i:1651525117;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/lp/dot-nft/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:3:\"NFT\";s:4:\"tags\";s:100:\"[\"Art\",\"Author\",\"Business\",\"Creative\",\"Design\",\"Gallery\",\"Landing Pages\",\"NFT\",\"Products\",\"Virtual\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:116;a:18:{s:4:\"tmpl\";i:1423;s:2:\"id\";i:24191;s:5:\"title\";s:28:\"Cosmic Neighbors &#8211; NFT\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Cosmic_Neighbors-250_280.jpg\";s:12:\"tmpl_created\";i:1651525124;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/cosmic-neighbors-nft/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:3:\"NFT\";s:4:\"tags\";s:100:\"[\"Art\",\"Author\",\"Business\",\"Creative\",\"Design\",\"Gallery\",\"Landing Pages\",\"NFT\",\"Products\",\"Virtual\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:117;a:18:{s:4:\"tmpl\";i:1424;s:2:\"id\";i:24255;s:5:\"title\";s:30:\"Happy Food Friends &#8211; NFT\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/05/Featured_Image.jpg\";s:12:\"tmpl_created\";i:1651525475;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/happy-food-friends-nft/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:3:\"NFT\";s:4:\"tags\";s:100:\"[\"Art\",\"Author\",\"Business\",\"Creative\",\"Design\",\"Gallery\",\"Landing Pages\",\"NFT\",\"Products\",\"Virtual\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:118;a:18:{s:4:\"tmpl\";i:1443;s:2:\"id\";i:24599;s:5:\"title\";s:27:\"Wireframe &#8211; Courses 1\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Courses-1.jpg\";s:12:\"tmpl_created\";i:1653989626;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/lp/wireframe-courses-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:180:\"[\"About\",\"Academy\",\"Booking\",\"Business\",\"Course Online\",\"Features\",\"Footer\",\"Landing Pages\",\"Online Service\",\"Professional\",\"School\",\"Services\",\"Subscribe\",\"Teacher\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:119;a:18:{s:4:\"tmpl\";i:1444;s:2:\"id\";i:24614;s:5:\"title\";s:28:\"Wireframe &#8211; Services 1\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-1-2.jpg\";s:12:\"tmpl_created\";i:1653990084;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-services-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:139:\"[\"About\",\"Business\",\"Contact\",\"Features\",\"Footer\",\"Form\",\"Header\",\"Landing Pages\",\"Online Service\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:120;a:18:{s:4:\"tmpl\";i:1445;s:2:\"id\";i:24629;s:5:\"title\";s:28:\"Wireframe &#8211; Services 2\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-2-2.jpg\";s:12:\"tmpl_created\";i:1653990132;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-services-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:123:\"[\"About\",\"Business\",\"Contact\",\"Features\",\"Footer\",\"Form\",\"Gallery\",\"Landing Pages\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:121;a:18:{s:4:\"tmpl\";i:1446;s:2:\"id\";i:24644;s:5:\"title\";s:27:\"Wireframe &#8211; Webinar 1\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Webinar-1.jpg\";s:12:\"tmpl_created\";i:1653990164;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/lp/wireframe-webinar-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:177:\"[\"About\",\"Academy\",\"Booking\",\"Conference\",\"Course Online\",\"Education\",\"Features\",\"Footer\",\"Form\",\"Landing Pages\",\"Online Event\",\"Online Service\",\"Subscribe\",\"Virtual\",\"Webinar\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:122;a:18:{s:4:\"tmpl\";i:1447;s:2:\"id\";i:24655;s:5:\"title\";s:28:\"Wireframe &#8211; Services 3\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-3-2.jpg\";s:12:\"tmpl_created\";i:1653990198;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-services-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:143:\"[\"About\",\"Agency\",\"Business\",\"Contact\",\"Footer\",\"Form\",\"Gallery\",\"Landing Pages\",\"Portfolio\",\"Professional\",\"Project\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:123;a:18:{s:4:\"tmpl\";i:1448;s:2:\"id\";i:24677;s:5:\"title\";s:28:\"Wireframe &#8211; Services 4\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-4.jpg\";s:12:\"tmpl_created\";i:1653990233;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-services-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:102:\"[\"About\",\"Business\",\"Contact\",\"Footer\",\"Form\",\"Landing Pages\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:124;a:18:{s:4:\"tmpl\";i:1449;s:2:\"id\";i:24687;s:5:\"title\";s:28:\"Wireframe &#8211; Products 1\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Products-1.jpg\";s:12:\"tmpl_created\";i:1653990273;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-products-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:128:\"[\"About\",\"Booking\",\"Business\",\"Clients\",\"Ecommerce\",\"Features\",\"Footer\",\"Landing Pages\",\"Products\",\"Sales\",\"Shop\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:125;a:18:{s:4:\"tmpl\";i:1450;s:2:\"id\";i:24706;s:5:\"title\";s:28:\"Wireframe &#8211; Services 5\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-5.jpg\";s:12:\"tmpl_created\";i:1653990322;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-services-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:149:\"[\"About\",\"Booking\",\"Consulting\",\"Contact\",\"Doctor\",\"Footer\",\"Form\",\"Header\",\"Landing Pages\",\"Online Service\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:126;a:18:{s:4:\"tmpl\";i:1451;s:2:\"id\";i:23604;s:5:\"title\";s:38:\"Classic | Subscribe | Nail Polish Shop\";s:9:\"thumbnail\";s:96:\"https://library.elementor.com/wp-content/uploads/2022/03/38-Subscribe-Nail-Polish-Shop-Small.jpg\";s:12:\"tmpl_created\";i:1660205114;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/classic-subscribe-nail-polish-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:20:\"[\"Blog\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:127;a:18:{s:4:\"tmpl\";i:1452;s:2:\"id\";i:23047;s:5:\"title\";s:46:\"Fly-In | Contact | Health &#038; Fitness eBook\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/fitness-ebook-small.jpg\";s:12:\"tmpl_created\";i:1660205149;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/fly-in-contact-health-fitness-ebook/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:28:\"[\"Contact\",\"Ebook\",\"Health\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:128;a:18:{s:4:\"tmpl\";i:1199;s:2:\"id\";i:18839;s:5:\"title\";s:27:\"Hello Bar | CTA | eCommerce\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2021/05/350x250.png\";s:12:\"tmpl_created\";i:1621870603;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/hello-bar-cta-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:41:\"[\"Ecommerce\",\"Online Shop\",\"Sale\",\"Shop\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:129;a:18:{s:4:\"tmpl\";i:1247;s:2:\"id\";i:21907;s:5:\"title\";s:50:\"Fly-In | Team Details  | Electronic Music Festival\";s:9:\"thumbnail\";s:104:\"https://library.elementor.com/wp-content/uploads/2022/03/Kit-8-electronic-music-festival-CTA-image-1.jpg\";s:12:\"tmpl_created\";i:1646660881;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:157:\"https://library.elementor.com/popups/fly-in-team-details-popup-electronic-music-festival/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:8:\"[\"Team\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:130;a:18:{s:4:\"tmpl\";i:1253;s:2:\"id\";i:22162;s:5:\"title\";s:46:\"Full Screen | Menu | Electronic Music Festival\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/8-music-festival-Team-Details.jpg\";s:12:\"tmpl_created\";i:1647272934;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:154:\"https://library.elementor.com/popups/full-screen-menu-popup-electronic-music-festival/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:131;a:18:{s:4:\"tmpl\";i:1254;s:2:\"id\";i:22172;s:5:\"title\";s:45:\"Classic | Discount | Health &#038; Beauty Spa\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/health-beauty-spa-small.jpg\";s:12:\"tmpl_created\";i:1647273547;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/popups/classic-discount-popup-health-beauty-spa/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:36:\"[\"Hair\",\"Health\",\"Sales\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:132;a:18:{s:4:\"tmpl\";i:1255;s:2:\"id\";i:22183;s:5:\"title\";s:44:\"Hello Bar | CTA | Environmental Organization\";s:9:\"thumbnail\";s:104:\"https://library.elementor.com/wp-content/uploads/2022/03/11-Environmental-Organization-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647274384;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:152:\"https://library.elementor.com/popups/hello-bar-cta-popup-environmental-organization/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:133;a:18:{s:4:\"tmpl\";i:1256;s:2:\"id\";i:22195;s:5:\"title\";s:39:\"Classic | Discount | Italian Restaurant\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/restaurant-small.jpg\";s:12:\"tmpl_created\";i:1647329432;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:147:\"https://library.elementor.com/popups/classic-discount-popup-italian-restaurant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:22:\"[\"Restaurant\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:134;a:18:{s:4:\"tmpl\";i:1257;s:2:\"id\";i:22210;s:5:\"title\";s:45:\"Bottom Bar | Discount | Technology Conference\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/tech-conference-small.jpg\";s:12:\"tmpl_created\";i:1647330423;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:153:\"https://library.elementor.com/popups/bottom-bar-discount-popup-technology-conference/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:38:\"[\"Conference\",\"Sales\",\"Save the Date\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:135;a:18:{s:4:\"tmpl\";i:1258;s:2:\"id\";i:22221;s:5:\"title\";s:32:\"Hello Bar | Menu | Tattoo Studio\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/tattoo-studio-small-1.jpg\";s:12:\"tmpl_created\";i:1647330705;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/hello-bar-menu-popup-tattoo-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:17:\"[\"Header\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:136;a:18:{s:4:\"tmpl\";i:1259;s:2:\"id\";i:22231;s:5:\"title\";s:37:\"Full Screen | Booking | Tattoo Studio\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/tattoo-studio-small.jpg\";s:12:\"tmpl_created\";i:1647331823;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/popups/full-screen-booking-popup-tattoo-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:32:\"[\"Booking\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:137;a:18:{s:4:\"tmpl\";i:1260;s:2:\"id\";i:22251;s:5:\"title\";s:34:\"Classic | Discount | Dental Clinic\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/dental-clinic-small.jpg\";s:12:\"tmpl_created\";i:1647332171;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/classic-discount-popup-dental-clinic/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:30:\"[\"Health\",\"Marketing\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:138;a:18:{s:4:\"tmpl\";i:1261;s:2:\"id\";i:22261;s:5:\"title\";s:34:\"Slide-In | Contact | Makeup Artist\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/20-Makeup-Artist-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647333946;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/slide-in-contact-popup-makeup-artist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:33:\"[\"Business\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:139;a:18:{s:4:\"tmpl\";i:1262;s:2:\"id\";i:22271;s:5:\"title\";s:24:\"Fly-In | CTA | Headphone\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/headphones-1-small.jpg\";s:12:\"tmpl_created\";i:1647334784;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/fly-in-cta-popup-headphone/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:41:\"[\"cta\",\"Ecommerce\",\"Marketing\",\"Product\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:140;a:18:{s:4:\"tmpl\";i:1263;s:2:\"id\";i:22277;s:5:\"title\";s:29:\"Classic | CTA | Online Course\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/online-course-2.jpg\";s:12:\"tmpl_created\";i:1647337110;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/classic-cta-popup-online-course/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:35:\"[\"Course Online\",\"cta\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:141;a:18:{s:4:\"tmpl\";i:1264;s:2:\"id\";i:22283;s:5:\"title\";s:40:\"Bottom Bar | Contact | Virtual Assistant\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/virtual-assistant-3.jpg\";s:12:\"tmpl_created\";i:1647337517;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:148:\"https://library.elementor.com/popups/bottom-bar-contact-popup-virtual-assistant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:33:\"[\"Business\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:142;a:18:{s:4:\"tmpl\";i:1265;s:2:\"id\";i:22289;s:5:\"title\";s:32:\"Fly-In | Contact | Private Tutor\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/private-tutor-4.jpg\";s:12:\"tmpl_created\";i:1647337676;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/fly-in-contact-popup-private-tutor/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:27:\"[\"Contact\",\"Course Online\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:143;a:18:{s:4:\"tmpl\";i:1266;s:2:\"id\";i:22295;s:5:\"title\";s:31:\"Classic |  Login | Login Travel\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/login-travel-6.jpg\";s:12:\"tmpl_created\";i:1647339467;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-login-popup-login-travel/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:9:\"[\"Login\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:144;a:18:{s:4:\"tmpl\";i:1267;s:2:\"id\";i:22301;s:5:\"title\";s:36:\"Full Screen | Login | Login Business\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/login-business-7.jpg\";s:12:\"tmpl_created\";i:1647339782;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:144:\"https://library.elementor.com/popups/full-screen-login-popup-login-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:16:\"[\"Login\",\"SaaS\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:145;a:18:{s:4:\"tmpl\";i:1268;s:2:\"id\";i:22307;s:5:\"title\";s:28:\"Classic | Login | Login Blog\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2022/03/login-blog-8.jpg\";s:12:\"tmpl_created\";i:1647339986;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/popups/classic-login-popup-login-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:16:\"[\"Blog\",\"Login\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:146;a:18:{s:4:\"tmpl\";i:1269;s:2:\"id\";i:22313;s:5:\"title\";s:31:\"Classic | Login | Login Fashion\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/login-fashion-9.jpg\";s:12:\"tmpl_created\";i:1647340204;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/classic-login-popup-login-fashion/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:19:\"[\"Fashion\",\"Login\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:147;a:18:{s:4:\"tmpl\";i:1270;s:2:\"id\";i:22319;s:5:\"title\";s:40:\"Classic |  Login | Login Design Platform\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/03/login-design-platform-10.jpg\";s:12:\"tmpl_created\";i:1647340531;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:147:\"https://library.elementor.com/popups/classic-login-popup-login-design-platform/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:25:\"[\"Design\",\"Login\",\"SaaS\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:148;a:18:{s:4:\"tmpl\";i:1271;s:2:\"id\";i:22325;s:5:\"title\";s:36:\"Fly-In | Contact | Digital Marketing\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/digital-marketing-11.jpg\";s:12:\"tmpl_created\";i:1647340770;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:144:\"https://library.elementor.com/popups/fly-in-contact-popup-digital-marketing/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:51:\"[\"Business\",\"Contact\",\"Digital Agency\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:149;a:18:{s:4:\"tmpl\";i:1272;s:2:\"id\";i:22331;s:5:\"title\";s:36:\"Fly-In | CTA | Dog Cat Food Delivery\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/dog-cat-food-delivery-5.jpg\";s:12:\"tmpl_created\";i:1647341069;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:144:\"https://library.elementor.com/popups/fly-in-cta-popup-dog-cat-food-delivery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:33:\"[\"cta\",\"Delivery Service\",\"Pets\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:150;a:18:{s:4:\"tmpl\";i:1273;s:2:\"id\";i:22337;s:5:\"title\";s:37:\"Full Screen | Contact | Design Studio\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/design-studio-12.jpg\";s:12:\"tmpl_created\";i:1647341370;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/popups/full-screen-contact-popup-design-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:39:\"[\"Business\",\"Contact\",\"Digital Agency\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:151;a:18:{s:4:\"tmpl\";i:1274;s:2:\"id\";i:22343;s:5:\"title\";s:44:\"Classic | Contact | Support Product Platform\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2022/03/support-13.jpg\";s:12:\"tmpl_created\";i:1647341972;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/popups/classic-contact-support-product-platform/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:21:\"[\"Contact\",\"Support\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:152;a:18:{s:4:\"tmpl\";i:1275;s:2:\"id\";i:22371;s:5:\"title\";s:38:\"Full Screen | Contact | Small Business\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/small-business-14.jpg\";s:12:\"tmpl_created\";i:1647342508;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/full-screen-contact-small-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:40:\"[\"Business\",\"Contact\",\"Interior Design\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:153;a:18:{s:4:\"tmpl\";i:1276;s:2:\"id\";i:22377;s:5:\"title\";s:31:\"Classic | Contact | Online Shop\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/online-shop-15.jpg\";s:12:\"tmpl_created\";i:1647352786;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-contact-online-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:154;a:18:{s:4:\"tmpl\";i:1277;s:2:\"id\";i:22383;s:5:\"title\";s:40:\"Classic | Booking | Children Optometrist\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/children-optometrist-16.jpg\";s:12:\"tmpl_created\";i:1647352963;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/classic-booking-children-optometrist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:53:\"[\"Booking\",\"Business\",\"Contact\",\"Education\",\"Health\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:155;a:18:{s:4:\"tmpl\";i:1278;s:2:\"id\";i:22389;s:5:\"title\";s:28:\"Fly-In | Contact | Open Week\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2022/03/open-week17.jpg\";s:12:\"tmpl_created\";i:1647353281;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/fly-in-contact-open-week/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:34:\"[\"Business\",\"Contact\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:156;a:18:{s:4:\"tmpl\";i:1279;s:2:\"id\";i:22397;s:5:\"title\";s:43:\"Full Screen | CTA | Plant Pots Online Store\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/03/plant-pots-online-store-18.jpg\";s:12:\"tmpl_created\";i:1647353429;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/popups/full-screen-cta-plant-pots-online-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:33:\"[\"Ecommerce\",\"Marketing\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:157;a:18:{s:4:\"tmpl\";i:1054;s:2:\"id\";i:15414;s:5:\"title\";s:32:\"Classic | Contact | Dance Studio\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/10/PopUp.jpg\";s:12:\"tmpl_created\";i:1603180596;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-contact-dance-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:16:\"[\"Dance Studio\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:762;s:11:\"trend_index\";i:650;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:158;a:18:{s:4:\"tmpl\";i:1398;s:2:\"id\";i:23687;s:5:\"title\";s:32:\"Pizza Promotion &#8211; Business\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/04/48-Pizza-Promotion.jpg\";s:12:\"tmpl_created\";i:1649670575;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/pizza-promotion-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:92:\"[\"Business\",\"Cooking\",\"Delivery\",\"Discount\",\"Fast Food\",\"Food\",\"Landing Pages\",\"Restaurant\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:159;a:18:{s:4:\"tmpl\";i:1400;s:2:\"id\";i:23751;s:5:\"title\";s:33:\"Baby Sleep Webinar &#8211; Events\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/04/63-Baby-Sleep-Webinar.jpg\";s:12:\"tmpl_created\";i:1649676065;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/baby-sleep-webinar-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:227:\"[\"Baby\",\"Booking\",\"Business\",\"Children\",\"Course Online\",\"Education\",\"Events\",\"Health\",\"Landing Pages\",\"Life Coach\",\"Lifestyle\",\"Online Event\",\"Online Service\",\"Parenting\",\"Professional\",\"Remote\",\"Services\",\"Training\",\"Webinar\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:160;a:18:{s:4:\"tmpl\";i:1401;s:2:\"id\";i:23776;s:5:\"title\";s:34:\"Ski Hotel Promotion &#8211; Travel\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/04/64-Ski-Hotel-Promotion.jpg\";s:12:\"tmpl_created\";i:1649691720;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/lp/ski-hotel-promotion-travel/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:6:\"Travel\";s:4:\"tags\";s:118:\"[\"Accommodation\",\"Booking\",\"Discount. Landing Pages\",\"Lifestyle\",\"Luxury\",\"Services\",\"Spa\",\"Travel\",\"Trip\",\"Vacation\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:161;a:18:{s:4:\"tmpl\";i:1402;s:2:\"id\";i:23804;s:5:\"title\";s:30:\"Cake Delivery &#8211; Business\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/04/67-Cake-Delivery.jpg\";s:12:\"tmpl_created\";i:1649692909;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/cake-delivery-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:101:\"[\"Bakery\",\"Business\",\"Cake\",\"Cooking\",\"Delivery\",\"Discount\",\"Food\",\"Landing Pages\",\"Products\",\"Shop\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:162;a:18:{s:4:\"tmpl\";i:1403;s:2:\"id\";i:23832;s:5:\"title\";s:32:\"Furniture Store &#8211; Business\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/04/87-Furniture-Store.jpg\";s:12:\"tmpl_created\";i:1649694812;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/furniture-store-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:232:\"[\"Architecture\",\"Art\",\"Business\",\"Construction\",\"Coupon\",\"Creative\",\"Decor\",\"Designer\",\"Discount\",\"Fashion\",\"Furniture Design\",\"Home\",\"House\",\"Interior Design\",\"Landing Pages\",\"Lifestyle\",\"Products\",\"Professional\",\"Services\",\"Shop\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:163;a:18:{s:4:\"tmpl\";i:1404;s:2:\"id\";i:23746;s:5:\"title\";s:22:\"Nails &#8211; Business\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2022/04/62-Nails-1.jpg\";s:12:\"tmpl_created\";i:1649704635;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/lp/nails-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:173:\"[\"Art\",\"Beauty\",\"Business\",\"Colorful\",\"Cosmetics\",\"Creative\",\"Design\",\"Discount\",\"Fashion\",\"Girly\",\"Landing Pages\",\"Lifestyle\",\"Manicure\",\"Modern\",\"Professional\",\"Services\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:164;a:18:{s:4:\"tmpl\";i:1405;s:2:\"id\";i:23846;s:5:\"title\";s:29:\"Music Festival &#8211; Events\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/04/88-Music-Festival.jpg\";s:12:\"tmpl_created\";i:1649707763;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/lp/music-festival-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:128:\"[\"Author\",\"Booking\",\"Business\",\"Creative\",\"Discount\",\"Events\",\"Landing Pages\",\"Music\",\"Online\",\"Online Event\",\"Party\",\"Virtual\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:165;a:18:{s:4:\"tmpl\";i:1406;s:2:\"id\";i:23872;s:5:\"title\";s:40:\"Fashion Styling Course &#8211; Education\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/04/89-Fashion-Styling-Course.jpg\";s:12:\"tmpl_created\";i:1649708569;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/fashion-styling-course-education/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"Education\";s:4:\"tags\";s:173:\"[\"Aesthetic\",\"Art\",\"Beauty\",\"Business\",\"Course Online\",\"Creative\",\"Discount\",\"Education\",\"Fashion\",\"Landing Pages\",\"Lifestyle\",\"Online\",\"Online Service\",\"Stylist\",\"Virtual\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:166;a:18:{s:4:\"tmpl\";i:1407;s:2:\"id\";i:23897;s:5:\"title\";s:33:\"Bags Online Shop &#8211; Business\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/04/90-Bags-Online-Shop.jpg\";s:12:\"tmpl_created\";i:1649709513;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/bags-online-shop-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:170:\"[\"Art\",\"Bag\",\"Business\",\"Creative\",\"Design\",\"Discount\",\"Fashion\",\"Landing Pages\",\"Lifestyle\",\"Luxury\",\"Modern\",\"Online\",\"Online Shop\",\"Products\",\"Sales\",\"Shop\",\"Stylist\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:167;a:18:{s:4:\"tmpl\";i:1408;s:2:\"id\";i:23932;s:5:\"title\";s:32:\"Cooking Academy &#8211; Business\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/04/91-Cooking-Academy.jpg\";s:12:\"tmpl_created\";i:1649710216;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/cooking-academy-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:145:\"[\"Academy\",\"Booking\",\"Business\",\"Chef\",\"Cooking\",\"Education\",\"Food\",\"Free Trial\",\"Landing Pages\",\"Professional\",\"School\",\"Teacher\",\"Testimonial\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:168;a:18:{s:4:\"tmpl\";i:1409;s:2:\"id\";i:23970;s:5:\"title\";s:45:\"Ophthalmology Medical Clinic &#8211; Business\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/04/92-Ophthalmology-Medical-Clinic.jpg\";s:12:\"tmpl_created\";i:1649711096;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/lp/ophthalmology-medical-clinic-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:165:\"[\"About\",\"Business\",\"Care\",\"Consulting\",\"Eye\",\"Free Trial\",\"Glasses\",\"Health\",\"Landing Pages\",\"Lifestyle\",\"Medical\",\"Modern\",\"Optometrist\",\"Professional\",\"Services\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:169;a:18:{s:4:\"tmpl\";i:1425;s:2:\"id\";i:24331;s:5:\"title\";s:24:\"Wireframe &#8211; Home 1\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Home-1.jpg\";s:12:\"tmpl_created\";i:1653988363;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/wireframe-home-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:102:\"[\"Business\",\"Contact\",\"Features\",\"Footer\",\"Header\",\"Homepage\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:170;a:18:{s:4:\"tmpl\";i:1218;s:2:\"id\";i:20792;s:5:\"title\";s:26:\"Luxury Car &#8211; Product\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/11/250x280-1.jpg\";s:12:\"tmpl_created\";i:1636903770;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/lp/luxury-car-product/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:7:\"Product\";s:4:\"tags\";s:54:\"[\"car\",\"Ecommerce\",\"Landing Pages\",\"Luxury\",\"Product\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:171;a:18:{s:4:\"tmpl\";i:1428;s:2:\"id\";i:24398;s:5:\"title\";s:25:\"Wireframe &#8211; About 1\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-About-1.jpg\";s:12:\"tmpl_created\";i:1653988534;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/wireframe-about-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:83:\"[\"About\",\"Business\",\"Contact\",\"Features\",\"Footer\",\"Professional\",\"Services\",\"Team\"]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:172;a:18:{s:4:\"tmpl\";i:991;s:2:\"id\";i:13413;s:5:\"title\";s:33:\"Classic | Contact | Online Course\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/04/PopUp-Help.jpg\";s:12:\"tmpl_created\";i:1587474761;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/classic-contact-online-course/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:530;s:11:\"trend_index\";i:369;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:173;a:18:{s:4:\"tmpl\";i:1053;s:2:\"id\";i:15272;s:5:\"title\";s:32:\"Classic | Contact | Psychologist\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/09/PopUp.png\";s:12:\"tmpl_created\";i:1600170487;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-contact-psychologist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:578;s:11:\"trend_index\";i:312;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:174;a:18:{s:4:\"tmpl\";i:899;s:2:\"id\";i:11839;s:5:\"title\";s:9:\"Portfolio\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/09/Header_small.png\";s:12:\"tmpl_created\";i:1569430015;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:43:\"[\"creative portfolio\",\"header\",\"portfolio\"]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:189;s:11:\"trend_index\";i:20;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:175;a:18:{s:4:\"tmpl\";i:1433;s:2:\"id\";i:24477;s:5:\"title\";s:27:\"Wireframe &#8211; Gallery 2\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Gallery-2.jpg\";s:12:\"tmpl_created\";i:1653988835;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-gallery-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:82:\"[\"Business\",\"Contact\",\"Design\",\"Footer\",\"Gallery\",\"Header\",\"Portfolio\",\"Services\"]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:176;a:18:{s:4:\"tmpl\";i:1205;s:2:\"id\";i:20233;s:5:\"title\";s:32:\"Art Magazine &#8211; Coming Soon\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/10/Art-Magazine-Coming-Soon-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633881371;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/art-magazine-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:48:\"[\"Art\",\"Coming Soon\",\"Landing Pages\",\"Magazine\"]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:177;a:18:{s:4:\"tmpl\";i:1214;s:2:\"id\";i:20539;s:5:\"title\";s:31:\"Design Blog &#8211; Coming Soon\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2021/10/Design-Blog-Coming-Soon-250x280-1.jpg\";s:12:\"tmpl_created\";i:1634022706;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/lp/design-blog-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:47:\"[\"Blog\",\"Coming Soon\",\"Design\",\"Landing Pages\"]\";s:10:\"menu_order\";i:4;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:178;a:18:{s:4:\"tmpl\";i:1224;s:2:\"id\";i:21013;s:5:\"title\";s:24:\"Restaurant &#8211; About\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2021/12/7-About-Restaurant.jpg\";s:12:\"tmpl_created\";i:1638795588;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/restaurant-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:36:\"[\"About\",\"Chef\",\"Food\",\"Restaurant\"]\";s:10:\"menu_order\";i:4;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:179;a:18:{s:4:\"tmpl\";i:992;s:2:\"id\";i:13402;s:5:\"title\";s:29:\"Classic | CTA | Online Course\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2020/04/Popup-Course-Completed.jpg\";s:12:\"tmpl_created\";i:1587474772;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/classic-cta-online-course/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:4;s:16:\"popularity_index\";i:619;s:11:\"trend_index\";i:582;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:180;a:18:{s:4:\"tmpl\";i:1206;s:2:\"id\";i:20254;s:5:\"title\";s:41:\"Digital Marketing Agency &#8211; Business\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/10/Digital-Marketing-Agency-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633882427;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/lp/digital-marketing-agency-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:65:\"[\"Agency\",\"Business\",\"Digital Agency\",\"Landing Pages\",\"Services\"]\";s:10:\"menu_order\";i:5;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:181;a:18:{s:4:\"tmpl\";i:1235;s:2:\"id\";i:21281;s:5:\"title\";s:25:\"Law Firm &#8211; Services\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2021/12/16-Services-Law-firm.jpg\";s:12:\"tmpl_created\";i:1638819128;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/law-firm-services-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:56:\"[\"Consulting\",\"Law\",\"Law Firm\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:5;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:182;a:18:{s:4:\"tmpl\";i:1017;s:2:\"id\";i:14111;s:5:\"title\";s:36:\"Classic | Japanese restaurant | Sale\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2020/06/Pop-Up-Page-Small.jpg\";s:12:\"tmpl_created\";i:1592300400;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-japanese-restaurant-sale/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:5;s:16:\"popularity_index\";i:717;s:11:\"trend_index\";i:697;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:183;a:18:{s:4:\"tmpl\";i:1213;s:2:\"id\";i:20509;s:5:\"title\";s:40:\"Dogs Adoption &#8211; Social Involvement\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2021/10/Dog-Adoption-250x280-1.jpg\";s:12:\"tmpl_created\";i:1634022353;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/dogs-adoption-social-involvement/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:18:\"Social Involvement\";s:4:\"tags\";s:49:\"[\"Adoption\",\"Involvement\",\"Landing Pages\",\"Pets\"]\";s:10:\"menu_order\";i:6;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:184;a:18:{s:4:\"tmpl\";i:1233;s:2:\"id\";i:21205;s:5:\"title\";s:29:\"Photographer &#8211; Projects\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/12/25-Projects-Photographer.jpg\";s:12:\"tmpl_created\";i:1638818372;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/photographer-projects/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:43:\"[\"Black and white\",\"Photography\",\"Project\"]\";s:10:\"menu_order\";i:6;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:185;a:18:{s:4:\"tmpl\";i:993;s:2:\"id\";i:13422;s:5:\"title\";s:30:\"Classic | Menu | Online Course\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/04/PopUp-Menu.jpg\";s:12:\"tmpl_created\";i:1587474782;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-menu-online-course/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:6;s:16:\"popularity_index\";i:516;s:11:\"trend_index\";i:432;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:186;a:18:{s:4:\"tmpl\";i:925;s:2:\"id\";i:12540;s:5:\"title\";s:33:\"Classic | Menu | Travel and tours\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/12/PopUp_Menu_s.png\";s:12:\"tmpl_created\";i:1575960267;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/classic-menu-travel-and-tours/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:7;s:16:\"popularity_index\";i:690;s:11:\"trend_index\";i:714;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:187;a:18:{s:4:\"tmpl\";i:1208;s:2:\"id\";i:20361;s:5:\"title\";s:51:\"Exercise &#038; Fitness Equipment &#8211; eCommerce\";s:9:\"thumbnail\";s:97:\"https://library.elementor.com/wp-content/uploads/2021/10/Exercise-Fitness-Equipment-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633883766;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/lp/exercise-fitness-equipment-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:50:\"[\"Fitness\",\"Health\",\"Landing Pages\",\"Online Shop\"]\";s:10:\"menu_order\";i:7;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:188;a:18:{s:4:\"tmpl\";i:1239;s:2:\"id\";i:21373;s:5:\"title\";s:28:\"Photographer &#8211; Gallery\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/12/18-Gallery-Photographer.jpg\";s:12:\"tmpl_created\";i:1638821177;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/photographer-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:56:\"[\"Gallery\",\"Photography\",\"Portfolio\",\"Project\",\"Travel\"]\";s:10:\"menu_order\";i:7;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:189;a:18:{s:4:\"tmpl\";i:1426;s:2:\"id\";i:24348;s:5:\"title\";s:24:\"Wireframe &#8211; Home 2\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Home-2.jpg\";s:12:\"tmpl_created\";i:1653988444;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/wireframe-home-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:102:\"[\"Business\",\"Contact\",\"Features\",\"Footer\",\"Header\",\"Homepage\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:8;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:190;a:18:{s:4:\"tmpl\";i:958;s:2:\"id\";i:13129;s:5:\"title\";s:28:\"Classic | Menu | Photography\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/02/PopUp_s.png\";s:12:\"tmpl_created\";i:1582092645;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/classic-menu-photography/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:27:\"[\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:8;s:16:\"popularity_index\";i:646;s:11:\"trend_index\";i:521;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:191;a:18:{s:4:\"tmpl\";i:1427;s:2:\"id\";i:24366;s:5:\"title\";s:24:\"Wireframe &#8211; Home 3\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Home-3.jpg\";s:12:\"tmpl_created\";i:1653988491;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/wireframe-home-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:102:\"[\"Business\",\"Contact\",\"Features\",\"Footer\",\"Header\",\"Homepage\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:9;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:192;a:18:{s:4:\"tmpl\";i:1207;s:2:\"id\";i:20299;s:5:\"title\";s:51:\"Interior Design Consultation &#8211; Online Service\";s:9:\"thumbnail\";s:99:\"https://library.elementor.com/wp-content/uploads/2021/10/Interior-Design-Consultation-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633882989;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/lp/interior-design-consultation-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:65:\"[\"Consulting\",\"Interior Design\",\"Landing Pages\",\"Online Service\"]\";s:10:\"menu_order\";i:9;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:193;a:18:{s:4:\"tmpl\";i:952;s:2:\"id\";i:12726;s:5:\"title\";s:52:\"Classic | Newsletter | Subscribe | Magazine and Blog\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2020/01/PopUp_Newsletter_s.png\";s:12:\"tmpl_created\";i:1579061019;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:152:\"https://library.elementor.com/popups/classic-newsletter-subscribe-magazine-and-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:9;s:16:\"popularity_index\";i:357;s:11:\"trend_index\";i:281;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:194;a:18:{s:4:\"tmpl\";i:883;s:2:\"id\";i:11468;s:5:\"title\";s:20:\"Classic | Sale | Gym\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/08/PopUp_Small.png\";s:12:\"tmpl_created\";i:1567393182;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/popups/classic-sale-gym/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:10;s:16:\"popularity_index\";i:696;s:11:\"trend_index\";i:740;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:195;a:18:{s:4:\"tmpl\";i:1216;s:2:\"id\";i:20623;s:5:\"title\";s:57:\"Luxurious Camping Accommodation For Events &#8211; Events\";s:9:\"thumbnail\";s:113:\"https://library.elementor.com/wp-content/uploads/2021/10/Luxurious-Camping-Accommodation-For-Events-250x280-2.jpg\";s:12:\"tmpl_created\";i:1634041681;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:151:\"https://library.elementor.com/lp/luxurious-camping-accommodation-for-events-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:43:\"[\"Event\",\"Events\",\"Landing Pages\",\"Travel\"]\";s:10:\"menu_order\";i:10;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:196;a:18:{s:4:\"tmpl\";i:1219;s:2:\"id\";i:20886;s:5:\"title\";s:28:\"Online Training &#8211; Home\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2021/12/2-Home-Online-Training.jpg\";s:12:\"tmpl_created\";i:1638784769;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/online-training-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:39:\"[\"Fitness\",\"Online\",\"Sport\",\"Training\"]\";s:10:\"menu_order\";i:10;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:197;a:18:{s:4:\"tmpl\";i:1065;s:2:\"id\";i:15570;s:5:\"title\";s:33:\"Classic | Subscribe | Travel Blog\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/11/PopUp.jpg\";s:12:\"tmpl_created\";i:1606215555;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/classic-subscribe-travel-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:11;s:16:\"popularity_index\";i:709;s:11:\"trend_index\";i:459;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:198;a:18:{s:4:\"tmpl\";i:1431;s:2:\"id\";i:24437;s:5:\"title\";s:25:\"Wireframe &#8211; About 4\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-About-4.jpg\";s:12:\"tmpl_created\";i:1653988733;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/wireframe-about-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:74:\"[\"About\",\"Business\",\"Contact\",\"Features\",\"Footer\",\"Header\",\"Professional\"]\";s:10:\"menu_order\";i:11;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:199;a:18:{s:4:\"tmpl\";i:1210;s:2:\"id\";i:20414;s:5:\"title\";s:45:\"Online English Courses &#8211; Online Service\";s:9:\"thumbnail\";s:93:\"https://library.elementor.com/wp-content/uploads/2021/10/Online-English-Courses-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633884482;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/lp/online-english-courses-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:50:\"[\"Course Online\",\"Landing Pages\",\"Online Service\"]\";s:10:\"menu_order\";i:11;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:200;a:18:{s:4:\"tmpl\";i:1132;s:2:\"id\";i:16553;s:5:\"title\";s:31:\"Fly-In | Contact | Beauty Salon\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/12/PopUp.jpg\";s:12:\"tmpl_created\";i:1608622602;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-contact-beauty-salon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:23:\"[\"Beauty Salon\",\"Hair\"]\";s:10:\"menu_order\";i:12;s:16:\"popularity_index\";i:691;s:11:\"trend_index\";i:428;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:201;a:18:{s:4:\"tmpl\";i:1441;s:2:\"id\";i:24574;s:5:\"title\";s:27:\"Wireframe &#8211; Contact 5\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Contact-5.jpg\";s:12:\"tmpl_created\";i:1653989135;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-contact-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:88:\"[\"Business\",\"Contact\",\"Footer\",\"Form\",\"Google Maps\",\"Header\",\"Professional\",\"Subscribe\"]\";s:10:\"menu_order\";i:12;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:202;a:18:{s:4:\"tmpl\";i:1217;s:2:\"id\";i:20333;s:5:\"title\";s:40:\"Plant Pots Online Shop &#8211; eCommerce\";s:9:\"thumbnail\";s:93:\"https://library.elementor.com/wp-content/uploads/2021/10/Plant-Pots-Online-Shop-250x280-2.jpg\";s:12:\"tmpl_created\";i:1634042184;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/plant-pots-online-shop-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:50:\"[\"Ecommerce\",\"Landing Pages\",\"Online Shop\",\"Shop\"]\";s:10:\"menu_order\";i:12;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:203;a:18:{s:4:\"tmpl\";i:1211;s:2:\"id\";i:20447;s:5:\"title\";s:33:\"Shared Workspace &#8211; Business\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/10/250x280-Shared-Workspace.jpg\";s:12:\"tmpl_created\";i:1633884934;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/shared-workspace-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:28:\"[\"Business\",\"Landing Pages\"]\";s:10:\"menu_order\";i:13;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:204;a:18:{s:4:\"tmpl\";i:1237;s:2:\"id\";i:21313;s:5:\"title\";s:34:\"Spa &#038; Beauty &#8211; Services\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2021/12/Spa-Beauty-Treatments-page-1.jpg\";s:12:\"tmpl_created\";i:1638819709;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/spa-beauty-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:55:\"[\"Beauty\",\"Hair\",\"Health\",\"Services\",\"Spa\",\"Treatment\"]\";s:10:\"menu_order\";i:13;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:205;a:18:{s:4:\"tmpl\";i:1004;s:2:\"id\";i:13538;s:5:\"title\";s:32:\"Fly-In | Newsletter | Barbershop\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2020/05/Pop-Up-Page-Small.jpg\";s:12:\"tmpl_created\";i:1589893364;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-newsletter-barbershop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:13;s:16:\"popularity_index\";i:710;s:11:\"trend_index\";i:667;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:206;a:18:{s:4:\"tmpl\";i:924;s:2:\"id\";i:12550;s:5:\"title\";s:32:\"Fly-in | Sale | Travel and Tours\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2019/12/PopUp_s.png\";s:12:\"tmpl_created\";i:1575960263;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/flyin-sale-travel-and-tours/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:14;s:16:\"popularity_index\";i:754;s:11:\"trend_index\";i:791;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:207;a:18:{s:4:\"tmpl\";i:1212;s:2:\"id\";i:20479;s:5:\"title\";s:49:\"Teeth Straightening &#8211; Health &#038; Fitness\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/10/250x280-Teeth-Whitening.jpg\";s:12:\"tmpl_created\";i:1633886115;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/lp/teeth-straightening-health-fitness/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:18:\"Health and Fitness\";s:4:\"tags\";s:46:\"[\"Business\",\"Dental\",\"Health\",\"Landing Pages\"]\";s:10:\"menu_order\";i:14;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:208;a:18:{s:4:\"tmpl\";i:1234;s:2:\"id\";i:21234;s:5:\"title\";s:34:\"Insurance Company &#8211; Services\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2021/12/15-Services-Insurance-Company.jpg\";s:12:\"tmpl_created\";i:1638818688;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/insurance-company-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:51:\"[\"Faq\",\"Form\",\"Insurance\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:14;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:209;a:18:{s:4:\"tmpl\";i:1035;s:2:\"id\";i:15062;s:5:\"title\";s:35:\"Fly-In | Sign up | Flooring Company\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/08/PopUp.png\";s:12:\"tmpl_created\";i:1597739629;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/fly-in-sign-up-flooring-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:15;s:16:\"popularity_index\";i:625;s:11:\"trend_index\";i:309;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:210;a:18:{s:4:\"tmpl\";i:1209;s:2:\"id\";i:20394;s:5:\"title\";s:30:\"Time Management &#8211; Events\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/10/Time-Management-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633884077;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/time-management-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:17:\"[\"Landing Pages\"]\";s:10:\"menu_order\";i:15;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:211;a:18:{s:4:\"tmpl\";i:1229;s:2:\"id\";i:21118;s:5:\"title\";s:28:\"Contact &#8211; Plants Store\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/12/12-Contact-Plants-Store.jpg\";s:12:\"tmpl_created\";i:1638802472;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/contact-plants-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:40:\"[\"Contact\",\"Info\",\"Plant\",\"Testimonial\"]\";s:10:\"menu_order\";i:15;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:212;a:18:{s:4:\"tmpl\";i:893;s:2:\"id\";i:11822;s:5:\"title\";s:30:\"Full Screen | Menu | Portfolio\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/09/PopUp_small.png\";s:12:\"tmpl_created\";i:1569429896;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/full-screen-menu-portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:16;s:16:\"popularity_index\";i:654;s:11:\"trend_index\";i:626;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:213;a:18:{s:4:\"tmpl\";i:1203;s:2:\"id\";i:18591;s:5:\"title\";s:28:\"Coffee Sale &#8211; Business\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/04/250x280-7.png\";s:12:\"tmpl_created\";i:1633877319;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/coffee-sale-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:33:\"[\"Coffee\",\"Landing Pages\",\"Sale\"]\";s:10:\"menu_order\";i:16;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:214;a:18:{s:4:\"tmpl\";i:1231;s:2:\"id\";i:21184;s:5:\"title\";s:28:\"Dental Care &#8211; Services\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/12/14-Services-Dental-Care.jpg\";s:12:\"tmpl_created\";i:1638807148;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/dental-care-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:45:\"[\"Dental\",\"Medical\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:16;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:215;a:18:{s:4:\"tmpl\";i:1064;s:2:\"id\";i:15580;s:5:\"title\";s:31:\"Fullscreen | Menu | Travel Blog\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/11/PopUp-Menu.jpg\";s:12:\"tmpl_created\";i:1606215358;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fullscreen-menu-travel-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:17;s:16:\"popularity_index\";i:673;s:11:\"trend_index\";i:348;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:216;a:18:{s:4:\"tmpl\";i:1133;s:2:\"id\";i:16645;s:5:\"title\";s:28:\"Headphones &#8211; eCommerce\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2021/01/lp_headphones.png\";s:12:\"tmpl_created\";i:1609944115;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/lp/commerce-headphones/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:39:\"[\"Ecommerce\",\"Landing Pages\",\"Product\"]\";s:10:\"menu_order\";i:17;s:16:\"popularity_index\";i:633;s:11:\"trend_index\";i:87;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:217;a:18:{s:4:\"tmpl\";i:1442;s:2:\"id\";i:24584;s:5:\"title\";s:27:\"Wireframe &#8211; Pricing 1\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Pricing-1.jpg\";s:12:\"tmpl_created\";i:1653989152;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-pricing-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:146:\"[\"Booking\",\"Business\",\"Clients\",\"Contact\",\"Faq\",\"Features\",\"Footer\",\"Online Service\",\"Pricing\",\"Products\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:17;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:218;a:18:{s:4:\"tmpl\";i:1138;s:2:\"id\";i:16762;s:5:\"title\";s:25:\"Conference &#8211; Events\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2021/01/Conference.png\";s:12:\"tmpl_created\";i:1610455119;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/lp/conference-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:60:\"[\"Conference\",\"Convention\",\"Event\",\"Events\",\"Landing Pages\"]\";s:10:\"menu_order\";i:18;s:16:\"popularity_index\";i:705;s:11:\"trend_index\";i:216;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:219;a:18:{s:4:\"tmpl\";i:1438;s:2:\"id\";i:24539;s:5:\"title\";s:27:\"Wireframe &#8211; Contact 2\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Contact-2.jpg\";s:12:\"tmpl_created\";i:1653989019;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-contact-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:69:\"[\"Business\",\"Contact\",\"Footer\",\"Google Maps\",\"Header\",\"Professional\"]\";s:10:\"menu_order\";i:18;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:220;a:18:{s:4:\"tmpl\";i:981;s:2:\"id\";i:13281;s:5:\"title\";s:37:\"Hello Bar | Contact | Interior Design\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/04/PopUp.png\";s:12:\"tmpl_created\";i:1586148801;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/hello-bar-contact-interior-design/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:19:\"[\"Interior Design\"]\";s:10:\"menu_order\";i:18;s:16:\"popularity_index\";i:763;s:11:\"trend_index\";i:679;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:221;a:18:{s:4:\"tmpl\";i:1052;s:2:\"id\";i:15259;s:5:\"title\";s:31:\"Hello Bar | Menu | Psychologist\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/09/Menu-PopUp.png\";s:12:\"tmpl_created\";i:1600170209;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/hello-bar-menu-psychologist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:19;s:16:\"popularity_index\";i:739;s:11:\"trend_index\";i:583;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:222;a:18:{s:4:\"tmpl\";i:1434;s:2:\"id\";i:24494;s:5:\"title\";s:28:\"Wireframe &#8211; Services 1\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-1.jpg\";s:12:\"tmpl_created\";i:1653988874;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/wireframe-services-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:53:\"[\"Business\",\"Faq\",\"Footer\",\"Professional\",\"Services\"]\";s:10:\"menu_order\";i:19;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:223;a:18:{s:4:\"tmpl\";i:1194;s:2:\"id\";i:18701;s:5:\"title\";s:32:\"Digital Course &#8211; eCommerce\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2021/04/250x280.jpg\";s:12:\"tmpl_created\";i:1618995134;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/digital-course-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:57:\"[\"Course Online\",\"Ecommerce\",\"Landing Pages\",\"Marketing\"]\";s:10:\"menu_order\";i:19;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:224;a:18:{s:4:\"tmpl\";i:1192;s:2:\"id\";i:18612;s:5:\"title\";s:34:\"Bag Product Sale &#8211; eCommerce\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Bag-Product.jpeg\";s:12:\"tmpl_created\";i:1618395406;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/lp/bag-product-sale-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:61:\"[\"Bag\",\"Ecommerce\",\"Landing Pages\",\"Product\",\"Sale\",\"Travel\"]\";s:10:\"menu_order\";i:20;s:16:\"popularity_index\";i:875;s:11:\"trend_index\";i:605;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:225;a:18:{s:4:\"tmpl\";i:1227;s:2:\"id\";i:21083;s:5:\"title\";s:26:\"Conference &#8211; Contact\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2021/12/10-Contact-Conference.jpg\";s:12:\"tmpl_created\";i:1638799208;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/conference-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:44:\"[\"Conference\",\"Contact\",\"Form\",\"Info\",\"Map\"]\";s:10:\"menu_order\";i:20;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:226;a:18:{s:4:\"tmpl\";i:1193;s:2:\"id\";i:18644;s:5:\"title\";s:37:\"Camera Product Sale &#8211; eCommerce\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/04/camera_sale_featured-img.jpg\";s:12:\"tmpl_created\";i:1618396388;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/lp/camera-product-sale-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:59:\"[\"Camera\",\"Ecommerce\",\"Landing Pages\",\"Photography\",\"Sale\"]\";s:10:\"menu_order\";i:21;s:16:\"popularity_index\";i:873;s:11:\"trend_index\";i:535;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:227;a:18:{s:4:\"tmpl\";i:951;s:2:\"id\";i:12736;s:5:\"title\";s:41:\"Slide In | Contact Us | Magazine and Blog\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2020/01/PopUp_contact_s.png\";s:12:\"tmpl_created\";i:1579060978;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/slide-in-contact-us/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:21;s:16:\"popularity_index\";i:734;s:11:\"trend_index\";i:686;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:228;a:18:{s:4:\"tmpl\";i:1222;s:2:\"id\";i:20960;s:5:\"title\";s:26:\"Travel Agency &#8211; Home\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2021/12/5-Home-Travel-Agency.jpg\";s:12:\"tmpl_created\";i:1638788432;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/travel-agency-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:53:\"[\"Adventures\",\"Experience\",\"Explore\",\"Travel\",\"Trip\"]\";s:10:\"menu_order\";i:21;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:229;a:18:{s:4:\"tmpl\";i:1196;s:2:\"id\";i:18815;s:5:\"title\";s:25:\"Car Wash &#8211; Business\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2021/05/Library-Pic-Car-Wash.png\";s:12:\"tmpl_created\";i:1621336431;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/lp/car-wash-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:45:\"[\"Business\",\"car\",\"Discount\",\"Landing Pages\"]\";s:10:\"menu_order\";i:22;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:230;a:18:{s:4:\"tmpl\";i:1242;s:2:\"id\";i:21473;s:5:\"title\";s:40:\"Architecture Photography &#8211; Gallery\";s:9:\"thumbnail\";s:96:\"https://library.elementor.com/wp-content/uploads/2021/12/20-Gallery-Architecture-Photography.jpg\";s:12:\"tmpl_created\";i:1638822115;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/architecture-photography-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:52:\"[\"Architecture\",\"Gallery\",\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:22;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:231;a:18:{s:4:\"tmpl\";i:1015;s:2:\"id\";i:14067;s:5:\"title\";s:37:\"Slide In | Japanese restaurant | Menu\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2020/06/Menu-Pop-Up-Small.jpg\";s:12:\"tmpl_created\";i:1592290352;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/slide-in-japanese-restaurant-menu/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:22;s:16:\"popularity_index\";i:650;s:11:\"trend_index\";i:565;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:232;a:18:{s:4:\"tmpl\";i:923;s:2:\"id\";i:12229;s:5:\"title\";s:33:\"Slide In | Law Firm | Information\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2019/11/popup.png\";s:12:\"tmpl_created\";i:1572847842;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/slide-in-law-firm-information/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:23;s:16:\"popularity_index\";i:547;s:11:\"trend_index\";i:413;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:233;a:18:{s:4:\"tmpl\";i:1198;s:2:\"id\";i:18824;s:5:\"title\";s:33:\"Design School &#8211; Coming Soon\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/05/250x280-1.png\";s:12:\"tmpl_created\";i:1621336756;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/design-school-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:49:\"[\"Coming Soon\",\"Design\",\"Landing Pages\",\"School\"]\";s:10:\"menu_order\";i:23;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:234;a:18:{s:4:\"tmpl\";i:1236;s:2:\"id\";i:21259;s:5:\"title\";s:28:\"3D Designer &#8211; Projects\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/12/24-Projects-3D-Designer.jpg\";s:12:\"tmpl_created\";i:1638819185;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/3d-designer-projects/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:69:\"[\"3D\",\"Creative Portfolio\",\"Design\",\"Designer\",\"Portfolio\",\"Project\"]\";s:10:\"menu_order\";i:23;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:235;a:18:{s:4:\"tmpl\";i:1028;s:2:\"id\";i:14827;s:5:\"title\";s:39:\"Slide-In | Contact | Luxury Real Estate\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/07/PopUp.png\";s:12:\"tmpl_created\";i:1595323523;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/slide-in-contact-luxury-real-estate/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:28:\"[\"Real estate\",\"Realestate\"]\";s:10:\"menu_order\";i:24;s:16:\"popularity_index\";i:559;s:11:\"trend_index\";i:284;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:236;a:18:{s:4:\"tmpl\";i:1197;s:2:\"id\";i:18819;s:5:\"title\";s:27:\"Dog Walker &#8211; Business\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2021/05/Library-Pic-Dog-Walker.png\";s:12:\"tmpl_created\";i:1621336601;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/lp/dog-walker-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:41:\"[\"Business\",\"Dog\",\"Landing Pages\",\"Pets\"]\";s:10:\"menu_order\";i:24;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:237;a:18:{s:4:\"tmpl\";i:1238;s:2:\"id\";i:21349;s:5:\"title\";s:29:\"Architecture &#8211; Projects\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/12/23-Projects-Architecture.jpg\";s:12:\"tmpl_created\";i:1638820870;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/architecture-projects/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:70:\"[\"Architecture\",\"Creative\",\"Creative Portfolio\",\"Portfolio\",\"Project\"]\";s:10:\"menu_order\";i:24;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:238;a:18:{s:4:\"tmpl\";i:1034;s:2:\"id\";i:15075;s:5:\"title\";s:34:\"Slide-In | Menu | Flooring Company\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/08/PopUp-1.png\";s:12:\"tmpl_created\";i:1597739605;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/popups/slide-in-menu-flooring-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:25;s:16:\"popularity_index\";i:383;s:11:\"trend_index\";i:162;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:239;a:18:{s:4:\"tmpl\";i:1414;s:2:\"id\";i:24079;s:5:\"title\";s:32:\"Fashion Shop &#8211; Coming Soon\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Fashion-Shop.jpg\";s:12:\"tmpl_created\";i:1650988089;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/fashion-shop-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:88:\"[\"Aesthetic\",\"Business\",\"Coming Soon\",\"Ecommerce\",\"Girly\",\"Lifestyle\",\"Products\",\"Shop\"]\";s:10:\"menu_order\";i:25;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:240;a:18:{s:4:\"tmpl\";i:1195;s:2:\"id\";i:18761;s:5:\"title\";s:33:\"Fashion Store &#8211; Coming Soon\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/05/Library-Pic-Fashion-Store.png\";s:12:\"tmpl_created\";i:1621336146;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/fashion-store-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:56:\"[\"Coming Soon\",\"Fashion\",\"Landing Pages\",\"Shop\",\"store\"]\";s:10:\"menu_order\";i:25;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:241;a:18:{s:4:\"tmpl\";i:1153;s:2:\"id\";i:17060;s:5:\"title\";s:36:\"Private Tutor &#8211; Online Service\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2021/01/Online-Tutor-2.png\";s:12:\"tmpl_created\";i:1610631042;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/lp/private-tutor-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:64:\"[\"Education\",\"Landing Pages\",\"Online Service\",\"Teacher\",\"Tutor\"]\";s:10:\"menu_order\";i:26;s:16:\"popularity_index\";i:780;s:11:\"trend_index\";i:628;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:242;a:18:{s:4:\"tmpl\";i:1430;s:2:\"id\";i:24434;s:5:\"title\";s:25:\"Wireframe &#8211; About 3\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-About-3.jpg\";s:12:\"tmpl_created\";i:1653988697;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/wireframe-about-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:76:\"[\"About\",\"Business\",\"Contact\",\"Faq\",\"Footer\",\"Header\",\"Professional\",\"Team\"]\";s:10:\"menu_order\";i:26;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:243;a:18:{s:4:\"tmpl\";i:1158;s:2:\"id\";i:17232;s:5:\"title\";s:33:\"Life Coach &#8211; Online Service\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2021/01/Life-Coach.png\";s:12:\"tmpl_created\";i:1610902793;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/life-coach-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:38:\"[\"Coach\",\"Landing Pages\",\"Life Coach\"]\";s:10:\"menu_order\";i:27;s:16:\"popularity_index\";i:787;s:11:\"trend_index\";i:751;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:244;a:18:{s:4:\"tmpl\";i:1436;s:2:\"id\";i:24515;s:5:\"title\";s:28:\"Wireframe &#8211; Services 3\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-3.jpg\";s:12:\"tmpl_created\";i:1653988946;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/wireframe-services-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:66:\"[\"Business\",\"Contact\",\"Footer\",\"Header\",\"Professional\",\"Services\"]\";s:10:\"menu_order\";i:27;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:245;a:18:{s:4:\"tmpl\";i:875;s:2:\"id\";i:11241;s:5:\"title\";s:36:\"Classic | Digital Agency | Marketing\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/07/PopUp_small.jpg\";s:12:\"tmpl_created\";i:1564643043;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-digital-agency-marketing/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:28;s:16:\"popularity_index\";i:362;s:11:\"trend_index\";i:315;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:246;a:18:{s:4:\"tmpl\";i:1146;s:2:\"id\";i:16932;s:5:\"title\";s:35:\"Finance Consulting &#8211; Business\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2021/01/Finance-Consulting.png\";s:12:\"tmpl_created\";i:1610532170;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/lp/finance-consulting-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:80:\"[\"Advisor\",\"Business\",\"Consulting\",\"Finance\",\"Investment\",\"Landing Pages\",\"Tax\"]\";s:10:\"menu_order\";i:28;s:16:\"popularity_index\";i:790;s:11:\"trend_index\";i:630;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:247;a:18:{s:4:\"tmpl\";i:1429;s:2:\"id\";i:24421;s:5:\"title\";s:25:\"Wireframe &#8211; About 2\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-About-2.jpg\";s:12:\"tmpl_created\";i:1653988579;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/wireframe-about-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:87:\"[\"About\",\"Business\",\"Contact\",\"Faq\",\"Features\",\"Footer\",\"Header\",\"Professional\",\"Team\"]\";s:10:\"menu_order\";i:28;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:248;a:18:{s:4:\"tmpl\";i:674;s:2:\"id\";i:8505;s:5:\"title\";s:11:\"404 page 01\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/001.jpg\";s:12:\"tmpl_created\";i:1526415501;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-01/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:28;s:16:\"popularity_index\";i:533;s:11:\"trend_index\";i:222;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:249;a:18:{s:4:\"tmpl\";i:1136;s:2:\"id\";i:16721;s:5:\"title\";s:35:\"Dental &#8211; Health &amp; Fitness\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2021/01/Dental.jpg\";s:12:\"tmpl_created\";i:1610448567;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/lp/dental-health-fitness/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:18:\"Health and Fitness\";s:4:\"tags\";s:44:\"[\"Dental\",\"Doctor\",\"Health\",\"Landing Pages\"]\";s:10:\"menu_order\";i:29;s:16:\"popularity_index\";i:801;s:11:\"trend_index\";i:655;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:250;a:18:{s:4:\"tmpl\";i:1417;s:2:\"id\";i:24116;s:5:\"title\";s:32:\"Tech Company &#8211; Coming Soon\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Tech-Company.jpg\";s:12:\"tmpl_created\";i:1650989265;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/tech-company-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:87:\"[\"Business\",\"Coding\",\"Coming Soon\",\"Computer\",\"Developer\",\"IT\",\"Services\",\"Technology\"]\";s:10:\"menu_order\";i:29;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:251;a:18:{s:4:\"tmpl\";i:675;s:2:\"id\";i:8511;s:5:\"title\";s:11:\"404 page 02\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/002.jpg\";s:12:\"tmpl_created\";i:1526415528;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-02/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:29;s:16:\"popularity_index\";i:347;s:11:\"trend_index\";i:155;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:252;a:18:{s:4:\"tmpl\";i:1161;s:2:\"id\";i:17269;s:5:\"title\";s:34:\"Electronics Sale &#8211; eCommerce\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2021/01/Electronic-Products.png\";s:12:\"tmpl_created\";i:1610903298;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/lp/electronics-sale-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:29:\"[\"Ecommerce\",\"Landing Pages\"]\";s:10:\"menu_order\";i:30;s:16:\"popularity_index\";i:800;s:11:\"trend_index\";i:556;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:253;a:18:{s:4:\"tmpl\";i:1220;s:2:\"id\";i:20908;s:5:\"title\";s:42:\"Packing &#038; Moving Company &#8211; Home\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2021/12/3-Home-Packing-Moving-Company.jpg\";s:12:\"tmpl_created\";i:1638786127;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/packing-moving-company-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Movers\",\"Moving\",\"Storge\"]\";s:10:\"menu_order\";i:30;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:254;a:18:{s:4:\"tmpl\";i:1152;s:2:\"id\";i:17032;s:5:\"title\";s:42:\"Donate Computer &#8211; Social Involvement\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2021/01/Donation-2.png\";s:12:\"tmpl_created\";i:1610630585;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/lp/donate-computer-social-involvement/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:18:\"Social Involvement\";s:4:\"tags\";s:67:\"[\"Computer\",\"Donate\",\"Donation\",\"Kids\",\"Landing Pages\",\"Nonprofit\"]\";s:10:\"menu_order\";i:31;s:16:\"popularity_index\";i:718;s:11:\"trend_index\";i:278;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:255;a:18:{s:4:\"tmpl\";i:672;s:2:\"id\";i:8512;s:5:\"title\";s:11:\"404 page 03\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/003.jpg\";s:12:\"tmpl_created\";i:1526415449;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-03/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:31;s:16:\"popularity_index\";i:450;s:11:\"trend_index\";i:375;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:256;a:18:{s:4:\"tmpl\";i:1245;s:2:\"id\";i:21546;s:5:\"title\";s:28:\"Interior Design &#8211; Home\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/12/1-Home-Interior-Design-1.jpg\";s:12:\"tmpl_created\";i:1639046269;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/interior-design-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:68:\"[\"Design\",\"Form\",\"Furniture Design\",\"Interior Design\",\"Testimonial\"]\";s:10:\"menu_order\";i:31;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:257;a:18:{s:4:\"tmpl\";i:1135;s:2:\"id\";i:16684;s:5:\"title\";s:34:\"SaaS HR Management &#8211; Product\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2021/01/lp_hr.png\";s:12:\"tmpl_created\";i:1609945486;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/lp/saas-hr-management-product/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:7:\"Product\";s:4:\"tags\";s:39:\"[\"HR\",\"Landing Pages\",\"Product\",\"SaaS\"]\";s:10:\"menu_order\";i:32;s:16:\"popularity_index\";i:708;s:11:\"trend_index\";i:292;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:258;a:18:{s:4:\"tmpl\";i:671;s:2:\"id\";i:8513;s:5:\"title\";s:11:\"404 page 04\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/004.jpg\";s:12:\"tmpl_created\";i:1526415417;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-04/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:32;s:16:\"popularity_index\";i:420;s:11:\"trend_index\";i:176;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:259;a:18:{s:4:\"tmpl\";i:1249;s:2:\"id\";i:22137;s:5:\"title\";s:31:\"Design Blog &#8211; Coming Soon\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2021/10/Design-Blog-Coming-Soon-250x280-1.jpg\";s:12:\"tmpl_created\";i:1647177194;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/design-blog-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:47:\"[\"Blog\",\"Coming Soon\",\"Design\",\"Landing Pages\"]\";s:10:\"menu_order\";i:32;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:260;a:18:{s:4:\"tmpl\";i:1134;s:2:\"id\";i:16660;s:5:\"title\";s:37:\"Medical center &#8211; Online service\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/01/Online-medical-cosultation-250_280.png\";s:12:\"tmpl_created\";i:1609945122;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/lp/medical-center-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:44:\"[\"Landing Pages\",\"Medical\",\"Online Service\"]\";s:10:\"menu_order\";i:33;s:16:\"popularity_index\";i:750;s:11:\"trend_index\";i:332;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:261;a:18:{s:4:\"tmpl\";i:1226;s:2:\"id\";i:21069;s:5:\"title\";s:21:\"Hotel &#8211; Contact\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2021/12/9-Contact-Hotel.jpg\";s:12:\"tmpl_created\";i:1638798545;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/hotel-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:36:\"[\"Contact\",\"from\",\"Info\",\"Vacation\"]\";s:10:\"menu_order\";i:33;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:262;a:18:{s:4:\"tmpl\";i:1150;s:2:\"id\";i:17001;s:5:\"title\";s:36:\"Parental Counseling &#8211; Business\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2021/01/Parenting-Coach-2.png\";s:12:\"tmpl_created\";i:1610534999;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/lp/parental-counseling-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:99:\"[\"Advisor\",\"Business\",\"Coach\",\"Counseling\",\"Landing Pages\",\"Online Service\",\"Parental\",\"Parenting\"]\";s:10:\"menu_order\";i:34;s:16:\"popularity_index\";i:817;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:263;a:18:{s:4:\"tmpl\";i:1432;s:2:\"id\";i:24461;s:5:\"title\";s:27:\"Wireframe &#8211; Gallery 1\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Gallery-1.jpg\";s:12:\"tmpl_created\";i:1653988784;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-gallery-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:82:\"[\"Business\",\"Contact\",\"Design\",\"Footer\",\"Gallery\",\"Header\",\"Portfolio\",\"Services\"]\";s:10:\"menu_order\";i:34;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:264;a:18:{s:4:\"tmpl\";i:676;s:2:\"id\";i:8514;s:5:\"title\";s:11:\"404 Page 05\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/005.jpg\";s:12:\"tmpl_created\";i:1526415558;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-05/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:34;s:16:\"popularity_index\";i:419;s:11:\"trend_index\";i:220;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:265;a:18:{s:4:\"tmpl\";i:1137;s:2:\"id\";i:16742;s:5:\"title\";s:31:\"Online Course &#8211; Education\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2021/01/Online-Course.png\";s:12:\"tmpl_created\";i:1610454122;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/lp/online-course-education/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"Education\";s:4:\"tags\";s:55:\"[\"Academy\",\"Course Online\",\"Education\",\"Landing Pages\"]\";s:10:\"menu_order\";i:35;s:16:\"popularity_index\";i:777;s:11:\"trend_index\";i:776;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:266;a:18:{s:4:\"tmpl\";i:668;s:2:\"id\";i:8523;s:5:\"title\";s:11:\"404 page 06\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/006.jpg\";s:12:\"tmpl_created\";i:1526415291;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-06/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:35;s:16:\"popularity_index\";i:298;s:11:\"trend_index\";i:268;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:267;a:18:{s:4:\"tmpl\";i:1440;s:2:\"id\";i:24563;s:5:\"title\";s:27:\"Wireframe &#8211; Contact 4\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Contact-4.jpg\";s:12:\"tmpl_created\";i:1653989095;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-contact-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:84:\"[\"Business\",\"Contact\",\"Footer\",\"Form\",\"Gallery\",\"Header\",\"Professional\",\"Subscribe\"]\";s:10:\"menu_order\";i:35;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:268;a:18:{s:4:\"tmpl\";i:1162;s:2:\"id\";i:17284;s:5:\"title\";s:38:\"Dietitian &#8211; Health &amp; Fitness\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/01/Dietitian.png\";s:12:\"tmpl_created\";i:1610903484;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/dietitian-health-fitness/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:18:\"Health and Fitness\";s:4:\"tags\";s:39:\"[\"Fitness\",\"Health\",\"landscape design\"]\";s:10:\"menu_order\";i:36;s:16:\"popularity_index\";i:814;s:11:\"trend_index\";i:800;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:269;a:18:{s:4:\"tmpl\";i:1439;s:2:\"id\";i:24553;s:5:\"title\";s:27:\"Wireframe &#8211; Contact 3\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Contact-3.jpg\";s:12:\"tmpl_created\";i:1653989057;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-contact-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:67:\"[\"Business\",\"Contact\",\"Footer\",\"Form\",\"Professional\",\"Testimonial\"]\";s:10:\"menu_order\";i:36;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:270;a:18:{s:4:\"tmpl\";i:1144;s:2:\"id\";i:16897;s:5:\"title\";s:30:\"Personal Chef &#8211; Business\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2021/01/Personal-Chef.png\";s:12:\"tmpl_created\";i:1610466247;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/personal-chef-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:53:\"[\"Business\",\"Chef\",\"Food\",\"Landing Pages\",\"Services\"]\";s:10:\"menu_order\";i:37;s:16:\"popularity_index\";i:795;s:11:\"trend_index\";i:617;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:271;a:18:{s:4:\"tmpl\";i:1435;s:2:\"id\";i:24504;s:5:\"title\";s:28:\"Wireframe &#8211; Services 2\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-2.jpg\";s:12:\"tmpl_created\";i:1653988910;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/wireframe-services-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:80:\"[\"Business\",\"Contact\",\"Footer\",\"Header\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:37;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:272;a:18:{s:4:\"tmpl\";i:669;s:2:\"id\";i:8524;s:5:\"title\";s:11:\"404 page 07\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/007.jpg\";s:12:\"tmpl_created\";i:1526415337;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-07/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:37;s:16:\"popularity_index\";i:303;s:11:\"trend_index\";i:171;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:273;a:18:{s:4:\"tmpl\";i:1147;s:2:\"id\";i:16946;s:5:\"title\";s:52:\"Online Full-Stack Developer Course &#8211; Education\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/01/Online-Full-Stack-Developer-Course.png\";s:12:\"tmpl_created\";i:1610532778;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/lp/online-full-stack-developer-course-education/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"Education\";s:4:\"tags\";s:76:\"[\"Academy\",\"Coding\",\"Course Online\",\"Developer\",\"Education\",\"Landing Pages\"]\";s:10:\"menu_order\";i:38;s:16:\"popularity_index\";i:805;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:274;a:18:{s:4:\"tmpl\";i:1437;s:2:\"id\";i:24528;s:5:\"title\";s:27:\"Wireframe &#8211; Contact 1\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Contact-1.jpg\";s:12:\"tmpl_created\";i:1653988981;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-contact-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:76:\"[\"Business\",\"Contact\",\"Footer\",\"Form\",\"Google Maps\",\"Header\",\"Professional\"]\";s:10:\"menu_order\";i:38;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:275;a:18:{s:4:\"tmpl\";i:1143;s:2:\"id\";i:16868;s:5:\"title\";s:40:\"Virtual Assistant &#8211; Online Service\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2021/01/Virtual-Assistant-250x280-1.png\";s:12:\"tmpl_created\";i:1610465656;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/virtual-assistant-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:46:\"[\"Assistant\",\"Landing Pages\",\"Online Service\"]\";s:10:\"menu_order\";i:39;s:16:\"popularity_index\";i:793;s:11:\"trend_index\";i:757;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:276;a:18:{s:4:\"tmpl\";i:673;s:2:\"id\";i:8526;s:5:\"title\";s:11:\"404 page 09\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/009.jpg\";s:12:\"tmpl_created\";i:1526415474;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-09/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:39;s:16:\"popularity_index\";i:477;s:11:\"trend_index\";i:285;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:277;a:18:{s:4:\"tmpl\";i:1228;s:2:\"id\";i:21104;s:5:\"title\";s:26:\"Restaurant &#8211; Contact\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2021/12/11-Contact-Restaurant.jpg\";s:12:\"tmpl_created\";i:1638800146;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/restaurant-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:60:\"[\"Contact\",\"Food\",\"Form\",\"Google Maps\",\"Info\",\"Testimonial\"]\";s:10:\"menu_order\";i:39;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:278;a:18:{s:4:\"tmpl\";i:1140;s:2:\"id\";i:16812;s:5:\"title\";s:40:\"Construction Project &#8211; Real Estate\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2021/01/Construction-Project.png\";s:12:\"tmpl_created\";i:1610463582;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/construction-project-real-estate/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:11:\"Real Estate\";s:4:\"tags\";s:59:\"[\"Construction\",\"Landing Pages\",\"Real estate\",\"Realestate\"]\";s:10:\"menu_order\";i:40;s:16:\"popularity_index\";i:796;s:11:\"trend_index\";i:724;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:279;a:18:{s:4:\"tmpl\";i:1244;s:2:\"id\";i:21393;s:5:\"title\";s:34:\"Interior Designer &#8211; Projects\";s:9:\"thumbnail\";s:99:\"https://library.elementor.com/wp-content/uploads/2021/12/big-22-Projects-Interior-Designer-New.jpeg\";s:12:\"tmpl_created\";i:1638823945;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/interior-designer-projects/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:93:\"[\"Creative\",\"Creative Portfolio\",\"Design\",\"Designer\",\"Interior Design\",\"Portfolio\",\"Project\"]\";s:10:\"menu_order\";i:40;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:280;a:18:{s:4:\"tmpl\";i:1148;s:2:\"id\";i:16960;s:5:\"title\";s:44:\"Dog &amp; Cat Food Delivery &#8211; Business\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2021/01/Dog-Food.png\";s:12:\"tmpl_created\";i:1610533581;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/lp/dog-cat-food-delivery-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:71:\"[\"Business\",\"Cat\",\"Delivery\",\"Dog\",\"Food\",\"Landing Pages\",\"Pet\",\"Pets\"]\";s:10:\"menu_order\";i:41;s:16:\"popularity_index\";i:782;s:11:\"trend_index\";i:510;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:281;a:18:{s:4:\"tmpl\";i:670;s:2:\"id\";i:8525;s:5:\"title\";s:11:\"404 page 08\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/008.jpg\";s:12:\"tmpl_created\";i:1526415374;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-08/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:41;s:16:\"popularity_index\";i:510;s:11:\"trend_index\";i:575;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:282;a:18:{s:4:\"tmpl\";i:1251;s:2:\"id\";i:22143;s:5:\"title\";s:33:\"Fashion Store &#8211; Coming Soon\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/05/Library-Pic-Fashion-Store.png\";s:12:\"tmpl_created\";i:1647177389;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/fashion-store-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:56:\"[\"Coming Soon\",\"Fashion\",\"Landing Pages\",\"Shop\",\"store\"]\";s:10:\"menu_order\";i:41;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:283;a:18:{s:4:\"tmpl\";i:1155;s:2:\"id\";i:17095;s:5:\"title\";s:36:\"Mobile Pet Grooming &#8211; Business\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2021/01/Mobile-Pet-Grooming.png\";s:12:\"tmpl_created\";i:1610632115;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/lp/mobile-pet-grooming-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:38:\"[\"Dog\",\"Groom\",\"Landing Pages\",\"Pets\"]\";s:10:\"menu_order\";i:42;s:16:\"popularity_index\";i:786;s:11:\"trend_index\";i:731;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:284;a:18:{s:4:\"tmpl\";i:1241;s:2:\"id\";i:21451;s:5:\"title\";s:26:\"Exhibition &#8211; Gallery\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2021/12/21-Gallery-Exhibition.jpg\";s:12:\"tmpl_created\";i:1638821855;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/exhibition-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:74:\"[\"Art\",\"Creative\",\"Creative Portfolio\",\"Exhibition\",\"Gallery\",\"Portfolio\"]\";s:10:\"menu_order\";i:42;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:285;a:18:{s:4:\"tmpl\";i:502;s:2:\"id\";i:5438;s:5:\"title\";s:7:\"About 1\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_4.png\";s:12:\"tmpl_created\";i:1520443512;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/about-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:42;s:16:\"popularity_index\";i:147;s:11:\"trend_index\";i:9;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:286;a:18:{s:4:\"tmpl\";i:1159;s:2:\"id\";i:17245;s:5:\"title\";s:34:\"Marketing Course &#8211; Education\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2021/01/PPC.png\";s:12:\"tmpl_created\";i:1610902958;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/lp/marketing-course-education/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"Education\";s:4:\"tags\";s:45:\"[\"Course Online\",\"Landing Pages\",\"Marketing\"]\";s:10:\"menu_order\";i:43;s:16:\"popularity_index\";i:770;s:11:\"trend_index\";i:430;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:287;a:18:{s:4:\"tmpl\";i:1240;s:2:\"id\";i:21430;s:5:\"title\";s:30:\"Travel Blogger &#8211; Gallery\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/12/19-Gallery-Travel-Blogger.jpg\";s:12:\"tmpl_created\";i:1638821592;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/travel-blogger-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:43:\"[\"Gallery\",\"Photography\",\"Slider\",\"Travel\"]\";s:10:\"menu_order\";i:43;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:288;a:18:{s:4:\"tmpl\";i:1149;s:2:\"id\";i:16983;s:5:\"title\";s:41:\"Pilates Instructor &#8211; Online Service\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2021/01/Pilates-Instructor.png\";s:12:\"tmpl_created\";i:1610534138;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/lp/pilates-instructor-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:70:\"[\"Free Trial\",\"Instructor\",\"Landing Pages\",\"Online Service\",\"Pilates\"]\";s:10:\"menu_order\";i:44;s:16:\"popularity_index\";i:778;s:11:\"trend_index\";i:412;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:289;a:18:{s:4:\"tmpl\";i:1416;s:2:\"id\";i:24104;s:5:\"title\";s:33:\"Ceramics Shop &#8211; Coming Soon\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Ceramics-Shop.jpg\";s:12:\"tmpl_created\";i:1650988949;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/ceramics-shop-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:115:\"[\"Art\",\"Business\",\"Coming Soon\",\"Creative\",\"Decor\",\"Design\",\"Furniture Design\",\"Interior Design\",\"Products\",\"Shop\"]\";s:10:\"menu_order\";i:44;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:290;a:18:{s:4:\"tmpl\";i:557;s:2:\"id\";i:6135;s:5:\"title\";s:8:\"About 10\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_2.png\";s:12:\"tmpl_created\";i:1520443663;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-10/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:45;s:16:\"popularity_index\";i:77;s:11:\"trend_index\";i:47;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:291;a:18:{s:4:\"tmpl\";i:1412;s:2:\"id\";i:24033;s:5:\"title\";s:37:\"Dance Studio &#8211; Maintenance Mode\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/04/Maintenance-Mode-Dance-Studio.jpg\";s:12:\"tmpl_created\";i:1649881344;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/dance-studio-maintenance-mode/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:113:\"[\"Academy\",\"Business\",\"Dance Studio\",\"Form\",\"Pilates\",\"School\",\"Sport\",\"Teacher\",\"Training\",\"Under Construction\"]\";s:10:\"menu_order\";i:45;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:292;a:18:{s:4:\"tmpl\";i:1190;s:2:\"id\";i:18568;s:5:\"title\";s:32:\"Flower Delivery &#8211; Business\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2021/04/Flower-Delivery.png\";s:12:\"tmpl_created\";i:1617546716;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/flower-delivery-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:37:\"[\"Delivery\",\"Flower\",\"Landing Pages\"]\";s:10:\"menu_order\";i:45;s:16:\"popularity_index\";i:874;s:11:\"trend_index\";i:763;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:293;a:18:{s:4:\"tmpl\";i:1145;s:2:\"id\";i:16917;s:5:\"title\";s:22:\"Webinar &#8211; Events\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2021/01/Webinar-Library-Pic.jpg\";s:12:\"tmpl_created\";i:1610466822;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/lp/webinar-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:36:\"[\"Events\",\"Landing Pages\",\"Webinar\"]\";s:10:\"menu_order\";i:46;s:16:\"popularity_index\";i:821;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:294;a:18:{s:4:\"tmpl\";i:1413;s:2:\"id\";i:24049;s:5:\"title\";s:33:\"ECO Shop &#8211; Maintenance Mode\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/04/Maintenance-Mode-ECO-Shop.jpg\";s:12:\"tmpl_created\";i:1649882053;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/eco-shop-maintenance-mode/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:110:\"[\"Aesthetic\",\"Business\",\"Creative\",\"Decor\",\"Health\",\"Help\",\"Lifestyle\",\"Products\",\"Shop\",\"Under Construction\"]\";s:10:\"menu_order\";i:46;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:295;a:18:{s:4:\"tmpl\";i:497;s:2:\"id\";i:5397;s:5:\"title\";s:8:\"About 11\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_1.png\";s:12:\"tmpl_created\";i:1520443503;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-11/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:46;s:16:\"popularity_index\";i:148;s:11:\"trend_index\";i:43;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:296;a:18:{s:4:\"tmpl\";i:1154;s:2:\"id\";i:17079;s:5:\"title\";s:42:\"Calls Volunteer &#8211; Social Involvement\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2021/01/Calls-Volunteer.png\";s:12:\"tmpl_created\";i:1610631774;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/lp/calls-volunteer-social-involvement/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:18:\"Social Involvement\";s:4:\"tags\";s:68:\"[\"Care\",\"Covid-19\",\"Help\",\"Involvement\",\"Landing Pages\",\"Volunteer\"]\";s:10:\"menu_order\";i:47;s:16:\"popularity_index\";i:854;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:297;a:18:{s:4:\"tmpl\";i:1419;s:2:\"id\";i:24136;s:5:\"title\";s:29:\"Food Blog &#8211; Coming Soon\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Food-Blog.jpg\";s:12:\"tmpl_created\";i:1650990034;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/food-blog-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:62:\"[\"Blog\",\"Business\",\"Coming Soon\",\"Cooking\",\"Education\",\"Food\"]\";s:10:\"menu_order\";i:47;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:298;a:18:{s:4:\"tmpl\";i:1142;s:2:\"id\";i:16836;s:5:\"title\";s:33:\"Marketing Agency &#8211; Business\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2021/01/Marketing-Agency-Library-Pic.jpg\";s:12:\"tmpl_created\";i:1610464490;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/marketing-agency-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:74:\"[\"Agency\",\"Business\",\"Landing Pages\",\"Marketing\",\"Marketing Landing Page\"]\";s:10:\"menu_order\";i:48;s:16:\"popularity_index\";i:816;s:11:\"trend_index\";i:787;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:299;a:18:{s:4:\"tmpl\";i:1411;s:2:\"id\";i:24020;s:5:\"title\";s:35:\"Mobile App &#8211; Maintenance Mode\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/04/Maintenance-Mode-Mobile-App.jpg\";s:12:\"tmpl_created\";i:1649880955;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/mobile-app-maintenance-mode/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:77:\"[\"App\",\"Business\",\"Coding\",\"Computer\",\"Launch\",\"Mobile\",\"Under Construction\"]\";s:10:\"menu_order\";i:48;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:300;a:18:{s:4:\"tmpl\";i:498;s:2:\"id\";i:5405;s:5:\"title\";s:8:\"About 12\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_1.png\";s:12:\"tmpl_created\";i:1520443505;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-12/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:48;s:16:\"popularity_index\";i:216;s:11:\"trend_index\";i:50;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:301;a:18:{s:4:\"tmpl\";i:1139;s:2:\"id\";i:16785;s:5:\"title\";s:42:\"Gym Promotion &#8211; Health &amp; Fitness\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2021/01/Gym-LP.jpg\";s:12:\"tmpl_created\";i:1610455496;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/lp/gym-promotion-health-fitness/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:18:\"Health and Fitness\";s:4:\"tags\";s:42:\"[\"Fitness\",\"Gym\",\"Health\",\"Landing Pages\"]\";s:10:\"menu_order\";i:49;s:16:\"popularity_index\";i:820;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:302;a:18:{s:4:\"tmpl\";i:1420;s:2:\"id\";i:24152;s:5:\"title\";s:32:\"Perfume Shop &#8211; Coming Soon\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Perfume-Shop.jpg\";s:12:\"tmpl_created\";i:1650990353;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/perfume-shop-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:68:\"[\"Business\",\"Coming Soon\",\"Cosmetics\",\"Lifestyle\",\"Products\",\"Shop\"]\";s:10:\"menu_order\";i:49;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:303;a:18:{s:4:\"tmpl\";i:1185;s:2:\"id\";i:18492;s:5:\"title\";s:34:\"Bicycle Pre-Sale &#8211; eCommerce\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Bike-Landing-Page.png\";s:12:\"tmpl_created\";i:1617535552;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/lp/bicycle-pre-sale-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:34:\"[\"Bicycle\",\"Landing Pages\",\"Sale\"]\";s:10:\"menu_order\";i:50;s:16:\"popularity_index\";i:871;s:11:\"trend_index\";i:826;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:304;a:18:{s:4:\"tmpl\";i:1418;s:2:\"id\";i:24126;s:5:\"title\";s:28:\"Skincare &#8211; Coming Soon\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Skincare.jpg\";s:12:\"tmpl_created\";i:1650989585;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/skincare-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:128:\"[\"Aesthetic\",\"Beauty\",\"Beauty Salon\",\"Business\",\"Coming Soon\",\"Cosmetics\",\"Girly\",\"Lifestyle\",\"Services\",\"Skincare\",\"Treatment\"]\";s:10:\"menu_order\";i:51;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:305;a:18:{s:4:\"tmpl\";i:1181;s:2:\"id\";i:18349;s:5:\"title\";s:39:\"Virtual try-on glasses &#8211; Business\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/03/250x280-8.png\";s:12:\"tmpl_created\";i:1614772569;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/lp/virtual-try-on-glasses-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:64:\"[\"Fashion\",\"Glasses\",\"Landing Pages\",\"Online Service\",\"Virtual\"]\";s:10:\"menu_order\";i:51;s:16:\"popularity_index\";i:848;s:11:\"trend_index\";i:803;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:306;a:18:{s:4:\"tmpl\";i:500;s:2:\"id\";i:5421;s:5:\"title\";s:8:\"About 13\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_3.png\";s:12:\"tmpl_created\";i:1520443509;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-13/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:51;s:16:\"popularity_index\";i:215;s:11:\"trend_index\";i:77;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:307;a:18:{s:4:\"tmpl\";i:513;s:2:\"id\";i:5533;s:5:\"title\";s:8:\"About 15\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_10.png\";s:12:\"tmpl_created\";i:1520443534;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-15/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:52;s:16:\"popularity_index\";i:21;s:11:\"trend_index\";i:57;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:308;a:18:{s:4:\"tmpl\";i:1410;s:2:\"id\";i:24004;s:5:\"title\";s:33:\"Skincare &#8211; Maintenance Mode\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/04/Maintenance-Mode-Skincare.jpg\";s:12:\"tmpl_created\";i:1649880534;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/skincare-maintenance-mode/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:144:\"[\"Aesthetic\",\"Beauty\",\"Beauty Salon\",\"Business\",\"Cosmetics\",\"Girly\",\"Lifestyle\",\"Makeup\",\"Services\",\"Skincare\",\"Treatment\",\"Under Construction\"]\";s:10:\"menu_order\";i:52;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:309;a:18:{s:4:\"tmpl\";i:1172;s:2:\"id\";i:17458;s:5:\"title\";s:31:\"Moving Company &#8211; Business\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2021/02/Library-Pic-Moving-Company.png\";s:12:\"tmpl_created\";i:1612727025;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/lp/moving-company-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:46:\"[\"Business\",\"Landing Pages\",\"Movers\",\"Moving\"]\";s:10:\"menu_order\";i:52;s:16:\"popularity_index\";i:826;s:11:\"trend_index\";i:767;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:310;a:18:{s:4:\"tmpl\";i:1415;s:2:\"id\";i:24092;s:5:\"title\";s:29:\"Vase Shop &#8211; Coming Soon\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Vase-Shop.jpg\";s:12:\"tmpl_created\";i:1650988613;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/vase-shop-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:115:\"[\"Art\",\"Business\",\"Coming Soon\",\"Creative\",\"Decor\",\"Design\",\"Furniture Design\",\"Interior Design\",\"Products\",\"Shop\"]\";s:10:\"menu_order\";i:53;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:311;a:18:{s:4:\"tmpl\";i:1186;s:2:\"id\";i:18517;s:5:\"title\";s:29:\"Food Blog &#8211; Coming Soon\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Food-Blog.png\";s:12:\"tmpl_created\";i:1617539897;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/lp/food-blog-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:45:\"[\"Blog\",\"Coming Soon\",\"Food\",\"Landing Pages\"]\";s:10:\"menu_order\";i:53;s:16:\"popularity_index\";i:844;s:11:\"trend_index\";i:672;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:312;a:18:{s:4:\"tmpl\";i:1167;s:2:\"id\";i:17379;s:5:\"title\";s:33:\"IT Service &#8211; Online Service\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2021/02/Library-Pic-IT-Service.png\";s:12:\"tmpl_created\";i:1612713022;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/it-service-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:41:\"[\"IT\",\"Landing Pages\",\"Remote\",\"Support\"]\";s:10:\"menu_order\";i:54;s:16:\"popularity_index\";i:806;s:11:\"trend_index\";i:634;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:313;a:18:{s:4:\"tmpl\";i:1248;s:2:\"id\";i:22134;s:5:\"title\";s:32:\"Art Magazine &#8211; Coming Soon\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/10/Art-Magazine-Coming-Soon-250x280-1.jpg\";s:12:\"tmpl_created\";i:1647176713;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/art-magazine-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:48:\"[\"Art\",\"Coming Soon\",\"Landing Pages\",\"Magazine\"]\";s:10:\"menu_order\";i:54;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:314;a:18:{s:4:\"tmpl\";i:512;s:2:\"id\";i:5525;s:5:\"title\";s:8:\"About 14\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_10.png\";s:12:\"tmpl_created\";i:1520443532;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-14/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:55;s:16:\"popularity_index\";i:9;s:11:\"trend_index\";i:29;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:315;a:18:{s:4:\"tmpl\";i:1189;s:2:\"id\";i:18560;s:5:\"title\";s:52:\"Finance Learning Platform &#8211; Under Construction\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Finance-Platform.png\";s:12:\"tmpl_created\";i:1617542761;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/lp/finance-learning-platform-under-construction/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:18:\"Under Construction\";s:4:\"tags\";s:27:\"[\"Finance\",\"Landing Pages\"]\";s:10:\"menu_order\";i:55;s:16:\"popularity_index\";i:843;s:11:\"trend_index\";i:561;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:316;a:18:{s:4:\"tmpl\";i:1225;s:2:\"id\";i:21041;s:5:\"title\";s:41:\"Business Consulting Company &#8211; About\";s:9:\"thumbnail\";s:96:\"https://library.elementor.com/wp-content/uploads/2021/12/8-About-Business-Consulting-Company.jpg\";s:12:\"tmpl_created\";i:1638797560;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/business-consulting-company-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:51:\"[\"Coach\",\"Collaboration\",\"Consulting\",\"Life Coach\"]\";s:10:\"menu_order\";i:55;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:317;a:18:{s:4:\"tmpl\";i:1187;s:2:\"id\";i:18528;s:5:\"title\";s:36:\"Home Decor Store &#8211; Coming Soon\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Home-Decore.png\";s:12:\"tmpl_created\";i:1617541784;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/lp/home-decor-store-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:57:\"[\"Coming Soon\",\"Decor\",\"Interior Design\",\"Landing Pages\"]\";s:10:\"menu_order\";i:56;s:16:\"popularity_index\";i:872;s:11:\"trend_index\";i:819;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:318;a:18:{s:4:\"tmpl\";i:1243;s:2:\"id\";i:21135;s:5:\"title\";s:28:\"Construction &#8211; Service\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/12/13-Service-Construction.jpg\";s:12:\"tmpl_created\";i:1638823202;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/construction-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:48:\"[\"Architecture\",\"Construction\",\"Faq\",\"Services\"]\";s:10:\"menu_order\";i:56;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:319;a:18:{s:4:\"tmpl\";i:501;s:2:\"id\";i:5429;s:5:\"title\";s:8:\"About 16\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_4.png\";s:12:\"tmpl_created\";i:1520443510;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-16/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:56;s:16:\"popularity_index\";i:59;s:11:\"trend_index\";i:8;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:320;a:18:{s:4:\"tmpl\";i:1174;s:2:\"id\";i:17504;s:5:\"title\";s:29:\"Hair Stylist &#8211; Business\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/02/250x280-3.png\";s:12:\"tmpl_created\";i:1612883014;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/lp/hair-stylist-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:59:\"[\"Business\",\"Hair\",\"hairdresser\",\"Landing Pages\",\"Stylist\"]\";s:10:\"menu_order\";i:57;s:16:\"popularity_index\";i:840;s:11:\"trend_index\";i:806;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:321;a:18:{s:4:\"tmpl\";i:1223;s:2:\"id\";i:20981;s:5:\"title\";s:37:\"Creative Digital Agency &#8211; About\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2021/12/6-About-Creative-Digital-Agency.jpg\";s:12:\"tmpl_created\";i:1638789303;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/creative-digital-agency-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:51:\"[\"About\",\"Advisor\",\"Creative\",\"Creative Portfolio\"]\";s:10:\"menu_order\";i:57;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:322;a:18:{s:4:\"tmpl\";i:1184;s:2:\"id\";i:18449;s:5:\"title\";s:45:\"Aesthetic Clinic &#8211; Health &amp; Fitness\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2021/03/Aesthetic-Clinic.png\";s:12:\"tmpl_created\";i:1616682181;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/lp/aesthetic-clinic-health-fitness/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:18:\"Health and Fitness\";s:4:\"tags\";s:57:\"[\"Aesthetic\",\"Beauty\",\"Fitness\",\"Health\",\"Landing Pages\"]\";s:10:\"menu_order\";i:58;s:16:\"popularity_index\";i:859;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:323;a:18:{s:4:\"tmpl\";i:1221;s:2:\"id\";i:20926;s:5:\"title\";s:33:\"Doctors Online Consultation -Home\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/12/4-Home-Doctors-Online-Consultation.jpg\";s:12:\"tmpl_created\";i:1638787371;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/doctors-online-consultation-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:35:\"[\"App\",\"Health\",\"Medical\",\"Online\"]\";s:10:\"menu_order\";i:58;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:324;a:18:{s:4:\"tmpl\";i:505;s:2:\"id\";i:5464;s:5:\"title\";s:8:\"About 17\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_6.png\";s:12:\"tmpl_created\";i:1520443518;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-17/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:58;s:16:\"popularity_index\";i:220;s:11:\"trend_index\";i:142;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:325;a:18:{s:4:\"tmpl\";i:1165;s:2:\"id\";i:17353;s:5:\"title\";s:44:\"Online Cooking Course &#8211; Online Service\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/02/250x280-2.png\";s:12:\"tmpl_created\";i:1612705144;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/lp/online-cooking-course-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:50:\"[\"Cooking\",\"Course Online\",\"Food\",\"Landing Pages\"]\";s:10:\"menu_order\";i:59;s:16:\"popularity_index\";i:845;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:326;a:18:{s:4:\"tmpl\";i:1188;s:2:\"id\";i:18550;s:5:\"title\";s:39:\"Online Store &#8211; Under Construction\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Online-Store.png\";s:12:\"tmpl_created\";i:1617542506;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/lp/online-store-under-construction/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:18:\"Under Construction\";s:4:\"tags\";s:59:\"[\"Landing Pages\",\"Online Shop\",\"Shop\",\"Under Construction\"]\";s:10:\"menu_order\";i:60;s:16:\"popularity_index\";i:832;s:11:\"trend_index\";i:600;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:327;a:18:{s:4:\"tmpl\";i:1250;s:2:\"id\";i:22140;s:5:\"title\";s:33:\"Design School &#8211; Coming Soon\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/05/250x280-1.png\";s:12:\"tmpl_created\";i:1647177317;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/design-school-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:49:\"[\"Coming Soon\",\"Design\",\"Landing Pages\",\"School\"]\";s:10:\"menu_order\";i:60;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:328;a:18:{s:4:\"tmpl\";i:510;s:2:\"id\";i:5504;s:5:\"title\";s:8:\"About 18\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_9.png\";s:12:\"tmpl_created\";i:1520443528;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-18/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:60;s:16:\"popularity_index\";i:104;s:11:\"trend_index\";i:46;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:329;a:18:{s:4:\"tmpl\";i:1191;s:2:\"id\";i:18539;s:5:\"title\";s:40:\"Travel Agency &#8211; Under Construction\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Travel-Agency-1.png\";s:12:\"tmpl_created\";i:1617610273;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/travel-agency-under-construction/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:18:\"Under Construction\";s:4:\"tags\";s:56:\"[\"Agency\",\"Landing Pages\",\"Travel\",\"Under Construction\"]\";s:10:\"menu_order\";i:61;s:16:\"popularity_index\";i:876;s:11:\"trend_index\";i:652;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:330;a:18:{s:4:\"tmpl\";i:1175;s:2:\"id\";i:18270;s:5:\"title\";s:24:\"Open week &#8211; Events\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2021/03/250x280.png\";s:12:\"tmpl_created\";i:1614767186;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/lp/open-week-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:59:\"[\"Education\",\"Event\",\"Events\",\"Landing Pages\",\"University\"]\";s:10:\"menu_order\";i:62;s:16:\"popularity_index\";i:831;s:11:\"trend_index\";i:673;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:331;a:18:{s:4:\"tmpl\";i:1177;s:2:\"id\";i:18300;s:5:\"title\";s:30:\"Makeup Artist &#8211; Business\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/03/250x280-2.png\";s:12:\"tmpl_created\";i:1614768608;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/makeup-artist-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:79:\"[\"Beauty\",\"Business\",\"Course Online\",\"Landing Pages\",\"Makeup\",\"Online Service\"]\";s:10:\"menu_order\";i:63;s:16:\"popularity_index\";i:861;s:11:\"trend_index\";i:783;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:332;a:18:{s:4:\"tmpl\";i:511;s:2:\"id\";i:5515;s:5:\"title\";s:8:\"About 19\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_9.png\";s:12:\"tmpl_created\";i:1520443530;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-19/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:63;s:16:\"popularity_index\";i:268;s:11:\"trend_index\";i:161;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:333;a:18:{s:4:\"tmpl\";i:1179;s:2:\"id\";i:18329;s:5:\"title\";s:63:\"Online Real Estate Investment Conference &#8211; Online Service\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/03/250x280-5.png\";s:12:\"tmpl_created\";i:1614770404;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:157:\"https://library.elementor.com/lp/online-real-estate-investment-conference-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:76:\"[\"Conference\",\"Event\",\"Events\",\"Landing Pages\",\"Online Event\",\"Real estate\"]\";s:10:\"menu_order\";i:64;s:16:\"popularity_index\";i:866;s:11:\"trend_index\";i:779;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:334;a:18:{s:4:\"tmpl\";i:506;s:2:\"id\";i:5472;s:5:\"title\";s:7:\"About 2\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_7.png\";s:12:\"tmpl_created\";i:1520443520;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/about-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:64;s:16:\"popularity_index\";i:210;s:11:\"trend_index\";i:116;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:335;a:18:{s:4:\"tmpl\";i:1183;s:2:\"id\";i:18391;s:5:\"title\";s:45:\"Children&#8217;s Optometrist &#8211; Business\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2021/03/Library-Pic-Childrens-Optometrist.png\";s:12:\"tmpl_created\";i:1614773564;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/lp/childrens-optometrist-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:85:\"[\"Business\",\"Children\",\"Eye\",\"Glasses\",\"Health\",\"Kids\",\"Landing Pages\",\"Optometrist\"]\";s:10:\"menu_order\";i:65;s:16:\"popularity_index\";i:877;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:336;a:18:{s:4:\"tmpl\";i:1182;s:2:\"id\";i:18366;s:5:\"title\";s:30:\"Car Insurance &#8211; Business\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/03/Library-Pic-Car-Insurance.png\";s:12:\"tmpl_created\";i:1614773263;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/car-insurance-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:46:\"[\"Business\",\"car\",\"Insurance\",\"Landing Pages\"]\";s:10:\"menu_order\";i:66;s:16:\"popularity_index\";i:869;s:11:\"trend_index\";i:797;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:337;a:18:{s:4:\"tmpl\";i:1201;s:2:\"id\";i:19144;s:5:\"title\";s:25:\"Birthday Party Invitation\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2021/06/250x280.png\";s:12:\"tmpl_created\";i:1623848691;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/birthday-party-invitation/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:67:\"[\"Birthday\",\"Event\",\"Landing Pages\",\"Party\",\"RSVD\",\"Save the Date\"]\";s:10:\"menu_order\";i:66;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:338;a:18:{s:4:\"tmpl\";i:1124;s:2:\"id\";i:16473;s:5:\"title\";s:26:\"Beauty Salon &#8211; About\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/12/about-1.jpg\";s:12:\"tmpl_created\";i:1608622373;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/beauty-salon-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:23:\"[\"Beauty Salon\",\"Hair\"]\";s:10:\"menu_order\";i:67;s:16:\"popularity_index\";i:615;s:11:\"trend_index\";i:184;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:339;a:18:{s:4:\"tmpl\";i:1176;s:2:\"id\";i:18291;s:5:\"title\";s:47:\"Grill Restaurant Food Delivery &#8211; Business\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2021/03/Library-Pic-Food-Delivery-LP.png\";s:12:\"tmpl_created\";i:1614767830;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/lp/grill-restaurant-food-delivery-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:79:\"[\"Delivery\",\"Delivery Service\",\"Fast Food\",\"Food\",\"Landing Pages\",\"Restaurant\"]\";s:10:\"menu_order\";i:67;s:16:\"popularity_index\";i:819;s:11:\"trend_index\";i:685;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:340;a:18:{s:4:\"tmpl\";i:504;s:2:\"id\";i:5455;s:5:\"title\";s:8:\"About 20\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_6.png\";s:12:\"tmpl_created\";i:1520443516;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-20/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:67;s:16:\"popularity_index\";i:134;s:11:\"trend_index\";i:70;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:341;a:18:{s:4:\"tmpl\";i:1125;s:2:\"id\";i:16488;s:5:\"title\";s:28:\"Beauty Salon &#8211; Contact\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/12/contact.jpg\";s:12:\"tmpl_created\";i:1608622374;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/beauty-salon-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:23:\"[\"Beauty Salon\",\"Hair\"]\";s:10:\"menu_order\";i:68;s:16:\"popularity_index\";i:548;s:11:\"trend_index\";i:101;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:342;a:18:{s:4:\"tmpl\";i:1180;s:2:\"id\";i:18340;s:5:\"title\";s:30:\"Restaurant &#8211; Coming Soon\";s:9:\"thumbnail\";s:98:\"https://library.elementor.com/wp-content/uploads/2021/03/Library-Pic-Restuarant-Coming-Soon-LP.png\";s:12:\"tmpl_created\";i:1614772183;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/restaurant-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:51:\"[\"Coming Soon\",\"Food\",\"Landing Pages\",\"Restaurant\"]\";s:10:\"menu_order\";i:68;s:16:\"popularity_index\";i:810;s:11:\"trend_index\";i:809;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:343;a:18:{s:4:\"tmpl\";i:499;s:2:\"id\";i:5413;s:5:\"title\";s:8:\"About 21\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_2.png\";s:12:\"tmpl_created\";i:1520443507;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-21/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:68;s:16:\"popularity_index\";i:83;s:11:\"trend_index\";i:52;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:344;a:18:{s:4:\"tmpl\";i:1126;s:2:\"id\";i:16496;s:5:\"title\";s:28:\"Beauty Salon &#8211; Gallery\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/12/gallery-1.jpg\";s:12:\"tmpl_created\";i:1608622379;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/beauty-salon-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:23:\"[\"Beauty Salon\",\"Hair\"]\";s:10:\"menu_order\";i:69;s:16:\"popularity_index\";i:491;s:11:\"trend_index\";i:90;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:345;a:18:{s:4:\"tmpl\";i:1173;s:2:\"id\";i:17480;s:5:\"title\";s:42:\"At-home Massage Therapist &#8211; Business\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/02/At-Home-Massage-Therapist.jpg\";s:12:\"tmpl_created\";i:1612879264;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/lp/at-home-massage-therapist-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:60:\"[\"Business\",\"Health\",\"Landing Pages\",\"Services\",\"Therapist\"]\";s:10:\"menu_order\";i:69;s:16:\"popularity_index\";i:856;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:346;a:18:{s:4:\"tmpl\";i:1127;s:2:\"id\";i:16457;s:5:\"title\";s:25:\"Beauty Salon &#8211; Home\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/12/home-1.jpg\";s:12:\"tmpl_created\";i:1608622383;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/beauty-salon-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:23:\"[\"Beauty Salon\",\"Hair\"]\";s:10:\"menu_order\";i:70;s:16:\"popularity_index\";i:408;s:11:\"trend_index\";i:56;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:347;a:18:{s:4:\"tmpl\";i:1178;s:2:\"id\";i:18317;s:5:\"title\";s:26:\"Insurance &#8211; Business\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2021/03/Library-Pic-Life-Insirance.png\";s:12:\"tmpl_created\";i:1614769488;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/lp/insurance-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:61:\"[\"Business\",\"Family\",\"Financial\",\"Insurance\",\"Landing Pages\"]\";s:10:\"menu_order\";i:70;s:16:\"popularity_index\";i:870;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:348;a:18:{s:4:\"tmpl\";i:1128;s:2:\"id\";i:16518;s:5:\"title\";s:29:\"Beauty Salon &#8211; Services\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/12/services-1.jpg\";s:12:\"tmpl_created\";i:1608622386;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/beauty-salon-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:23:\"[\"Beauty Salon\",\"Hair\"]\";s:10:\"menu_order\";i:71;s:16:\"popularity_index\";i:664;s:11:\"trend_index\";i:261;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:349;a:18:{s:4:\"tmpl\";i:1168;s:2:\"id\";i:17401;s:5:\"title\";s:40:\"Conference Thank You Page &#8211; Events\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2021/02/250x280.png\";s:12:\"tmpl_created\";i:1612724753;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/conference-thank-you-page-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Thank You Page\";s:4:\"tags\";s:59:\"[\"Conference\",\"Event\",\"Events\",\"Landing Pages\",\"Thank You\"]\";s:10:\"menu_order\";i:71;s:16:\"popularity_index\";i:799;s:11:\"trend_index\";i:540;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:350;a:18:{s:4:\"tmpl\";i:503;s:2:\"id\";i:5447;s:5:\"title\";s:7:\"About 3\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_5.png\";s:12:\"tmpl_created\";i:1520443514;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/about-3-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:71;s:16:\"popularity_index\";i:48;s:11:\"trend_index\";i:12;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:351;a:18:{s:4:\"tmpl\";i:1073;s:2:\"id\";i:15486;s:5:\"title\";s:25:\"Travel Blog &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/11/About.jpg\";s:12:\"tmpl_created\";i:1606215720;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/travel-blog-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:72;s:16:\"popularity_index\";i:608;s:11:\"trend_index\";i:343;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:352;a:18:{s:4:\"tmpl\";i:1166;s:2:\"id\";i:17368;s:5:\"title\";s:38:\"Real Estate Agency &#8211; Real-Estate\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/02/Library-Pic-Real-Estate.png\";s:12:\"tmpl_created\";i:1612711814;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/lp/real-estate-agency-real-estate/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:11:\"Real Estate\";s:4:\"tags\";s:73:\"[\"Landing Pages\",\"listing\",\"Real estate\",\"Realestate\",\"realtor\",\"realty\"]\";s:10:\"menu_order\";i:72;s:16:\"popularity_index\";i:858;s:11:\"trend_index\";i:777;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:353;a:18:{s:4:\"tmpl\";i:1074;s:2:\"id\";i:15478;s:5:\"title\";s:27:\"Travel Blog &#8211; Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/11/Contact-Us.jpg\";s:12:\"tmpl_created\";i:1606215735;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/travel-blog-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:73;s:16:\"popularity_index\";i:687;s:11:\"trend_index\";i:564;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:354;a:18:{s:4:\"tmpl\";i:1170;s:2:\"id\";i:17423;s:5:\"title\";s:57:\"Volunteer Calls Thank You Page &#8211; Social Involvement\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2021/02/Volunteer-Calls-TYP.jpg\";s:12:\"tmpl_created\";i:1612726058;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:151:\"https://library.elementor.com/lp/volunteer-calls-thank-you-page-social-involvement/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Thank You Page\";s:4:\"tags\";s:62:\"[\"Care\",\"Involvement\",\"Landing Pages\",\"Thank You\",\"Volunteer\"]\";s:10:\"menu_order\";i:73;s:16:\"popularity_index\";i:857;s:11:\"trend_index\";i:818;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:355;a:18:{s:4:\"tmpl\";i:507;s:2:\"id\";i:5480;s:5:\"title\";s:7:\"About 4\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_7-1.png\";s:12:\"tmpl_created\";i:1520443522;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/about-4-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:73;s:16:\"popularity_index\";i:428;s:11:\"trend_index\";i:303;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:356;a:18:{s:4:\"tmpl\";i:1075;s:2:\"id\";i:15467;s:5:\"title\";s:24:\"Travel Blog &#8211; Home\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/11/Home.jpg\";s:12:\"tmpl_created\";i:1606215756;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/travel-blog-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:74;s:16:\"popularity_index\";i:567;s:11:\"trend_index\";i:224;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:357;a:18:{s:4:\"tmpl\";i:1169;s:2:\"id\";i:17409;s:5:\"title\";s:37:\"Webinar Thank You Page &#8211; Events\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/02/Library-Pic-Webinar-TYP.png\";s:12:\"tmpl_created\";i:1612725644;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/lp/webinar-thank-you-page-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Thank You Page\";s:4:\"tags\";s:56:\"[\"Event\",\"Events\",\"Landing Pages\",\"Thank You\",\"Webinar\"]\";s:10:\"menu_order\";i:74;s:16:\"popularity_index\";i:868;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:358;a:18:{s:4:\"tmpl\";i:1056;s:2:\"id\";i:15317;s:5:\"title\";s:25:\"Dance Studio &#8211; Home\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/10/Home.jpg\";s:12:\"tmpl_created\";i:1603181291;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/dance-studio-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:16:\"[\"Dance Studio\"]\";s:10:\"menu_order\";i:75;s:16:\"popularity_index\";i:596;s:11:\"trend_index\";i:301;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:359;a:18:{s:4:\"tmpl\";i:545;s:2:\"id\";i:6027;s:5:\"title\";s:7:\"About 5\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_1-1.png\";s:12:\"tmpl_created\";i:1520443639;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/about-5-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:75;s:16:\"popularity_index\";i:40;s:11:\"trend_index\";i:40;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:360;a:18:{s:4:\"tmpl\";i:1160;s:2:\"id\";i:17258;s:5:\"title\";s:32:\"Beauty Product &#8211; eCommerce\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2021/01/Beauty-Product.png\";s:12:\"tmpl_created\";i:1610903153;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/beauty-product-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:38:\"[\"Beauty\",\"Ecommerce\",\"Landing Pages\"]\";s:10:\"menu_order\";i:75;s:16:\"popularity_index\";i:797;s:11:\"trend_index\";i:703;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:361;a:18:{s:4:\"tmpl\";i:1057;s:2:\"id\";i:15334;s:5:\"title\";s:26:\"Dance Studio &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/10/About.jpg\";s:12:\"tmpl_created\";i:1603181364;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/dance-studio-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:16:\"[\"Dance Studio\"]\";s:10:\"menu_order\";i:76;s:16:\"popularity_index\";i:626;s:11:\"trend_index\";i:373;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:362;a:18:{s:4:\"tmpl\";i:546;s:2:\"id\";i:6036;s:5:\"title\";s:7:\"About 6\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_1-1.png\";s:12:\"tmpl_created\";i:1520443641;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/about-6-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:76;s:16:\"popularity_index\";i:90;s:11:\"trend_index\";i:123;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:363;a:18:{s:4:\"tmpl\";i:1171;s:2:\"id\";i:17435;s:5:\"title\";s:39:\"Gym &#8211; App Service &#8211; Product\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/02/250x280-4.png\";s:12:\"tmpl_created\";i:1612726462;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/lp/gym-app-service-product/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:7:\"Product\";s:4:\"tags\";s:58:\"[\"App\",\"Fitness\",\"Gym\",\"Health\",\"Landing Pages\",\"Product\"]\";s:10:\"menu_order\";i:76;s:16:\"popularity_index\";i:767;s:11:\"trend_index\";i:577;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:364;a:18:{s:4:\"tmpl\";i:1058;s:2:\"id\";i:15349;s:5:\"title\";s:28:\"Dance Studio &#8211; Classes\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/10/Classes.jpg\";s:12:\"tmpl_created\";i:1603181425;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/dance-studio-classes/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:16:\"[\"Dance Studio\"]\";s:10:\"menu_order\";i:77;s:16:\"popularity_index\";i:629;s:11:\"trend_index\";i:458;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:365;a:18:{s:4:\"tmpl\";i:1156;s:2:\"id\";i:17111;s:5:\"title\";s:33:\"Sunglasses Sale &#8211; eCommerce\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/01/Sunglasses-LP-Library-Pic.jpg\";s:12:\"tmpl_created\";i:1610632408;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/sunglasses-sale-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:59:\"[\"Ecommerce\",\"Fashion\",\"Landing Pages\",\"Sale\",\"Sunglasses\"]\";s:10:\"menu_order\";i:77;s:16:\"popularity_index\";i:812;s:11:\"trend_index\";i:732;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:366;a:18:{s:4:\"tmpl\";i:1055;s:2:\"id\";i:15366;s:5:\"title\";s:29:\"Dance Studio &#8211; Schedule\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2020/10/Classes-Schedule.jpg\";s:12:\"tmpl_created\";i:1603181056;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/dance-studio-schedule/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:16:\"[\"Dance Studio\"]\";s:10:\"menu_order\";i:78;s:16:\"popularity_index\";i:698;s:11:\"trend_index\";i:602;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:367;a:18:{s:4:\"tmpl\";i:1157;s:2:\"id\";i:17223;s:5:\"title\";s:25:\"Fashion &#8211; eCommerce\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2021/01/Commerce-Fashion.png\";s:12:\"tmpl_created\";i:1610902553;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/lp/fashion-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:29:\"[\"Ecommerce\",\"Landing Pages\"]\";s:10:\"menu_order\";i:78;s:16:\"popularity_index\";i:808;s:11:\"trend_index\";i:745;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:368;a:18:{s:4:\"tmpl\";i:1059;s:2:\"id\";i:15373;s:5:\"title\";s:28:\"Dance Studio &#8211; Pricing\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/10/Pricing.jpg\";s:12:\"tmpl_created\";i:1603181678;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/dance-studio-pricing/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:16:\"[\"Dance Studio\"]\";s:10:\"menu_order\";i:79;s:16:\"popularity_index\";i:731;s:11:\"trend_index\";i:661;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:369;a:18:{s:4:\"tmpl\";i:1151;s:2:\"id\";i:17017;s:5:\"title\";s:28:\"Shoes Sale &#8211; eCommerce\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2021/01/Shoes-LP-Library-Pic.jpg\";s:12:\"tmpl_created\";i:1610535361;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/shoes-sale-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:55:\"[\"Discount\",\"Ecommerce\",\"Landing Pages\",\"Sale\",\"Shoes\"]\";s:10:\"menu_order\";i:79;s:16:\"popularity_index\";i:803;s:11:\"trend_index\";i:642;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:370;a:18:{s:4:\"tmpl\";i:508;s:2:\"id\";i:5488;s:5:\"title\";s:7:\"About 7\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_8.png\";s:12:\"tmpl_created\";i:1520443524;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/about-7/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:79;s:16:\"popularity_index\";i:307;s:11:\"trend_index\";i:169;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:371;a:18:{s:4:\"tmpl\";i:1060;s:2:\"id\";i:15384;s:5:\"title\";s:28:\"Dance Studio &#8211; Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/10/Contact-Us.jpg\";s:12:\"tmpl_created\";i:1603181738;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/dance-studio-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:16:\"[\"Dance Studio\"]\";s:10:\"menu_order\";i:80;s:16:\"popularity_index\";i:741;s:11:\"trend_index\";i:721;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:372;a:18:{s:4:\"tmpl\";i:556;s:2:\"id\";i:6122;s:5:\"title\";s:7:\"About 8\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_2-1.png\";s:12:\"tmpl_created\";i:1520443661;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/about-8/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:80;s:16:\"popularity_index\";i:38;s:11:\"trend_index\";i:26;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:373;a:18:{s:4:\"tmpl\";i:1163;s:2:\"id\";i:17301;s:5:\"title\";s:53:\"Personal Chef &#8211; Thank You Page &#8211; Business\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2021/01/TYP-Personal-Chef.jpg\";s:12:\"tmpl_created\";i:1610903622;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/lp/personal-chef-thank-you-page-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Thank You Page\";s:4:\"tags\";s:43:\"[\"Chef\",\"Food\",\"Landing Pages\",\"Thank You\"]\";s:10:\"menu_order\";i:80;s:16:\"popularity_index\";i:823;s:11:\"trend_index\";i:754;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:374;a:18:{s:4:\"tmpl\";i:1042;s:2:\"id\";i:15158;s:5:\"title\";s:26:\"Psychologist &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/09/About.jpg\";s:12:\"tmpl_created\";i:1600157561;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/psychologist-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:81;s:16:\"popularity_index\";i:618;s:11:\"trend_index\";i:426;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:375;a:18:{s:4:\"tmpl\";i:1164;s:2:\"id\";i:17313;s:5:\"title\";s:60:\"Development Course  &#8211; Thank You Page &#8211; Education\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2021/01/Dev-Course-TYP-.png\";s:12:\"tmpl_created\";i:1610903776;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/lp/development-course-thank-you-page-education/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Thank You Page\";s:4:\"tags\";s:57:\"[\"Course Online\",\"Education\",\"Landing Pages\",\"Thank You\"]\";s:10:\"menu_order\";i:81;s:16:\"popularity_index\";i:834;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:376;a:18:{s:4:\"tmpl\";i:1045;s:2:\"id\";i:15197;s:5:\"title\";s:28:\"Psychologist &#8211; Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/09/Contact-Us.jpg\";s:12:\"tmpl_created\";i:1600160499;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/psychologist-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:82;s:16:\"popularity_index\";i:666;s:11:\"trend_index\";i:558;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:377;a:18:{s:4:\"tmpl\";i:509;s:2:\"id\";i:5496;s:5:\"title\";s:7:\"About 9\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_8-1.png\";s:12:\"tmpl_created\";i:1520443526;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/about-9/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:82;s:16:\"popularity_index\";i:523;s:11:\"trend_index\";i:453;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:378;a:18:{s:4:\"tmpl\";i:1041;s:2:\"id\";i:15142;s:5:\"title\";s:25:\"Psychologist &#8211; Home\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/09/Home.jpg\";s:12:\"tmpl_created\";i:1600156308;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/psychologist-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:83;s:16:\"popularity_index\";i:464;s:11:\"trend_index\";i:297;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:379;a:18:{s:4:\"tmpl\";i:1044;s:2:\"id\";i:15188;s:5:\"title\";s:28:\"Psychologist &#8211; Pricing\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/09/Pricing.jpg\";s:12:\"tmpl_created\";i:1600159731;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/psychologist-pricing/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:84;s:16:\"popularity_index\";i:732;s:11:\"trend_index\";i:537;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:380;a:18:{s:4:\"tmpl\";i:684;s:2:\"id\";i:8961;s:5:\"title\";s:9:\"archive 1\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.1.jpg\";s:12:\"tmpl_created\";i:1528639909;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/archive-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:84;s:16:\"popularity_index\";i:79;s:11:\"trend_index\";i:15;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:381;a:18:{s:4:\"tmpl\";i:1043;s:2:\"id\";i:15167;s:5:\"title\";s:29:\"Psychologist &#8211; Services\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/09/Services.jpg\";s:12:\"tmpl_created\";i:1600158206;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/psychologist-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:85;s:16:\"popularity_index\";i:606;s:11:\"trend_index\";i:379;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:382;a:18:{s:4:\"tmpl\";i:1036;s:2:\"id\";i:14932;s:5:\"title\";s:30:\"Flooring Company &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/08/About.png\";s:12:\"tmpl_created\";i:1597740110;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/flooring-company-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:86;s:16:\"popularity_index\";i:488;s:11:\"trend_index\";i:319;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:383;a:18:{s:4:\"tmpl\";i:685;s:2:\"id\";i:8969;s:5:\"title\";s:9:\"archive 2\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.2.jpg\";s:12:\"tmpl_created\";i:1528700014;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/archive-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:86;s:16:\"popularity_index\";i:250;s:11:\"trend_index\";i:124;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:384;a:18:{s:4:\"tmpl\";i:1037;s:2:\"id\";i:14998;s:5:\"title\";s:32:\"Flooring Company &#8211; Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/08/Contact-Us.png\";s:12:\"tmpl_created\";i:1597740222;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/flooring-company-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:87;s:16:\"popularity_index\";i:553;s:11:\"trend_index\";i:380;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:385;a:18:{s:4:\"tmpl\";i:1038;s:2:\"id\";i:14965;s:5:\"title\";s:32:\"Flooring Company &#8211; Gallery\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/08/Gallery.png\";s:12:\"tmpl_created\";i:1597740353;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/flooring-company-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:88;s:16:\"popularity_index\";i:371;s:11:\"trend_index\";i:291;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:386;a:18:{s:4:\"tmpl\";i:686;s:2:\"id\";i:8973;s:5:\"title\";s:9:\"archive 3\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.3.jpg\";s:12:\"tmpl_created\";i:1528700205;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/archive-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:88;s:16:\"popularity_index\";i:176;s:11:\"trend_index\";i:54;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:387;a:18:{s:4:\"tmpl\";i:1282;s:2:\"id\";i:22417;s:5:\"title\";s:52:\"Finance Learning Platform &#8211; Under Construction\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Finance-Platform.png\";s:12:\"tmpl_created\";i:1647354987;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/finance-learning-platform-under-construction/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Finance\",\"Landing Pages\"]\";s:10:\"menu_order\";i:89;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:388;a:18:{s:4:\"tmpl\";i:1040;s:2:\"id\";i:14947;s:5:\"title\";s:33:\"Flooring company &#8211; Services\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/08/Services.png\";s:12:\"tmpl_created\";i:1597740551;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/flooring-company-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:90;s:16:\"popularity_index\";i:538;s:11:\"trend_index\";i:392;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:389;a:18:{s:4:\"tmpl\";i:1039;s:2:\"id\";i:14901;s:5:\"title\";s:29:\"Flooring Company &#8211; Home\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/08/Home.png\";s:12:\"tmpl_created\";i:1597740474;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/flooring-company-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:91;s:16:\"popularity_index\";i:387;s:11:\"trend_index\";i:185;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:390;a:18:{s:4:\"tmpl\";i:687;s:2:\"id\";i:8977;s:5:\"title\";s:9:\"archive 4\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.4.jpg\";s:12:\"tmpl_created\";i:1528700326;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/archive-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:91;s:16:\"popularity_index\";i:354;s:11:\"trend_index\";i:396;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:391;a:18:{s:4:\"tmpl\";i:1252;s:2:\"id\";i:22146;s:5:\"title\";s:36:\"Home Decor Store &#8211; Coming Soon\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Home-Decore.png\";s:12:\"tmpl_created\";i:1647177514;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/home-decor-store-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:57:\"[\"Coming Soon\",\"Decor\",\"Interior Design\",\"Landing Pages\"]\";s:10:\"menu_order\";i:92;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:392;a:18:{s:4:\"tmpl\";i:688;s:2:\"id\";i:8981;s:5:\"title\";s:9:\"archive 5\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.5.jpg\";s:12:\"tmpl_created\";i:1528700484;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/archive-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:93;s:16:\"popularity_index\";i:333;s:11:\"trend_index\";i:195;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:393;a:18:{s:4:\"tmpl\";i:1021;s:2:\"id\";i:14737;s:5:\"title\";s:32:\"Luxury Real Estate &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/07/About.png\";s:12:\"tmpl_created\";i:1595313527;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/luxury-real-estate-about-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Real estate\",\"Realestate\"]\";s:10:\"menu_order\";i:93;s:16:\"popularity_index\";i:150;s:11:\"trend_index\";i:447;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:394;a:18:{s:4:\"tmpl\";i:689;s:2:\"id\";i:8985;s:5:\"title\";s:9:\"archive 6\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.6.jpg\";s:12:\"tmpl_created\";i:1528700612;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/archive-6/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:94;s:16:\"popularity_index\";i:204;s:11:\"trend_index\";i:95;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:395;a:18:{s:4:\"tmpl\";i:1020;s:2:\"id\";i:14756;s:5:\"title\";s:34:\"Luxury Real Estate &#8211; Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/07/Contact-Us.png\";s:12:\"tmpl_created\";i:1595313519;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/luxury-real-estate-contact-us-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Real estate\",\"Realestate\"]\";s:10:\"menu_order\";i:94;s:16:\"popularity_index\";i:610;s:11:\"trend_index\";i:569;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:396;a:18:{s:4:\"tmpl\";i:1019;s:2:\"id\";i:14716;s:5:\"title\";s:31:\"Luxury Real Estate &#8211; Home\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/07/Home.png\";s:12:\"tmpl_created\";i:1595313512;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/luxury-real-estate-home-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Real estate\",\"Realestate\"]\";s:10:\"menu_order\";i:95;s:16:\"popularity_index\";i:394;s:11:\"trend_index\";i:165;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:397;a:18:{s:4:\"tmpl\";i:690;s:2:\"id\";i:8989;s:5:\"title\";s:9:\"archive 7\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.7.jpg\";s:12:\"tmpl_created\";i:1528701063;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/archive-7/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:96;s:16:\"popularity_index\";i:208;s:11:\"trend_index\";i:111;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:398;a:18:{s:4:\"tmpl\";i:1018;s:2:\"id\";i:14763;s:5:\"title\";s:31:\"Luxury Real Estate &#8211; News\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2020/07/news-Archive.png\";s:12:\"tmpl_created\";i:1595313273;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/luxury-real-estate-news-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Real estate\",\"Realestate\"]\";s:10:\"menu_order\";i:96;s:16:\"popularity_index\";i:404;s:11:\"trend_index\";i:167;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:399;a:18:{s:4:\"tmpl\";i:1283;s:2:\"id\";i:22423;s:5:\"title\";s:39:\"Online Store &#8211; Under Construction\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Online-Store.png\";s:12:\"tmpl_created\";i:1647355154;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/online-store-under-construction/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:59:\"[\"Landing Pages\",\"Online Shop\",\"Shop\",\"Under Construction\"]\";s:10:\"menu_order\";i:97;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:400;a:18:{s:4:\"tmpl\";i:691;s:2:\"id\";i:8996;s:5:\"title\";s:9:\"archive 8\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.8.jpg\";s:12:\"tmpl_created\";i:1528701290;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/archive-8/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:98;s:16:\"popularity_index\";i:227;s:11:\"trend_index\";i:153;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:401;a:18:{s:4:\"tmpl\";i:1010;s:2:\"id\";i:13960;s:5:\"title\";s:32:\"Japanese restaurant &#8211; Home\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/06/Home-Page.jpg\";s:12:\"tmpl_created\";i:1592289775;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/japanese-restaurant-home-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:98;s:16:\"popularity_index\";i:537;s:11:\"trend_index\";i:287;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:402;a:18:{s:4:\"tmpl\";i:1284;s:2:\"id\";i:22428;s:5:\"title\";s:40:\"Travel Agency &#8211; Under Construction\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Travel-Agency-1.png\";s:12:\"tmpl_created\";i:1647355339;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/travel-agency-under-construction/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:56:\"[\"Agency\",\"Landing Pages\",\"Travel\",\"Under Construction\"]\";s:10:\"menu_order\";i:99;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:403;a:18:{s:4:\"tmpl\";i:692;s:2:\"id\";i:9001;s:5:\"title\";s:9:\"archive 9\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.9.jpg\";s:12:\"tmpl_created\";i:1528701433;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/archive-9/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:100;s:16:\"popularity_index\";i:265;s:11:\"trend_index\";i:208;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:404;a:18:{s:4:\"tmpl\";i:1007;s:2:\"id\";i:13993;s:5:\"title\";s:45:\"Japanese restaurant &#8211; Chef&#8217;s Menu\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2020/06/Chef_s-Menu-Page.jpg\";s:12:\"tmpl_created\";i:1592289691;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/japanese-restaurant-chefs-menu/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:100;s:16:\"popularity_index\";i:651;s:11:\"trend_index\";i:675;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:405;a:18:{s:4:\"tmpl\";i:1006;s:2:\"id\";i:14012;s:5:\"title\";s:36:\"Japanese restaurant &#8211; Bar Menu\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2020/06/Bar-Menu-Page.jpg\";s:12:\"tmpl_created\";i:1592289665;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/japanese-restaurant-bar-menu/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:101;s:16:\"popularity_index\";i:735;s:11:\"trend_index\";i:829;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:406;a:18:{s:4:\"tmpl\";i:1005;s:2:\"id\";i:13917;s:5:\"title\";s:33:\"Japanese restaurant &#8211; About\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/06/About-Page.jpg\";s:12:\"tmpl_created\";i:1592289629;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/japanese-restaurant-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:102;s:16:\"popularity_index\";i:640;s:11:\"trend_index\";i:389;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:407;a:18:{s:4:\"tmpl\";i:997;s:2:\"id\";i:13528;s:5:\"title\";s:22:\"Barbershop &#8211; 404\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/05/404-Page.jpg\";s:12:\"tmpl_created\";i:1589893152;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/blocks/barbershop-404/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:34:\"[\"404\",\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:103;s:16:\"popularity_index\";i:768;s:11:\"trend_index\";i:681;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:408;a:18:{s:4:\"tmpl\";i:1009;s:2:\"id\";i:13937;s:5:\"title\";s:35:\"Japanese restaurant &#8211; Gallery\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2020/06/Gallery-Page.jpg\";s:12:\"tmpl_created\";i:1592289748;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/japanese-restaurant-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:103;s:16:\"popularity_index\";i:648;s:11:\"trend_index\";i:551;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:409;a:18:{s:4:\"tmpl\";i:1008;s:2:\"id\";i:14030;s:5:\"title\";s:34:\"Japanese restaurant &#8211; Events\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/06/Events-Page.jpg\";s:12:\"tmpl_created\";i:1592289713;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/japanese-restaurant-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:104;s:16:\"popularity_index\";i:723;s:11:\"trend_index\";i:711;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:410;a:18:{s:4:\"tmpl\";i:998;s:2:\"id\";i:13518;s:5:\"title\";s:26:\"Barbershop &#8211; Archive\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/05/Blog-Page.jpg\";s:12:\"tmpl_created\";i:1589893157;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/blocks/barbershop-archive/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:105;s:16:\"popularity_index\";i:737;s:11:\"trend_index\";i:523;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:411;a:18:{s:4:\"tmpl\";i:1016;s:2:\"id\";i:13984;s:5:\"title\";s:40:\"Japanese restaurant &#8211; Reservations\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2020/06/reservations.jpg\";s:12:\"tmpl_created\";i:1592294757;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/japanese-restaurant-reservations/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:105;s:16:\"popularity_index\";i:715;s:11:\"trend_index\";i:727;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:412;a:18:{s:4:\"tmpl\";i:999;s:2:\"id\";i:13479;s:5:\"title\";s:23:\"Barbershop &#8211; Home\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/05/Home-Page.jpg\";s:12:\"tmpl_created\";i:1589893275;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/barbershop-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:106;s:16:\"popularity_index\";i:683;s:11:\"trend_index\";i:832;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:413;a:18:{s:4:\"tmpl\";i:996;s:2:\"id\";i:13604;s:5:\"title\";s:25:\"Barbershop &#8211; Footer\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2020/05/Footer-Small.jpg\";s:12:\"tmpl_created\";i:1589893147;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/blocks/barbershop-footer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:37:\"[\"Barber Shop\",\"Barbershop\",\"Footer\"]\";s:10:\"menu_order\";i:107;s:16:\"popularity_index\";i:555;s:11:\"trend_index\";i:267;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:414;a:18:{s:4:\"tmpl\";i:1000;s:2:\"id\";i:13503;s:5:\"title\";s:24:\"Barbershop &#8211; About\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/05/About-Page.jpg\";s:12:\"tmpl_created\";i:1589893289;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/barbershop-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:107;s:16:\"popularity_index\";i:744;s:11:\"trend_index\";i:739;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:415;a:18:{s:4:\"tmpl\";i:995;s:2:\"id\";i:13612;s:5:\"title\";s:25:\"Barbershop &#8211; Header\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2020/06/barber-shop-header.jpg\";s:12:\"tmpl_created\";i:1589893142;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/blocks/barbershop-header/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:37:\"[\"Barber Shop\",\"Barbershop\",\"Header\"]\";s:10:\"menu_order\";i:108;s:16:\"popularity_index\";i:343;s:11:\"trend_index\";i:137;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:416;a:18:{s:4:\"tmpl\";i:1001;s:2:\"id\";i:13548;s:5:\"title\";s:27:\"Barbershop &#8211; Services\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2020/05/Services-Page.jpg\";s:12:\"tmpl_created\";i:1589893298;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/barbershop-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:108;s:16:\"popularity_index\";i:761;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:417;a:18:{s:4:\"tmpl\";i:1002;s:2:\"id\";i:13560;s:5:\"title\";s:26:\"Barbershop &#8211; Gallery\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2020/05/Gallery-Page.jpg\";s:12:\"tmpl_created\";i:1589893307;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/barbershop-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:109;s:16:\"popularity_index\";i:756;s:11:\"trend_index\";i:822;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:418;a:18:{s:4:\"tmpl\";i:1003;s:2:\"id\";i:13587;s:5:\"title\";s:26:\"Barbershop &#8211; Contact\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2020/05/Contact-Us-Page.jpg\";s:12:\"tmpl_created\";i:1589893315;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/barbershop-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:110;s:16:\"popularity_index\";i:753;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:419;a:18:{s:4:\"tmpl\";i:982;s:2:\"id\";i:13307;s:5:\"title\";s:26:\"Online Course &#8211; Home\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/04/Home.jpg\";s:12:\"tmpl_created\";i:1587474541;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/online-course-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:111;s:16:\"popularity_index\";i:230;s:11:\"trend_index\";i:125;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:420;a:18:{s:4:\"tmpl\";i:994;s:2:\"id\";i:13621;s:5:\"title\";s:30:\"Barbershop &#8211; Single Post\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/05/Single-Page.jpg\";s:12:\"tmpl_created\";i:1589893137;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/blocks/barbershop-single-post/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:111;s:16:\"popularity_index\";i:736;s:11:\"trend_index\";i:580;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:421;a:18:{s:4:\"tmpl\";i:1131;s:2:\"id\";i:16527;s:5:\"title\";s:24:\"Beauty Salon &#8211; 404\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2020/12/404.jpg\";s:12:\"tmpl_created\";i:1608622517;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/blocks/beauty-salon-404/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:29:\"[\"404\",\"Beauty Salon\",\"Hair\"]\";s:10:\"menu_order\";i:112;s:16:\"popularity_index\";i:742;s:11:\"trend_index\";i:563;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:422;a:18:{s:4:\"tmpl\";i:983;s:2:\"id\";i:13328;s:5:\"title\";s:27:\"Online Course &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/04/About.jpg\";s:12:\"tmpl_created\";i:1587474558;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/online-course-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:112;s:16:\"popularity_index\";i:508;s:11:\"trend_index\";i:429;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:423;a:18:{s:4:\"tmpl\";i:984;s:2:\"id\";i:13338;s:5:\"title\";s:33:\"Online Course &#8211; Course Page\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/04/Course-Page.png\";s:12:\"tmpl_created\";i:1587474574;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/online-course-course-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:113;s:16:\"popularity_index\";i:337;s:11:\"trend_index\";i:310;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:424;a:18:{s:4:\"tmpl\";i:985;s:2:\"id\";i:13352;s:5:\"title\";s:29:\"Online Course &#8211; Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/04/Contact-Us.jpg\";s:12:\"tmpl_created\";i:1587474591;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/online-course-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:114;s:16:\"popularity_index\";i:565;s:11:\"trend_index\";i:533;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:425;a:18:{s:4:\"tmpl\";i:1130;s:2:\"id\";i:16535;s:5:\"title\";s:27:\"Beauty Salon &#8211; Footer\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/12/Footer.jpg\";s:12:\"tmpl_created\";i:1608622498;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/blocks/beauty-salon-footer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:32:\"[\"Beauty Salon\",\"Footer\",\"Hair\"]\";s:10:\"menu_order\";i:115;s:16:\"popularity_index\";i:524;s:11:\"trend_index\";i:126;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:426;a:18:{s:4:\"tmpl\";i:971;s:2:\"id\";i:13187;s:5:\"title\";s:33:\"Interior Design &#8211; Home Page\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/04/Home.png\";s:12:\"tmpl_created\";i:1586148661;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/interior-design-home-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"Business\",\"Interior Design\"]\";s:10:\"menu_order\";i:115;s:16:\"popularity_index\";i:331;s:11:\"trend_index\";i:264;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:427;a:18:{s:4:\"tmpl\";i:1453;s:2:\"id\";i:16346;s:5:\"title\";s:33:\"Your New Home &#8211; Real Estate\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2017/03/lp3-l.png\";s:12:\"tmpl_created\";i:1660205402;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/your-new-home-real-estate/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:11:\"Real Estate\";s:4:\"tags\";s:31:\"[\"Landing Pages\",\"Real estate\"]\";s:10:\"menu_order\";i:116;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:428;a:18:{s:4:\"tmpl\";i:972;s:2:\"id\";i:13199;s:5:\"title\";s:29:\"Interior Design &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/04/About.png\";s:12:\"tmpl_created\";i:1586148666;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/interior-design-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"Business\",\"Interior Design\"]\";s:10:\"menu_order\";i:116;s:16:\"popularity_index\";i:316;s:11:\"trend_index\";i:334;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:429;a:18:{s:4:\"tmpl\";i:1129;s:2:\"id\";i:16545;s:5:\"title\";s:27:\"Beauty Salon &#8211; Header\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/12/Header.jpg\";s:12:\"tmpl_created\";i:1608622495;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/blocks/beauty-salon-header/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:32:\"[\"Beauty Salon\",\"Hair\",\"Header\"]\";s:10:\"menu_order\";i:117;s:16:\"popularity_index\";i:356;s:11:\"trend_index\";i:49;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:430;a:18:{s:4:\"tmpl\";i:973;s:2:\"id\";i:13214;s:5:\"title\";s:32:\"Interior Design &#8211; Projects\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/04/portfolio_s.jpg\";s:12:\"tmpl_created\";i:1586148672;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/interior-design-projects/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"Business\",\"Interior Design\"]\";s:10:\"menu_order\";i:117;s:16:\"popularity_index\";i:367;s:11:\"trend_index\";i:323;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:431;a:18:{s:4:\"tmpl\";i:641;s:2:\"id\";i:7686;s:5:\"title\";s:12:\"Blog Posts 1\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2018/03/blog_posts.png\";s:12:\"tmpl_created\";i:1521558047;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/blocks/blog-posts-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:26:\"[\"Archive\",\"Blog\",\"posts\"]\";s:10:\"menu_order\";i:118;s:16:\"popularity_index\";i:131;s:11:\"trend_index\";i:152;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:432;a:18:{s:4:\"tmpl\";i:974;s:2:\"id\";i:13229;s:5:\"title\";s:31:\"Interior Design &#8211; Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/04/Contact-Us.png\";s:12:\"tmpl_created\";i:1586148677;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/interior-design-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"Business\",\"Interior Design\"]\";s:10:\"menu_order\";i:118;s:16:\"popularity_index\";i:395;s:11:\"trend_index\";i:337;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:433;a:18:{s:4:\"tmpl\";i:959;s:2:\"id\";i:12948;s:5:\"title\";s:29:\"Photography &#8211; Home Page\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/02/Home_s.png\";s:12:\"tmpl_created\";i:1582093442;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/photography-home-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:119;s:16:\"popularity_index\";i:241;s:11:\"trend_index\";i:201;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:434;a:18:{s:4:\"tmpl\";i:960;s:2:\"id\";i:12798;s:5:\"title\";s:25:\"Photography &#8211; About\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/02/About_s.png\";s:12:\"tmpl_created\";i:1582093446;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/photography-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:120;s:16:\"popularity_index\";i:499;s:11:\"trend_index\";i:374;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:435;a:18:{s:4:\"tmpl\";i:484;s:2:\"id\";i:5283;s:5:\"title\";s:9:\"Clients 1\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_white_2.png\";s:12:\"tmpl_created\";i:1520443478;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/clients-1-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"Clients\"]\";s:10:\"menu_order\";i:120;s:16:\"popularity_index\";i:294;s:11:\"trend_index\";i:202;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:436;a:18:{s:4:\"tmpl\";i:961;s:2:\"id\";i:12868;s:5:\"title\";s:27:\"Photography &#8211; Contact\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/02/Contact_s.png\";s:12:\"tmpl_created\";i:1582093450;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/photography-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:121;s:16:\"popularity_index\";i:531;s:11:\"trend_index\";i:350;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:437;a:18:{s:4:\"tmpl\";i:962;s:2:\"id\";i:13056;s:5:\"title\";s:28:\"Photography &#8211; Wildlife\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/02/Wildlife_s.png\";s:12:\"tmpl_created\";i:1582093454;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/photography-wildlife/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:122;s:16:\"popularity_index\";i:579;s:11:\"trend_index\";i:656;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:438;a:18:{s:4:\"tmpl\";i:487;s:2:\"id\";i:5306;s:5:\"title\";s:10:\"Clients 10\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_black_3.png\";s:12:\"tmpl_created\";i:1520443484;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/clients-10/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"Clients\"]\";s:10:\"menu_order\";i:122;s:16:\"popularity_index\";i:657;s:11:\"trend_index\";i:581;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:439;a:18:{s:4:\"tmpl\";i:963;s:2:\"id\";i:12922;s:5:\"title\";s:37:\"Photography &#8211; Glowing Jellyfish\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/02/Jellyfish_S.png\";s:12:\"tmpl_created\";i:1582093457;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/photography-glowing-jellyfish/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:123;s:16:\"popularity_index\";i:628;s:11:\"trend_index\";i:532;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:440;a:18:{s:4:\"tmpl\";i:964;s:2:\"id\";i:12875;s:5:\"title\";s:36:\"Photography &#8211; Fluttering Birds\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/02/Birds_s.png\";s:12:\"tmpl_created\";i:1582093461;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/photography-fluttering-birds/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:124;s:16:\"popularity_index\";i:693;s:11:\"trend_index\";i:766;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:441;a:18:{s:4:\"tmpl\";i:965;s:2:\"id\";i:12962;s:5:\"title\";s:26:\"Photography &#8211; Nature\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/02/Nature_s.png\";s:12:\"tmpl_created\";i:1582093465;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/photography-nature/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:125;s:16:\"popularity_index\";i:592;s:11:\"trend_index\";i:778;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:442;a:18:{s:4:\"tmpl\";i:491;s:2:\"id\";i:5341;s:5:\"title\";s:10:\"Clients 11\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_black_4.png\";s:12:\"tmpl_created\";i:1520443491;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/clients-11/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"Clients\"]\";s:10:\"menu_order\";i:125;s:16:\"popularity_index\";i:603;s:11:\"trend_index\";i:633;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:443;a:18:{s:4:\"tmpl\";i:966;s:2:\"id\";i:12833;s:5:\"title\";s:38:\"Photography &#8211; Blossoming Flowers\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/02/Flowers_s.png\";s:12:\"tmpl_created\";i:1582093469;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/photography-blossoming-flowers/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:126;s:16:\"popularity_index\";i:597;s:11:\"trend_index\";i:750;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:444;a:18:{s:4:\"tmpl\";i:488;s:2:\"id\";i:5315;s:5:\"title\";s:10:\"Clients 12\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_4-1.png\";s:12:\"tmpl_created\";i:1520443486;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/clients-12/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"Clients\"]\";s:10:\"menu_order\";i:126;s:16:\"popularity_index\";i:485;s:11:\"trend_index\";i:263;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:445;a:18:{s:4:\"tmpl\";i:967;s:2:\"id\";i:12898;s:5:\"title\";s:36:\"Photography &#8211; Forest Mushrooms\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/02/Mushrooms_s.png\";s:12:\"tmpl_created\";i:1582093473;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/photography-forest-mushrooms/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:127;s:16:\"popularity_index\";i:667;s:11:\"trend_index\";i:649;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:446;a:18:{s:4:\"tmpl\";i:968;s:2:\"id\";i:12994;s:5:\"title\";s:24:\"Photography &#8211; Pets\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/02/Pets_s.png\";s:12:\"tmpl_created\";i:1582093477;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/photography-pets/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:128;s:16:\"popularity_index\";i:612;s:11:\"trend_index\";i:508;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:447;a:18:{s:4:\"tmpl\";i:969;s:2:\"id\";i:12805;s:5:\"title\";s:37:\"Photography &#8211; B&amp;W Portraits\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/02/Black_s.png\";s:12:\"tmpl_created\";i:1582093481;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/photography-bw-portraits/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:129;s:16:\"popularity_index\";i:695;s:11:\"trend_index\";i:735;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:448;a:18:{s:4:\"tmpl\";i:490;s:2:\"id\";i:5333;s:5:\"title\";s:10:\"Clients 13\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_6.png\";s:12:\"tmpl_created\";i:1520443489;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/clients-13/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"Clients\"]\";s:10:\"menu_order\";i:129;s:16:\"popularity_index\";i:234;s:11:\"trend_index\";i:128;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:449;a:18:{s:4:\"tmpl\";i:970;s:2:\"id\";i:13031;s:5:\"title\";s:33:\"Photography &#8211; Vivid Parrots\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/02/Parrots_s.png\";s:12:\"tmpl_created\";i:1582093484;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/photography-vivid-parrots/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:130;s:16:\"popularity_index\";i:660;s:11:\"trend_index\";i:643;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:450;a:18:{s:4:\"tmpl\";i:496;s:2:\"id\";i:5389;s:5:\"title\";s:10:\"Clients 14\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_black_9.png\";s:12:\"tmpl_created\";i:1520443501;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/clients-14/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"Clients\"]\";s:10:\"menu_order\";i:130;s:16:\"popularity_index\";i:407;s:11:\"trend_index\";i:307;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:451;a:18:{s:4:\"tmpl\";i:940;s:2:\"id\";i:12621;s:5:\"title\";s:26:\"Magazine &#8211; Home Page\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/01/Home_s.png\";s:12:\"tmpl_created\";i:1579060604;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/magazine-home-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:131;s:16:\"popularity_index\";i:167;s:11:\"trend_index\";i:121;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:452;a:18:{s:4:\"tmpl\";i:936;s:2:\"id\";i:12352;s:5:\"title\";s:24:\"Travel &#8211; Home Page\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2019/12/Home_s.png\";s:12:\"tmpl_created\";i:1575960464;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/travel-home-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:132;s:16:\"popularity_index\";i:291;s:11:\"trend_index\";i:194;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:453;a:18:{s:4:\"tmpl\";i:486;s:2:\"id\";i:5298;s:5:\"title\";s:10:\"Clients 15\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_white_3.png\";s:12:\"tmpl_created\";i:1520443482;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/clients-15/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"Clients\"]\";s:10:\"menu_order\";i:132;s:16:\"popularity_index\";i:465;s:11:\"trend_index\";i:520;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:454;a:18:{s:4:\"tmpl\";i:932;s:2:\"id\";i:12400;s:5:\"title\";s:20:\"Travel &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2019/12/About.png\";s:12:\"tmpl_created\";i:1575960441;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/travel-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:133;s:16:\"popularity_index\";i:444;s:11:\"trend_index\";i:445;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:455;a:18:{s:4:\"tmpl\";i:938;s:2:\"id\";i:12479;s:5:\"title\";s:20:\"Travel &#8211; Tours\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2019/12/Tours_s.png\";s:12:\"tmpl_created\";i:1575960474;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/travel-tours/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:134;s:16:\"popularity_index\";i:539;s:11:\"trend_index\";i:726;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:456;a:18:{s:4:\"tmpl\";i:495;s:2:\"id\";i:5381;s:5:\"title\";s:10:\"Clients 16\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_9.png\";s:12:\"tmpl_created\";i:1520443499;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/clients-16/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"Clients\"]\";s:10:\"menu_order\";i:134;s:16:\"popularity_index\";i:198;s:11:\"trend_index\";i:168;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:457;a:18:{s:4:\"tmpl\";i:937;s:2:\"id\";i:12466;s:5:\"title\";s:27:\"Travel &#8211; Testimonials\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/12/Testimonials.png\";s:12:\"tmpl_created\";i:1575960469;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/travel-testimonials/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:135;s:16:\"popularity_index\";i:527;s:11:\"trend_index\";i:481;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:458;a:18:{s:4:\"tmpl\";i:935;s:2:\"id\";i:12443;s:5:\"title\";s:22:\"Travel &#8211; Gallery\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2019/12/Gallery.png\";s:12:\"tmpl_created\";i:1575960459;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/travel-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:136;s:16:\"popularity_index\";i:467;s:11:\"trend_index\";i:501;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:459;a:18:{s:4:\"tmpl\";i:934;s:2:\"id\";i:12431;s:5:\"title\";s:18:\"Travel &#8211; FAQ\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2019/12/FAQ.png\";s:12:\"tmpl_created\";i:1575960453;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/travel-faq/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:137;s:16:\"popularity_index\";i:501;s:11:\"trend_index\";i:387;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:460;a:18:{s:4:\"tmpl\";i:493;s:2:\"id\";i:5357;s:5:\"title\";s:9:\"Clients 2\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_black_7.png\";s:12:\"tmpl_created\";i:1520443495;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/clients-2-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"Clients\"]\";s:10:\"menu_order\";i:137;s:16:\"popularity_index\";i:341;s:11:\"trend_index\";i:232;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:461;a:18:{s:4:\"tmpl\";i:933;s:2:\"id\";i:12421;s:5:\"title\";s:27:\"Travel &#8211; Contact Page\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/12/Contsct-Us.png\";s:12:\"tmpl_created\";i:1575960445;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/travel-contact-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:138;s:16:\"popularity_index\";i:571;s:11:\"trend_index\";i:536;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:462;a:18:{s:4:\"tmpl\";i:892;s:2:\"id\";i:11763;s:5:\"title\";s:27:\"Portfolio &#8211; Home Page\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/09/Homepage_small.png\";s:12:\"tmpl_created\";i:1569428959;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/portfolio-home-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"Creative Portfolio\",\"Portfolio\"]\";s:10:\"menu_order\";i:139;s:16:\"popularity_index\";i:280;s:11:\"trend_index\";i:241;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:463;a:18:{s:4:\"tmpl\";i:485;s:2:\"id\";i:5290;s:5:\"title\";s:9:\"Clients 3\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_black_2.png\";s:12:\"tmpl_created\";i:1520443480;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/clients-3-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"Clients\"]\";s:10:\"menu_order\";i:139;s:16:\"popularity_index\";i:545;s:11:\"trend_index\";i:502;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:464;a:18:{s:4:\"tmpl\";i:891;s:2:\"id\";i:11781;s:5:\"title\";s:23:\"Portfolio &#8211; About\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/09/About_small.png\";s:12:\"tmpl_created\";i:1569428955;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/portfolio-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"Creative Portfolio\",\"Portfolio\"]\";s:10:\"menu_order\";i:140;s:16:\"popularity_index\";i:349;s:11:\"trend_index\";i:290;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:465;a:18:{s:4:\"tmpl\";i:482;s:2:\"id\";i:5266;s:5:\"title\";s:9:\"Clients 4\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_white_1.png\";s:12:\"tmpl_created\";i:1520443474;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/clients-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"Clients\"]\";s:10:\"menu_order\";i:140;s:16:\"popularity_index\";i:95;s:11:\"trend_index\";i:134;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:466;a:18:{s:4:\"tmpl\";i:890;s:2:\"id\";i:11793;s:5:\"title\";s:26:\"Portfolio &#8211; Projects\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/09/Projects_small.png\";s:12:\"tmpl_created\";i:1569428951;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/portfolio-projects/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"Creative Portfolio\",\"Portfolio\"]\";s:10:\"menu_order\";i:141;s:16:\"popularity_index\";i:448;s:11:\"trend_index\";i:467;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:467;a:18:{s:4:\"tmpl\";i:889;s:2:\"id\";i:11800;s:5:\"title\";s:25:\"Portfolio &#8211; Contact\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/09/Contact_small.png\";s:12:\"tmpl_created\";i:1569428946;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/portfolio-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"Creative Portfolio\",\"Portfolio\"]\";s:10:\"menu_order\";i:142;s:16:\"popularity_index\";i:494;s:11:\"trend_index\";i:449;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:468;a:18:{s:4:\"tmpl\";i:866;s:2:\"id\";i:11163;s:5:\"title\";s:32:\"Digital Agency &#8211; Home Page\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/07/Home_small.png\";s:12:\"tmpl_created\";i:1564641877;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/digital-agency-home-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"Digital Agency\",\"Marketing\"]\";s:10:\"menu_order\";i:143;s:16:\"popularity_index\";i:57;s:11:\"trend_index\";i:32;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:469;a:18:{s:4:\"tmpl\";i:483;s:2:\"id\";i:5275;s:5:\"title\";s:9:\"Clients 5\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_black_1.png\";s:12:\"tmpl_created\";i:1520443476;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/clients-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"Clients\"]\";s:10:\"menu_order\";i:143;s:16:\"popularity_index\";i:334;s:11:\"trend_index\";i:321;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:470;a:18:{s:4:\"tmpl\";i:492;s:2:\"id\";i:5349;s:5:\"title\";s:9:\"Clients 7\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_7.png\";s:12:\"tmpl_created\";i:1520443493;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/clients-7/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"Clients\"]\";s:10:\"menu_order\";i:144;s:16:\"popularity_index\";i:233;s:11:\"trend_index\";i:92;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:471;a:18:{s:4:\"tmpl\";i:916;s:2:\"id\";i:12143;s:5:\"title\";s:22:\"Law Firm &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2019/11/about.png\";s:12:\"tmpl_created\";i:1572847069;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/law-firm-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:146;s:16:\"popularity_index\";i:350;s:11:\"trend_index\";i:344;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:472;a:18:{s:4:\"tmpl\";i:489;s:2:\"id\";i:5324;s:5:\"title\";s:9:\"Clients 8\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_5-1.png\";s:12:\"tmpl_created\";i:1520443488;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/clients-8/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"Clients\"]\";s:10:\"menu_order\";i:146;s:16:\"popularity_index\";i:526;s:11:\"trend_index\";i:381;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:473;a:18:{s:4:\"tmpl\";i:920;s:2:\"id\";i:12091;s:5:\"title\";s:21:\"Law Firm &#8211; Team\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2019/11/team.png\";s:12:\"tmpl_created\";i:1572847113;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/law-firm-team/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:147;s:16:\"popularity_index\";i:318;s:11:\"trend_index\";i:314;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:474;a:18:{s:4:\"tmpl\";i:869;s:2:\"id\";i:11129;s:5:\"title\";s:28:\"Digital Agency &#8211; About\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/07/About_small.png\";s:12:\"tmpl_created\";i:1564641889;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/digital-agency-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"Digital Agency\",\"Marketing\"]\";s:10:\"menu_order\";i:148;s:16:\"popularity_index\";i:182;s:11:\"trend_index\";i:166;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:475;a:18:{s:4:\"tmpl\";i:880;s:2:\"id\";i:11572;s:5:\"title\";s:19:\"Gym &#8211; Trainer\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/08/Trainer_Small.png\";s:12:\"tmpl_created\";i:1567392934;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/gym-trainer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";i:149;s:16:\"popularity_index\";i:521;s:11:\"trend_index\";i:590;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:476;a:18:{s:4:\"tmpl\";i:494;s:2:\"id\";i:5368;s:5:\"title\";s:9:\"Clients 9\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_8.png\";s:12:\"tmpl_created\";i:1520443497;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/clients-9/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"Clients\"]\";s:10:\"menu_order\";i:149;s:16:\"popularity_index\";i:253;s:11:\"trend_index\";i:273;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:477;a:18:{s:4:\"tmpl\";i:917;s:2:\"id\";i:12133;s:5:\"title\";s:24:\"Law Firm &#8211; Careers\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2019/11/careers.png\";s:12:\"tmpl_created\";i:1572847078;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/law-firm-careers/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:151;s:16:\"popularity_index\";i:583;s:11:\"trend_index\";i:640;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:478;a:18:{s:4:\"tmpl\";i:425;s:2:\"id\";i:4436;s:5:\"title\";s:11:\"Contact  16\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/02/map_black_2.png\";s:12:\"tmpl_created\";i:1520443293;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/contact-16/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:151;s:16:\"popularity_index\";i:161;s:11:\"trend_index\";i:68;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:479;a:18:{s:4:\"tmpl\";i:915;s:2:\"id\";i:12155;s:5:\"title\";s:26:\"Law Firm &#8211; Home Page\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2019/11/home.png\";s:12:\"tmpl_created\";i:1572847054;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/law-firm-home-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:152;s:16:\"popularity_index\";i:193;s:11:\"trend_index\";i:110;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:480;a:18:{s:4:\"tmpl\";i:423;s:2:\"id\";i:4420;s:5:\"title\";s:9:\"Contact 1\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/02/map_black_1.png\";s:12:\"tmpl_created\";i:1520443289;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/contact-1-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:152;s:16:\"popularity_index\";i:196;s:11:\"trend_index\";i:127;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:481;a:18:{s:4:\"tmpl\";i:921;s:2:\"id\";i:12080;s:5:\"title\";s:24:\"Law Firm &#8211; Partner\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/11/partner-1.png\";s:12:\"tmpl_created\";i:1572847120;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/law-firm-partner/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:153;s:16:\"popularity_index\";i:556;s:11:\"trend_index\";i:471;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:482;a:18:{s:4:\"tmpl\";i:534;s:2:\"id\";i:5836;s:5:\"title\";s:10:\"Contact 10\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/contact_white_2.png\";s:12:\"tmpl_created\";i:1520443597;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/contact-10/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:154;s:16:\"popularity_index\";i:114;s:11:\"trend_index\";i:76;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:483;a:18:{s:4:\"tmpl\";i:865;s:2:\"id\";i:11074;s:5:\"title\";s:31:\"Digital Agency &#8211; Services\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/07/Services_small.png\";s:12:\"tmpl_created\";i:1564641872;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/digital-agency-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"Digital Agency\",\"Marketing\"]\";s:10:\"menu_order\";i:154;s:16:\"popularity_index\";i:163;s:11:\"trend_index\";i:170;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:484;a:18:{s:4:\"tmpl\";i:879;s:2:\"id\";i:11506;s:5:\"title\";s:19:\"Gym &#8211; Classes\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/08/Classes_Small.png\";s:12:\"tmpl_created\";i:1567392930;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/gym-classes/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";i:155;s:16:\"popularity_index\";i:514;s:11:\"trend_index\";i:554;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:485;a:18:{s:4:\"tmpl\";i:535;s:2:\"id\";i:5844;s:5:\"title\";s:10:\"Contact 11\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/contact_black_2.png\";s:12:\"tmpl_created\";i:1520443599;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/contact-11/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:156;s:16:\"popularity_index\";i:289;s:11:\"trend_index\";i:313;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:486;a:18:{s:4:\"tmpl\";i:922;s:2:\"id\";i:12044;s:5:\"title\";s:24:\"Law Firm &#8211; Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/11/contsct_us.png\";s:12:\"tmpl_created\";i:1572847130;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/law-firm-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:157;s:16:\"popularity_index\";i:437;s:11:\"trend_index\";i:304;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:487;a:18:{s:4:\"tmpl\";i:430;s:2:\"id\";i:4476;s:5:\"title\";s:10:\"Contact 15\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/contact_white_4.png\";s:12:\"tmpl_created\";i:1520443303;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/contact-15/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:18:\"[\"Contact\",\"Form\"]\";s:10:\"menu_order\";i:157;s:16:\"popularity_index\";i:229;s:11:\"trend_index\";i:187;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:488;a:18:{s:4:\"tmpl\";i:918;s:2:\"id\";i:12124;s:5:\"title\";s:25:\"Law Firm &#8211; Services\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2019/11/services.png\";s:12:\"tmpl_created\";i:1572847096;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/law-firm-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:158;s:16:\"popularity_index\";i:433;s:11:\"trend_index\";i:296;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:489;a:18:{s:4:\"tmpl\";i:864;s:2:\"id\";i:11056;s:5:\"title\";s:35:\"Digital Agency &#8211; Social Media\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2019/07/Social-Media_small.png\";s:12:\"tmpl_created\";i:1564641867;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/digital-agency-social-media/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"Digital Agency\",\"Marketing\"]\";s:10:\"menu_order\";i:159;s:16:\"popularity_index\";i:297;s:11:\"trend_index\";i:361;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:490;a:18:{s:4:\"tmpl\";i:476;s:2:\"id\";i:5214;s:5:\"title\";s:10:\"Contact 16\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_2.png\";s:12:\"tmpl_created\";i:1520443462;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/blocks/contact-16-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:18:\"[\"Contact\",\"Form\"]\";s:10:\"menu_order\";i:159;s:16:\"popularity_index\";i:194;s:11:\"trend_index\";i:106;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:491;a:18:{s:4:\"tmpl\";i:878;s:2:\"id\";i:11536;s:5:\"title\";s:19:\"Gym &#8211; Fitness\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/08/Fitness_Small.png\";s:12:\"tmpl_created\";i:1567392927;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/gym-fitness/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";i:160;s:16:\"popularity_index\";i:621;s:11:\"trend_index\";i:674;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:492;a:18:{s:4:\"tmpl\";i:882;s:2:\"id\";i:11545;s:5:\"title\";s:21:\"Gym &#8211; Home Page\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/08/Home_Small.png\";s:12:\"tmpl_created\";i:1567392943;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/gym-home-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";i:161;s:16:\"popularity_index\";i:310;s:11:\"trend_index\";i:229;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:493;a:18:{s:4:\"tmpl\";i:919;s:2:\"id\";i:12116;s:5:\"title\";s:24:\"Law Firm &#8211; Service\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/11/family_law.png\";s:12:\"tmpl_created\";i:1572847105;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/law-firm-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:162;s:16:\"popularity_index\";i:489;s:11:\"trend_index\";i:339;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:494;a:18:{s:4:\"tmpl\";i:478;s:2:\"id\";i:5230;s:5:\"title\";s:10:\"Contact 17\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_3.png\";s:12:\"tmpl_created\";i:1520443466;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/contact-17/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:18:\"[\"Contact\",\"Form\"]\";s:10:\"menu_order\";i:162;s:16:\"popularity_index\";i:339;s:11:\"trend_index\";i:335;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:495;a:18:{s:4:\"tmpl\";i:868;s:2:\"id\";i:11094;s:5:\"title\";s:30:\"Digital Agency &#8211; Clients\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/07/Clients_small.png\";s:12:\"tmpl_created\";i:1564641885;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/digital-agency-clients/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"Digital Agency\",\"Marketing\"]\";s:10:\"menu_order\";i:163;s:16:\"popularity_index\";i:424;s:11:\"trend_index\";i:424;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:496;a:18:{s:4:\"tmpl\";i:481;s:2:\"id\";i:5257;s:5:\"title\";s:10:\"Contact 18\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_5.png\";s:12:\"tmpl_created\";i:1520443472;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/contact-18/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:8:\"[\"Form\"]\";s:10:\"menu_order\";i:163;s:16:\"popularity_index\";i:438;s:11:\"trend_index\";i:490;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:497;a:18:{s:4:\"tmpl\";i:881;s:2:\"id\";i:11478;s:5:\"title\";s:17:\"Gym &#8211; About\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/08/About_Small.png\";s:12:\"tmpl_created\";i:1567392939;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/gym-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";i:164;s:16:\"popularity_index\";i:481;s:11:\"trend_index\";i:579;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:498;a:18:{s:4:\"tmpl\";i:532;s:2:\"id\";i:5820;s:5:\"title\";s:9:\"Contact 2\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/contact_white_1.png\";s:12:\"tmpl_created\";i:1520443593;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/contact-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:166;s:16:\"popularity_index\";i:183;s:11:\"trend_index\";i:357;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:499;a:18:{s:4:\"tmpl\";i:877;s:2:\"id\";i:11563;s:5:\"title\";s:19:\"Gym &#8211; Pricing\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/08/Pricing_Small.png\";s:12:\"tmpl_created\";i:1567392923;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/gym-pricing/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";i:166;s:16:\"popularity_index\";i:577;s:11:\"trend_index\";i:736;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:500;a:18:{s:4:\"tmpl\";i:422;s:2:\"id\";i:4411;s:5:\"title\";s:9:\"Contact 3\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/02/map_white_1.png\";s:12:\"tmpl_created\";i:1520443287;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/contact-3-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:167;s:16:\"popularity_index\";i:113;s:11:\"trend_index\";i:217;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:501;a:18:{s:4:\"tmpl\";i:867;s:2:\"id\";i:11034;s:5:\"title\";s:30:\"Digital Agency &#8211; Contact\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2019/07/Contsct-Us_small.png\";s:12:\"tmpl_created\";i:1564641881;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/contact-digital-agency/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"Digital Agency\",\"Marketing\"]\";s:10:\"menu_order\";i:168;s:16:\"popularity_index\";i:191;s:11:\"trend_index\";i:156;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:502;a:18:{s:4:\"tmpl\";i:533;s:2:\"id\";i:5828;s:5:\"title\";s:9:\"Contact 3\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/contact_black_1.png\";s:12:\"tmpl_created\";i:1520443595;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/contact-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:170;s:16:\"popularity_index\";i:312;s:11:\"trend_index\";i:495;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:503;a:18:{s:4:\"tmpl\";i:876;s:2:\"id\";i:11528;s:5:\"title\";s:19:\"Gym &#8211; Contact\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/08/Contact_Small.png\";s:12:\"tmpl_created\";i:1567392917;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/gym-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";i:171;s:16:\"popularity_index\";i:505;s:11:\"trend_index\";i:624;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:504;a:18:{s:4:\"tmpl\";i:424;s:2:\"id\";i:4428;s:5:\"title\";s:9:\"Contact 4\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/02/map_white_2.png\";s:12:\"tmpl_created\";i:1520443291;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/contact-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:171;s:16:\"popularity_index\";i:118;s:11:\"trend_index\";i:131;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:505;a:18:{s:4:\"tmpl\";i:426;s:2:\"id\";i:4444;s:5:\"title\";s:9:\"Contact 5\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/contact_white_1.png\";s:12:\"tmpl_created\";i:1520443295;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/contact-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:174;s:16:\"popularity_index\";i:84;s:11:\"trend_index\";i:93;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:506;a:18:{s:4:\"tmpl\";i:432;s:2:\"id\";i:4492;s:5:\"title\";s:9:\"Contact 5\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/02/map_white_3.png\";s:12:\"tmpl_created\";i:1520443307;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/contact-5-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:176;s:16:\"popularity_index\";i:37;s:11:\"trend_index\";i:31;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:507;a:18:{s:4:\"tmpl\";i:427;s:2:\"id\";i:4452;s:5:\"title\";s:9:\"Contact 6\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/contact_black_1.png\";s:12:\"tmpl_created\";i:1520443296;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/contact-6/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:178;s:16:\"popularity_index\";i:139;s:11:\"trend_index\";i:150;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:508;a:18:{s:4:\"tmpl\";i:429;s:2:\"id\";i:4468;s:5:\"title\";s:9:\"Contact 7\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/contact_white_3.png\";s:12:\"tmpl_created\";i:1520443301;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/contact-7/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:18:\"[\"Contact\",\"Form\"]\";s:10:\"menu_order\";i:179;s:16:\"popularity_index\";i:127;s:11:\"trend_index\";i:72;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:509;a:18:{s:4:\"tmpl\";i:431;s:2:\"id\";i:4484;s:5:\"title\";s:9:\"Contact 8\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/contact_black_3.png\";s:12:\"tmpl_created\";i:1520443305;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/contact-8/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:18:\"[\"Contact\",\"Form\"]\";s:10:\"menu_order\";i:182;s:16:\"popularity_index\";i:328;s:11:\"trend_index\";i:260;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:510;a:18:{s:4:\"tmpl\";i:428;s:2:\"id\";i:4460;s:5:\"title\";s:9:\"Contact 9\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/contact_white_2.png\";s:12:\"tmpl_created\";i:1520443298;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/contact-9/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:184;s:16:\"popularity_index\";i:99;s:11:\"trend_index\";i:80;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:511;a:18:{s:4:\"tmpl\";i:613;s:2:\"id\";i:5558;s:5:\"title\";s:5:\"CTA 1\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_2.png\";s:12:\"tmpl_created\";i:1520520684;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/cta-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:185;s:16:\"popularity_index\";i:129;s:11:\"trend_index\";i:69;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:512;a:18:{s:4:\"tmpl\";i:634;s:2:\"id\";i:5939;s:5:\"title\";s:6:\"CTA 10\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_13-1.png\";s:12:\"tmpl_created\";i:1520520760;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/cta-10/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:187;s:16:\"popularity_index\";i:190;s:11:\"trend_index\";i:118;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:513;a:18:{s:4:\"tmpl\";i:633;s:2:\"id\";i:5930;s:5:\"title\";s:6:\"CTA 11\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_15.png\";s:12:\"tmpl_created\";i:1520520758;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/cta-11/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:190;s:16:\"popularity_index\";i:76;s:11:\"trend_index\";i:84;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:514;a:18:{s:4:\"tmpl\";i:632;s:2:\"id\";i:5921;s:5:\"title\";s:6:\"CTA 12\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_14.png\";s:12:\"tmpl_created\";i:1520520757;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/cta-12/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:192;s:16:\"popularity_index\";i:278;s:11:\"trend_index\";i:234;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:515;a:18:{s:4:\"tmpl\";i:618;s:2:\"id\";i:5607;s:5:\"title\";s:6:\"CTA 13\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_5.png\";s:12:\"tmpl_created\";i:1520520695;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/cta-13/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:194;s:16:\"popularity_index\";i:42;s:11:\"trend_index\";i:11;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:516;a:18:{s:4:\"tmpl\";i:574;s:2:\"id\";i:6017;s:5:\"title\";s:6:\"CTA 14\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_14.png\";s:12:\"tmpl_created\";i:1520520331;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/cta-14/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:196;s:16:\"popularity_index\";i:152;s:11:\"trend_index\";i:122;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:517;a:18:{s:4:\"tmpl\";i:628;s:2:\"id\";i:5885;s:5:\"title\";s:6:\"CTA 15\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_11.png\";s:12:\"tmpl_created\";i:1520520751;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/cta-15/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:197;s:16:\"popularity_index\";i:274;s:11:\"trend_index\";i:256;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:518;a:18:{s:4:\"tmpl\";i:627;s:2:\"id\";i:5877;s:5:\"title\";s:6:\"CTA 16\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_10.png\";s:12:\"tmpl_created\";i:1520520749;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/cta-16/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:200;s:16:\"popularity_index\";i:564;s:11:\"trend_index\";i:677;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:519;a:18:{s:4:\"tmpl\";i:625;s:2:\"id\";i:5860;s:5:\"title\";s:6:\"CTA 17\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_9.png\";s:12:\"tmpl_created\";i:1520520746;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/cta-17/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:201;s:16:\"popularity_index\";i:120;s:11:\"trend_index\";i:63;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:520;a:18:{s:4:\"tmpl\";i:626;s:2:\"id\";i:5869;s:5:\"title\";s:6:\"CTA 18\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_10.png\";s:12:\"tmpl_created\";i:1520520747;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/cta-18/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:204;s:16:\"popularity_index\";i:345;s:11:\"trend_index\";i:486;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:521;a:18:{s:4:\"tmpl\";i:611;s:2:\"id\";i:5542;s:5:\"title\";s:6:\"CTA 19\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_1.png\";s:12:\"tmpl_created\";i:1520520681;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/cta-19/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:205;s:16:\"popularity_index\";i:169;s:11:\"trend_index\";i:270;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:522;a:18:{s:4:\"tmpl\";i:614;s:2:\"id\";i:5567;s:5:\"title\";s:5:\"CTA 2\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_2.png\";s:12:\"tmpl_created\";i:1520520685;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/cta-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:207;s:16:\"popularity_index\";i:143;s:11:\"trend_index\";i:225;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:523;a:18:{s:4:\"tmpl\";i:629;s:2:\"id\";i:5893;s:5:\"title\";s:6:\"CTA 21\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_12.png\";s:12:\"tmpl_created\";i:1520520752;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/cta-21/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:210;s:16:\"popularity_index\";i:259;s:11:\"trend_index\";i:457;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:524;a:18:{s:4:\"tmpl\";i:619;s:2:\"id\";i:5634;s:5:\"title\";s:6:\"CTA 24\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_6.png\";s:12:\"tmpl_created\";i:1520520699;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/cta-24/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:212;s:16:\"popularity_index\";i:188;s:11:\"trend_index\";i:255;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:525;a:18:{s:4:\"tmpl\";i:620;s:2:\"id\";i:5642;s:5:\"title\";s:6:\"CTA 25\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_6.png\";s:12:\"tmpl_created\";i:1520520701;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/cta-25/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:214;s:16:\"popularity_index\";i:226;s:11:\"trend_index\";i:262;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:526;a:18:{s:4:\"tmpl\";i:615;s:2:\"id\";i:5583;s:5:\"title\";s:6:\"CTA 26\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_3.png\";s:12:\"tmpl_created\";i:1520520689;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/cta-26/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:216;s:16:\"popularity_index\";i:117;s:11:\"trend_index\";i:117;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:527;a:18:{s:4:\"tmpl\";i:630;s:2:\"id\";i:5904;s:5:\"title\";s:6:\"CTA 27\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_13.png\";s:12:\"tmpl_created\";i:1520520754;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/cta-27/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:217;s:16:\"popularity_index\";i:528;s:11:\"trend_index\";i:517;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:528;a:18:{s:4:\"tmpl\";i:631;s:2:\"id\";i:5912;s:5:\"title\";s:6:\"CTA 28\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_11.png\";s:12:\"tmpl_created\";i:1520520755;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/cta-28/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:219;s:16:\"popularity_index\";i:665;s:11:\"trend_index\";i:702;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:529;a:18:{s:4:\"tmpl\";i:473;s:2:\"id\";i:5189;s:5:\"title\";s:6:\"CTA 29\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_1.png\";s:12:\"tmpl_created\";i:1520443456;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/cta-29/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:8:\"[\"Form\"]\";s:10:\"menu_order\";i:221;s:16:\"popularity_index\";i:472;s:11:\"trend_index\";i:631;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:530;a:18:{s:4:\"tmpl\";i:623;s:2:\"id\";i:5667;s:5:\"title\";s:5:\"CTA 3\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_8.png\";s:12:\"tmpl_created\";i:1520520705;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/cta-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:222;s:16:\"popularity_index\";i:171;s:11:\"trend_index\";i:250;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:531;a:18:{s:4:\"tmpl\";i:474;s:2:\"id\";i:5198;s:5:\"title\";s:6:\"CTA 30\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_black_1.png\";s:12:\"tmpl_created\";i:1520443458;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/cta-30/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:8:\"[\"Form\"]\";s:10:\"menu_order\";i:225;s:16:\"popularity_index\";i:572;s:11:\"trend_index\";i:511;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:532;a:18:{s:4:\"tmpl\";i:475;s:2:\"id\";i:5206;s:5:\"title\";s:6:\"CTA 31\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_black_2.png\";s:12:\"tmpl_created\";i:1520443459;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/cta-31/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:8:\"[\"Form\"]\";s:10:\"menu_order\";i:226;s:16:\"popularity_index\";i:593;s:11:\"trend_index\";i:611;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:533;a:18:{s:4:\"tmpl\";i:480;s:2:\"id\";i:5249;s:5:\"title\";s:6:\"CTA 32\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_black_4.png\";s:12:\"tmpl_created\";i:1520443470;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/cta-32/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:8:\"[\"Form\"]\";s:10:\"menu_order\";i:228;s:16:\"popularity_index\";i:512;s:11:\"trend_index\";i:409;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:534;a:18:{s:4:\"tmpl\";i:612;s:2:\"id\";i:5550;s:5:\"title\";s:6:\"CTA 33\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_1.png\";s:12:\"tmpl_created\";i:1520520682;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/cta-33/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:231;s:16:\"popularity_index\";i:260;s:11:\"trend_index\";i:562;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:535;a:18:{s:4:\"tmpl\";i:536;s:2:\"id\";i:5852;s:5:\"title\";s:6:\"CTA 34\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2018/03/form_1.png\";s:12:\"tmpl_created\";i:1520443600;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/cta-34/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:8:\"[\"Form\"]\";s:10:\"menu_order\";i:232;s:16:\"popularity_index\";i:563;s:11:\"trend_index\";i:828;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:536;a:18:{s:4:\"tmpl\";i:624;s:2:\"id\";i:5675;s:5:\"title\";s:5:\"CTA 4\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_8.png\";s:12:\"tmpl_created\";i:1520520707;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/cta-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:235;s:16:\"popularity_index\";i:391;s:11:\"trend_index\";i:484;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:537;a:18:{s:4:\"tmpl\";i:616;s:2:\"id\";i:5591;s:5:\"title\";s:5:\"CTA 5\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_4.png\";s:12:\"tmpl_created\";i:1520520691;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/cta-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:237;s:16:\"popularity_index\";i:133;s:11:\"trend_index\";i:130;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:538;a:18:{s:4:\"tmpl\";i:617;s:2:\"id\";i:5599;s:5:\"title\";s:5:\"CTA 6\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_4.png\";s:12:\"tmpl_created\";i:1520520693;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/cta-6/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:239;s:16:\"popularity_index\";i:252;s:11:\"trend_index\";i:362;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:539;a:18:{s:4:\"tmpl\";i:514;s:2:\"id\";i:5575;s:5:\"title\";s:5:\"CTA 7\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_3.png\";s:12:\"tmpl_created\";i:1520443543;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/cta-7/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:240;s:16:\"popularity_index\";i:13;s:11:\"trend_index\";i:586;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:540;a:18:{s:4:\"tmpl\";i:622;s:2:\"id\";i:5658;s:5:\"title\";s:5:\"CTA 8\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_7.png\";s:12:\"tmpl_created\";i:1520520704;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/cta-8/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:243;s:16:\"popularity_index\";i:187;s:11:\"trend_index\";i:235;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:541;a:18:{s:4:\"tmpl\";i:621;s:2:\"id\";i:5650;s:5:\"title\";s:5:\"CTA 9\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_7.png\";s:12:\"tmpl_created\";i:1520520702;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/cta-9/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:244;s:16:\"popularity_index\";i:94;s:11:\"trend_index\";i:148;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:542;a:18:{s:4:\"tmpl\";i:1061;s:2:\"id\";i:15407;s:5:\"title\";s:24:\"Dance Studio &#8211; 404\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2020/10/404.jpg\";s:12:\"tmpl_created\";i:1603181958;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/blocks/dance-studio-404/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:22:\"[\"404\",\"Dance Studio\"]\";s:10:\"menu_order\";i:246;s:16:\"popularity_index\";i:783;s:11:\"trend_index\";i:710;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:543;a:18:{s:4:\"tmpl\";i:1062;s:2:\"id\";i:15400;s:5:\"title\";s:27:\"Dance Studio &#8211; Footer\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/10/Footer.jpg\";s:12:\"tmpl_created\";i:1603181989;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/blocks/dance-studio-footer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:25:\"[\"Dance Studio\",\"Footer\"]\";s:10:\"menu_order\";i:247;s:16:\"popularity_index\";i:586;s:11:\"trend_index\";i:243;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:544;a:18:{s:4:\"tmpl\";i:1063;s:2:\"id\";i:15391;s:5:\"title\";s:27:\"Dance Studio &#8211; Header\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/10/Header.jpg\";s:12:\"tmpl_created\";i:1603182011;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/blocks/dance-studio-header/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:25:\"[\"Dance Studio\",\"Header\"]\";s:10:\"menu_order\";i:248;s:16:\"popularity_index\";i:352;s:11:\"trend_index\";i:67;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:545;a:18:{s:4:\"tmpl\";i:874;s:2:\"id\";i:11192;s:5:\"title\";s:14:\"Digital Agency\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/07/Footer_small.jpg\";s:12:\"tmpl_created\";i:1564642399;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/blocks/digital-agency-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:39:\"[\"Digital Agency\",\"Footer\",\"Marketing\"]\";s:10:\"menu_order\";i:250;s:16:\"popularity_index\";i:172;s:11:\"trend_index\";i:105;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:546;a:18:{s:4:\"tmpl\";i:873;s:2:\"id\";i:11198;s:5:\"title\";s:14:\"Digital Agency\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2020/06/Header-digital-marketing-agency.png\";s:12:\"tmpl_created\";i:1564642395;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/blocks/digital-agency-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:39:\"[\"Digital Agency\",\"Header\",\"Marketing\"]\";s:10:\"menu_order\";i:251;s:16:\"popularity_index\";i:34;s:11:\"trend_index\";i:10;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:547;a:18:{s:4:\"tmpl\";i:872;s:2:\"id\";i:11204;s:5:\"title\";s:14:\"Digital Agency\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/07/404_small.jpg\";s:12:\"tmpl_created\";i:1564642389;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/blocks/digital-agency-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:36:\"[\"404\",\"Digital Agency\",\"Marketing\"]\";s:10:\"menu_order\";i:253;s:16:\"popularity_index\";i:301;s:11:\"trend_index\";i:239;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:548;a:18:{s:4:\"tmpl\";i:871;s:2:\"id\";i:11220;s:5:\"title\";s:14:\"Digital Agency\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/08/Archive_small1.png\";s:12:\"tmpl_created\";i:1564642385;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/blocks/digital-agency-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:30:\"[\"Digital Agency\",\"Marketing\"]\";s:10:\"menu_order\";i:255;s:16:\"popularity_index\";i:116;s:11:\"trend_index\";i:73;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:549;a:18:{s:4:\"tmpl\";i:870;s:2:\"id\";i:11231;s:5:\"title\";s:14:\"Digital Agency\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/07/Post_small1.png\";s:12:\"tmpl_created\";i:1564642380;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/blocks/digital-agency/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:30:\"[\"Digital Agency\",\"Marketing\"]\";s:10:\"menu_order\";i:257;s:16:\"popularity_index\";i:145;s:11:\"trend_index\";i:71;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:550;a:18:{s:4:\"tmpl\";i:520;s:2:\"id\";i:5711;s:5:\"title\";s:5:\"FAQ 1\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_black_2.png\";s:12:\"tmpl_created\";i:1520443571;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/faq-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"Faq\"]\";s:10:\"menu_order\";i:260;s:16:\"popularity_index\";i:200;s:11:\"trend_index\";i:231;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:551;a:18:{s:4:\"tmpl\";i:523;s:2:\"id\";i:5737;s:5:\"title\";s:6:\"FAQ 10\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_white_4.png\";s:12:\"tmpl_created\";i:1520443576;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/faq-10/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"Faq\"]\";s:10:\"menu_order\";i:261;s:16:\"popularity_index\";i:155;s:11:\"trend_index\";i:112;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:552;a:18:{s:4:\"tmpl\";i:524;s:2:\"id\";i:5746;s:5:\"title\";s:6:\"FAQ 11\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_black_4.png\";s:12:\"tmpl_created\";i:1520443578;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/faq-11/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"Faq\"]\";s:10:\"menu_order\";i:264;s:16:\"popularity_index\";i:212;s:11:\"trend_index\";i:305;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:553;a:18:{s:4:\"tmpl\";i:519;s:2:\"id\";i:5703;s:5:\"title\";s:6:\"FAQ 13\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_white_2.png\";s:12:\"tmpl_created\";i:1520443569;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/faq-13/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"Faq\"]\";s:10:\"menu_order\";i:265;s:16:\"popularity_index\";i:29;s:11:\"trend_index\";i:38;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:554;a:18:{s:4:\"tmpl\";i:521;s:2:\"id\";i:5719;s:5:\"title\";s:5:\"FAQ 4\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_white_3.png\";s:12:\"tmpl_created\";i:1520443573;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/faq-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"Faq\"]\";s:10:\"menu_order\";i:267;s:16:\"popularity_index\";i:125;s:11:\"trend_index\";i:251;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:555;a:18:{s:4:\"tmpl\";i:522;s:2:\"id\";i:5729;s:5:\"title\";s:5:\"FAQ 5\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_black_3.png\";s:12:\"tmpl_created\";i:1520443575;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/faq-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"Faq\"]\";s:10:\"menu_order\";i:269;s:16:\"popularity_index\";i:319;s:11:\"trend_index\";i:327;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:556;a:18:{s:4:\"tmpl\";i:525;s:2:\"id\";i:5755;s:5:\"title\";s:5:\"FAQ 6\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_white_5.png\";s:12:\"tmpl_created\";i:1520443580;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/faq-6/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"Faq\"]\";s:10:\"menu_order\";i:271;s:16:\"popularity_index\";i:112;s:11:\"trend_index\";i:180;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:557;a:18:{s:4:\"tmpl\";i:526;s:2:\"id\";i:5764;s:5:\"title\";s:5:\"FAQ 7\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_black_5.png\";s:12:\"tmpl_created\";i:1520443582;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/faq-7/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"Faq\"]\";s:10:\"menu_order\";i:273;s:16:\"popularity_index\";i:338;s:11:\"trend_index\";i:474;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:558;a:18:{s:4:\"tmpl\";i:517;s:2:\"id\";i:5684;s:5:\"title\";s:5:\"FAQ 8\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_white_1.png\";s:12:\"tmpl_created\";i:1520443565;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/faq-8/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"Faq\"]\";s:10:\"menu_order\";i:274;s:16:\"popularity_index\";i:74;s:11:\"trend_index\";i:193;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:559;a:18:{s:4:\"tmpl\";i:518;s:2:\"id\";i:5693;s:5:\"title\";s:5:\"FAQ 9\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_black_1.png\";s:12:\"tmpl_created\";i:1520443567;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/faq-9/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"Faq\"]\";s:10:\"menu_order\";i:276;s:16:\"popularity_index\";i:224;s:11:\"trend_index\";i:515;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:560;a:18:{s:4:\"tmpl\";i:548;s:2:\"id\";i:6053;s:5:\"title\";s:10:\"Features 1\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_black_5.png\";s:12:\"tmpl_created\";i:1520443645;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/features-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"Features\"]\";s:10:\"menu_order\";i:277;s:16:\"popularity_index\";i:179;s:11:\"trend_index\";i:463;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:561;a:18:{s:4:\"tmpl\";i:542;s:2:\"id\";i:5991;s:5:\"title\";s:11:\"Features 10\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_white_4.png\";s:12:\"tmpl_created\";i:1520443632;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/features-10/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"Features\"]\";s:10:\"menu_order\";i:279;s:16:\"popularity_index\";i:135;s:11:\"trend_index\";i:265;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:562;a:18:{s:4:\"tmpl\";i:547;s:2:\"id\";i:6044;s:5:\"title\";s:11:\"Features 11\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_white_5.png\";s:12:\"tmpl_created\";i:1520443643;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/features-11/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"Features\"]\";s:10:\"menu_order\";i:280;s:16:\"popularity_index\";i:70;s:11:\"trend_index\";i:163;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:563;a:18:{s:4:\"tmpl\";i:566;s:2:\"id\";i:6212;s:5:\"title\";s:11:\"Features 12\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_white_7.png\";s:12:\"tmpl_created\";i:1520443684;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/features-12/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"Features\"]\";s:10:\"menu_order\";i:281;s:16:\"popularity_index\";i:81;s:11:\"trend_index\";i:98;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:564;a:18:{s:4:\"tmpl\";i:567;s:2:\"id\";i:6220;s:5:\"title\";s:10:\"Features 2\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_white_8.png\";s:12:\"tmpl_created\";i:1520443685;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/features-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"Features\"]\";s:10:\"menu_order\";i:282;s:16:\"popularity_index\";i:88;s:11:\"trend_index\";i:189;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:565;a:18:{s:4:\"tmpl\";i:541;s:2:\"id\";i:5983;s:5:\"title\";s:10:\"Features 3\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_black_3.png\";s:12:\"tmpl_created\";i:1520443630;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/features-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:283;s:16:\"popularity_index\";i:231;s:11:\"trend_index\";i:351;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:566;a:18:{s:4:\"tmpl\";i:540;s:2:\"id\";i:5974;s:5:\"title\";s:10:\"Features 4\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_white_3.png\";s:12:\"tmpl_created\";i:1520443629;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/features-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"Features\"]\";s:10:\"menu_order\";i:286;s:16:\"popularity_index\";i:69;s:11:\"trend_index\";i:181;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:567;a:18:{s:4:\"tmpl\";i:516;s:2:\"id\";i:5624;s:5:\"title\";s:10:\"Features 5\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_black_1.png\";s:12:\"tmpl_created\";i:1520443553;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/features-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"Features\"]\";s:10:\"menu_order\";i:287;s:16:\"popularity_index\";i:93;s:11:\"trend_index\";i:352;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:568;a:18:{s:4:\"tmpl\";i:515;s:2:\"id\";i:5615;s:5:\"title\";s:10:\"Features 6\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_5.png\";s:12:\"tmpl_created\";i:1520443551;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/features-6/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"Features\"]\";s:10:\"menu_order\";i:290;s:16:\"popularity_index\";i:41;s:11:\"trend_index\";i:119;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:569;a:18:{s:4:\"tmpl\";i:539;s:2:\"id\";i:5963;s:5:\"title\";s:10:\"Features 7\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_white_2.png\";s:12:\"tmpl_created\";i:1520443626;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/features-7/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"Features\"]\";s:10:\"menu_order\";i:291;s:16:\"popularity_index\";i:67;s:11:\"trend_index\";i:133;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:570;a:18:{s:4:\"tmpl\";i:565;s:2:\"id\";i:6204;s:5:\"title\";s:10:\"Features 8\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/progress_black_6.png\";s:12:\"tmpl_created\";i:1520443681;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/features-8/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"Features\"]\";s:10:\"menu_order\";i:292;s:16:\"popularity_index\";i:217;s:11:\"trend_index\";i:223;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:571;a:18:{s:4:\"tmpl\";i:564;s:2:\"id\";i:6196;s:5:\"title\";s:10:\"Features 9\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_white_6.png\";s:12:\"tmpl_created\";i:1520443680;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/features-9/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"Features\"]\";s:10:\"menu_order\";i:294;s:16:\"popularity_index\";i:106;s:11:\"trend_index\";i:113;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:572;a:18:{s:4:\"tmpl\";i:1033;s:2:\"id\";i:15033;s:5:\"title\";s:28:\"Flooring Company &#8211; 404\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2020/08/404.png\";s:12:\"tmpl_created\";i:1597739459;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/blocks/flooring-company-404/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:45:\"[\"404\",\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:296;s:16:\"popularity_index\";i:655;s:11:\"trend_index\";i:671;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:573;a:18:{s:4:\"tmpl\";i:1032;s:2:\"id\";i:15042;s:5:\"title\";s:32:\"Flooring Company &#8211; Archive\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/08/Blog.png\";s:12:\"tmpl_created\";i:1597739084;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/blocks/flooring-company-archive/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:297;s:16:\"popularity_index\";i:320;s:11:\"trend_index\";i:275;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:574;a:18:{s:4:\"tmpl\";i:1031;s:2:\"id\";i:15017;s:5:\"title\";s:31:\"Flooring Company &#8211; Footer\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/08/Footer.png\";s:12:\"tmpl_created\";i:1597738933;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/blocks/flooring-company-footer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:48:\"[\"Flooring company\",\"Flooring website\",\"Footer\"]\";s:10:\"menu_order\";i:299;s:16:\"popularity_index\";i:323;s:11:\"trend_index\";i:192;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:575;a:18:{s:4:\"tmpl\";i:1030;s:2:\"id\";i:15007;s:5:\"title\";s:31:\"Flooring Company &#8211; Header\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/08/Header.png\";s:12:\"tmpl_created\";i:1597738896;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/blocks/flooring-company-header/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:48:\"[\"Flooring company\",\"Flooring website\",\"Header\"]\";s:10:\"menu_order\";i:302;s:16:\"popularity_index\";i:459;s:11:\"trend_index\";i:333;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:576;a:18:{s:4:\"tmpl\";i:1029;s:2:\"id\";i:15052;s:5:\"title\";s:36:\"Flooring Company &#8211; Single post\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/08/Single.png\";s:12:\"tmpl_created\";i:1597738858;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/blocks/flooring-company-single-post/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:303;s:16:\"popularity_index\";i:392;s:11:\"trend_index\";i:226;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:577;a:18:{s:4:\"tmpl\";i:651;s:2:\"id\";i:7837;s:5:\"title\";s:9:\"footer 01\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.14.jpg\";s:12:\"tmpl_created\";i:1524582852;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/footer-01/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:305;s:16:\"popularity_index\";i:495;s:11:\"trend_index\";i:539;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:578;a:18:{s:4:\"tmpl\";i:647;s:2:\"id\";i:7937;s:5:\"title\";s:10:\"footer 010\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.5.jpg\";s:12:\"tmpl_created\";i:1524582665;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/footer-010/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:308;s:16:\"popularity_index\";i:185;s:11:\"trend_index\";i:115;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:579;a:18:{s:4:\"tmpl\";i:646;s:2:\"id\";i:7950;s:5:\"title\";s:10:\"footer 011\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.4.jpg\";s:12:\"tmpl_created\";i:1524582631;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/footer-011/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:310;s:16:\"popularity_index\";i:244;s:11:\"trend_index\";i:203;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:580;a:18:{s:4:\"tmpl\";i:645;s:2:\"id\";i:7959;s:5:\"title\";s:10:\"footer 012\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.3.jpg\";s:12:\"tmpl_created\";i:1524582605;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/footer-012/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:311;s:16:\"popularity_index\";i:177;s:11:\"trend_index\";i:140;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:581;a:18:{s:4:\"tmpl\";i:644;s:2:\"id\";i:7982;s:5:\"title\";s:10:\"footer 013\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.2.jpg\";s:12:\"tmpl_created\";i:1524582468;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/footer-013/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:314;s:16:\"popularity_index\";i:209;s:11:\"trend_index\";i:212;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:582;a:18:{s:4:\"tmpl\";i:643;s:2:\"id\";i:7997;s:5:\"title\";s:10:\"footer 014\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.1.jpg\";s:12:\"tmpl_created\";i:1524582343;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/footer-014/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:316;s:16:\"popularity_index\";i:64;s:11:\"trend_index\";i:41;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:583;a:18:{s:4:\"tmpl\";i:693;s:2:\"id\";i:9119;s:5:\"title\";s:10:\"footer 015\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/07/Footer_GetStarted_350.png\";s:12:\"tmpl_created\";i:1532428138;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/demo/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:317;s:16:\"popularity_index\";i:240;s:11:\"trend_index\";i:154;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:584;a:18:{s:4:\"tmpl\";i:652;s:2:\"id\";i:7852;s:5:\"title\";s:9:\"footer 02\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.13.jpg\";s:12:\"tmpl_created\";i:1524582875;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/footer-02/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:320;s:16:\"popularity_index\";i:199;s:11:\"trend_index\";i:96;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:585;a:18:{s:4:\"tmpl\";i:653;s:2:\"id\";i:7862;s:5:\"title\";s:9:\"footer 03\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.12.jpg\";s:12:\"tmpl_created\";i:1524582903;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/footer-03/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:321;s:16:\"popularity_index\";i:137;s:11:\"trend_index\";i:91;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:586;a:18:{s:4:\"tmpl\";i:654;s:2:\"id\";i:7871;s:5:\"title\";s:9:\"footer 04\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.11.jpg\";s:12:\"tmpl_created\";i:1524582927;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/footer-04/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:323;s:16:\"popularity_index\";i:97;s:11:\"trend_index\";i:55;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:587;a:18:{s:4:\"tmpl\";i:655;s:2:\"id\";i:7884;s:5:\"title\";s:9:\"footer 05\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.10.jpg\";s:12:\"tmpl_created\";i:1524582944;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/footer-05/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:325;s:16:\"popularity_index\";i:92;s:11:\"trend_index\";i:109;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:588;a:18:{s:4:\"tmpl\";i:656;s:2:\"id\";i:7892;s:5:\"title\";s:9:\"footer 06\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.9.jpg\";s:12:\"tmpl_created\";i:1524583015;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/footer-06/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:326;s:16:\"popularity_index\";i:132;s:11:\"trend_index\";i:146;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:589;a:18:{s:4:\"tmpl\";i:650;s:2:\"id\";i:7904;s:5:\"title\";s:9:\"footer 07\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.8.jpg\";s:12:\"tmpl_created\";i:1524582814;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/footer-07/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:328;s:16:\"popularity_index\";i:203;s:11:\"trend_index\";i:186;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:590;a:18:{s:4:\"tmpl\";i:649;s:2:\"id\";i:7917;s:5:\"title\";s:9:\"footer 08\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.7.jpg\";s:12:\"tmpl_created\";i:1524582788;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/footer-08/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:329;s:16:\"popularity_index\";i:89;s:11:\"trend_index\";i:144;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:591;a:18:{s:4:\"tmpl\";i:648;s:2:\"id\";i:7927;s:5:\"title\";s:9:\"footer 09\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.6.jpg\";s:12:\"tmpl_created\";i:1524582691;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/footer-09/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:331;s:16:\"popularity_index\";i:178;s:11:\"trend_index\";i:100;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:592;a:18:{s:4:\"tmpl\";i:642;s:2:\"id\";i:4676;s:5:\"title\";s:8:\"Footer 7\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/03/footer_7.png\";s:12:\"tmpl_created\";i:1522014215;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/footer_7/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:10:\"[\"Footer\"]\";s:10:\"menu_order\";i:338;s:16:\"popularity_index\";i:237;s:11:\"trend_index\";i:346;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:593;a:18:{s:4:\"tmpl\";i:637;s:2:\"id\";i:7627;s:5:\"title\";s:8:\"Footer 8\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/footer_hero_1.png\";s:12:\"tmpl_created\";i:1521547332;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/footer-8/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:10:\"[\"Footer\"]\";s:10:\"menu_order\";i:340;s:16:\"popularity_index\";i:100;s:11:\"trend_index\";i:83;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:594;a:18:{s:4:\"tmpl\";i:638;s:2:\"id\";i:7638;s:5:\"title\";s:8:\"Footer 9\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/footer_hero_2.png\";s:12:\"tmpl_created\";i:1521547502;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/footer-9/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:10:\"[\"Footer\"]\";s:10:\"menu_order\";i:342;s:16:\"popularity_index\";i:124;s:11:\"trend_index\";i:147;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:595;a:18:{s:4:\"tmpl\";i:888;s:2:\"id\";i:11424;s:5:\"title\";s:3:\"GYM\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/08/404_Small.png\";s:12:\"tmpl_created\";i:1567393309;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/gym-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:13:\"[\"404\",\"Gym\"]\";s:10:\"menu_order\";i:344;s:16:\"popularity_index\";i:679;s:11:\"trend_index\";i:769;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:596;a:18:{s:4:\"tmpl\";i:887;s:2:\"id\";i:11435;s:5:\"title\";s:3:\"GYM\";s:9:\"thumbnail\";s:73:\"https://library.elementor.